/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cli.model;

import com.google.common.collect.ImmutableSet;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.cli.VertexiumScript;
import org.vertexium.cli.model.LazyEdgeProperty;
import org.vertexium.cli.model.LazyExtendedDataTable;
import org.vertexium.cli.model.LazyVertex;
import org.vertexium.cli.model.ModelBase;
import org.vertexium.util.IterableUtils;

public class LazyEdge
extends ModelBase {
    private final String edgeId;

    public LazyEdge(String edgeId) {
        this.edgeId = edgeId;
    }

    public String toString() {
        Edge e = this.getE();
        if (e == null) {
            return null;
        }
        return LazyEdge.toString(e);
    }

    public static String toString(Edge e) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("@|bold " + e.getId() + "|@");
        writer.println("  @|bold hidden:|@ " + e.isHidden(LazyEdge.getAuthorizations()));
        writer.println("  @|bold visibility:|@ " + e.getVisibility());
        writer.println("  @|bold label:|@ " + e.getLabel());
        writer.println("  @|bold timestamp:|@ " + VertexiumScript.timestampToString(e.getTimestamp()));
        writer.println("  @|bold hidden visibilities:|@");
        List hiddenVisibilities = IterableUtils.toList((Iterable)e.getHiddenVisibilities());
        if (hiddenVisibilities.size() == 0) {
            writer.println("    none");
        } else {
            for (Visibility hiddenVisibility : hiddenVisibilities) {
                writer.println("    " + hiddenVisibility.getVisibilityString());
            }
        }
        writer.println("  @|bold extended data table names:|@");
        VertexiumScript.getContextExtendedDataTables().clear();
        ImmutableSet extendedDataTableNames = e.getExtendedDataTableNames();
        if (extendedDataTableNames.size() == 0) {
            writer.println("    none");
        } else {
            int tableIndex = 0;
            for (String extendedDataTableName : extendedDataTableNames) {
                String tableIndexString = "t" + tableIndex;
                writer.println("    @|bold " + tableIndexString + ":|@ " + extendedDataTableName);
                LazyExtendedDataTable lazyExtendedDataTable = new LazyExtendedDataTable(ElementType.EDGE, e.getId(), extendedDataTableName);
                VertexiumScript.getContextExtendedDataTables().put(tableIndexString, lazyExtendedDataTable);
                ++tableIndex;
            }
        }
        writer.println("  @|bold properties:|@");
        VertexiumScript.getContextProperties().clear();
        int propIndex = 0;
        for (Property prop : e.getProperties()) {
            String propertyIndexString = "p" + propIndex;
            String valueString = VertexiumScript.valueToString(prop.getValue(), false);
            boolean isHidden = prop.isHidden(LazyEdge.getAuthorizations());
            writer.println("    @|bold " + propertyIndexString + ":|@ " + prop.getName() + ":" + prop.getKey() + "[" + prop.getVisibility().getVisibilityString() + "] = " + valueString + (isHidden ? " @|red (hidden)|@" : ""));
            LazyEdgeProperty lazyProperty = new LazyEdgeProperty(e.getId(), prop.getKey(), prop.getName(), prop.getVisibility());
            VertexiumScript.getContextProperties().put(propertyIndexString, lazyProperty);
            ++propIndex;
        }
        VertexiumScript.getContextVertices().clear();
        int vertexIndex = 0;
        writer.println("  @|bold out vertex:|@");
        String vertexIndexString = "v" + vertexIndex;
        writer.println("    @|bold " + vertexIndexString + ":|@ " + e.getVertexId(Direction.OUT));
        LazyVertex lazyVertex = new LazyVertex(e.getVertexId(Direction.OUT));
        VertexiumScript.getContextVertices().put(vertexIndexString, lazyVertex);
        writer.println("  @|bold in vertex:|@");
        vertexIndexString = "v" + ++vertexIndex;
        writer.println("    @|bold " + vertexIndexString + ":|@ " + e.getVertexId(Direction.IN));
        lazyVertex = new LazyVertex(e.getVertexId(Direction.IN));
        VertexiumScript.getContextVertices().put(vertexIndexString, lazyVertex);
        ++vertexIndex;
        return out.toString();
    }

    private Edge getE() {
        return this.getGraph().getEdge(this.getId(), FetchHint.ALL_INCLUDING_HIDDEN, LazyEdge.getTime(), LazyEdge.getAuthorizations());
    }

    public String getId() {
        return this.edgeId;
    }

    public void delete() {
        this.getGraph().deleteEdge(this.getE(), LazyEdge.getAuthorizations());
        this.getGraph().flush();
    }
}

