/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cli.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.List;
import org.vertexium.Element;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.cli.VertexiumScript;
import org.vertexium.cli.model.ModelBase;
import org.vertexium.util.IterableUtils;

public abstract class LazyProperty
extends ModelBase {
    private final String propertyKey;
    private final String propertyName;
    private final Visibility propertyVisibility;

    public LazyProperty(String propertyKey, String propertyName, Visibility propertyVisibility) {
        this.propertyKey = propertyKey;
        this.propertyName = propertyName;
        this.propertyVisibility = propertyVisibility;
    }

    public String toString() {
        Property prop = this.getP();
        if (prop == null) {
            return null;
        }
        return LazyProperty.toString(prop, this.getToStringHeaderLine());
    }

    public static String toString(Property prop, String headerLine) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        if (headerLine != null) {
            writer.println(headerLine);
        }
        writer.println("  @|bold key:|@ " + prop.getKey());
        writer.println("  @|bold name:|@ " + prop.getName());
        writer.println("  @|bold visibility:|@ " + prop.getVisibility());
        writer.println("  @|bold timestamp:|@ " + VertexiumScript.timestampToString(prop.getTimestamp()));
        writer.println("  @|bold metadata:|@");
        Collection metadataEntries = prop.getMetadata().entrySet();
        if (metadataEntries.size() == 0) {
            writer.println("    none");
        } else {
            for (Metadata.Entry m : metadataEntries) {
                writer.println("    " + m.getKey() + "[" + m.getVisibility() + "]: " + VertexiumScript.valueToString(m.getValue(), false));
            }
        }
        writer.println("  @|bold hidden visibilities:|@");
        List hiddenVisibilities = IterableUtils.toList((Iterable)prop.getHiddenVisibilities());
        if (hiddenVisibilities.size() == 0) {
            writer.println("    none");
        } else {
            for (Visibility hiddenVisibility : hiddenVisibilities) {
                writer.println("    " + hiddenVisibility.getVisibilityString());
            }
        }
        writer.println("  @|bold value:|@" + VertexiumScript.valueToString(prop.getValue(), true));
        return out.toString();
    }

    public String getHistory() {
        Element e = this.getE();
        if (e == null) {
            return null;
        }
        Iterable historicalValues = e.getHistoricalPropertyValues(this.getKey(), this.getName(), this.getVisibility(), LazyProperty.getAuthorizations());
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("@|bold history:|@");
        for (HistoricalPropertyValue historicalValue : historicalValues) {
            writer.println("  @|bold " + VertexiumScript.timestampToString(historicalValue.getTimestamp()) + ":|@");
            writer.println("    @|bold value:|@" + VertexiumScript.valueToString(historicalValue.getValue(), true));
            writer.println("    @|bold metadata:|@");
            for (Metadata.Entry m : historicalValue.getMetadata().entrySet()) {
                writer.println("      " + m.getKey() + "[" + m.getVisibility() + "]: " + VertexiumScript.valueToString(m.getValue(), false));
            }
        }
        return out.toString();
    }

    protected abstract String getToStringHeaderLine();

    protected abstract Element getE();

    protected abstract Property getP();

    public String getKey() {
        return this.propertyKey;
    }

    public String getName() {
        return this.propertyName;
    }

    public Visibility getVisibility() {
        return this.propertyVisibility;
    }

    public void delete() {
        this.getE().deleteProperty(this.getKey(), this.getName(), this.getVisibility(), LazyProperty.getAuthorizations());
        this.getGraph().flush();
    }
}

