/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cli.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.ExtendedDataRow;
import org.vertexium.Property;
import org.vertexium.VertexiumException;
import org.vertexium.cli.VertexiumScript;
import org.vertexium.cli.model.ModelBase;

public class LazyExtendedDataTable
extends ModelBase {
    private final ElementType elementType;
    private final String elementId;
    private final String tableName;

    public LazyExtendedDataTable(ElementType elementType, String elementId, String tableName) {
        this.elementType = elementType;
        this.elementId = elementId;
        this.tableName = tableName;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("");
        for (ExtendedDataRow row : this.getRows()) {
            writer.println("@|bold " + row.getId().getRowId() + ":|@");
            for (Property property : row.getProperties()) {
                Object value = property.getValue();
                writer.println("    @|bold " + property.getName() + ":" + (property.getKey() == null ? "" : property.getKey()) + "|@ " + VertexiumScript.valueToString(value, true));
            }
        }
        return out.toString();
    }

    public Iterable<ExtendedDataRow> getRows() {
        return this.getElement().getExtendedData(this.tableName);
    }

    public Element getElement() {
        switch (this.elementType) {
            case VERTEX: {
                return this.getGraph().getVertex(this.getElementId(), this.getGraph().getDefaultFetchHints(), LazyExtendedDataTable.getTime(), LazyExtendedDataTable.getAuthorizations());
            }
            case EDGE: {
                return this.getGraph().getEdge(this.getElementId(), this.getGraph().getDefaultFetchHints(), LazyExtendedDataTable.getTime(), LazyExtendedDataTable.getAuthorizations());
            }
        }
        throw new VertexiumException("Unhandled element type: " + this.elementType);
    }

    public String getElementId() {
        return this.elementId;
    }
}

