/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.vertexium.Element;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchQueryBase;
import org.vertexium.elasticsearch.GeohashUtils;
import org.vertexium.query.DefaultGraphQueryIterable;
import org.vertexium.query.GeohashBucket;
import org.vertexium.query.GeohashResult;
import org.vertexium.query.HistogramBucket;
import org.vertexium.query.HistogramResult;
import org.vertexium.query.IterableWithGeohashResults;
import org.vertexium.query.IterableWithHistogramResults;
import org.vertexium.query.IterableWithScores;
import org.vertexium.query.IterableWithSearchTime;
import org.vertexium.query.IterableWithStatisticsResults;
import org.vertexium.query.IterableWithTermsResults;
import org.vertexium.query.IterableWithTotalHits;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.StatisticsResult;
import org.vertexium.query.TermsBucket;
import org.vertexium.query.TermsResult;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoRect;

public class ElasticSearchGraphQueryIterable<T extends Element>
extends DefaultGraphQueryIterable<T>
implements IterableWithTotalHits<T>,
IterableWithSearchTime<T>,
IterableWithScores<T>,
IterableWithHistogramResults<T>,
IterableWithTermsResults<T>,
IterableWithGeohashResults<T>,
IterableWithStatisticsResults<T> {
    private final ElasticSearchQueryBase query;
    private final SearchResponse searchResponse;
    private final long totalHits;
    private final long searchTimeInNanoSeconds;
    private final Map<String, Double> scores = new HashMap<String, Double>();

    public ElasticSearchGraphQueryIterable(ElasticSearchQueryBase query, SearchResponse searchResponse, QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, long totalHits, long searchTimeInNanoSeconds, SearchHits hits) {
        super(parameters, iterable, evaluateQueryString, evaluateHasContainers, evaluateSortContainers);
        this.query = query;
        this.searchResponse = searchResponse;
        this.totalHits = totalHits;
        this.searchTimeInNanoSeconds = searchTimeInNanoSeconds;
        if (hits != null) {
            for (SearchHit hit : hits.getHits()) {
                this.scores.put(hit.getId(), Double.valueOf(hit.getScore()));
            }
        }
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public Map<String, Double> getScores() {
        return this.scores;
    }

    public long getSearchTimeNanoSeconds() {
        return this.searchTimeInNanoSeconds;
    }

    public HistogramResult getHistogramResults(String name) {
        HashMap<Object, HistogramBucket> buckets = new HashMap<Object, HistogramBucket>();
        if (this.searchResponse == null || this.searchResponse.getAggregations() == null) {
            return new HistogramResult(new ArrayList());
        }
        for (Aggregation agg : this.searchResponse.getAggregations()) {
            long existingCount;
            HistogramBucket existingBucket;
            DateHistogram h;
            String aggName = this.query.getAggregationName(agg.getName());
            if (!aggName.equals(name)) continue;
            if (agg instanceof DateHistogram) {
                h = (DateHistogram)agg;
                for (DateHistogram.Bucket b : h.getBuckets()) {
                    existingBucket = (HistogramBucket)buckets.get(b.getKey());
                    existingCount = 0L;
                    if (existingBucket != null) {
                        existingCount = existingBucket.getCount();
                    }
                    buckets.put(b.getKeyAsDate().toDate(), new HistogramBucket((Object)b.getKeyAsDate().toDate(), existingCount + b.getDocCount()));
                }
                continue;
            }
            if (agg instanceof Histogram) {
                h = (Histogram)agg;
                for (DateHistogram.Bucket b : h.getBuckets()) {
                    existingBucket = (HistogramBucket)buckets.get(b.getKey());
                    existingCount = 0L;
                    if (existingBucket != null) {
                        existingCount = existingBucket.getCount();
                    }
                    buckets.put(b.getKey(), new HistogramBucket((Object)b.getKey(), existingCount + b.getDocCount()));
                }
                continue;
            }
            throw new VertexiumException("Aggregation is not a histogram: " + agg.getClass().getName());
        }
        return new HistogramResult(buckets.values());
    }

    public TermsResult getTermsResults(String name) {
        HashMap<String, TermsBucket> buckets = new HashMap<String, TermsBucket>();
        if (this.searchResponse == null || this.searchResponse.getAggregations() == null) {
            return new TermsResult(new ArrayList());
        }
        for (Aggregation agg : this.searchResponse.getAggregations()) {
            String aggName = this.query.getAggregationName(agg.getName());
            if (!aggName.equals(name)) continue;
            if (agg instanceof Terms) {
                Terms h = (Terms)agg;
                for (Terms.Bucket b : h.getBuckets()) {
                    String mapKey = b.getKey().toLowerCase();
                    TermsBucket existingBucket = (TermsBucket)buckets.get(mapKey);
                    long existingCount = 0L;
                    if (existingBucket != null) {
                        existingCount = existingBucket.getCount();
                    }
                    buckets.put(mapKey, new TermsBucket((Object)mapKey, existingCount + b.getDocCount()));
                }
                continue;
            }
            throw new VertexiumException("Aggregation is not a terms: " + agg.getClass().getName());
        }
        return new TermsResult(buckets.values());
    }

    public GeohashResult getGeohashResults(String name) {
        HashMap<String, 1> buckets = new HashMap<String, 1>();
        if (this.searchResponse == null || this.searchResponse.getAggregations() == null) {
            return new GeohashResult(new ArrayList());
        }
        for (Aggregation agg : this.searchResponse.getAggregations()) {
            String aggName = this.query.getAggregationName(agg.getName());
            if (!aggName.equals(name)) continue;
            if (agg instanceof GeoHashGrid) {
                GeoHashGrid h = (GeoHashGrid)agg;
                for (GeoHashGrid.Bucket b : h.getBuckets()) {
                    org.elasticsearch.common.geo.GeoPoint g = b.getKeyAsGeoPoint();
                    GeohashBucket existingBucket = (GeohashBucket)buckets.get(b.getKey());
                    long existingCount = 0L;
                    if (existingBucket != null) {
                        existingCount = existingBucket.getCount();
                    }
                    GeohashBucket geohashBucket = new GeohashBucket(b.getKey(), existingCount + b.getDocCount(), new GeoPoint(g.getLat(), g.getLon())){

                        public GeoRect getGeoCell() {
                            org.elasticsearch.common.geo.GeoPoint northWest = new org.elasticsearch.common.geo.GeoPoint();
                            org.elasticsearch.common.geo.GeoPoint southEast = new org.elasticsearch.common.geo.GeoPoint();
                            GeohashUtils.decodeCell(this.getKey(), northWest, southEast);
                            return new GeoRect(new GeoPoint(northWest.getLat(), northWest.getLon()), new GeoPoint(southEast.getLat(), southEast.getLon()));
                        }
                    };
                    buckets.put(b.getKey(), geohashBucket);
                }
                continue;
            }
            throw new VertexiumException("Aggregation is not a geohash: " + agg.getClass().getName());
        }
        return new GeohashResult(buckets.values());
    }

    public StatisticsResult getStatisticsResults(String name) {
        if (this.searchResponse == null || this.searchResponse.getAggregations() == null) {
            return new StatisticsResult(0L, 0.0, 0.0, 0.0, 0.0);
        }
        ArrayList<StatisticsResult> results = new ArrayList<StatisticsResult>();
        for (Aggregation agg : this.searchResponse.getAggregations()) {
            String aggName = this.query.getAggregationName(agg.getName());
            if (!aggName.equals(name)) continue;
            if (agg instanceof ExtendedStats) {
                ExtendedStats extendedStats = (ExtendedStats)agg;
                long count = extendedStats.getCount();
                double sum = extendedStats.getSum();
                double min = extendedStats.getMin();
                double max = extendedStats.getMax();
                double standardDeviation = extendedStats.getStdDeviation();
                results.add(new StatisticsResult(count, sum, min, max, standardDeviation));
                continue;
            }
            throw new VertexiumException("Aggregation is not a statistics: " + agg.getClass().getName());
        }
        return StatisticsResult.combine(results);
    }
}

