/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.geo.builders.CircleBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.GeoShapeFilterBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStatsBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.vertexium.Authorizations;
import org.vertexium.DateOnly;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.PropertyDefinition;
import org.vertexium.TextIndexHint;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchGraphQueryIterable;
import org.vertexium.elasticsearch.ElasticSearchSearchIndexBase;
import org.vertexium.elasticsearch.EmptyElasticSearchGraphQueryIterable;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.elasticsearch.VertexiumNoMatchingPropertiesException;
import org.vertexium.elasticsearch.score.ScoringStrategy;
import org.vertexium.elasticsearch.utils.PagingIterable;
import org.vertexium.query.Compare;
import org.vertexium.query.Contains;
import org.vertexium.query.GeoCompare;
import org.vertexium.query.GeohashQueryItem;
import org.vertexium.query.HistogramQueryItem;
import org.vertexium.query.Query;
import org.vertexium.query.QueryBase;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.QueryStringQueryParameters;
import org.vertexium.query.SimilarToTextQueryParameters;
import org.vertexium.query.SortDirection;
import org.vertexium.query.StatisticsQueryItem;
import org.vertexium.query.TermsQueryItem;
import org.vertexium.query.TextPredicate;
import org.vertexium.type.GeoCircle;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.JoinIterable;
import org.vertexium.util.ToElementIterable;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public abstract class ElasticSearchQueryBase
extends QueryBase {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ElasticSearchQueryBase.class);
    public static final VertexiumLogger QUERY_LOGGER = VertexiumLoggerFactory.getQueryLogger(Query.class);
    private final Client client;
    private final boolean evaluateHasContainers;
    private final boolean evaluateQueryString;
    private final boolean evaluateSortContainers;
    private final StandardAnalyzer analyzer;
    private final ScoringStrategy scoringStrategy;
    private final IndexSelectionStrategy indexSelectionStrategy;

    protected ElasticSearchQueryBase(Client client, Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, Authorizations authorizations) {
        super(graph, queryString, propertyDefinitions, authorizations);
        this.client = client;
        this.evaluateQueryString = evaluateQueryString;
        this.evaluateHasContainers = evaluateHasContainers;
        this.evaluateSortContainers = evaluateSortContainers;
        this.scoringStrategy = scoringStrategy;
        this.analyzer = new StandardAnalyzer();
        this.indexSelectionStrategy = indexSelectionStrategy;
    }

    protected ElasticSearchQueryBase(Client client, Graph graph, String[] similarToFields, String similarToText, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, Authorizations authorizations) {
        super(graph, similarToFields, similarToText, propertyDefinitions, authorizations);
        this.client = client;
        this.evaluateQueryString = evaluateQueryString;
        this.evaluateHasContainers = evaluateHasContainers;
        this.evaluateSortContainers = evaluateSortContainers;
        this.scoringStrategy = scoringStrategy;
        this.analyzer = new StandardAnalyzer();
        this.indexSelectionStrategy = indexSelectionStrategy;
    }

    public Iterable<Vertex> vertices(final EnumSet<FetchHint> fetchHints) {
        return new PagingIterable<Vertex>(this.getParameters().getSkip(), this.getParameters().getLimit()){

            @Override
            protected ElasticSearchGraphQueryIterable<Vertex> getPageIterable(int skip, int limit) {
                SearchResponse response;
                long startTime = System.nanoTime();
                try {
                    response = ElasticSearchQueryBase.this.getSearchResponse(ElasticSearchElementType.VERTEX, skip, limit);
                }
                catch (IndexMissingException ex) {
                    LOGGER.debug("Index missing: %s", new Object[]{ex.getMessage()});
                    return ElasticSearchQueryBase.this.createEmptyIterable();
                }
                catch (VertexiumNoMatchingPropertiesException ex) {
                    LOGGER.debug("Could not find property %s", new Object[]{ex.getPropertyName()});
                    return ElasticSearchQueryBase.this.createEmptyIterable();
                }
                SearchHits hits = response.getHits();
                List ids = IterableUtils.toList((Iterable)new ConvertingIterable<SearchHit, String>((Iterable)hits){

                    protected String convert(SearchHit searchHit) {
                        return searchHit.getId();
                    }
                });
                long endTime = System.nanoTime();
                long searchTime = endTime - startTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("elastic search results %d of %d (time: %dms)", new Object[]{ids.size(), hits.getTotalHits(), searchTime / 1000L / 1000L});
                }
                QueryParameters filterParameters = ElasticSearchQueryBase.this.getParameters().clone();
                filterParameters.setSkip(0L);
                Iterable vertices = ElasticSearchQueryBase.this.getGraph().getVertices((Iterable)ids, fetchHints, filterParameters.getAuthorizations());
                vertices = ElasticSearchQueryBase.this.sortByResultOrder(vertices, ids);
                return ElasticSearchQueryBase.this.createIterable(response, filterParameters, vertices, ElasticSearchQueryBase.this.evaluateQueryString, ElasticSearchQueryBase.this.evaluateHasContainers, ElasticSearchQueryBase.this.evaluateSortContainers, searchTime, hits);
            }
        };
    }

    public Iterable<Edge> edges(final EnumSet<FetchHint> fetchHints) {
        return new PagingIterable<Edge>(this.getParameters().getSkip(), this.getParameters().getLimit()){

            @Override
            protected ElasticSearchGraphQueryIterable<Edge> getPageIterable(int skip, int limit) {
                SearchResponse response;
                long startTime = System.nanoTime();
                try {
                    response = ElasticSearchQueryBase.this.getSearchResponse(ElasticSearchElementType.EDGE, skip, limit);
                }
                catch (IndexMissingException ex) {
                    LOGGER.debug("Index missing: %s", new Object[]{ex.getMessage()});
                    return ElasticSearchQueryBase.this.createEmptyIterable();
                }
                catch (VertexiumNoMatchingPropertiesException ex) {
                    LOGGER.debug("Could not find property", (Throwable)((Object)ex));
                    return ElasticSearchQueryBase.this.createEmptyIterable();
                }
                SearchHits hits = response.getHits();
                List ids = IterableUtils.toList((Iterable)new ConvertingIterable<SearchHit, String>((Iterable)hits){

                    protected String convert(SearchHit searchHit) {
                        return searchHit.getId();
                    }
                });
                long endTime = System.nanoTime();
                long searchTime = endTime - startTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("elastic search results %d of %d (time: %dms)", new Object[]{ids.size(), hits.getTotalHits(), (endTime - startTime) / 1000L / 1000L});
                }
                QueryParameters filterParameters = ElasticSearchQueryBase.this.getParameters().clone();
                filterParameters.setSkip(0L);
                Iterable edges = ElasticSearchQueryBase.this.getGraph().getEdges((Iterable)ids, fetchHints, filterParameters.getAuthorizations());
                edges = ElasticSearchQueryBase.this.sortByResultOrder(edges, ids);
                return ElasticSearchQueryBase.this.createIterable(response, filterParameters, edges, ElasticSearchQueryBase.this.evaluateQueryString, ElasticSearchQueryBase.this.evaluateHasContainers, ElasticSearchQueryBase.this.evaluateSortContainers, searchTime, hits);
            }
        };
    }

    public Iterable<Element> elements(final EnumSet<FetchHint> fetchHints) {
        return new PagingIterable<Element>(this.getParameters().getSkip(), this.getParameters().getLimit()){

            @Override
            protected ElasticSearchGraphQueryIterable<Element> getPageIterable(int skip, int limit) {
                SearchResponse response;
                long startTime = System.nanoTime();
                try {
                    response = ElasticSearchQueryBase.this.getSearchResponse(null, skip, limit);
                }
                catch (IndexMissingException ex) {
                    LOGGER.debug("Index missing: %s", new Object[]{ex.getMessage()});
                    return ElasticSearchQueryBase.this.createEmptyIterable();
                }
                catch (VertexiumNoMatchingPropertiesException ex) {
                    LOGGER.debug("Could not find property", (Throwable)((Object)ex));
                    return ElasticSearchQueryBase.this.createEmptyIterable();
                }
                SearchHits hits = response.getHits();
                ArrayList<String> vertexIds = new ArrayList<String>();
                ArrayList<String> edgeIds = new ArrayList<String>();
                ArrayList<String> ids = new ArrayList<String>();
                block7: for (SearchHit hit : hits) {
                    SearchHitField elementType = (SearchHitField)hit.getFields().get("__elementType");
                    if (elementType == null) continue;
                    ElasticSearchElementType et = ElasticSearchElementType.parse(elementType.getValue().toString());
                    ids.add(hit.getId());
                    switch (et) {
                        case VERTEX: {
                            vertexIds.add(hit.getId());
                            continue block7;
                        }
                        case EDGE: {
                            edgeIds.add(hit.getId());
                            continue block7;
                        }
                    }
                    LOGGER.warn("Unhandled element type returned: %s", new Object[]{elementType});
                }
                long endTime = System.nanoTime();
                long searchTime = endTime - startTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("elastic search results (vertices: %d, edges: %d = %d) of %d (time: %dms)", new Object[]{vertexIds.size(), edgeIds.size(), vertexIds.size() + edgeIds.size(), hits.getTotalHits(), (endTime - startTime) / 1000L / 1000L});
                }
                QueryParameters filterParameters = ElasticSearchQueryBase.this.getParameters().clone();
                filterParameters.setSkip(0L);
                Iterable vertices = ElasticSearchQueryBase.this.getGraph().getVertices(vertexIds, fetchHints, filterParameters.getAuthorizations());
                Iterable edges = ElasticSearchQueryBase.this.getGraph().getEdges(edgeIds, fetchHints, filterParameters.getAuthorizations());
                Object elements = new JoinIterable(new Iterable[]{new ToElementIterable(vertices), new ToElementIterable(edges)});
                elements = ElasticSearchQueryBase.this.sortByResultOrder((Iterable)elements, ids);
                return ElasticSearchQueryBase.this.createIterable(response, filterParameters, elements, ElasticSearchQueryBase.this.evaluateQueryString, ElasticSearchQueryBase.this.evaluateHasContainers, ElasticSearchQueryBase.this.evaluateSortContainers, searchTime, hits);
            }
        };
    }

    private <T extends Element> Iterable<T> sortByResultOrder(Iterable<T> elements, List<String> ids) {
        ImmutableMap elementsMap = Maps.uniqueIndex(elements, (Function)new Function<T, String>(){

            public String apply(T e) {
                return e.getId();
            }
        });
        ArrayList<Element> results = new ArrayList<Element>();
        for (String id : ids) {
            Element element = (Element)elementsMap.get((Object)id);
            if (element == null) continue;
            results.add(element);
        }
        return results;
    }

    private <T extends Element> EmptyElasticSearchGraphQueryIterable<T> createEmptyIterable() {
        return new EmptyElasticSearchGraphQueryIterable(this, this.getParameters());
    }

    protected <T extends Element> ElasticSearchGraphQueryIterable<T> createIterable(SearchResponse response, QueryParameters filterParameters, Iterable<T> elements, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, long searchTime, SearchHits hits) {
        return new ElasticSearchGraphQueryIterable<T>(this, response, filterParameters, elements, evaluateQueryString, evaluateHasContainers, evaluateSortContainers, hits.getTotalHits(), searchTime, hits);
    }

    private SearchResponse getSearchResponse(ElasticSearchElementType elementType, int skip, int limit) {
        List<FilterBuilder> filters = this.getFilters(elementType);
        QueryBuilder query = this.createQuery(this.getParameters(), elementType, filters);
        query = this.scoringStrategy.updateQuery(query);
        SearchRequestBuilder q = this.getSearchRequestBuilder(filters, query, elementType, skip, limit);
        this.applySort(q);
        if (QUERY_LOGGER.isTraceEnabled()) {
            QUERY_LOGGER.trace("query: %s", new Object[]{q});
        }
        return (SearchResponse)q.execute().actionGet();
    }

    protected void applySort(SearchRequestBuilder q) {
        for (QueryBase.SortContainer sortContainer : this.getParameters().getSortContainers()) {
            SortOrder esOrder = sortContainer.direction == SortDirection.ASCENDING ? SortOrder.ASC : SortOrder.DESC;
            for (String propertyName : this.getPropertyNames(sortContainer.propertyName)) {
                q.addSort(propertyName, esOrder);
            }
        }
    }

    protected List<FilterBuilder> getFilters(ElasticSearchElementType elementType) {
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        if (elementType != null) {
            this.addElementTypeFilter(filters, elementType);
        }
        for (QueryBase.HasContainer has : this.getParameters().getHasContainers()) {
            if (has instanceof QueryBase.HasValueContainer) {
                filters.add(this.getFiltersForHasValueContainer((QueryBase.HasValueContainer)has));
                continue;
            }
            if (has instanceof QueryBase.HasPropertyContainer) {
                filters.add(this.getFilterForHasPropertyContainer((QueryBase.HasPropertyContainer)has));
                continue;
            }
            if (has instanceof QueryBase.HasNotPropertyContainer) {
                filters.add(this.getFilterForHasNotPropertyContainer((QueryBase.HasNotPropertyContainer)has));
                continue;
            }
            throw new VertexiumException("Unexpected type " + has.getClass().getName());
        }
        if (this.getParameters().getEdgeLabels().size() > 0) {
            String[] edgeLabelsArray = this.getParameters().getEdgeLabels().toArray(new String[this.getParameters().getEdgeLabels().size()]);
            filters.add((FilterBuilder)FilterBuilders.inFilter((String)"__edgeLabel", (String[])edgeLabelsArray));
        }
        return filters;
    }

    protected FilterBuilder getFilterForHasNotPropertyContainer(QueryBase.HasNotPropertyContainer hasNotProperty) {
        String[] propertyNames;
        try {
            propertyNames = this.getPropertyNames(hasNotProperty.getKey());
        }
        catch (VertexiumNoMatchingPropertiesException ex) {
            return FilterBuilders.matchAllFilter();
        }
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        for (String propertyName : propertyNames) {
            filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.existsFilter((String)propertyName)));
        }
        return this.getSingleFilterOrAndTheFilters(filters);
    }

    protected FilterBuilder getFilterForHasPropertyContainer(QueryBase.HasPropertyContainer hasProperty) {
        String[] propertyNames = this.getPropertyNames(hasProperty.getKey());
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        for (String propertyName : propertyNames) {
            filters.add((FilterBuilder)FilterBuilders.existsFilter((String)propertyName));
        }
        return this.getSingleFilterOrOrTheFilters(filters);
    }

    protected FilterBuilder getFiltersForHasValueContainer(QueryBase.HasValueContainer has) {
        if (has.predicate instanceof Compare) {
            return this.getFilterForComparePredicate((Compare)has.predicate, has);
        }
        if (has.predicate instanceof Contains) {
            return this.getFilterForContainsPredicate((Contains)has.predicate, has);
        }
        if (has.predicate instanceof TextPredicate) {
            return this.getFilterForTextPredicate((TextPredicate)has.predicate, has);
        }
        if (has.predicate instanceof GeoCompare) {
            return this.getFilterForGeoComparePredicate((GeoCompare)has.predicate, has);
        }
        throw new VertexiumException("Unexpected predicate type " + has.predicate.getClass().getName());
    }

    protected FilterBuilder getFilterForGeoComparePredicate(GeoCompare compare, QueryBase.HasValueContainer has) {
        String[] keys = this.getPropertyNames(has.key);
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block3: for (String key : keys) {
            String propertyName = key + "_g";
            switch (compare) {
                case WITHIN: {
                    if (has.value instanceof GeoCircle) {
                        GeoCircle geoCircle = (GeoCircle)has.value;
                        double lat = geoCircle.getLatitude();
                        double lon = geoCircle.getLongitude();
                        double distance = geoCircle.getRadius();
                        PropertyDefinition propertyDefinition = (PropertyDefinition)this.getPropertyDefinitions().get(propertyName);
                        if (propertyDefinition != null && propertyDefinition.getDataType() == GeoCircle.class) {
                            CircleBuilder shapeBuilder = ShapeBuilder.newCircleBuilder().center(lon, lat).radius(distance, DistanceUnit.KILOMETERS);
                            filters.add((FilterBuilder)new GeoShapeFilterBuilder(propertyName, (ShapeBuilder)shapeBuilder));
                            continue block3;
                        }
                        filters.add((FilterBuilder)FilterBuilders.geoDistanceFilter((String)propertyName).point(lat, lon).distance(distance, DistanceUnit.KILOMETERS));
                        continue block3;
                    }
                    throw new VertexiumException("Unexpected has value type " + has.value.getClass().getName());
                }
                default: {
                    throw new VertexiumException("Unexpected GeoCompare predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters);
    }

    private FilterBuilder getSingleFilterOrOrTheFilters(List<FilterBuilder> filters) {
        if (filters.size() > 1) {
            return FilterBuilders.orFilter((FilterBuilder[])filters.toArray(new FilterBuilder[filters.size()]));
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        throw new VertexiumException("Unexpected filter count, expected at least 1 filter");
    }

    private FilterBuilder getSingleFilterOrAndTheFilters(List<FilterBuilder> filters) {
        if (filters.size() > 1) {
            return FilterBuilders.andFilter((FilterBuilder[])filters.toArray(new FilterBuilder[filters.size()]));
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        throw new VertexiumException("Unexpected filter count, expected at least 1 filter");
    }

    protected FilterBuilder getFilterForTextPredicate(TextPredicate compare, QueryBase.HasValueContainer has) {
        Object value = has.value;
        String[] keys = this.getPropertyNames(has.key);
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block3: for (String key : keys) {
            if (value instanceof String) {
                value = ((String)value).toLowerCase();
            }
            switch (compare) {
                case CONTAINS: {
                    if (value instanceof String) {
                        filters.add((FilterBuilder)FilterBuilders.termsFilter((String)key, (String[])this.splitStringIntoTerms((String)value)).execution("and"));
                        continue block3;
                    }
                    filters.add((FilterBuilder)FilterBuilders.termFilter((String)key, (Object)value));
                    continue block3;
                }
                default: {
                    throw new VertexiumException("Unexpected text predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters);
    }

    protected FilterBuilder getFilterForContainsPredicate(Contains contains, QueryBase.HasValueContainer has) {
        String[] keys = this.getPropertyNames(has.key);
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block4: for (String key : keys) {
            if (has.value instanceof Iterable) {
                has.value = IterableUtils.toArray((Iterable)((Iterable)has.value), Object.class);
            }
            if (has.value instanceof String || has.value instanceof String[] || has.value instanceof Object[] && ((Object[])has.value).length > 0 && ((Object[])has.value)[0] instanceof String) {
                key = key + "_e";
            }
            switch (contains) {
                case IN: {
                    filters.add((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])((Object[])has.value)));
                    continue block4;
                }
                case NOT_IN: {
                    filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])((Object[])has.value))));
                    continue block4;
                }
                default: {
                    throw new VertexiumException("Unexpected Contains predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters);
    }

    protected FilterBuilder getFilterForComparePredicate(Compare compare, QueryBase.HasValueContainer has) {
        Object value = has.value;
        String[] keys = this.getPropertyNames(has.key);
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block8: for (String key : keys) {
            if (value instanceof String || value instanceof String[]) {
                key = key + "_e";
            }
            switch (compare) {
                case EQUAL: {
                    if (value instanceof DateOnly) {
                        DateOnly dateOnlyValue = (DateOnly)value;
                        filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).from((Object)dateOnlyValue.toString()).to((Object)dateOnlyValue.toString()));
                        continue block8;
                    }
                    filters.add((FilterBuilder)FilterBuilders.termFilter((String)key, (Object)value));
                    continue block8;
                }
                case GREATER_THAN_EQUAL: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).gte(value));
                    continue block8;
                }
                case GREATER_THAN: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).gt(value));
                    continue block8;
                }
                case LESS_THAN_EQUAL: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).lte(value));
                    continue block8;
                }
                case LESS_THAN: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).lt(value));
                    continue block8;
                }
                case NOT_EQUAL: {
                    this.addNotFilter(filters, key, value);
                    continue block8;
                }
                default: {
                    throw new VertexiumException("Unexpected Compare predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters);
    }

    protected String[] getPropertyNames(String propertyName) {
        return this.getSearchIndex().getAllMatchingPropertyNames(this.getGraph(), propertyName, this.getParameters().getAuthorizations());
    }

    protected ElasticSearchSearchIndexBase getSearchIndex() {
        return (ElasticSearchSearchIndexBase)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
    }

    protected void addElementTypeFilter(List<FilterBuilder> filters, ElasticSearchElementType elementType) {
        if (elementType != null) {
            filters.add((FilterBuilder)this.createElementTypeFilter(elementType));
        }
    }

    protected TermsFilterBuilder createElementTypeFilter(ElasticSearchElementType elementType) {
        return FilterBuilders.inFilter((String)"__elementType", (String[])new String[]{elementType.getKey()});
    }

    protected void addNotFilter(List<FilterBuilder> filters, String key, Object value) {
        filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])new Object[]{value})));
    }

    protected SearchRequestBuilder getSearchRequestBuilder(List<FilterBuilder> filters, QueryBuilder queryBuilder, ElasticSearchElementType elementType, int skip, int limit) {
        AndFilterBuilder filterBuilder = this.getFilterBuilder(filters);
        Object[] indicesToQuery = this.getIndexSelectionStrategy().getIndicesToQuery(this, elementType);
        if (QUERY_LOGGER.isTraceEnabled()) {
            QUERY_LOGGER.trace("indicesToQuery: %s", new Object[]{Joiner.on((String)", ").join(indicesToQuery)});
        }
        return this.getClient().prepareSearch((String[])indicesToQuery).setTypes(new String[]{"element"}).setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder)).addField("__elementType").setFrom(skip).setSize(limit);
    }

    protected AndFilterBuilder getFilterBuilder(List<FilterBuilder> filters) {
        return FilterBuilders.andFilter((FilterBuilder[])filters.toArray(new FilterBuilder[filters.size()]));
    }

    private String[] splitStringIntoTerms(String value) {
        try {
            ArrayList<String> results = new ArrayList<String>();
            try (TokenStream tokens = this.analyzer.tokenStream("", value);){
                CharTermAttribute term = (CharTermAttribute)tokens.getAttribute(CharTermAttribute.class);
                tokens.reset();
                while (tokens.incrementToken()) {
                    String t = term.toString().trim();
                    if (t.length() <= 0) continue;
                    results.add(t);
                }
            }
            return results.toArray(new String[results.size()]);
        }
        catch (IOException e) {
            throw new VertexiumException("Could not tokenize string: " + value, (Throwable)e);
        }
    }

    protected QueryBuilder createQuery(QueryParameters queryParameters, ElasticSearchElementType elementType, List<FilterBuilder> filters) {
        if (queryParameters instanceof QueryStringQueryParameters) {
            return this.createQueryStringQuery((QueryStringQueryParameters)queryParameters);
        }
        if (queryParameters instanceof SimilarToTextQueryParameters) {
            return this.createSimilarToTextQuery((SimilarToTextQueryParameters)queryParameters);
        }
        throw new VertexiumException("Query parameters not supported of type: " + queryParameters.getClass().getName());
    }

    protected QueryBuilder createSimilarToTextQuery(SimilarToTextQueryParameters queryParameters) {
        String[] fields;
        SimilarToTextQueryParameters similarTo = queryParameters;
        ArrayList allFields = new ArrayList();
        for (String field : fields = similarTo.getFields()) {
            Collections.addAll(allFields, this.getPropertyNames(field));
        }
        MoreLikeThisQueryBuilder q = QueryBuilders.moreLikeThisQuery((String[])allFields.toArray(new String[allFields.size()])).likeText(similarTo.getText());
        if (similarTo.getPercentTermsToMatch() != null) {
            q.percentTermsToMatch(similarTo.getPercentTermsToMatch().floatValue());
        }
        if (similarTo.getMinTermFrequency() != null) {
            q.minTermFreq(similarTo.getMinTermFrequency().intValue());
        }
        if (similarTo.getMaxQueryTerms() != null) {
            q.maxQueryTerms(similarTo.getMaxQueryTerms().intValue());
        }
        if (similarTo.getMinDocFrequency() != null) {
            q.minDocFreq(similarTo.getMinDocFrequency().intValue());
        }
        if (similarTo.getMaxDocFrequency() != null) {
            q.maxDocFreq(similarTo.getMaxDocFrequency().intValue());
        }
        if (similarTo.getBoost() != null) {
            q.boost(similarTo.getBoost().floatValue());
        }
        return q;
    }

    protected QueryBuilder createQueryStringQuery(QueryStringQueryParameters queryParameters) {
        String queryString = queryParameters.getQueryString();
        if (queryString == null || queryString.equals("*")) {
            return QueryBuilders.matchAllQuery();
        }
        return QueryBuilders.queryString((String)queryString);
    }

    public Client getClient() {
        return this.client;
    }

    protected void addGeohashQueryToSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, List<GeohashQueryItem> geohashQueryItems) {
        for (GeohashQueryItem geohashQueryItem : geohashQueryItems) {
            for (String propertyName : this.getPropertyNames(geohashQueryItem.getFieldName())) {
                String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
                String aggName = this.createAggregationName(geohashQueryItem.getAggregationName(), visibilityHash);
                GeoHashGridBuilder agg = AggregationBuilders.geohashGrid((String)aggName);
                agg.field(propertyName + "_g");
                agg.precision(geohashQueryItem.getPrecision());
                searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg);
            }
        }
    }

    protected void addStatisticsQueryToSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, List<StatisticsQueryItem> statisticsQueryItems) {
        for (StatisticsQueryItem statisticsQueryItem : statisticsQueryItems) {
            for (String propertyName : this.getPropertyNames(statisticsQueryItem.getFieldName())) {
                String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
                String aggName = this.createAggregationName(statisticsQueryItem.getAggregationName(), visibilityHash);
                ExtendedStatsBuilder agg = AggregationBuilders.extendedStats((String)aggName);
                agg.field(propertyName);
                searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg);
            }
        }
    }

    private String createAggregationName(String aggName, String visibilityHash) {
        if (visibilityHash != null && visibilityHash.length() > 0) {
            return aggName + "_" + visibilityHash;
        }
        return aggName;
    }

    protected void addTermsQueryToSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, List<TermsQueryItem> termsQueryItems) {
        for (TermsQueryItem termsQueryItem : termsQueryItems) {
            String fieldName = termsQueryItem.getFieldName();
            PropertyDefinition propertyDefinition = this.getPropertyDefinition(fieldName);
            for (String propertyName : this.getPropertyNames(fieldName)) {
                if (propertyDefinition != null && propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                    propertyName = propertyName + "_e";
                }
                String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
                TermsBuilder agg = AggregationBuilders.terms((String)this.createAggregationName(termsQueryItem.getAggregationName(), visibilityHash));
                agg.field(propertyName);
                searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg);
            }
        }
    }

    protected void addHistogramQueryToSearchRequestBuilder(SearchRequestBuilder searchRequestBuilder, List<HistogramQueryItem> histogramQueryItems) {
        for (HistogramQueryItem histogramQueryItem : histogramQueryItems) {
            PropertyDefinition propertyDefinition = this.getPropertyDefinition(histogramQueryItem.getFieldName());
            if (propertyDefinition == null) {
                throw new VertexiumException("Could not find mapping for property: " + histogramQueryItem.getFieldName());
            }
            Class propertyDataType = propertyDefinition.getDataType();
            for (String propertyName : this.getPropertyNames(histogramQueryItem.getFieldName())) {
                DateHistogramBuilder agg;
                String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
                String aggName = this.createAggregationName(histogramQueryItem.getAggregationName(), visibilityHash);
                if (propertyDataType == Date.class) {
                    agg = AggregationBuilders.dateHistogram((String)aggName);
                    agg.field(propertyName);
                    agg.interval(new DateHistogram.Interval(histogramQueryItem.getInterval()));
                    if (histogramQueryItem.getMinDocumentCount() != null) {
                        agg.minDocCount(histogramQueryItem.getMinDocumentCount().longValue());
                    }
                    searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg);
                    continue;
                }
                agg = AggregationBuilders.histogram((String)aggName);
                agg.field(propertyName);
                agg.interval(Long.parseLong(histogramQueryItem.getInterval()));
                if (histogramQueryItem.getMinDocumentCount() != null) {
                    agg.minDocCount(histogramQueryItem.getMinDocumentCount().longValue());
                }
                searchRequestBuilder.addAggregation((AbstractAggregationBuilder)agg);
            }
        }
    }

    private PropertyDefinition getPropertyDefinition(String propertyName) {
        return this.getSearchIndex().getPropertyDefinition(this.getGraph(), propertyName);
    }

    protected IndexSelectionStrategy getIndexSelectionStrategy() {
        return this.indexSelectionStrategy;
    }

    public String getAggregationName(String name) {
        return this.getSearchIndex().getAggregationName(name);
    }
}

