/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import org.vertexium.Graph;
import org.vertexium.GraphConfiguration;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.DefaultIndexSelectionStrategy;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.elasticsearch.score.EdgeCountScoringStrategy;
import org.vertexium.elasticsearch.score.ScoringStrategy;
import org.vertexium.id.IdentityNameSubstitutionStrategy;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.util.ConfigurationUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class ElasticSearchSearchIndexConfiguration {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ElasticSearchSearchIndexConfiguration.class);
    public static final String STORE_SOURCE_DATA = "storeSourceData";
    public static final boolean STORE_SOURCE_DATA_DEFAULT = false;
    public static final String ES_LOCATIONS = "locations";
    public static final String INDEX_EDGES = "indexEdges";
    public static final boolean INDEX_EDGES_DEFAULT = true;
    public static final boolean AUTO_FLUSH_DEFAULT = false;
    public static final String CLUSTER_NAME = "clusterName";
    public static final String CLUSTER_NAME_DEFAULT = null;
    public static final String PORT = "port";
    public static final int PORT_DEFAULT = 9300;
    public static final String NUMBER_OF_SHARDS = "shards";
    public static final int NUMBER_OF_SHARDS_DEFAULT = 5;
    public static final int NUMBER_OF_SHARDS_IN_PROCESS_DEFAULT = 1;
    public static final String AUTHORIZATION_FILTER_ENABLED = "authorizationFilterEnabled";
    public static final boolean AUTHORIZATION_FILTER_ENABLED_DEFAULT = true;
    public static final String SCORING_STRATEGY_CLASS_NAME = "scoringStrategy";
    public static final Class<? extends ScoringStrategy> SCORING_STRATEGY_CLASS_NAME_DEFAULT = EdgeCountScoringStrategy.class;
    public static final String NAME_SUBSTITUTION_STRATEGY_CLASS_NAME = "nameSubstitutionStrategy";
    public static final Class<? extends NameSubstitutionStrategy> NAME_SUBSTITUTION_STRATEGY_CLASS_NAME_DEFAULT = IdentityNameSubstitutionStrategy.class;
    public static final String INDEX_SELECTION_STRATEGY_CLASS_NAME = "indexSelectionStrategy";
    public static final Class<? extends IndexSelectionStrategy> INDEX_SELECTION_STRATEGY_CLASS_NAME_DEFAULT = DefaultIndexSelectionStrategy.class;
    public static final String ALL_FIELD_ENABLED = "allFieldEnabled";
    public static final String IN_PROCESS_NODE = "inProcessNode";
    public static final boolean IN_PROCESS_NODE_DEFAULT = false;
    public static final String IN_PROCESS_NODE_DATA_PATH = "inProcessNode.dataPath";
    public static final String IN_PROCESS_NODE_LOGS_PATH = "inProcessNode.logsPath";
    public static final String IN_PROCESS_NODE_WORK_PATH = "inProcessNode.workPath";
    private GraphConfiguration graphConfiguration;
    private IndexSelectionStrategy indexSelectionStrategy;
    private ScoringStrategy scoringStrategy;
    private NameSubstitutionStrategy nameSubstitutionStrategy;

    public ElasticSearchSearchIndexConfiguration(Graph graph, GraphConfiguration graphConfiguration) {
        this.graphConfiguration = graphConfiguration;
        this.scoringStrategy = ElasticSearchSearchIndexConfiguration.getScoringStrategy(graph, graphConfiguration);
        this.nameSubstitutionStrategy = ElasticSearchSearchIndexConfiguration.getNameSubstitutionStrategy(graph, graphConfiguration);
        this.indexSelectionStrategy = ElasticSearchSearchIndexConfiguration.getIndexSelectionStrategy(graph, graphConfiguration);
    }

    public ScoringStrategy getScoringStrategy() {
        return this.scoringStrategy;
    }

    public NameSubstitutionStrategy getNameSubstitutionStrategy() {
        return this.nameSubstitutionStrategy;
    }

    public IndexSelectionStrategy getIndexSelectionStrategy() {
        return this.indexSelectionStrategy;
    }

    public boolean isAutoFlush() {
        return this.graphConfiguration.getBoolean("autoFlush", false);
    }

    public boolean isStoreSourceData() {
        return this.graphConfiguration.getBoolean("search.storeSourceData", false);
    }

    public boolean isIndexEdges() {
        return this.graphConfiguration.getBoolean("search.indexEdges", true);
    }

    public String[] getEsLocations() {
        String esLocationsString = this.graphConfiguration.getString("search.locations", null);
        if (esLocationsString == null) {
            throw new VertexiumException("search.locations is a required configuration parameter");
        }
        return esLocationsString.split(",");
    }

    public String getClusterName() {
        return this.graphConfiguration.getString("search.clusterName", CLUSTER_NAME_DEFAULT);
    }

    public int getPort() {
        return this.graphConfiguration.getInt("search.port", 9300);
    }

    private static ScoringStrategy getScoringStrategy(Graph graph, GraphConfiguration config) {
        String className = config.getString("search.scoringStrategy", SCORING_STRATEGY_CLASS_NAME_DEFAULT.getName());
        return (ScoringStrategy)ConfigurationUtils.createProvider((String)className, (Graph)graph, (GraphConfiguration)config);
    }

    private static NameSubstitutionStrategy getNameSubstitutionStrategy(Graph graph, GraphConfiguration config) {
        String className = config.getString("search.nameSubstitutionStrategy", NAME_SUBSTITUTION_STRATEGY_CLASS_NAME_DEFAULT.getName());
        NameSubstitutionStrategy strategy = (NameSubstitutionStrategy)ConfigurationUtils.createProvider((String)className, (Graph)graph, (GraphConfiguration)config);
        strategy.setup(config.getConfig());
        return strategy;
    }

    public static IndexSelectionStrategy getIndexSelectionStrategy(Graph graph, GraphConfiguration config) {
        String className = config.getString("search.indexSelectionStrategy", INDEX_SELECTION_STRATEGY_CLASS_NAME_DEFAULT.getName());
        IndexSelectionStrategy strategy = (IndexSelectionStrategy)ConfigurationUtils.createProvider((String)className, (Graph)graph, (GraphConfiguration)config);
        return strategy;
    }

    public int getNumberOfShards() {
        int numberOfShardsDefault = this.getNumberOfShardsDefault();
        return this.graphConfiguration.getInt("search.shards", numberOfShardsDefault);
    }

    public int getNumberOfShardsDefault() {
        return this.isInProcessNode() ? 1 : 5;
    }

    public boolean isAuthorizationFilterEnabled() {
        return this.graphConfiguration.getBoolean("search.authorizationFilterEnabled", true);
    }

    public boolean isAllFieldEnabled(boolean defaultAllFieldEnabled) {
        return this.graphConfiguration.getBoolean("search.allFieldEnabled", defaultAllFieldEnabled);
    }

    public boolean isInProcessNode() {
        return this.graphConfiguration.getBoolean("search.inProcessNode", false);
    }

    public String getInProcessNodeDataPath() {
        return this.graphConfiguration.getString("search.inProcessNode.dataPath", null);
    }

    public String getInProcessNodeLogsPath() {
        return this.graphConfiguration.getString("search.inProcessNode.logsPath", null);
    }

    public String getInProcessNodeWorkPath() {
        return this.graphConfiguration.getString("search.inProcessNode.workPath", null);
    }
}

