/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch.utils;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.vertexium.Element;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchGraphQueryIterable;
import org.vertexium.query.GeohashResult;
import org.vertexium.query.HistogramResult;
import org.vertexium.query.IterableWithGeohashResults;
import org.vertexium.query.IterableWithHistogramResults;
import org.vertexium.query.IterableWithScores;
import org.vertexium.query.IterableWithStatisticsResults;
import org.vertexium.query.IterableWithTermsResults;
import org.vertexium.query.IterableWithTotalHits;
import org.vertexium.query.StatisticsResult;
import org.vertexium.query.TermsResult;

public abstract class PagingIterable<T extends Element>
implements Iterable<T>,
IterableWithTotalHits<T>,
IterableWithScores<T>,
IterableWithHistogramResults<T>,
IterableWithTermsResults<T>,
IterableWithGeohashResults<T>,
IterableWithStatisticsResults<T> {
    private static final int PAGE_SIZE = 1000;
    private final long skip;
    private final Long limit;
    private boolean isFirstCallToIterator;
    private final ElasticSearchGraphQueryIterable<T> firstIterable;

    public PagingIterable(long skip, Long limit) {
        this.skip = skip;
        this.limit = limit;
        int firstIterableLimit = Math.min(1000, limit == null ? Integer.MAX_VALUE : limit.intValue());
        this.firstIterable = this.getPageIterable((int)this.skip, firstIterableLimit);
        this.isFirstCallToIterator = true;
    }

    public GeohashResult getGeohashResults(String name) {
        return this.firstIterable.getGeohashResults(name);
    }

    public HistogramResult getHistogramResults(String name) {
        return this.firstIterable.getHistogramResults(name);
    }

    public StatisticsResult getStatisticsResults(String name) {
        return this.firstIterable.getStatisticsResults(name);
    }

    public Map<String, Double> getScores() {
        return this.firstIterable.getScores();
    }

    public TermsResult getTermsResults(String name) {
        return this.firstIterable.getTermsResults(name);
    }

    public long getTotalHits() {
        return this.firstIterable.getTotalHits();
    }

    protected abstract ElasticSearchGraphQueryIterable<T> getPageIterable(int var1, int var2);

    @Override
    public Iterator<T> iterator() {
        MyIterator it = new MyIterator(this.isFirstCallToIterator ? this.firstIterable : null);
        this.isFirstCallToIterator = false;
        return it;
    }

    private class MyIterator
    implements Iterator<T> {
        private ElasticSearchGraphQueryIterable<T> firstIterable;
        private int nextSkip;
        private int limit;
        private int currentIteratorCount;
        private Iterator<T> currentIterator;

        public MyIterator(ElasticSearchGraphQueryIterable<T> firstIterable) {
            this.firstIterable = firstIterable;
            this.nextSkip = (int)PagingIterable.this.skip;
            this.limit = (int)(PagingIterable.this.limit == null ? Integer.MAX_VALUE : PagingIterable.this.limit);
            this.currentIterator = this.getNextIterator();
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currentIterator == null) {
                    if (this.currentIteratorCount == 0) {
                        return false;
                    }
                    this.currentIterator = this.getNextIterator();
                    if (this.currentIterator == null) {
                        return false;
                    }
                }
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                this.currentIterator = null;
            }
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                --this.limit;
                ++this.currentIteratorCount;
                return (Element)this.currentIterator.next();
            }
            throw new NoSuchElementException();
        }

        private Iterator<T> getNextIterator() {
            if (this.limit <= 0) {
                return null;
            }
            int limit = Math.min(1000, this.limit);
            this.currentIteratorCount = 0;
            if (this.firstIterable == null) {
                this.firstIterable = PagingIterable.this.getPageIterable(this.nextSkip, limit);
            }
            Iterator it = this.firstIterable.iterator();
            this.firstIterable = null;
            this.nextSkip += limit;
            return it;
        }

        @Override
        public void remove() {
            throw new VertexiumException("remove not implemented");
        }
    }
}

