/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveCompaction;
import org.apache.accumulo.core.client.admin.InstanceOperations;
import org.apache.accumulo.core.client.impl.ActiveCompactionImpl;
import org.apache.accumulo.core.client.impl.ActiveScanImpl;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.ClientExecReturn;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.ServerClient;
import org.apache.accumulo.core.client.impl.ServerConfigurationUtil;
import org.apache.accumulo.core.client.impl.thrift.ClientService;
import org.apache.accumulo.core.client.impl.thrift.ConfigurationType;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.tabletserver.thrift.ActiveScan;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooCacheFactory;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class InstanceOperationsImpl
implements InstanceOperations {
    private Instance instance;
    private Credentials credentials;

    public InstanceOperationsImpl(Instance instance, Credentials credentials) {
        ArgumentChecker.notNull(instance, credentials);
        this.instance = instance;
        this.credentials = credentials;
    }

    @Override
    public void setProperty(final String property, final String value) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(property, value);
        MasterClient.execute(this.instance, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.setSystemProperty(Tracer.traceInfo(), InstanceOperationsImpl.this.credentials.toThrift(InstanceOperationsImpl.this.instance), property, value);
            }
        });
    }

    @Override
    public void removeProperty(final String property) throws AccumuloException, AccumuloSecurityException {
        ArgumentChecker.notNull(property);
        MasterClient.execute(this.instance, new ClientExec<MasterClientService.Client>(){

            @Override
            public void execute(MasterClientService.Client client) throws Exception {
                client.removeSystemProperty(Tracer.traceInfo(), InstanceOperationsImpl.this.credentials.toThrift(InstanceOperationsImpl.this.instance), property);
            }
        });
    }

    @Override
    public Map<String, String> getSystemConfiguration() throws AccumuloException, AccumuloSecurityException {
        return ServerClient.execute(this.instance, new ClientExecReturn<Map<String, String>, ClientService.Client>(){

            @Override
            public Map<String, String> execute(ClientService.Client client) throws Exception {
                return client.getConfiguration(Tracer.traceInfo(), InstanceOperationsImpl.this.credentials.toThrift(InstanceOperationsImpl.this.instance), ConfigurationType.CURRENT);
            }
        });
    }

    @Override
    public Map<String, String> getSiteConfiguration() throws AccumuloException, AccumuloSecurityException {
        return ServerClient.execute(this.instance, new ClientExecReturn<Map<String, String>, ClientService.Client>(){

            @Override
            public Map<String, String> execute(ClientService.Client client) throws Exception {
                return client.getConfiguration(Tracer.traceInfo(), InstanceOperationsImpl.this.credentials.toThrift(InstanceOperationsImpl.this.instance), ConfigurationType.SITE);
            }
        });
    }

    @Override
    public List<String> getTabletServers() {
        ZooCache cache = new ZooCacheFactory().getZooCache(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut());
        String path = ZooUtil.getRoot(this.instance) + "/tservers";
        ArrayList<String> results = new ArrayList<String>();
        for (String candidate : cache.getChildren(path)) {
            List children = cache.getChildren(path + "/" + candidate);
            if (children == null || children.size() <= 0) continue;
            ArrayList copy = new ArrayList(children);
            Collections.sort(copy);
            byte[] data = cache.get(path + "/" + candidate + "/" + (String)copy.get(0));
            if (data == null || "master".equals(new String(data, Constants.UTF8))) continue;
            results.add(candidate);
        }
        return results;
    }

    @Override
    public List<org.apache.accumulo.core.client.admin.ActiveScan> getActiveScans(String tserver) throws AccumuloException, AccumuloSecurityException {
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getTServerClient(tserver, ServerConfigurationUtil.getConfiguration(this.instance));
            ArrayList<org.apache.accumulo.core.client.admin.ActiveScan> as = new ArrayList<org.apache.accumulo.core.client.admin.ActiveScan>();
            for (ActiveScan activeScan : client.getActiveScans(Tracer.traceInfo(), this.credentials.toThrift(this.instance))) {
                try {
                    as.add(new ActiveScanImpl(this.instance, activeScan));
                }
                catch (TableNotFoundException e) {
                    throw new AccumuloException(e);
                }
            }
            ArrayList<org.apache.accumulo.core.client.admin.ActiveScan> arrayList = as;
            return arrayList;
        }
        catch (TTransportException e) {
            throw new AccumuloException(e);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
        finally {
            if (client != null) {
                ThriftUtil.returnClient(client);
            }
        }
    }

    @Override
    public boolean testClassLoad(final String className, final String asTypeName) throws AccumuloException, AccumuloSecurityException {
        return ServerClient.execute(this.instance, new ClientExecReturn<Boolean, ClientService.Client>(){

            @Override
            public Boolean execute(ClientService.Client client) throws Exception {
                return client.checkClass(Tracer.traceInfo(), InstanceOperationsImpl.this.credentials.toThrift(InstanceOperationsImpl.this.instance), className, asTypeName);
            }
        });
    }

    @Override
    public List<ActiveCompaction> getActiveCompactions(String tserver) throws AccumuloException, AccumuloSecurityException {
        TabletClientService.Client client = null;
        try {
            client = ThriftUtil.getTServerClient(tserver, ServerConfigurationUtil.getConfiguration(this.instance));
            ArrayList<ActiveCompaction> as = new ArrayList<ActiveCompaction>();
            for (org.apache.accumulo.core.tabletserver.thrift.ActiveCompaction activeCompaction : client.getActiveCompactions(Tracer.traceInfo(), this.credentials.toThrift(this.instance))) {
                as.add(new ActiveCompactionImpl(this.instance, activeCompaction));
            }
            ArrayList<ActiveCompaction> arrayList = as;
            return arrayList;
        }
        catch (TTransportException e) {
            throw new AccumuloException(e);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
        finally {
            if (client != null) {
                ThriftUtil.returnClient(client);
            }
        }
    }

    @Override
    public void ping(String tserver) throws AccumuloException {
        TTransport transport = null;
        try {
            transport = ThriftUtil.createTransport(AddressUtil.parseAddress(tserver, false), ServerConfigurationUtil.getConfiguration(this.instance));
            TabletClientService.Client client = ThriftUtil.createClient(new TabletClientService.Client.Factory(), transport);
            client.getTabletServerStatus(Tracer.traceInfo(), this.credentials.toThrift(this.instance));
        }
        catch (TTransportException e) {
            throw new AccumuloException(e);
        }
        catch (ThriftSecurityException e) {
            throw new AccumuloException((Throwable)((Object)e));
        }
        catch (TException e) {
            throw new AccumuloException(e);
        }
        finally {
            if (transport != null) {
                transport.close();
            }
        }
    }
}

