/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.property.MutableProperty;
import org.vertexium.property.PropertyValue;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.FilterIterable;

public abstract class ElementBase
implements Element {
    private final Graph graph;
    private final String id;
    private Visibility visibility;
    private final long timestamp;
    private Set<Visibility> hiddenVisibilities = new HashSet<Visibility>();
    private final ConcurrentSkipListSet<Property> properties;
    private ConcurrentSkipListSet<PropertyDeleteMutation> propertyDeleteMutations;
    private ConcurrentSkipListSet<PropertySoftDeleteMutation> propertySoftDeleteMutations;
    private final Authorizations authorizations;

    protected ElementBase(Graph graph, String id, Visibility visibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, long timestamp, Authorizations authorizations) {
        this.graph = graph;
        this.id = id;
        this.visibility = visibility;
        this.timestamp = timestamp;
        this.properties = new ConcurrentSkipListSet();
        this.authorizations = authorizations;
        if (hiddenVisibilities != null) {
            for (Visibility v : hiddenVisibilities) {
                this.hiddenVisibilities.add(v);
            }
        }
        this.updatePropertiesInternal(properties, propertyDeleteMutations, propertySoftDeleteMutations);
    }

    @Override
    public Iterable<Object> getPropertyValues(String name) {
        return new ConvertingIterable<Property, Object>(this.getProperties(name)){

            @Override
            protected Object convert(Property p) {
                return p.getValue();
            }
        };
    }

    @Override
    public Iterable<Object> getPropertyValues(String key, String name) {
        return new ConvertingIterable<Property, Object>(this.getProperties(key, name)){

            @Override
            protected Object convert(Property p) {
                return p.getValue();
            }
        };
    }

    @Override
    public Property getProperty(String name, Visibility visibility) {
        return this.getProperty("", name, visibility);
    }

    @Override
    public Property getProperty(String key, String name, Visibility visibility) {
        for (Property p : this.getProperties()) {
            if (!p.getKey().equals(key) || !p.getName().equals(name)) continue;
            if (visibility == null) {
                return p;
            }
            if (!visibility.equals(p.getVisibility())) continue;
            return p;
        }
        return null;
    }

    @Override
    public Property getProperty(String key, String name) {
        return this.getProperty(key, name, null);
    }

    @Override
    public Property getProperty(String name) {
        Iterator<Property> propertiesWithName = this.getProperties(name).iterator();
        if (propertiesWithName.hasNext()) {
            return propertiesWithName.next();
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getPropertyValue(name, 0);
    }

    @Override
    public Object getPropertyValue(String name, int index) {
        Iterator<Object> values = this.getPropertyValues(name).iterator();
        while (values.hasNext() && index >= 0) {
            Object v = values.next();
            if (index == 0) {
                return v;
            }
            --index;
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String key, String name, int index) {
        Iterator<Object> values = this.getPropertyValues(key, name).iterator();
        while (values.hasNext() && index >= 0) {
            Object v = values.next();
            if (index == 0) {
                return v;
            }
            --index;
        }
        return null;
    }

    @Override
    public Object getPropertyValue(String key, String name) {
        return this.getPropertyValue(key, name, 0);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    protected void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Override
    public Iterable<Property> getProperties() {
        return this.properties;
    }

    public Iterable<PropertyDeleteMutation> getPropertyDeleteMutations() {
        return this.propertyDeleteMutations;
    }

    public Iterable<PropertySoftDeleteMutation> getPropertySoftDeleteMutations() {
        return this.propertySoftDeleteMutations;
    }

    @Override
    public Iterable<Property> getProperties(final String name) {
        return new FilterIterable<Property>(this.getProperties()){

            @Override
            protected boolean isIncluded(Property property) {
                return property.getName().equals(name);
            }
        };
    }

    @Override
    public Iterable<Property> getProperties(final String key, final String name) {
        return new FilterIterable<Property>(this.getProperties()){

            @Override
            protected boolean isIncluded(Property property) {
                return property.getName().equals(name) && property.getKey().equals(key);
            }
        };
    }

    protected void updatePropertiesInternal(Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations) {
        if (propertyDeleteMutations != null) {
            this.propertyDeleteMutations = new ConcurrentSkipListSet();
            for (PropertyDeleteMutation propertyDeleteMutation : propertyDeleteMutations) {
                this.removePropertyInternal(propertyDeleteMutation.getKey(), propertyDeleteMutation.getName(), propertyDeleteMutation.getVisibility());
                this.propertyDeleteMutations.add(propertyDeleteMutation);
            }
        }
        if (propertySoftDeleteMutations != null) {
            this.propertySoftDeleteMutations = new ConcurrentSkipListSet();
            for (PropertySoftDeleteMutation propertySoftDeleteMutation : propertySoftDeleteMutations) {
                this.removePropertyInternal(propertySoftDeleteMutation.getKey(), propertySoftDeleteMutation.getName(), propertySoftDeleteMutation.getVisibility());
                this.propertySoftDeleteMutations.add(propertySoftDeleteMutation);
            }
        }
        for (Property property : properties) {
            this.addPropertyInternal(property);
        }
    }

    protected void addPropertyInternal(Property property) {
        if (property.getKey() == null) {
            throw new IllegalArgumentException("key is required for property");
        }
        Object propertyValue = property.getValue();
        if (propertyValue instanceof PropertyValue && !((PropertyValue)propertyValue).isStore()) {
            return;
        }
        Property existingProperty = this.getProperty(property.getKey(), property.getName(), property.getVisibility());
        if (existingProperty == null) {
            this.properties.add(property);
        } else if (existingProperty instanceof MutableProperty) {
            ((MutableProperty)existingProperty).update(property);
        } else {
            throw new VertexiumException("Could not update property of type: " + existingProperty.getClass().getName());
        }
    }

    protected Property removePropertyInternal(String key, String name, Visibility visibility) {
        Property property = this.getProperty(key, name, visibility);
        if (property != null) {
            this.properties.remove(property);
        }
        return property;
    }

    protected Property removePropertyInternal(String key, String name) {
        Property property = this.getProperty(key, name);
        if (property != null) {
            this.properties.remove(property);
        }
        return property;
    }

    protected Property softDeletePropertyInternal(String key, String name) {
        Property property = this.getProperty(key, name);
        if (property != null) {
            this.properties.remove(property);
        }
        return property;
    }

    protected Property softDeletePropertyInternal(String key, String name, Visibility visibility) {
        Property property = this.getProperty(key, name, visibility);
        if (property != null) {
            this.properties.remove(property);
        }
        return property;
    }

    protected Iterable<Property> removePropertyInternal(String name) {
        ArrayList<Property> removedProperties = new ArrayList<Property>();
        for (Property p : this.properties) {
            if (!p.getName().equals(name)) continue;
            removedProperties.add(p);
        }
        for (Property p : removedProperties) {
            this.properties.remove(p);
        }
        return removedProperties;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        if (this instanceof Edge) {
            Edge edge = (Edge)((Object)this);
            return this.getId() + ":[" + edge.getVertexId(Direction.OUT) + "-" + edge.getLabel() + "->" + edge.getVertexId(Direction.IN) + "]";
        }
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element objElem = (Element)obj;
            return this.getId().equals(objElem.getId());
        }
        return super.equals(obj);
    }

    @Override
    public abstract void deleteProperty(String var1, String var2, Authorizations var3);

    @Override
    public abstract void deleteProperties(String var1, Authorizations var2);

    @Override
    public abstract void softDeleteProperty(String var1, String var2, Authorizations var3);

    @Override
    public abstract void softDeleteProperty(String var1, String var2, Visibility var3, Authorizations var4);

    @Override
    public abstract void softDeleteProperties(String var1, Authorizations var2);

    @Override
    public void addPropertyValue(String key, String name, Object value, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().addPropertyValue(key, name, value, visibility).save(authorizations);
    }

    @Override
    public void addPropertyValue(String key, String name, Object value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().addPropertyValue(key, name, value, metadata, visibility).save(authorizations);
    }

    @Override
    public void setProperty(String name, Object value, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().setProperty(name, value, visibility).save(authorizations);
    }

    @Override
    public void setProperty(String name, Object value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        this.prepareMutation().setProperty(name, value, metadata, visibility).save(authorizations);
    }

    @Override
    public void markPropertyHidden(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Iterable<Property> properties = this.getProperties(key, name);
        for (Property property : properties) {
            if (!property.getVisibility().equals(propertyVisibility)) continue;
            this.markPropertyHidden(property, timestamp, visibility, authorizations);
            return;
        }
        throw new IllegalArgumentException("Could not find property " + key + " : " + name + " : " + propertyVisibility);
    }

    @Override
    public void markPropertyHidden(String key, String name, Visibility propertyVisibility, Visibility visibility, Authorizations authorizations) {
        this.markPropertyHidden(key, name, propertyVisibility, null, visibility, authorizations);
    }

    @Override
    public void markPropertyHidden(Property property, Visibility visibility, Authorizations authorizations) {
        this.markPropertyHidden(property, null, visibility, authorizations);
    }

    @Override
    public void markPropertyVisible(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Iterable<Property> properties = this.getProperties(key, name);
        for (Property property : properties) {
            if (!property.getVisibility().equals(propertyVisibility)) continue;
            this.markPropertyVisible(property, timestamp, visibility, authorizations);
            return;
        }
        throw new IllegalArgumentException("Could not find property " + key + " : " + name + " : " + propertyVisibility);
    }

    @Override
    public void markPropertyVisible(String key, String name, Visibility propertyVisibility, Visibility visibility, Authorizations authorizations) {
        this.markPropertyVisible(key, name, propertyVisibility, null, visibility, authorizations);
    }

    @Override
    public void markPropertyVisible(Property property, Visibility visibility, Authorizations authorizations) {
        this.markPropertyVisible(property, null, visibility, authorizations);
    }

    @Override
    public abstract <T extends Element> ExistingElementMutation<T> prepareMutation();

    @Override
    public abstract void markPropertyHidden(Property var1, Long var2, Visibility var3, Authorizations var4);

    @Override
    public abstract void markPropertyVisible(Property var1, Long var2, Visibility var3, Authorizations var4);

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public void mergeProperties(Element element) {
        for (Property property : element.getProperties()) {
            this.properties.remove(property);
            this.properties.add(property);
        }
    }

    @Override
    public Iterable<Visibility> getHiddenVisibilities() {
        return this.hiddenVisibilities;
    }

    @Override
    public boolean isHidden(Authorizations authorizations) {
        for (Visibility visibility : this.getHiddenVisibilities()) {
            if (!authorizations.canRead(visibility)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Authorizations authorizations) {
        return this.getHistoricalPropertyValues(key, name, visibility, null, null, authorizations);
    }

    @Override
    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, final Long startTime, final Long endTime, Authorizations authorizations) {
        return new FilterIterable<HistoricalPropertyValue>(this.getHistoricalPropertyValues(key, name, visibility, authorizations)){

            @Override
            protected boolean isIncluded(HistoricalPropertyValue pv) {
                if (startTime != null && pv.getTimestamp() < startTime) {
                    return false;
                }
                return endTime == null || pv.getTimestamp() <= endTime;
            }
        };
    }
}

