/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.vertexium.util.CloseableUtils;

public class IterableUtils {
    public static <T> List<T> toList(Iterable<? extends T> iterable) {
        if (iterable instanceof List) {
            return (List)iterable;
        }
        ArrayList<T> results = new ArrayList<T>();
        for (T o : iterable) {
            results.add(o);
        }
        CloseableUtils.closeQuietly(iterable);
        return results;
    }

    public static <T> List<T> toList(Iterator<T> iterator) {
        ArrayList<T> results = new ArrayList<T>();
        while (iterator.hasNext()) {
            T o = iterator.next();
            results.add(o);
        }
        return results;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> iterable) {
        if (iterable instanceof Set) {
            return (Set)iterable;
        }
        HashSet<T> results = new HashSet<T>();
        for (T o : iterable) {
            results.add(o);
        }
        CloseableUtils.closeQuietly(iterable);
        return results;
    }

    public static <T> Set<T> toSet(T[] iterable) {
        HashSet results = new HashSet();
        Collections.addAll(results, iterable);
        return results;
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        List<Object> list = IterableUtils.toList(iterable);
        Object[] array = (Object[])Array.newInstance(type, list.size());
        return list.toArray(array);
    }

    public static <T> int count(Iterable<T> iterable) {
        int count = 0;
        for (T ignore : iterable) {
            ++count;
        }
        CloseableUtils.closeQuietly(iterable);
        return count;
    }

    public static <T> int count(Iterator<T> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        CloseableUtils.closeQuietly(iterator);
        return count;
    }

    public static <T> Iterable<T> toIterable(final T[] arr) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < arr.length;
                    }

                    @Override
                    public T next() {
                        return arr[this.index++];
                    }

                    @Override
                    public void remove() {
                        throw new RuntimeException("Not supported");
                    }
                };
            }
        };
    }

    public static <T> T single(Iterable<? extends T> it) {
        Iterator<T> i = it.iterator();
        if (!i.hasNext()) {
            CloseableUtils.closeQuietly(i, it);
            throw new IllegalStateException("No items found.");
        }
        T result = i.next();
        if (i.hasNext()) {
            CloseableUtils.closeQuietly(i, it);
            throw new IllegalStateException("More than 1 item found.");
        }
        CloseableUtils.closeQuietly(i, it);
        return result;
    }

    public static <T> T singleOrDefault(Iterable<? extends T> it, T defaultValue) {
        Iterator<T> i = it.iterator();
        if (!i.hasNext()) {
            CloseableUtils.closeQuietly(i, it);
            return defaultValue;
        }
        T result = i.next();
        if (i.hasNext()) {
            T nextValue = i.next();
            CloseableUtils.closeQuietly(i, it);
            throw new IllegalStateException("More than 1 item found. [" + result + ", " + nextValue + "...]");
        }
        CloseableUtils.closeQuietly(i, it);
        return result;
    }

    public static String join(Iterable items, String sep) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (Object o : items) {
            if (!first) {
                sb.append(sep);
            }
            sb.append(o);
            first = false;
        }
        return sb.toString();
    }
}

