/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.vertexium.VertexiumException;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.util.StreamUtils;

public class InMemoryStreamingPropertyValue
extends StreamingPropertyValue
implements Serializable {
    static final long serialVersionUID = 42L;
    private byte[] data;

    public InMemoryStreamingPropertyValue() {
        this(null, null);
    }

    public InMemoryStreamingPropertyValue(byte[] data, Class valueType) {
        super(null, valueType, (long)data.length);
        this.data = data;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public static Object saveStreamingPropertyValue(Object propertyValue) {
        try {
            if (propertyValue instanceof StreamingPropertyValue) {
                StreamingPropertyValue value = (StreamingPropertyValue)propertyValue;
                byte[] valueData = StreamUtils.toBytes((InputStream)value.getInputStream());
                return new InMemoryStreamingPropertyValue(valueData, value.getValueType()).store(value.isStore()).searchIndex(value.isSearchIndex());
            }
            return propertyValue;
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not save streaming property value", (Throwable)ex);
        }
    }
}

