/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;

public class PrecompactedRow
extends AbstractCompactedRow {
    private final ColumnFamily compactedCf;

    public PrecompactedRow(DecoratedKey key, ColumnFamily cf) {
        super(key);
        this.compactedCf = cf;
    }

    public static ColumnFamily removeDeleted(DecoratedKey key, CompactionController controller, ColumnFamily cf) {
        assert (key != null);
        assert (controller != null);
        assert (cf != null);
        Boolean shouldPurge = null;
        if (cf.hasIrrelevantData(controller.gcBefore)) {
            shouldPurge = controller.shouldPurge(key, cf.maxTimestamp());
        }
        return ColumnFamilyStore.removeDeleted(cf, shouldPurge != null && shouldPurge != false ? controller.gcBefore : Integer.MIN_VALUE);
    }

    public static ColumnFamily removeDeleted(DecoratedKey key, boolean shouldPurge, CompactionController controller, ColumnFamily cf) {
        return ColumnFamilyStore.removeDeleted(cf, shouldPurge ? controller.gcBefore : Integer.MIN_VALUE, controller.cfs.indexManager.updaterFor(key));
    }

    public PrecompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        this(rows.get(0).getKey(), PrecompactedRow.removeDeleted(rows.get(0).getKey(), controller, PrecompactedRow.merge(rows, controller)));
    }

    private static ColumnFamily merge(List<SSTableIdentityIterator> rows, CompactionController controller) {
        assert (!rows.isEmpty());
        ArrayBackedSortedColumns returnCF = ArrayBackedSortedColumns.factory.create(controller.cfs.metadata);
        ArrayList<CloseableIterator<Column>> data = new ArrayList<CloseableIterator<Column>>(rows.size());
        for (SSTableIdentityIterator row : rows) {
            ColumnFamily cf = row.getColumnFamilyWithColumns(ArrayBackedSortedColumns.factory);
            returnCF.delete(cf);
            data.add(FBUtilities.closeableIterator(cf.iterator()));
        }
        PrecompactedRow.merge(returnCF, data, controller.cfs.indexManager.updaterFor(rows.get(0).getKey()));
        return returnCF;
    }

    public static void merge(final ColumnFamily returnCF, List<CloseableIterator<Column>> data, final SecondaryIndexManager.Updater indexer) {
        IdentityQueryFilter filter = new IdentityQueryFilter();
        Comparator<Column> fcomp = filter.getColumnComparator(returnCF.getComparator());
        MergeIterator.Reducer<Column, Column> reducer = new MergeIterator.Reducer<Column, Column>(){
            ColumnFamily container;
            {
                this.container = returnCF.cloneMeShallow();
            }

            @Override
            public void reduce(Column column) {
                this.container.addColumn(column);
                if (indexer == SecondaryIndexManager.nullUpdater) {
                    return;
                }
                if (!column.isMarkedForDelete(System.currentTimeMillis()) && !this.container.getColumn(column.name()).equals(column) || returnCF.deletionInfo().isDeleted(column)) {
                    indexer.remove(column);
                }
            }

            @Override
            protected Column getReduced() {
                Column c = this.container.iterator().next();
                this.container.clear();
                return c;
            }
        };
        IMergeIterator<Column, Column> reduced = MergeIterator.get(data, fcomp, reducer);
        filter.collectReducedColumns(returnCF, reduced, Integer.MIN_VALUE, System.currentTimeMillis());
    }

    @Override
    public RowIndexEntry write(long currentPosition, DataOutput out) throws IOException {
        if (this.compactedCf == null) {
            return null;
        }
        return SSTableWriter.rawAppend(this.compactedCf, currentPosition, this.key, out);
    }

    @Override
    public void update(MessageDigest digest) {
        if (this.compactedCf == null) {
            return;
        }
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            DeletionTime.serializer.serialize(this.compactedCf.deletionInfo().getTopLevelDeletion(), buffer);
            digest.update(buffer.getData(), 0, buffer.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.compactedCf.updateDigest(digest);
    }

    @Override
    public ColumnStats columnStats() {
        return this.compactedCf.getColumnStats();
    }

    public ColumnFamily getFullColumnFamily() {
        return this.compactedCf;
    }

    @Override
    public void close() {
    }
}

