/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.util;

import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.database.RelationReader;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.relations.RelationCache;
import com.thinkaurelius.titan.graphdb.types.TypeInspector;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusRelation;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.StandardFaunusProperty;
import com.thinkaurelius.titan.hadoop.StandardFaunusRelation;
import com.thinkaurelius.titan.hadoop.formats.util.input.SystemTypeInspector;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetup;
import com.thinkaurelius.titan.hadoop.formats.util.input.VertexReader;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TitanHadoopGraph {
    private final TitanHadoopSetup setup;
    private final TypeInspector typeManager;
    private final SystemTypeInspector systemTypes;
    private final VertexReader vertexReader;
    private final boolean verifyVertexExistence = false;
    private static final Logger log = LoggerFactory.getLogger(TitanHadoopGraph.class);

    public TitanHadoopGraph(TitanHadoopSetup setup) {
        this.setup = setup;
        this.typeManager = setup.getTypeInspector();
        this.systemTypes = setup.getSystemTypeInspector();
        this.vertexReader = setup.getVertexReader();
    }

    protected FaunusVertex readHadoopVertex(Configuration configuration, StaticBuffer key, Iterable<Entry> entries) {
        return new VertexBuilder(configuration, key).addEntries(entries).build();
    }

    public void close() {
        this.setup.close();
    }

    public VertexBuilder newVertexBuilder(Configuration configuration, StaticBuffer key) {
        return new VertexBuilder(configuration, key);
    }

    public class VertexBuilder {
        private final Configuration configuration;
        private final StaticBuffer key;
        private final long vertexId;
        private final FaunusVertex vertex;
        private boolean foundVertexState;

        public VertexBuilder(Configuration configuration, StaticBuffer key) {
            this.configuration = configuration;
            this.key = key;
            Preconditions.checkNotNull((Object)configuration);
            Preconditions.checkNotNull((Object)key);
            this.vertexId = TitanHadoopGraph.this.vertexReader.getVertexId(this.key);
            Preconditions.checkArgument((this.vertexId > 0L ? 1 : 0) != 0);
            this.vertex = new FaunusVertex(configuration, this.vertexId);
            this.foundVertexState = true;
        }

        public VertexBuilder addEntries(Iterable<Entry> entries) {
            for (Entry data : entries) {
                try {
                    StandardFaunusRelation frel;
                    RelationType type;
                    RelationReader relationReader = TitanHadoopGraph.this.setup.getRelationReader(this.vertex.getLongId());
                    RelationCache relation = relationReader.parseRelation(data, false, TitanHadoopGraph.this.typeManager);
                    if (TitanHadoopGraph.this.systemTypes.isVertexExistsSystemType(relation.typeId)) {
                        this.foundVertexState = true;
                    } else if (TitanHadoopGraph.this.systemTypes.isVertexLabelSystemType(relation.typeId)) {
                        long vertexLabelId = relation.getOtherVertexId();
                        VertexLabel vl = TitanHadoopGraph.this.typeManager.getExistingVertexLabel(vertexLabelId);
                        this.vertex.setVertexLabel(this.vertex.getTypeManager().getVertexLabel(vl.getName()));
                    }
                    if (TitanHadoopGraph.this.systemTypes.isSystemType(relation.typeId) || ((InternalRelationType)(type = TitanHadoopGraph.this.typeManager.getExistingRelationType(relation.typeId))).isHiddenType()) continue;
                    if (type.isPropertyKey()) {
                        Object value = relation.getValue();
                        Preconditions.checkNotNull((Object)value);
                        StandardFaunusProperty fprop = new StandardFaunusProperty(relation.relationId, this.vertex, type.getName(), value);
                        this.vertex.addProperty(fprop);
                        frel = fprop;
                    } else {
                        StandardFaunusEdge fedge;
                        assert (type.isEdgeLabel());
                        if (relation.direction.equals((Object)Direction.IN)) {
                            fedge = new StandardFaunusEdge(this.configuration, relation.relationId, (long)relation.getOtherVertexId(), this.vertexId, type.getName());
                        } else if (relation.direction.equals((Object)Direction.OUT)) {
                            fedge = new StandardFaunusEdge(this.configuration, relation.relationId, this.vertexId, (long)relation.getOtherVertexId(), type.getName());
                        } else {
                            throw ExceptionFactory.bothIsNotSupported();
                        }
                        this.vertex.addEdge(fedge);
                        frel = fedge;
                    }
                    if (relation.hasProperties()) {
                        for (LongObjectCursor next : relation) {
                            assert (next.value != null);
                            RelationType rt = TitanHadoopGraph.this.typeManager.getExistingRelationType(next.key);
                            if (rt.isPropertyKey()) {
                                FaunusPropertyKey pkey = this.vertex.getTypeManager().getPropertyKey(rt.getName());
                                log.debug("Retrieved key {} for name \"{}\"", (Object)pkey, (Object)rt.getName());
                                frel.setProperty(pkey, next.value);
                                continue;
                            }
                            assert (next.value instanceof Long);
                            FaunusEdgeLabel el = this.vertex.getTypeManager().getEdgeLabel(rt.getName());
                            log.debug("Retrieved ege label {} for name \"{}\"", (Object)el, (Object)rt.getName());
                            frel.setProperty(el, new FaunusVertex(this.configuration, (Long)next.value));
                        }
                        for (TitanRelation rel : frel.query().queryAll().relations()) {
                            ((FaunusRelation)rel).setLifeCycle((byte)2);
                        }
                    }
                    frel.setLifeCycle((byte)2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        public StaticBuffer getKey() {
            return this.key;
        }

        public FaunusVertex build() {
            this.vertex.setLifeCycle((byte)2);
            if (!this.foundVertexState || !this.vertex.query().relations().iterator().hasNext()) {
                return null;
            }
            return this.vertex;
        }
    }
}

