/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.tinkerpop.gremlin;

import com.google.common.base.Function;
import com.thinkaurelius.titan.hadoop.HadoopPipeline;
import com.thinkaurelius.titan.hadoop.hdfs.HDFSTools;
import com.thinkaurelius.titan.hadoop.hdfs.TextFileLineIterator;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.ConsolePreferenceChangeListener;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.transform.ToStringPipe;
import com.tinkerpop.pipes.util.iterators.SingleIterator;
import groovy.lang.Closure;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.codehaus.groovy.tools.shell.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultHookClosure
extends Closure {
    private static final Logger log = LoggerFactory.getLogger(ResultHookClosure.class);
    private final String resultPrompt;
    private final IO io;
    private static final int OLAP_PEEK_DEFAULT = 50;
    private static final int OLTP_PEEK_DEFAULT = 500;
    private int olapPeek = 50;
    private int oltpPeek = 500;

    public ResultHookClosure(Object owner, IO io, String resultPrompt) {
        super(owner);
        this.io = io;
        this.resultPrompt = resultPrompt;
    }

    public Object call(Object[] args) {
        int linesPrinted;
        Object itty;
        int peekLines;
        Object result = args[0];
        if (result instanceof HadoopPipeline) {
            peekLines = this.olapPeek;
            if (0 == peekLines) {
                return null;
            }
            try {
                HadoopPipeline pipeline = (HadoopPipeline)result;
                pipeline.submit();
                FileSystem hdfs = FileSystem.get((Configuration)pipeline.getGraph().getConf());
                Path output = HDFSTools.getOutputsFinalJob(hdfs, pipeline.getGraph().getJobDir().toString());
                int peekPlusOne = peekLines == Integer.MAX_VALUE ? Integer.MAX_VALUE : peekLines + 1;
                itty = new TextFileLineIterator(hdfs, hdfs.globStatus(new Path(output.toString() + "/" + "sideeffect" + "*")), (long)peekPlusOne);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        } else {
            peekLines = this.oltpPeek;
            if (0 == peekLines) {
                return null;
            }
            itty = new ToStringPipe();
            ((Pipe)itty).setStarts((Iterator)new SingleIterator(result));
        }
        for (linesPrinted = 0; itty.hasNext() && linesPrinted < peekLines; ++linesPrinted) {
            this.io.out.println(this.resultPrompt + itty.next());
        }
        if (linesPrinted == peekLines && itty.hasNext()) {
            this.io.out.println(this.resultPrompt + "...");
        }
        return null;
    }

    void setConsolePreferenceConsumers(ConsolePreferenceChangeListener listener) {
        listener.setConsumer("olap-result-peek", new OLAPPeekConsumer());
        listener.setConsumer("oltp-result-peek", new OLTPPeekConsumer());
    }

    private int safeIntConversion(String raw, int defaultValue) {
        int l;
        block5: {
            l = defaultValue;
            try {
                if (null == raw) break block5;
                try {
                    l = Integer.parseInt(raw);
                    log.debug("Parsed integer {} (original string: \"{}\")", (Object)l, (Object)raw);
                    if (l < 0) {
                        log.debug("Overwriting negative integer {} with {}", (Object)l, (Object)Integer.MAX_VALUE);
                        l = Integer.MAX_VALUE;
                    }
                }
                catch (NumberFormatException e) {
                    log.warn("String {} could not be converted to a number", (Object)raw, (Object)e);
                }
            }
            catch (Throwable t) {
                log.warn("Error parsing {}", (Object)raw, (Object)t);
            }
        }
        return l;
    }

    private class OLAPPeekConsumer
    implements Function<PreferenceChangeEvent, Void> {
        private OLAPPeekConsumer() {
        }

        public Void apply(PreferenceChangeEvent input) {
            ResultHookClosure.this.olapPeek = ResultHookClosure.this.safeIntConversion(input.getNewValue(), 50);
            return null;
        }
    }

    private class OLTPPeekConsumer
    implements Function<PreferenceChangeEvent, Void> {
        private OLTPPeekConsumer() {
        }

        public Void apply(PreferenceChangeEvent input) {
            ResultHookClosure.this.oltpPeek = ResultHookClosure.this.safeIntConversion(input.getNewValue(), 500);
            return null;
        }
    }
}

