/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.engine.application.Conneg;
import org.restlet.engine.resource.AnnotationInfo;
import org.restlet.engine.resource.VariantInfo;
import org.restlet.representation.Variant;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrictConneg
extends Conneg {
    public StrictConneg(Request request, MetadataService metadataService) {
        super(request, metadataService);
    }

    protected List<Preference<CharacterSet>> getCharacterSetPrefs() {
        return this.getRequest().getClientInfo().getAcceptedCharacterSets();
    }

    protected List<Preference<Encoding>> getEncodingPrefs() {
        return this.getRequest().getClientInfo().getAcceptedEncodings();
    }

    protected List<Preference<Language>> getLanguagePrefs() {
        return this.getRequest().getClientInfo().getAcceptedLanguages();
    }

    protected List<Preference<MediaType>> getMediaTypePrefs() {
        return this.getRequest().getClientInfo().getAcceptedMediaTypes();
    }

    protected float scoreAnnotation(AnnotationInfo annotation) {
        float result = -1.0f;
        if (annotation != null) {
            if (annotation.getQuery() != null) {
                if (this.getRequest().getResourceRef() == null || this.getRequest().getResourceRef().getQuery() == null) {
                    result = -1.0f;
                } else {
                    boolean allActualMatched;
                    Form constraintParams = new Form(annotation.getQuery());
                    Form actualParams = this.getRequest().getResourceRef().getQueryAsForm();
                    HashSet<Parameter> matchedParams = new HashSet<Parameter>();
                    boolean allConstraintsMatched = true;
                    boolean constraintMatched = false;
                    for (int i = 0; i < constraintParams.size() && allConstraintsMatched; ++i) {
                        Parameter constraintParam = (Parameter)constraintParams.get(i);
                        constraintMatched = false;
                        for (int j = 0; j < actualParams.size(); ++j) {
                            Parameter actualParam = (Parameter)actualParams.get(j);
                            if (!constraintParam.getName().equals(actualParam.getName()) || constraintParam.getValue() != null && !constraintParam.getValue().equals(actualParam.getValue())) continue;
                            constraintMatched = true;
                            matchedParams.add(actualParam);
                        }
                        allConstraintsMatched = allConstraintsMatched && constraintMatched;
                    }
                    boolean bl = allActualMatched = actualParams.size() == matchedParams.size();
                    result = allConstraintsMatched ? (allActualMatched ? 1.0f : 0.75f) : -1.0f;
                }
            } else {
                result = this.getRequest().getResourceRef() == null || this.getRequest().getResourceRef().getQuery() == null ? 0.5f : 0.25f;
            }
            if (Context.getCurrentLogger().isLoggable(Level.FINE)) {
                Context.getCurrentLogger().fine("Score of annotation \"" + annotation + "\"= " + result);
            }
        } else {
            result = 0.0f;
        }
        return result;
    }

    public float scoreCharacterSet(CharacterSet characterSet) {
        return this.scoreMetadata(characterSet, this.getCharacterSetPrefs());
    }

    public float scoreEncodings(List<Encoding> encodings) {
        return this.scoreMetadata((Metadata)((Object)encodings), this.getEncodingPrefs());
    }

    public float scoreLanguages(List<Language> languages) {
        return this.scoreMetadata((Metadata)((Object)languages), this.getLanguagePrefs());
    }

    public float scoreMediaType(MediaType mediaType) {
        float result = -1.0f;
        if (mediaType != null) {
            for (Preference<MediaType> pref : this.getMediaTypePrefs()) {
                float current = pref.getMetadata().includes(mediaType, false) ? pref.getQuality() : -1.0f;
                if (!(current > result)) continue;
                result = current;
            }
        } else {
            result = 0.0f;
        }
        return result;
    }

    protected <T extends Metadata> float scoreMetadata(List<T> metadataList, List<Preference<T>> prefs) {
        float result = -1.0f;
        if (metadataList != null && !metadataList.isEmpty()) {
            for (Preference<T> pref : prefs) {
                for (Metadata metadata : metadataList) {
                    float current = ((Metadata)pref.getMetadata()).includes(metadata) ? pref.getQuality() : -1.0f;
                    if (!(current > result)) continue;
                    result = current;
                }
            }
        } else {
            result = 0.0f;
        }
        return result;
    }

    protected <T extends Metadata> float scoreMetadata(T metadata, List<Preference<T>> prefs) {
        float result = -1.0f;
        if (metadata != null) {
            for (Preference<T> pref : prefs) {
                float current = ((Metadata)pref.getMetadata()).includes(metadata) ? pref.getQuality() : -1.0f;
                if (!(current > result)) continue;
                result = current;
            }
        } else {
            result = 0.0f;
        }
        return result;
    }

    @Override
    public float scoreVariant(Variant variant) {
        float encodingScore;
        float characterSetScore;
        float mediaTypeScore;
        float result = -1.0f;
        float languageScore = this.scoreLanguages(variant.getLanguages());
        if (languageScore != -1.0f && (mediaTypeScore = this.scoreMediaType(variant.getMediaType())) != -1.0f && (characterSetScore = this.scoreCharacterSet(variant.getCharacterSet())) != -1.0f && (encodingScore = this.scoreEncodings(variant.getEncodings())) != -1.0f) {
            if (variant instanceof VariantInfo) {
                float annotationScore = this.scoreAnnotation(((VariantInfo)variant).getAnnotationInfo());
                result = (languageScore * 4.0f + mediaTypeScore * 3.0f + characterSetScore * 2.0f + encodingScore * 1.0f + annotationScore * 2.0f) / 12.0f;
                result *= ((VariantInfo)variant).getInputScore();
            } else {
                result = (languageScore * 4.0f + mediaTypeScore * 3.0f + characterSetScore * 2.0f + encodingScore * 1.0f) / 10.0f;
            }
        }
        if (Context.getCurrentLogger().isLoggable(Level.FINE)) {
            Context.getCurrentLogger().fine("Total score of variant \"" + variant + "\"= " + result);
        }
        return result;
    }
}

