/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mrunit.TestDriver;
import org.apache.hadoop.mrunit.internal.output.MockOutputCreator;
import org.apache.hadoop.mrunit.types.Pair;

public abstract class MapDriverBase<K1, V1, K2, V2, T extends MapDriverBase<K1, V1, K2, V2, T>>
extends TestDriver<K2, V2, T> {
    public static final Log LOG = LogFactory.getLog(MapDriverBase.class);
    protected List<Pair<K1, V1>> inputs = new ArrayList<Pair<K1, V1>>();
    protected Path mapInputPath = new Path("somefile");
    @Deprecated
    protected K1 inputKey;
    @Deprecated
    protected V1 inputVal;
    protected final MockOutputCreator<K2, V2> mockOutputCreator = new MockOutputCreator();

    @Deprecated
    public void setInputKey(K1 key) {
        this.inputKey = this.copy(key);
    }

    @Deprecated
    public K1 getInputKey() {
        return this.inputKey;
    }

    @Deprecated
    public void setInputValue(V1 val) {
        this.inputVal = this.copy(val);
    }

    @Deprecated
    public V1 getInputValue() {
        return this.inputVal;
    }

    public void setInput(K1 key, V1 val) {
        this.setInput(new Pair<K1, V1>(key, val));
    }

    public void setInput(Pair<K1, V1> inputRecord) {
        this.setInputKey(inputRecord.getFirst());
        this.setInputValue(inputRecord.getSecond());
        this.clearInput();
        this.addInput(inputRecord);
    }

    public void addInput(K1 key, V1 val) {
        this.inputs.add(this.copyPair(key, val));
    }

    public void addInput(Pair<K1, V1> input) {
        this.addInput(input.getFirst(), input.getSecond());
    }

    public void addAll(List<Pair<K1, V1>> inputs) {
        for (Pair<K1, V1> input : inputs) {
            this.addInput(input);
        }
    }

    public void clearInput() {
        this.inputs.clear();
    }

    @Deprecated
    public void setInputFromString(String input) {
        Pair<Text, Text> inputPair = MapDriverBase.parseTabbedPair(input);
        this.setInputKey(inputPair.getFirst());
        this.setInputValue(inputPair.getSecond());
    }

    private T thisAsMapDriver() {
        return (T)this;
    }

    @Deprecated
    public T withInputKey(K1 key) {
        this.setInputKey(key);
        return this.thisAsMapDriver();
    }

    @Deprecated
    public T withInputValue(V1 val) {
        this.setInputValue(val);
        return this.thisAsMapDriver();
    }

    public T withInput(K1 key, V1 val) {
        this.addInput(key, val);
        return this.thisAsMapDriver();
    }

    public T withInput(Pair<K1, V1> inputRecord) {
        this.setInput(inputRecord);
        return this.thisAsMapDriver();
    }

    @Deprecated
    public T withInputFromString(String input) {
        this.setInputFromString(input);
        return this.thisAsMapDriver();
    }

    public T withAll(List<Pair<K1, V1>> inputRecords) {
        this.addAll(inputRecords);
        return this.thisAsMapDriver();
    }

    public Path getMapInputPath() {
        return this.mapInputPath;
    }

    public void setMapInputPath(Path mapInputPath) {
        this.mapInputPath = mapInputPath;
    }

    public final T withMapInputPath(Path mapInputPath) {
        this.setMapInputPath(mapInputPath);
        return (T)((MapDriverBase)this.thisAsTestDriver());
    }

    protected void preRunChecks(Object mapper) {
        if (this.inputKey != null && this.inputVal != null) {
            this.setInput(this.inputKey, this.inputVal);
        }
        if (this.inputs == null || this.inputs.isEmpty()) {
            throw new IllegalStateException("No input was provided");
        }
        if (mapper == null) {
            throw new IllegalStateException("No Mapper class was provided");
        }
        if (this.driverReused()) {
            throw new IllegalStateException("Driver reuse not allowed");
        }
        this.setUsedOnceStatus();
    }

    @Override
    public abstract List<Pair<K2, V2>> run() throws IOException;

    @Override
    protected void printPreTestDebugLog() {
        for (Pair<K1, V1> input : this.inputs) {
            LOG.debug((Object)("Mapping input (" + input.getFirst() + ", " + input.getSecond() + ")"));
        }
    }
}

