/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.util;

import java.util.Comparator;
import org.apache.hadoop.mrunit.types.Pair;

public class PairEquality<K, V> {
    private final Comparator<K> keyComparator;
    private final Comparator<V> valueComparator;

    public PairEquality(Comparator<K> keyComparator, Comparator<V> valueComparator) {
        this.keyComparator = keyComparator;
        this.valueComparator = valueComparator;
    }

    public boolean isTrueFor(Pair<K, V> o1, Pair<K, V> o2) {
        return this.equalityOf(o1.getFirst(), o2.getFirst(), this.keyComparator) && this.equalityOf(o1.getSecond(), o2.getSecond(), this.valueComparator);
    }

    private <T> boolean equalityOf(T t1, T t2, Comparator<T> c) {
        if (c != null) {
            return c.compare(t1, t2) == 0;
        }
        if (t1 == null && t2 == null) {
            return true;
        }
        if (t1 != null && t2 == null) {
            return false;
        }
        if (t1 == null && t2 != null) {
            return false;
        }
        return t1.equals(t2);
    }
}

