/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.io.Serializable;
import org.vertexium.VertexiumException;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.property.StreamingPropertyValue;

public abstract class StreamingPropertyValueRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String valueType;
    private boolean searchIndex;
    private boolean store;

    protected StreamingPropertyValueRef() {
        this.valueType = null;
        this.searchIndex = false;
        this.store = false;
    }

    protected StreamingPropertyValueRef(StreamingPropertyValue propertyValue) {
        this.valueType = propertyValue.getValueType().getName();
        this.searchIndex = propertyValue.isSearchIndex();
        this.store = propertyValue.isStore();
    }

    public Class getValueType() {
        try {
            return Class.forName(this.valueType);
        }
        catch (ClassNotFoundException e) {
            throw new VertexiumException("Could not get type: " + this.valueType);
        }
    }

    public boolean isSearchIndex() {
        return this.searchIndex;
    }

    public boolean isStore() {
        return this.store;
    }

    public abstract StreamingPropertyValue toStreamingPropertyValue(AccumuloGraph var1);
}

