/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.mapreduce;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloEdge;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.iterator.EdgeIterator;
import org.vertexium.accumulo.iterator.model.EdgeElementData;
import org.vertexium.accumulo.iterator.model.ElementData;
import org.vertexium.accumulo.mapreduce.AccumuloElementInputFormatBase;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;

public class AccumuloEdgeInputFormat
extends AccumuloElementInputFormatBase<Edge> {
    private static EdgeIterator edgeIterator = new EdgeIterator(AccumuloGraph.toIteratorFetchHints(FetchHint.ALL));

    public static void setInputInfo(Job job, AccumuloGraph graph, String instanceName, String zooKeepers, String principal, AuthenticationToken token, String[] authorizations) throws AccumuloSecurityException {
        String tableName = graph.getEdgesTableName();
        AccumuloEdgeInputFormat.setInputInfo(job, instanceName, zooKeepers, principal, token, authorizations, tableName);
    }

    @Override
    protected Edge createElementFromRow(AccumuloGraph graph, PeekingIterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        try {
            EnumSet<org.vertexium.accumulo.iterator.model.FetchHint> fetchHints = AccumuloGraph.toIteratorFetchHints(FetchHint.ALL);
            EdgeElementData edgeElementData = (EdgeElementData)edgeIterator.createElementDataFromRows(row);
            Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(edgeElementData.visibility.toString()));
            Iterable<Property> properties = AccumuloEdgeInputFormat.makePropertiesFromElementData(graph, (ElementData)edgeElementData, fetchHints);
            Iterable<PropertyDeleteMutation> propertyDeleteMutations = null;
            Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations = null;
            Iterable hiddenVisibilities = Iterables.transform((Iterable)edgeElementData.hiddenVisibilities, (Function)new Function<Text, Visibility>(){

                @Nullable
                public Visibility apply(Text visibilityText) {
                    return AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(visibilityText.toString()));
                }
            });
            return new AccumuloEdge((Graph)graph, edgeElementData.id.toString(), edgeElementData.outVertexId.toString(), edgeElementData.inVertexId.toString(), edgeElementData.label.toString(), null, visibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, edgeElementData.timestamp, authorizations);
        }
        catch (Throwable ex) {
            throw new VertexiumException("Failed to create vertex", ex);
        }
    }
}

