/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.mapreduce;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.vertexium.Authorizations;
import org.vertexium.FetchHint;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.AccumuloVertex;
import org.vertexium.accumulo.iterator.VertexIterator;
import org.vertexium.accumulo.iterator.model.Edges;
import org.vertexium.accumulo.iterator.model.ElementData;
import org.vertexium.accumulo.iterator.model.VertexElementData;
import org.vertexium.accumulo.mapreduce.AccumuloElementInputFormatBase;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;

public class AccumuloVertexInputFormat
extends AccumuloElementInputFormatBase<Vertex> {
    private static VertexIterator vertexIterator = new VertexIterator(AccumuloGraph.toIteratorFetchHints(FetchHint.ALL));

    public static void setInputInfo(Job job, AccumuloGraph graph, String instanceName, String zooKeepers, String principal, AuthenticationToken token, String[] authorizations) throws AccumuloSecurityException {
        String tableName = graph.getVerticesTableName();
        AccumuloVertexInputFormat.setInputInfo(job, instanceName, zooKeepers, principal, token, authorizations, tableName);
    }

    @Override
    protected Vertex createElementFromRow(AccumuloGraph graph, PeekingIterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        return AccumuloVertexInputFormat.createVertex(graph, row, authorizations);
    }

    public static Vertex createVertex(AccumuloGraph graph, Iterator<Map.Entry<Key, Value>> row, Authorizations authorizations) {
        try {
            EnumSet<org.vertexium.accumulo.iterator.model.FetchHint> fetchHints = AccumuloGraph.toIteratorFetchHints(FetchHint.ALL);
            VertexElementData vertexElementData = (VertexElementData)vertexIterator.createElementDataFromRows(row);
            Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(vertexElementData.visibility.toString()));
            Iterable<Property> properties = AccumuloVertexInputFormat.makePropertiesFromElementData(graph, (ElementData)vertexElementData, fetchHints);
            Iterable<PropertyDeleteMutation> propertyDeleteMutations = null;
            Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations = null;
            Iterable hiddenVisibilities = Iterables.transform((Iterable)vertexElementData.hiddenVisibilities, (Function)new Function<Text, Visibility>(){

                @Nullable
                public Visibility apply(Text visibilityText) {
                    return AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(visibilityText.toString()));
                }
            });
            return new AccumuloVertex(graph, vertexElementData.id.toString(), visibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, (Edges)vertexElementData.inEdges, (Edges)vertexElementData.outEdges, vertexElementData.timestamp, authorizations);
        }
        catch (Throwable ex) {
            throw new VertexiumException("Failed to create vertex", ex);
        }
    }
}

