/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.threading;

import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cache2k.impl.threading.DefaultThreadFactoryProvider;
import org.cache2k.impl.threading.ThreadFactoryProvider;
import org.cache2k.impl.util.Log;
import org.cache2k.impl.util.TunableConstants;
import org.cache2k.impl.util.TunableFactory;

public class GlobalPooledExecutor {
    private static final Task<?> CLOSE_TASK = new Task();
    private static final Tunable TUNABLE = TunableFactory.get(Tunable.class);
    private static final ProgressNotifier DUMMY_NOTIFIER = new DummyNotifier();
    private int peakThreadCount = -1;
    private Random delayRandom = new Random(new SecureRandom().nextLong());
    private int threadCount;
    private int diedThreadCount;
    private BlockingQueue<Task<?>> taskQueue;
    private boolean closed;
    private Tunable tunable;
    private ThreadFactory factory;
    private Log log = Log.getLog(GlobalPooledExecutor.class);

    public GlobalPooledExecutor(String _name) {
        this(TUNABLE, null, _name);
    }

    GlobalPooledExecutor() {
        this((String)null);
    }

    GlobalPooledExecutor(Tunable t) {
        this(t, null, null);
    }

    GlobalPooledExecutor(Tunable t, Properties _managerProperties, String _threadNamePrefix) {
        this.tunable = t;
        this.taskQueue = new ArrayBlockingQueue(this.tunable.queueSize);
        this.factory = this.tunable.threadFactoryProvider.newThreadFactory(_managerProperties, _threadNamePrefix);
    }

    public void execute(Runnable r) throws InterruptedException, TimeoutException {
        this.execute(r, DUMMY_NOTIFIER);
    }

    public <V> Future<V> execute(Callable<V> c) throws InterruptedException, TimeoutException {
        return this.execute(c, DUMMY_NOTIFIER);
    }

    public void execute(final Runnable r, ProgressNotifier n) throws InterruptedException, TimeoutException {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                r.run();
                return null;
            }
        };
        this.execute(c, n);
    }

    public <V> Future<V> execute(Callable<V> c, ProgressNotifier n) throws InterruptedException, TimeoutException {
        return this.execute(c, n, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Future<V> execute(Callable<V> c, ProgressNotifier n, long _timeoutMillis) throws InterruptedException, TimeoutException {
        int cnt;
        if (this.closed) {
            throw new IllegalStateException("pool was shut down");
        }
        Task<V> t = new Task<V>(c, n);
        GlobalPooledExecutor globalPooledExecutor = this;
        synchronized (globalPooledExecutor) {
            cnt = this.getThreadInUseCount();
            if (cnt > 0) {
                if (this.taskQueue.size() == 0) {
                    return this.queue(t, _timeoutMillis);
                }
                if (!this.tunable.disableHardLimit && cnt >= this.tunable.hardLimitThreadCount) {
                    return this.queue(t, _timeoutMillis);
                }
            }
            ++this.threadCount;
            cnt = this.getThreadInUseCount();
        }
        Thread thr = this.factory.newThread(new ExecutorThread());
        thr.start();
        if (cnt > this.peakThreadCount) {
            this.peakThreadCount = cnt;
        }
        return this.queue(t, _timeoutMillis);
    }

    private <V> Future<V> queue(Task<V> t, long _timeoutMillis) throws InterruptedException, TimeoutException {
        boolean _queued = this.taskQueue.offer(t, _timeoutMillis, TimeUnit.MILLISECONDS);
        if (_queued) {
            return t;
        }
        throw new TimeoutException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilAllDied() {
        while (true) {
            int _delta;
            GlobalPooledExecutor globalPooledExecutor = this;
            synchronized (globalPooledExecutor) {
                _delta = this.threadCount - this.diedThreadCount;
            }
            if (_delta == 0) break;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.taskQueue.clear();
            this.taskQueue.add(CLOSE_TASK);
        }
    }

    public int getTotalStartedThreadCount() {
        return this.threadCount;
    }

    public int getThreadInUseCount() {
        return this.threadCount - this.diedThreadCount;
    }

    public int getDiedThreadCount() {
        return this.diedThreadCount;
    }

    public boolean wasWarningLimitReached() {
        return this.peakThreadCount >= this.tunable.warningLimitThreadCount;
    }

    public int getPeakThreadCount() {
        return this.peakThreadCount;
    }

    public static class Tunable
    extends TunableConstants {
        public int queueSize = 3;
        public int idleTimeMillis = 9876;
        public int randomIdleTimeMillis = 1800000;
        public boolean randomizeIdleTime = true;
        public int hardLimitThreadCount = 100 * Runtime.getRuntime().availableProcessors();
        public boolean disableHardLimit = false;
        public int warningLimitThreadCount = 33 * Runtime.getRuntime().availableProcessors();
        public ThreadFactoryProvider threadFactoryProvider = new DefaultThreadFactoryProvider();
    }

    static class DummyNotifier
    implements ProgressNotifier {
        DummyNotifier() {
        }

        @Override
        public void taskStarted() {
        }

        @Override
        public void taskFinished() {
        }

        @Override
        public void taskFinishedWithException(Throwable ex) {
        }
    }

    private class ExecutorThread
    implements Runnable {
        int waitTime;

        private ExecutorThread() {
            this.waitTime = (((GlobalPooledExecutor)GlobalPooledExecutor.this).tunable.randomizeIdleTime ? GlobalPooledExecutor.this.delayRandom.nextInt(((GlobalPooledExecutor)GlobalPooledExecutor.this).tunable.randomIdleTimeMillis) : 0) + ((GlobalPooledExecutor)GlobalPooledExecutor.this).tunable.idleTimeMillis;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    Object t;
                    if ((t = (Task)GlobalPooledExecutor.this.taskQueue.poll(this.waitTime, TimeUnit.MILLISECONDS)) == CLOSE_TASK) {
                        GlobalPooledExecutor.this.taskQueue.put(t);
                        return;
                    }
                    if (t != null) {
                        ((Task)t).progressNotifier.taskStarted();
                        try {
                            Callable c = ((Task)t).start();
                            Object _result = c.call();
                            ((Task)t).done(_result, null);
                            ((Task)t).progressNotifier.taskFinished();
                        }
                        catch (Throwable ex) {
                            GlobalPooledExecutor.this.log.warn("exception in thread", ex);
                            ((Task)t).done(null, ex);
                            ((Task)t).progressNotifier.taskFinishedWithException(ex);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ex2) {
                GlobalPooledExecutor ex2 = GlobalPooledExecutor.this;
                synchronized (ex2) {
                    GlobalPooledExecutor.this.diedThreadCount++;
                }
            }
            catch (Throwable ex) {
                GlobalPooledExecutor.this.log.warn("unexpected exception", ex);
            }
            finally {
                GlobalPooledExecutor globalPooledExecutor = GlobalPooledExecutor.this;
                synchronized (globalPooledExecutor) {
                    GlobalPooledExecutor.this.diedThreadCount++;
                }
            }
        }
    }

    private static class Task<V>
    implements Future<V> {
        ProgressNotifier progressNotifier;
        int state = 0;
        V result;
        Throwable exception;
        Callable<V> callable;

        Task() {
        }

        Task(Callable<V> _callable, ProgressNotifier _progressNotifier) {
            this.callable = _callable;
            this.progressNotifier = _progressNotifier;
        }

        synchronized Callable<V> start() {
            if (this.state == 0) {
                this.state = 1;
                return this.callable;
            }
            return null;
        }

        synchronized void done(V _result, Throwable ex) {
            this.result = _result;
            this.exception = ex;
            this.state = 2;
            this.notifyAll();
        }

        @Override
        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            boolean f;
            boolean bl = f = this.callable != null && this.state == 0;
            if (f) {
                this.callable = null;
                this.state = 2;
                this.notifyAll();
            }
            return f;
        }

        @Override
        public boolean isCancelled() {
            return this.callable == null;
        }

        @Override
        public boolean isDone() {
            return this.state == 2;
        }

        @Override
        public synchronized V get() throws InterruptedException, ExecutionException {
            while (!this.isDone()) {
                this.wait();
                if (this.exception == null) continue;
                throw new ExecutionException(this.exception);
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        @Override
        public synchronized V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.isDone()) {
                this.wait(unit.toMillis(timeout));
                if (!this.isDone()) {
                    throw new TimeoutException();
                }
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }
    }

    public static interface ProgressNotifier {
        public void taskStarted();

        public void taskFinished();

        public void taskFinishedWithException(Throwable var1);
    }
}

