/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import jline.UnixTerminal;
import jline.UnsupportedTerminal;
import jline.WindowsTerminal;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.shell.AnsiDetector;
import org.codehaus.groovy.tools.shell.Command;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.Interpreter;
import org.codehaus.groovy.tools.shell.util.Logger;
import org.codehaus.groovy.tools.shell.util.NoExitSecurityManager;
import org.codehaus.groovy.tools.shell.util.Preferences;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.vertexium.Graph;
import org.vertexium.GraphFactory;
import org.vertexium.Visibility;
import org.vertexium.cli.VertexiumScript;
import org.vertexium.cli.commands.GetAuthsCommand;
import org.vertexium.cli.commands.GetTimeCommand;
import org.vertexium.cli.commands.NowCommand;
import org.vertexium.cli.commands.SetAuthsCommand;
import org.vertexium.cli.commands.SetTimeCommand;
import org.vertexium.util.ConfigurationUtils;

public class VertexiumShell {
    private Groovysh groovysh;
    @Parameter(names={"--help", "-h"}, description="Print help", help=true)
    private boolean help;
    @Parameter(names={"-C"}, description="Suppress colors")
    private boolean suppressColor;
    @Parameter(names={"-T"}, description="Terminal type")
    private String terminalType = "auto";
    @Parameter(names={"-e"}, description="String to evaluate")
    private String evalString = null;
    @Parameter(names={"-c"}, description="Configuration file name", required=true)
    private List<String> configFileNames = new ArrayList<String>();
    @Parameter(names={"-cp"}, description="Configuration property prefix")
    private String configPropertyPrefix = null;
    @Parameter(names={"-a"}, description="Authorizations")
    private String authorizations = null;
    @Parameter(names={"-t"}, description="Time")
    private Long time = null;
    @Parameter(description="File names to execute")
    private List<String> fileNames = new ArrayList<String>();

    public int run(String[] args) throws Exception {
        IO io;
        JCommander j = new JCommander((Object)this, args);
        if (this.help) {
            j.usage();
            return -1;
        }
        VertexiumShell.setTerminalType(this.terminalType, this.suppressColor);
        Map config = ConfigurationUtils.loadConfig(this.configFileNames, (String)this.configPropertyPrefix);
        Graph graph = new GraphFactory().createGraph(config);
        System.setProperty("groovysh.prompt", "vertexium");
        Logger.io = io = new IO();
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        VertexiumScript.setGraph(graph);
        if (this.authorizations != null) {
            VertexiumScript.setAuthorizations(graph.createAuthorizations(this.authorizations.split(",")));
        }
        VertexiumScript.setTime(this.time);
        compilerConfiguration.setScriptBaseClass(VertexiumScript.class.getName());
        Binding binding = new Binding();
        GroovyShell groovyShell = new GroovyShell(this.getClass().getClassLoader(), binding, compilerConfiguration);
        Closure<Object> resultHook = new Closure<Object>((Object)this){

            public Object call(Object ... args) {
                boolean showLastResult;
                Object obj = args[0];
                boolean bl = showLastResult = !io.isQuiet() && (io.isVerbose() || Preferences.getShowLastResult());
                if (showLastResult) {
                    io.out.println("@|bold ===>|@ " + VertexiumScript.resultToString(obj));
                }
                return null;
            }
        };
        this.groovysh = new Groovysh(io);
        this.setGroovyShell(this.groovysh, groovyShell);
        this.setResultHook(this.groovysh, resultHook);
        this.startGroovysh(this.evalString, this.fileNames);
        return 0;
    }

    private void setGroovyShell(Groovysh groovysh, GroovyShell groovyShell) throws NoSuchFieldException, IllegalAccessException {
        Field interpField = groovysh.getClass().getDeclaredField("interp");
        interpField.setAccessible(true);
        Field shellField = Interpreter.class.getDeclaredField("shell");
        shellField.setAccessible(true);
        Interpreter interpreter = (Interpreter)interpField.get(groovysh);
        shellField.set(interpreter, groovyShell);
    }

    private void setResultHook(Groovysh groovysh, Closure<Object> resultHook) throws NoSuchFieldException, IllegalAccessException {
        Field resultHookField = Groovysh.class.getDeclaredField("resultHook");
        resultHookField.setAccessible(true);
        resultHookField.set(groovysh, resultHook);
    }

    public Groovysh getGroovysh() {
        return this.groovysh;
    }

    public static void main(String[] args) throws Exception {
        int result = new VertexiumShell().run(args);
        System.exit(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startGroovysh(String evalString, List<String> filenames) throws IOException {
        int code;
        final Groovysh shell = this.getGroovysh();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (shell.getHistory() != null) {
                    try {
                        shell.getHistory().flush();
                    }
                    catch (IOException e) {
                        System.out.println("Could not flush history.");
                    }
                }
            }
        });
        SecurityManager psm = System.getSecurityManager();
        System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
        shell.register((Command)new GetAuthsCommand(shell));
        shell.register((Command)new SetAuthsCommand(shell));
        shell.register((Command)new GetTimeCommand(shell));
        shell.register((Command)new SetTimeCommand(shell));
        shell.register((Command)new NowCommand(shell));
        System.out.println("Usage:");
        System.out.println("  vertex1=v['vertex1'] - gets the vertex with id 'v1' and assigns it to variable 'v'");
        System.out.println("  vertex1.methods      - gets the methods available on the Vertexium object");
        System.out.println("  vertex1.properties   - gets the properties available on the Vertexium object");
        System.out.println("  vertex1.delete()     - deletes the vertex v1");
        System.out.println("  p1.delete()          - deletes the property currently referenced by p1");
        System.out.println("  q.has('name', 'joe').vertices().each() { println it.id } - execute a query for all vertices with property 'name' equal to 'joe'");
        System.out.println("  g.query('apple', auths).vertices()[0]                    - execute a query for 'apple' and get the first match");
        System.out.println("");
        System.out.println("Global Properties:");
        System.out.println("  g     - the Graph object");
        System.out.println("  q     - a query object");
        System.out.println("  auths - the currently set query authorizations");
        System.out.println("  time  - the currently set query time");
        System.out.println("  now   - the current time");
        System.out.println("  v     - vertex map (usage: v['v1'])");
        System.out.println("  e     - edge map (usage: e['e1'])");
        try {
            shell.execute("import " + Visibility.class.getPackage().getName() + ".*;");
            code = shell.run(evalString, filenames);
        }
        finally {
            System.setSecurityManager(psm);
        }
        System.exit(code);
    }

    static void setTerminalType(String type, boolean suppressColor) {
        assert (type != null);
        type = type.toLowerCase();
        boolean enableAnsi = true;
        switch (type) {
            case "auto": {
                type = null;
                break;
            }
            case "unix": {
                type = UnixTerminal.class.getCanonicalName();
                break;
            }
            case "win": 
            case "windows": {
                type = WindowsTerminal.class.getCanonicalName();
                break;
            }
            case "false": 
            case "off": 
            case "none": {
                type = UnsupportedTerminal.class.getCanonicalName();
                enableAnsi = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Terminal type: $type");
            }
        }
        if (enableAnsi) {
            VertexiumShell.installAnsi();
            Ansi.setEnabled((!suppressColor ? 1 : 0) != 0);
        } else {
            Ansi.setEnabled((boolean)false);
        }
        if (type != null) {
            System.setProperty("jline.terminal", type);
        }
    }

    static void installAnsi() {
        AnsiConsole.systemInstall();
        Ansi.setDetector((Callable)new AnsiDetector());
    }
}

