/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class MultiPut
extends Operation
implements Writable {
    public HServerAddress address;
    public static final int DEFAULT_MAX_PUT_OUTPUT = 10;
    public Map<byte[], List<Put>> puts = new TreeMap<byte[], List<Put>>(Bytes.BYTES_COMPARATOR);

    public MultiPut() {
    }

    public MultiPut(HServerAddress a) {
        this.address = a;
    }

    public int size() {
        int size = 0;
        for (List<Put> l : this.puts.values()) {
            size += l.size();
        }
        return size;
    }

    public void add(byte[] regionName, Put aPut) {
        List<Put> rsput = this.puts.get(regionName);
        if (rsput == null) {
            rsput = new ArrayList<Put>();
            this.puts.put(regionName, rsput);
        }
        rsput.add(aPut);
    }

    public Collection<Put> allPuts() {
        ArrayList<Put> res = new ArrayList<Put>();
        for (List<Put> pp : this.puts.values()) {
            res.addAll(pp);
        }
        return res;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap tableInfo = new HashMap();
        map.put("tables", tableInfo);
        for (Map.Entry<byte[], List<Put>> entry : this.puts.entrySet()) {
            Set<String> familySet;
            HashMap table;
            try {
                String tableName = Bytes.toStringBinary(HRegionInfo.parseRegionName(entry.getKey())[0]);
                if (tableInfo.get(tableName) == null) {
                    table = new HashMap();
                    familySet = new TreeSet();
                    table.put("families", familySet);
                    tableInfo.put(tableName, table);
                } else {
                    familySet = (Set)((Map)tableInfo.get(tableName)).get("families");
                }
            }
            catch (IOException ioe) {
                table = new HashMap();
                familySet = new TreeSet();
                table.put("families", familySet);
                tableInfo.put(Bytes.toStringBinary(entry.getKey()), table);
            }
            for (Put p : entry.getValue()) {
                for (byte[] fam : p.getFamilyMap().keySet()) {
                    familySet.add(Bytes.toStringBinary(fam));
                }
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        Map tableInfo = (Map)map.get("tables");
        int putCount = 0;
        for (Map.Entry<byte[], List<Put>> entry : this.puts.entrySet()) {
            if (putCount >= 10) {
                putCount += entry.getValue().size();
                continue;
            }
            List<Put> regionPuts = entry.getValue();
            ArrayList<Map<String, Object>> putSummaries = new ArrayList<Map<String, Object>>();
            int regionPutsToAdd = regionPuts.size();
            if ((putCount += regionPutsToAdd) > 10) {
                regionPutsToAdd -= putCount - 10;
            }
            Iterator<Put> iter = regionPuts.iterator();
            while (regionPutsToAdd-- > 0) {
                putSummaries.add(iter.next().toMap(maxCols));
            }
            String tableName = "";
            try {
                tableName = Bytes.toStringBinary(HRegionInfo.parseRegionName(entry.getKey())[0]);
            }
            catch (IOException ioe) {
                tableName = Bytes.toStringBinary(entry.getKey());
            }
            HashMap<String, ArrayList<Map<String, Object>>> table = (HashMap<String, ArrayList<Map<String, Object>>>)tableInfo.get(tableName);
            if (table == null) {
                table = new HashMap<String, ArrayList<Map<String, Object>>>();
                tableInfo.put(tableName, table);
                table.put("puts", putSummaries);
                continue;
            }
            if (table.get("puts") == null) {
                table.put("puts", putSummaries);
                continue;
            }
            ((List)table.get("puts")).addAll(putSummaries);
        }
        map.put("totalPuts", putCount);
        return map;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.puts.size());
        for (Map.Entry<byte[], List<Put>> e : this.puts.entrySet()) {
            Bytes.writeByteArray(out, e.getKey());
            List<Put> ps = e.getValue();
            out.writeInt(ps.size());
            for (Put p : ps) {
                p.write(out);
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.puts.clear();
        int mapSize = in.readInt();
        for (int i = 0; i < mapSize; ++i) {
            byte[] key = Bytes.readByteArray(in);
            int listSize = in.readInt();
            ArrayList<Put> ps = new ArrayList<Put>(listSize);
            for (int j = 0; j < listSize; ++j) {
                Put put2 = new Put();
                put2.readFields(in);
                ps.add(put2);
            }
            this.puts.put(key, ps);
        }
    }
}

