/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.accumulo.core.data.Value;
import org.vertexium.accumulo.iterator.model.VertexiumAccumuloIteratorException;

public class EdgeInfo {
    public static final String CHARSET_NAME = "UTF-8";
    private byte[] bytes;
    private transient long timestamp;
    private transient String label;
    private transient String vertexId;
    private transient boolean decoded;

    public EdgeInfo(String label, String vertexId) {
        this(label, vertexId, System.currentTimeMillis());
    }

    public EdgeInfo(String label, String vertexId, long timestamp) {
        this.label = label;
        this.vertexId = vertexId;
        this.timestamp = timestamp;
        this.decoded = true;
    }

    public EdgeInfo(byte[] bytes, long timestamp) {
        this.timestamp = timestamp;
        this.bytes = bytes;
    }

    public String getLabel() {
        this.decodeBytes();
        return this.label;
    }

    public String getVertexId() {
        this.decodeBytes();
        return this.vertexId;
    }

    public static String getVertexId(Value value) {
        ByteBuffer in = ByteBuffer.wrap(value.get());
        EdgeInfo.readString(in);
        return EdgeInfo.readString(in);
    }

    private void decodeBytes() {
        if (!this.decoded) {
            ByteBuffer in = ByteBuffer.wrap(this.bytes);
            this.label = EdgeInfo.readString(in);
            this.vertexId = EdgeInfo.readString(in);
            this.decoded = true;
        }
    }

    public byte[] getLabelBytes() {
        int labelBytesLength = (this.bytes[0] << 24) + (this.bytes[1] << 16) + (this.bytes[2] << 8) + this.bytes[3];
        if (labelBytesLength == -1) {
            return null;
        }
        return Arrays.copyOfRange(this.bytes, 4, 4 + labelBytesLength);
    }

    private static String readString(ByteBuffer in) {
        int labelBytesLength = in.getInt();
        if (labelBytesLength == -1) {
            return null;
        }
        byte[] d = new byte[labelBytesLength];
        in.get(d);
        try {
            return new String(d, CHARSET_NAME);
        }
        catch (IOException ex) {
            throw new VertexiumAccumuloIteratorException("Could not decode edge info", ex);
        }
    }

    public static EdgeInfo parse(Value value, long timestamp) {
        return new EdgeInfo(value.get(), timestamp);
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            try {
                int vertexIdBytesLength;
                byte[] vertexIdBytes;
                int labelBytesLength;
                byte[] labelBytes;
                if (this.label == null) {
                    labelBytes = null;
                    labelBytesLength = -1;
                } else {
                    labelBytes = this.label.getBytes(CHARSET_NAME);
                    labelBytesLength = labelBytes.length;
                }
                if (this.vertexId == null) {
                    vertexIdBytes = null;
                    vertexIdBytesLength = -1;
                } else {
                    vertexIdBytes = this.vertexId.getBytes(CHARSET_NAME);
                    vertexIdBytesLength = vertexIdBytes.length;
                }
                int len = 4 + labelBytesLength + 4 + vertexIdBytesLength;
                ByteBuffer buffer = ByteBuffer.allocate(len);
                buffer.putInt(labelBytesLength);
                if (labelBytes != null) {
                    buffer.put(labelBytes);
                }
                buffer.putInt(vertexIdBytesLength);
                if (vertexIdBytes != null) {
                    buffer.put(vertexIdBytes);
                }
                this.bytes = buffer.array();
            }
            catch (UnsupportedEncodingException ex) {
                throw new VertexiumAccumuloIteratorException("Could not encode edge info", ex);
            }
        }
        return this.bytes;
    }

    public Value toValue() {
        return new Value(this.getBytes());
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "EdgeInfo{vertexId='" + this.vertexId + '\'' + ", label='" + this.label + '\'' + '}';
    }
}

