/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene;

import org.apache.lucene.util.InfoStream;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;

public final class LoggerInfoStream
extends InfoStream {
    private final ESLogger logger;
    private final ESLogger ifdLogger;

    public LoggerInfoStream(Settings settings, ShardId shardId) {
        this.logger = Loggers.getLogger("lucene.iw", settings, shardId, new String[0]);
        this.ifdLogger = Loggers.getLogger("lucene.iw.ifd", settings, shardId, new String[0]);
    }

    public void message(String component, String message) {
        this.getLogger(component).trace("{} {}: {}", Thread.currentThread().getName(), component, message);
    }

    public boolean isEnabled(String component) {
        return this.getLogger(component).isTraceEnabled() && !component.equals("TP");
    }

    private ESLogger getLogger(String component) {
        if (component.equals("IFD")) {
            return this.ifdLogger;
        }
        return this.logger;
    }

    public void close() {
    }
}

