/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.PropertyDefinition;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchQueryBase;
import org.vertexium.elasticsearch.ElasticsearchSingleDocumentSearchIndex;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.elasticsearch.score.ScoringStrategy;
import org.vertexium.query.GeohashQueryItem;
import org.vertexium.query.GraphQueryWithGeohashAggregation;
import org.vertexium.query.GraphQueryWithHistogramAggregation;
import org.vertexium.query.GraphQueryWithStatisticsAggregation;
import org.vertexium.query.GraphQueryWithTermsAggregation;
import org.vertexium.query.HistogramQueryItem;
import org.vertexium.query.QueryBase;
import org.vertexium.query.QueryStringQueryParameters;
import org.vertexium.query.SortDirection;
import org.vertexium.query.StatisticsQueryItem;
import org.vertexium.query.TermsQueryItem;

public class ElasticSearchSingleDocumentSearchQueryBase
extends ElasticSearchQueryBase
implements GraphQueryWithHistogramAggregation,
GraphQueryWithTermsAggregation,
GraphQueryWithGeohashAggregation,
GraphQueryWithStatisticsAggregation {
    private final List<HistogramQueryItem> histogramQueryItems = new ArrayList<HistogramQueryItem>();
    private final List<TermsQueryItem> termsQueryItems = new ArrayList<TermsQueryItem>();
    private final List<GeohashQueryItem> geohashQueryItems = new ArrayList<GeohashQueryItem>();
    private final List<StatisticsQueryItem> statisticsQueryItems = new ArrayList<StatisticsQueryItem>();

    public ElasticSearchSingleDocumentSearchQueryBase(Client client, Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, Authorizations authorizations) {
        super(client, graph, queryString, propertyDefinitions, scoringStrategy, indexSelectionStrategy, false, true, false, authorizations);
    }

    public ElasticSearchSingleDocumentSearchQueryBase(Client client, Graph graph, String[] similarToFields, String similarToText, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, Authorizations authorizations) {
        super(client, graph, similarToFields, similarToText, propertyDefinitions, scoringStrategy, indexSelectionStrategy, false, true, false, authorizations);
    }

    public GraphQueryWithHistogramAggregation addHistogramAggregation(String aggregationName, String fieldName, String interval, Long minDocumentCount) {
        this.histogramQueryItems.add(new HistogramQueryItem(aggregationName, fieldName, interval, minDocumentCount));
        return this;
    }

    public GraphQueryWithHistogramAggregation addHistogramAggregation(String aggregationName, String fieldName, String interval) {
        return this.addHistogramAggregation(aggregationName, fieldName, interval, null);
    }

    public GraphQueryWithTermsAggregation addTermsAggregation(String aggregationName, String fieldName) {
        this.termsQueryItems.add(new TermsQueryItem(aggregationName, fieldName));
        return this;
    }

    public GraphQueryWithGeohashAggregation addGeohashAggregation(String aggregationName, String fieldName, int precision) {
        this.geohashQueryItems.add(new GeohashQueryItem(aggregationName, fieldName, precision));
        return this;
    }

    public GraphQueryWithStatisticsAggregation addStatisticsAggregation(String aggregationName, String field) {
        this.statisticsQueryItems.add(new StatisticsQueryItem(aggregationName, field));
        return this;
    }

    protected SearchRequestBuilder getSearchRequestBuilder(List<FilterBuilder> filters, QueryBuilder queryBuilder, ElasticSearchElementType elementType, int skip, int limit) {
        SearchRequestBuilder searchRequestBuilder = super.getSearchRequestBuilder(filters, queryBuilder, elementType, skip, limit);
        this.addHistogramQueryToSearchRequestBuilder(searchRequestBuilder, this.histogramQueryItems);
        this.addTermsQueryToSearchRequestBuilder(searchRequestBuilder, this.termsQueryItems);
        this.addGeohashQueryToSearchRequestBuilder(searchRequestBuilder, this.geohashQueryItems);
        this.addStatisticsQueryToSearchRequestBuilder(searchRequestBuilder, this.statisticsQueryItems);
        return searchRequestBuilder;
    }

    protected QueryBuilder createQueryStringQuery(QueryStringQueryParameters queryParameters) {
        String queryString = queryParameters.getQueryString();
        if (queryString == null || queryString.equals("*")) {
            return QueryBuilders.matchAllQuery();
        }
        ElasticsearchSingleDocumentSearchIndex es = (ElasticsearchSingleDocumentSearchIndex)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
        Collection<String> fields = es.getQueryablePropertyNames(this.getGraph(), false, this.getParameters().getAuthorizations());
        QueryStringQueryBuilder qs = QueryBuilders.queryString((String)queryString);
        for (String field : fields) {
            qs = qs.field(field);
        }
        return qs;
    }

    protected List<FilterBuilder> getFilters(ElasticSearchElementType elementType) {
        String queryString;
        List results = super.getFilters(elementType);
        if (this.getParameters() instanceof QueryStringQueryParameters && ((queryString = ((QueryStringQueryParameters)this.getParameters()).getQueryString()) == null || queryString.equals("*"))) {
            ElasticsearchSingleDocumentSearchIndex es = (ElasticsearchSingleDocumentSearchIndex)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
            Collection<String> fields = es.getQueryableElementTypeVisibilityPropertyNames(this.getGraph(), this.getParameters().getAuthorizations());
            OrFilterBuilder atLeastOneFieldExistsFilter = new OrFilterBuilder(new FilterBuilder[0]);
            for (String field : fields) {
                atLeastOneFieldExistsFilter.add((FilterBuilder)new ExistsFilterBuilder(field));
            }
            results.add(atLeastOneFieldExistsFilter);
        }
        return results;
    }

    protected void applySort(SearchRequestBuilder q) {
        for (QueryBase.SortContainer sortContainer : this.getParameters().getSortContainers()) {
            SortOrder esOrder;
            SortOrder sortOrder = esOrder = sortContainer.direction == SortDirection.ASCENDING ? SortOrder.ASC : SortOrder.DESC;
            PropertyDefinition propertyDefinition = this.getSearchIndex().getPropertyDefinition(this.getGraph(), sortContainer.propertyName);
            if (propertyDefinition == null) continue;
            if (!propertyDefinition.isSortable()) {
                throw new VertexiumException("Cannot sort on non-sortable fields");
            }
            q.addSort(propertyDefinition.getPropertyName(), esOrder);
        }
    }
}

