/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.ws.Holder;
import net.jodah.recurrent.Recurrent;
import net.jodah.recurrent.RetryPolicy;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermFilterBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.vertexium.Authorizations;
import org.vertexium.DateOnly;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.GraphConfiguration;
import org.vertexium.Property;
import org.vertexium.PropertyDefinition;
import org.vertexium.SearchIndexSecurityGranularity;
import org.vertexium.TextIndexHint;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchQueryBase;
import org.vertexium.elasticsearch.ElasticSearchSearchIndexBase;
import org.vertexium.elasticsearch.ElasticSearchSingleDocumentSearchGraphQuery;
import org.vertexium.elasticsearch.ElasticSearchSingleDocumentSearchVertexQuery;
import org.vertexium.elasticsearch.IndexInfo;
import org.vertexium.elasticsearch.MetadataTablePropertyNameVisibilitiesStore;
import org.vertexium.elasticsearch.PropertyNameVisibilitiesStore;
import org.vertexium.elasticsearch.VertexiumNoMatchingPropertiesException;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.SimilarToGraphQuery;
import org.vertexium.query.VertexQuery;
import org.vertexium.search.SearchIndex;
import org.vertexium.type.GeoCircle;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoShape;
import org.vertexium.util.ConfigurationUtils;
import org.vertexium.util.StreamUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class ElasticsearchSingleDocumentSearchIndex
extends ElasticSearchSearchIndexBase {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ElasticsearchSingleDocumentSearchIndex.class);
    public static final Pattern PROPERTY_NAME_PATTERN = Pattern.compile("^(.*?)(_([0-9a-f]{32}))?(_([a-z]))?$");
    public static final Pattern AGGREGATION_NAME_PATTERN = Pattern.compile("(.*?)_([0-9a-f]+)");
    public static final String CONFIG_PROPERTY_NAME_VISIBILITIES_STORE = "propertyNameVisibilitiesStore";
    public static final Class<? extends PropertyNameVisibilitiesStore> DEFAULT_PROPERTY_NAME_VISIBILITIES_STORE = MetadataTablePropertyNameVisibilitiesStore.class;
    private final NameSubstitutionStrategy nameSubstitutionStrategy;
    private final PropertyNameVisibilitiesStore propertyNameVisibilitiesStore;
    private final Random random = new Random();

    public ElasticsearchSingleDocumentSearchIndex(Graph graph, GraphConfiguration config) {
        super(graph, config);
        this.nameSubstitutionStrategy = this.getConfig().getNameSubstitutionStrategy();
        this.propertyNameVisibilitiesStore = this.createPropertyNameVisibilitiesStore(graph, config);
    }

    private PropertyNameVisibilitiesStore createPropertyNameVisibilitiesStore(Graph graph, GraphConfiguration config) {
        String className = config.getString("search.propertyNameVisibilitiesStore", DEFAULT_PROPERTY_NAME_VISIBILITIES_STORE.getName());
        return (PropertyNameVisibilitiesStore)ConfigurationUtils.createProvider((String)className, (Graph)graph, (GraphConfiguration)config);
    }

    public void shutdown() {
        super.shutdown();
        if (this.propertyNameVisibilitiesStore instanceof Closeable) {
            try {
                ((Closeable)((Object)this.propertyNameVisibilitiesStore)).close();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }

    protected boolean isStoreSourceData() {
        return true;
    }

    protected boolean getDefaultAllFieldEnabled() {
        return false;
    }

    public void addElement(Graph graph, final Element element, Authorizations authorizations) {
        if (MUTATION_LOGGER.isTraceEnabled()) {
            MUTATION_LOGGER.trace("addElement: %s", new Object[]{element.getId()});
        }
        if (!this.getConfig().isIndexEdges() && element instanceof Edge) {
            return;
        }
        final IndexInfo indexInfo = this.addPropertiesToIndex(graph, element, element.getProperties());
        try {
            XContentBuilder jsonBuilder = this.buildJsonContentFromElement(graph, element, authorizations);
            final XContentBuilder source = jsonBuilder.endObject();
            if (MUTATION_LOGGER.isTraceEnabled()) {
                MUTATION_LOGGER.trace("addElement json: %s: %s", new Object[]{element.getId(), source.string()});
            }
            final Holder retrying = new Holder((Object)false);
            Runnable update = new Runnable(){

                @Override
                public void run() {
                    if (((Boolean)retrying.value).booleanValue()) {
                        ElasticsearchSingleDocumentSearchIndex.this.getClient().get(Requests.getRequest((String)indexInfo.getIndexName()).id(element.getId()).type("element").refresh(true)).actionGet();
                    }
                    try {
                        UpdateResponse response = (UpdateResponse)ElasticsearchSingleDocumentSearchIndex.this.getClient().prepareUpdate(indexInfo.getIndexName(), "element", element.getId()).setDocAsUpsert(true).setDoc(source).execute().actionGet();
                        if (response.getId() == null) {
                            throw new VertexiumException("Could not index document " + element.getId());
                        }
                    }
                    catch (VersionConflictEngineException e) {
                        LOGGER.warn("ES version conflict detected for id %s. Retrying.", new Object[]{element.getId()});
                        retrying.value = true;
                        throw e;
                    }
                }
            };
            RetryPolicy retryPolicy = new RetryPolicy().retryOn(new Class[]{VersionConflictEngineException.class}).withDelay((long)(100 + this.random.nextInt(50)), TimeUnit.MILLISECONDS).withMaxRetries(3);
            Recurrent.run((Runnable)update, (RetryPolicy)retryPolicy);
            if (this.getConfig().isAutoFlush()) {
                this.flush();
            }
        }
        catch (Exception e) {
            throw new VertexiumException("Could not add element", (Throwable)e);
        }
        this.getConfig().getScoringStrategy().addElement((SearchIndex)this, graph, element, authorizations);
    }

    private XContentBuilder buildJsonContentFromElement(Graph graph, Element element, Authorizations authorizations) throws IOException {
        XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
        String elementTypeVisibilityPropertyName = this.addElementTypeVisibilityPropertyToIndex(graph, element);
        if (element instanceof Vertex) {
            jsonBuilder.field("__elementType", ElasticSearchElementType.VERTEX.getKey());
            jsonBuilder.field(elementTypeVisibilityPropertyName, ElasticSearchElementType.VERTEX.getKey());
            this.getConfig().getScoringStrategy().addFieldsToVertexDocument((SearchIndex)this, jsonBuilder, (Vertex)element, null, authorizations);
        } else if (element instanceof Edge) {
            Edge edge = (Edge)element;
            jsonBuilder.field("__elementType", ElasticSearchElementType.EDGE.getKey());
            jsonBuilder.field(elementTypeVisibilityPropertyName, ElasticSearchElementType.VERTEX.getKey());
            this.getConfig().getScoringStrategy().addFieldsToEdgeDocument((SearchIndex)this, jsonBuilder, edge, null, authorizations);
            jsonBuilder.field("__inVertexId", edge.getVertexId(Direction.IN));
            jsonBuilder.field("__outVertexId", edge.getVertexId(Direction.OUT));
            jsonBuilder.field("__edgeLabel", edge.getLabel());
        } else {
            throw new VertexiumException("Unexpected element type " + element.getClass().getName());
        }
        Map<String, Object> properties = this.getProperties(graph, element);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            if (property.getValue() instanceof List) {
                List list = (List)property.getValue();
                jsonBuilder.field(property.getKey(), list.toArray(new Object[list.size()]));
                continue;
            }
            jsonBuilder.field(property.getKey(), property.getValue());
        }
        return jsonBuilder;
    }

    private String addElementTypeVisibilityPropertyToIndex(Graph graph, Element element) throws IOException {
        String elementTypeVisibilityPropertyName = this.deflatePropertyName(graph, "__elementType", element.getVisibility());
        String indexName = this.getIndexName(element);
        IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.isStoreSourceData());
        this.addPropertyToIndex(graph, indexInfo, elementTypeVisibilityPropertyName, String.class, false, false);
        return elementTypeVisibilityPropertyName;
    }

    private Map<String, Object> getProperties(Graph graph, Element element) throws IOException {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>();
        for (Property property : element.getProperties()) {
            this.addPropertyToMap(graph, property, propertiesMap);
        }
        return propertiesMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addPropertyToMap(Graph graph, Property property, Map<String, Object> propertiesMap) throws IOException {
        Object propertyValue = property.getValue();
        String propertyName = this.deflatePropertyName(graph, property);
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, propertyName);
        if (propertyValue != null && this.shouldIgnoreType(propertyValue.getClass())) {
            return;
        }
        if (propertyValue instanceof GeoPoint) {
            this.convertGeoPoint(graph, propertiesMap, property, (GeoPoint)propertyValue);
            return;
        }
        if (propertyValue instanceof GeoCircle) {
            this.convertGeoCircle(graph, propertiesMap, property, (GeoCircle)propertyValue);
            return;
        }
        if (propertyValue instanceof StreamingPropertyValue) {
            StreamingPropertyValue streamingPropertyValue = (StreamingPropertyValue)propertyValue;
            if (!streamingPropertyValue.isSearchIndex()) {
                return;
            }
            if (propertyDefinition != null && !propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                return;
            }
            Class valueType = streamingPropertyValue.getValueType();
            if (valueType != String.class) throw new VertexiumException("Unhandled StreamingPropertyValue type: " + valueType.getName());
            InputStream in = streamingPropertyValue.getInputStream();
            propertyValue = StreamUtils.toString((InputStream)in);
        } else if (propertyValue instanceof String) {
            if (propertyDefinition == null || propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                this.addPropertyValueToPropertiesMap(propertiesMap, propertyName + "_e", propertyValue);
            }
            if (propertyDefinition == null || propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                this.addPropertyValueToPropertiesMap(propertiesMap, propertyName, propertyValue);
            }
            if (propertyDefinition == null || !propertyDefinition.isSortable()) return;
            String s = ((String)propertyValue).substring(0, Math.min(100, ((String)propertyValue).length()));
            this.addPropertyValueToPropertiesMap(propertiesMap, propertyDefinition.getPropertyName(), s);
            return;
        }
        if (propertyValue instanceof DateOnly) {
            propertyValue = ((DateOnly)propertyValue).getDate();
        }
        this.addPropertyValueToPropertiesMap(propertiesMap, propertyName, propertyValue);
        if (propertyDefinition == null || !propertyDefinition.isSortable()) return;
        this.addPropertyValueToPropertiesMap(propertiesMap, propertyDefinition.getPropertyName(), propertyValue);
    }

    protected String deflatePropertyName(Graph graph, Property property) {
        String propertyName = property.getName();
        Visibility propertyVisibility = property.getVisibility();
        return this.deflatePropertyName(graph, propertyName, propertyVisibility);
    }

    private String deflatePropertyName(Graph graph, String propertyName, Visibility propertyVisibility) {
        String visibilityHash = this.getVisibilityHash(graph, propertyName, propertyVisibility);
        return this.nameSubstitutionStrategy.deflate(propertyName) + "_" + visibilityHash;
    }

    protected String inflatePropertyName(String string) {
        Matcher m = PROPERTY_NAME_PATTERN.matcher(string);
        if (m.matches()) {
            string = m.group(1);
        }
        return super.inflatePropertyName(string);
    }

    private String inflatePropertyNameWithTypeSuffix(String string) {
        Matcher m = PROPERTY_NAME_PATTERN.matcher(string);
        if (m.matches()) {
            string = m.groupCount() >= 5 && m.group(5) != null ? m.group(1) + "_" + m.group(5) : m.group(1);
        }
        return super.inflatePropertyName(string);
    }

    public String getPropertyVisibilityHashFromDeflatedPropertyName(String deflatedPropertyName) {
        Matcher m = PROPERTY_NAME_PATTERN.matcher(deflatedPropertyName);
        if (m.matches()) {
            return m.group(3);
        }
        throw new VertexiumException("Could not match property name: " + deflatedPropertyName);
    }

    public String getAggregationName(String name) {
        Matcher m = AGGREGATION_NAME_PATTERN.matcher(name);
        if (m.matches()) {
            return m.group(1);
        }
        throw new VertexiumException("Could not get aggregation name from: " + name);
    }

    public String[] getAllMatchingPropertyNames(Graph graph, String propertyName, Authorizations authorizations) {
        Collection<String> hashes = this.propertyNameVisibilitiesStore.getHashes(graph, propertyName, authorizations);
        if (hashes.size() == 0) {
            throw new VertexiumNoMatchingPropertiesException(propertyName);
        }
        String[] results = new String[hashes.size()];
        String deflatedPropertyName = this.nameSubstitutionStrategy.deflate(propertyName);
        int i = 0;
        for (String hash : hashes) {
            results[i++] = deflatedPropertyName + "_" + hash;
        }
        return results;
    }

    public Collection<String> getQueryablePropertyNames(Graph graph, boolean includeNonStringFields, Authorizations authorizations) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (PropertyDefinition propertyDefinition : this.getAllPropertyDefinitions().values()) {
            List<String> queryableTypeSuffixes = this.getQueryableTypeSuffixes(propertyDefinition, includeNonStringFields);
            if (queryableTypeSuffixes.size() == 0) continue;
            String inflatedPropertyName = this.inflatePropertyName(propertyDefinition.getPropertyName());
            String deflatedPropertyName = this.nameSubstitutionStrategy.deflate(inflatedPropertyName);
            if (this.isReservedFieldName(inflatedPropertyName)) continue;
            for (String hash : this.propertyNameVisibilitiesStore.getHashes(graph, inflatedPropertyName, authorizations)) {
                for (String typeSuffix : queryableTypeSuffixes) {
                    propertyNames.add(deflatedPropertyName + "_" + hash + typeSuffix);
                }
            }
        }
        return propertyNames;
    }

    public Collection<String> getQueryableElementTypeVisibilityPropertyNames(Graph graph, Authorizations authorizations) {
        HashSet<String> propertyNames = new HashSet<String>();
        for (PropertyDefinition propertyDefinition : this.getAllPropertyDefinitions().values()) {
            String inflatedPropertyName = this.inflatePropertyName(propertyDefinition.getPropertyName());
            String deflatedPropertyName = this.nameSubstitutionStrategy.deflate(inflatedPropertyName);
            if (!inflatedPropertyName.equals("__elementType")) continue;
            for (String hash : this.propertyNameVisibilitiesStore.getHashes(graph, inflatedPropertyName, authorizations)) {
                propertyNames.add(deflatedPropertyName + "_" + hash);
            }
        }
        if (propertyNames.size() == 0) {
            throw new VertexiumNoMatchingPropertiesException("No queryable __elementType for authorizations " + authorizations);
        }
        return propertyNames;
    }

    private List<String> getQueryableTypeSuffixes(PropertyDefinition propertyDefinition, boolean includeNonStringFields) {
        ArrayList<String> typeSuffixes = new ArrayList<String>();
        if (propertyDefinition.getDataType() == String.class) {
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                typeSuffixes.add("_e");
            }
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                typeSuffixes.add("");
            }
        } else if (propertyDefinition.getDataType() == GeoPoint.class || propertyDefinition.getDataType() == GeoCircle.class) {
            typeSuffixes.add("");
        } else if (includeNonStringFields && !this.shouldIgnoreType(propertyDefinition.getDataType())) {
            typeSuffixes.add("");
        }
        return typeSuffixes;
    }

    private String getVisibilityHash(Graph graph, String propertyName, Visibility visibility) {
        return this.propertyNameVisibilitiesStore.getHash(graph, propertyName, visibility);
    }

    public void deleteElement(Graph graph, Element element, Authorizations authorizations) {
        String indexName = this.getIndexName(element);
        String id = element.getId();
        if (MUTATION_LOGGER.isTraceEnabled()) {
            LOGGER.trace("deleting document %s", new Object[]{id});
        }
        this.getClient().delete((DeleteRequest)this.getClient().prepareDelete(indexName, "element", id).request()).actionGet();
    }

    public SearchIndexSecurityGranularity getSearchIndexSecurityGranularity() {
        return SearchIndexSecurityGranularity.PROPERTY;
    }

    public GraphQuery queryGraph(Graph graph, String queryString, Authorizations authorizations) {
        return new ElasticSearchSingleDocumentSearchGraphQuery(this.getClient(), graph, queryString, this.getAllPropertyDefinitions(), this.getConfig().getScoringStrategy(), this.getIndexSelectionStrategy(), authorizations);
    }

    public VertexQuery queryVertex(Graph graph, Vertex vertex, String queryString, Authorizations authorizations) {
        return new ElasticSearchSingleDocumentSearchVertexQuery(this.getClient(), graph, vertex, queryString, (Map<String, PropertyDefinition>)this.getAllPropertyDefinitions(), this.getConfig().getScoringStrategy(), this.getIndexSelectionStrategy(), authorizations);
    }

    public SimilarToGraphQuery querySimilarTo(Graph graph, String[] similarToFields, String similarToText, Authorizations authorizations) {
        return new ElasticSearchSingleDocumentSearchGraphQuery(this.getClient(), graph, similarToFields, similarToText, this.getAllPropertyDefinitions(), this.getConfig().getScoringStrategy(), this.getIndexSelectionStrategy(), authorizations);
    }

    public boolean isFieldLevelSecuritySupported() {
        return true;
    }

    protected void addPropertyDefinitionToIndex(Graph graph, IndexInfo indexInfo, String propertyName, PropertyDefinition propertyDefinition) throws IOException {
    }

    public PropertyDefinition getPropertyDefinition(Graph graph, String propertyName) {
        propertyName = this.inflatePropertyNameWithTypeSuffix(propertyName);
        return ((GraphBaseWithSearchIndex)graph).getPropertyDefinition(propertyName);
    }

    private void savePropertyDefinition(Graph graph, String propertyName, PropertyDefinition propertyDefinition) {
        propertyName = this.inflatePropertyNameWithTypeSuffix(propertyName);
        ((GraphBaseWithSearchIndex)graph).savePropertyDefinition(propertyName, propertyDefinition);
    }

    public void addPropertyToIndex(Graph graph, IndexInfo indexInfo, Property property) throws IOException {
        String deflatedPropertyName;
        Object propertyValue = property.getValue();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, property.getName());
        if (propertyDefinition != null) {
            deflatedPropertyName = this.deflatePropertyName(graph, property);
            super.addPropertyDefinitionToIndex(graph, indexInfo, deflatedPropertyName, propertyDefinition);
        } else {
            super.addPropertyToIndex(graph, indexInfo, property);
        }
        propertyDefinition = this.getPropertyDefinition(graph, property.getName() + "_e");
        if (propertyDefinition != null) {
            deflatedPropertyName = this.deflatePropertyName(graph, property);
            super.addPropertyDefinitionToIndex(graph, indexInfo, deflatedPropertyName, propertyDefinition);
        }
        if (propertyValue instanceof GeoShape && (propertyDefinition = this.getPropertyDefinition(graph, property.getName() + "_g")) != null) {
            deflatedPropertyName = this.deflatePropertyName(graph, property);
            super.addPropertyDefinitionToIndex(graph, indexInfo, deflatedPropertyName, propertyDefinition);
        }
    }

    protected void addPropertyToIndex(Graph graph, IndexInfo indexInfo, String propertyName, Class dataType, boolean analyzed, Double boost, boolean sortable) throws IOException {
        if (indexInfo.isPropertyDefined(propertyName)) {
            return;
        }
        if (this.shouldIgnoreType(dataType)) {
            return;
        }
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject("element").startObject("properties").startObject(propertyName);
        this.addTypeToMapping(mapping, propertyName, dataType, analyzed, boost);
        mapping.endObject().endObject().endObject().endObject();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("addPropertyToIndex: %s: %s", new Object[]{dataType.getName(), mapping.string()});
        }
        this.getClient().admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setIgnoreConflicts(false).setType("element").setSource(mapping).execute().actionGet();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, this.inflatePropertyName(propertyName));
        if (propertyDefinition == null) {
            propertyDefinition = new PropertyDefinition(propertyName, dataType, TextIndexHint.ALL);
        }
        indexInfo.addPropertyDefinition(propertyName, propertyDefinition);
        this.savePropertyDefinition(graph, propertyName, propertyDefinition);
    }

    public void addElementToBulkRequest(Graph graph, BulkRequest bulkRequest, IndexInfo indexInfo, Element element, Authorizations authorizations) {
        try {
            XContentBuilder json = this.buildJsonContentFromElement(graph, element, authorizations);
            UpdateRequest indexRequest = new UpdateRequest(indexInfo.getIndexName(), "element", element.getId()).doc(json);
            indexRequest.docAsUpsert(true);
            bulkRequest.add(indexRequest);
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not add element to bulk request", (Throwable)ex);
        }
    }

    public Map<Object, Long> getVertexPropertyCountByValue(Graph graph, String propertyName, Authorizations authorizations) {
        TermFilterBuilder elementTypeFilterBuilder = new TermFilterBuilder("__elementType", ElasticSearchElementType.VERTEX.getKey());
        FilteredQueryBuilder queryBuilder = QueryBuilders.filteredQuery((QueryBuilder)QueryBuilders.matchAllQuery(), (FilterBuilder)elementTypeFilterBuilder);
        SearchRequestBuilder q = this.getClient().prepareSearch(this.getIndexNamesAsArray()).setQuery((QueryBuilder)queryBuilder).setSearchType(SearchType.COUNT);
        for (String p : this.getAllMatchingPropertyNames(graph, propertyName, authorizations)) {
            String countAggName = "count-" + p;
            PropertyDefinition propertyDefinition = this.getPropertyDefinition(graph, p);
            if (propertyDefinition != null && propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                p = p + "_e";
            }
            TermsBuilder countAgg = ((TermsBuilder)new TermsBuilder(countAggName).field(p)).size(500000);
            q = q.addAggregation((AbstractAggregationBuilder)countAgg);
        }
        if (ElasticSearchQueryBase.QUERY_LOGGER.isTraceEnabled()) {
            ElasticSearchQueryBase.QUERY_LOGGER.trace("query: %s", new Object[]{q});
        }
        SearchResponse response = (SearchResponse)this.getClient().search(q.request()).actionGet();
        HashMap<Object, Long> results = new HashMap<Object, Long>();
        for (Aggregation agg : response.getAggregations().asList()) {
            Terms propertyCountResults = (Terms)agg;
            for (Terms.Bucket propertyCountResult : propertyCountResults.getBuckets()) {
                String mapKey = propertyCountResult.getKey().toLowerCase();
                Long previousValue = (Long)results.get(mapKey);
                if (previousValue == null) {
                    previousValue = 0L;
                }
                results.put(mapKey, previousValue + propertyCountResult.getDocCount());
            }
        }
        return results;
    }
}

