/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.sql;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.vertexium.VertexiumSerializer;
import org.vertexium.inmemory.InMemoryEdge;
import org.vertexium.inmemory.InMemoryGraphConfiguration;
import org.vertexium.inmemory.InMemoryTableElement;
import org.vertexium.inmemory.InMemoryVertex;
import org.vertexium.sql.SqlTableEdge;
import org.vertexium.sql.collections.SqlMap;

public class SqlGraphConfiguration
extends InMemoryGraphConfiguration {
    protected static final String CONFIG_JDBC_DRIVER_CLASS = "sql.jdbc.driverClass";
    protected static final String CONFIG_JDBC_URL = "sql.jdbc.url";
    protected static final String CONFIG_JDBC_USERNAME = "sql.jdbc.username";
    protected static final String CONFIG_JDBC_PASSWORD = "sql.jdbc.password";
    protected static final String KEY_COLUMN_NAME = "id";
    protected static final String VALUE_COLUMN_NAME = "object";
    protected static final String VERTEX_TABLE_NAME = "vertex";
    protected static final String EDGE_TABLE_NAME = "edge";
    protected static final String METADATA_TABLE_NAME = "metadata";
    protected static final String IN_VERTEX_ID_COLUMN = "in_vertex_id";
    protected static final String OUT_VERTEX_ID_COLUMN = "out_vertex_id";
    private final BasicDataSource dataSource;
    private final VertexiumSerializer serializer;

    public SqlGraphConfiguration(Map<String, Object> config) {
        super(config);
        String driverClass = SqlGraphConfiguration.getConfigString(config, CONFIG_JDBC_DRIVER_CLASS);
        String url = SqlGraphConfiguration.getConfigString(config, CONFIG_JDBC_URL);
        String username = SqlGraphConfiguration.getConfigString(config, CONFIG_JDBC_USERNAME);
        String password = SqlGraphConfiguration.getConfigString(config, CONFIG_JDBC_PASSWORD);
        this.dataSource = new BasicDataSource();
        this.dataSource.setDriverClassName(driverClass);
        this.dataSource.setUrl(url);
        this.dataSource.setUsername(username);
        this.dataSource.setPassword(password);
        this.serializer = this.createSerializer();
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected String tableNameWithPrefix(String tableName) {
        return this.getTableNamePrefix() + "_" + tableName;
    }

    protected SqlMap<InMemoryTableElement<InMemoryEdge>> newEdgeMap() {
        return new SqlMap<InMemoryTableElement<InMemoryEdge>>(this.tableNameWithPrefix(EDGE_TABLE_NAME), KEY_COLUMN_NAME, VALUE_COLUMN_NAME, (DataSource)this.dataSource, this.serializer){

            @Override
            protected Map<String, Object> additionalColumns(String key, InMemoryTableElement<InMemoryEdge> value) {
                SqlTableEdge edge = (SqlTableEdge)value;
                HashMap<String, Object> columns = new HashMap<String, Object>();
                columns.put(SqlGraphConfiguration.IN_VERTEX_ID_COLUMN, edge.inVertexId());
                columns.put(SqlGraphConfiguration.OUT_VERTEX_ID_COLUMN, edge.outVertexId());
                return columns;
            }
        };
    }

    protected SqlMap<InMemoryTableElement<InMemoryVertex>> newVertexMap() {
        return new SqlMap<InMemoryTableElement<InMemoryVertex>>(this.tableNameWithPrefix(VERTEX_TABLE_NAME), KEY_COLUMN_NAME, VALUE_COLUMN_NAME, (DataSource)this.dataSource, this.serializer);
    }

    protected SqlMap<Object> newMetadataMap() {
        return new SqlMap<Object>(this.tableNameWithPrefix(METADATA_TABLE_NAME), KEY_COLUMN_NAME, VALUE_COLUMN_NAME, (DataSource)this.dataSource, this.serializer);
    }

    private static String getConfigString(Map<String, Object> config, String key) {
        String value = (String)config.get(key);
        Preconditions.checkNotNull((Object)value, (Object)("config property '" + key + "' is required"));
        return value;
    }
}

