/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.sql.collections;

import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;
import org.skife.jdbi.v2.util.IntegerMapper;
import org.skife.jdbi.v2.util.StringMapper;
import org.vertexium.VertexiumSerializer;
import org.vertexium.sql.collections.MapEntry;
import org.vertexium.sql.collections.Storable;
import org.vertexium.util.CloseableUtils;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class SqlMap<T>
extends AbstractMap<String, T> {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(SqlMap.class);
    protected final String tableName;
    protected final String keyColumnName;
    protected final String valueColumnName;
    private final DBI dbi;
    private final VertexiumSerializer serializer;
    private final ResultSetMapper<MapEntry<byte[]>> entrySetMapper;

    public SqlMap(String tableName, String keyColumnName, String valueColumnName, DataSource dataSource, VertexiumSerializer serializer) {
        this.tableName = tableName;
        this.keyColumnName = keyColumnName;
        this.valueColumnName = valueColumnName;
        this.dbi = new DBI(dataSource);
        this.serializer = serializer;
        this.entrySetMapper = new ResultSetMapper<MapEntry<byte[]>>(){

            public MapEntry<byte[]> map(int index, ResultSet rs, StatementContext ctx) throws SQLException {
                String key = rs.getString(SqlMap.this.keyColumnName);
                byte[] value = rs.getBytes(SqlMap.this.valueColumnName);
                return new MapEntry<byte[]>(key, value);
            }
        };
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        final Handle handle = this.dbi.open();
        final Query query = handle.createQuery(String.format("select %s, %s from %s order by %s", this.keyColumnName, this.valueColumnName, this.tableName, this.keyColumnName)).map(this.entrySetMapper);
        return new IteratingSet<Map.Entry<String, T>>(){

            @Override
            public Iterator<Map.Entry<String, T>> createIterator() {
                return new QueryResultIterator<Map.Entry<String, T>, MapEntry<byte[]>>(query, handle){

                    @Override
                    public Map.Entry<String, T> next() {
                        MapEntry stringifiedEntry = (MapEntry)this.resultIterator.next();
                        String key = stringifiedEntry.getKey();
                        Object value = SqlMap.this.withContainer(SqlMap.this.serializer.bytesToObject((byte[])stringifiedEntry.getValue()));
                        return new MapEntry<Object>(key, value);
                    }
                };
            }
        };
    }

    @Override
    public Set<String> keySet() {
        final Handle handle = this.dbi.open();
        final Query query = handle.createQuery(String.format("select %s from %s order by %s", this.keyColumnName, this.tableName, this.keyColumnName)).map((ResultSetMapper)StringMapper.FIRST);
        return new IteratingSet<String>(){

            @Override
            public Iterator<String> createIterator() {
                return new QueryResultIterator(query, handle);
            }
        };
    }

    @Override
    public Collection<T> values() {
        final Handle handle = this.dbi.open();
        final Query query = handle.createQuery(String.format("select %s from %s order by %s", this.valueColumnName, this.tableName, this.keyColumnName)).map((ResultSetMapper)ByteArrayMapper.FIRST);
        return new IteratingSet<T>(){

            @Override
            public Iterator<T> createIterator() {
                return new QueryResultIterator<T, byte[]>(query, handle){

                    @Override
                    public T next() {
                        return SqlMap.this.withContainer(SqlMap.this.serializer.bytesToObject((byte[])this.resultIterator.next()));
                    }
                };
            }
        };
    }

    @Override
    public boolean containsKey(Object key) {
        try (Handle handle = this.dbi.open();){
            boolean bl = (Integer)((Query)handle.createQuery(String.format("select count(*) %s from %s where %s = ?", this.keyColumnName, this.tableName, this.keyColumnName)).bind(0, key)).map((ResultSetMapper)IntegerMapper.FIRST).first() > 0;
            return bl;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try (Handle handle = this.dbi.open();){
            boolean bl = (Integer)((Query)handle.createQuery(String.format("select count(*) %s from %s where %s = ?", this.valueColumnName, this.tableName, this.valueColumnName)).bind(0, this.serializer.objectToBytes(value))).map((ResultSetMapper)IntegerMapper.FIRST).first() > 0;
            return bl;
        }
    }

    @Override
    public int size() {
        try (Handle handle = this.dbi.open();){
            int n = (Integer)handle.createQuery(String.format("select count(*) from %s", this.tableName)).map((ResultSetMapper)IntegerMapper.FIRST).first();
            return n;
        }
    }

    @Override
    public void clear() {
        try (Handle handle = this.dbi.open();){
            handle.execute(String.format("delete from %s", this.tableName), new Object[0]);
        }
    }

    @Override
    public T remove(Object key) {
        T value = this.get(key);
        try (Handle handle = this.dbi.open();){
            handle.execute(String.format("delete from %s where %s = ?", this.tableName, this.keyColumnName), new Object[]{key});
            T t = this.withoutContainer(value);
            return t;
        }
    }

    @Override
    public T get(Object key) {
        try (Handle handle = this.dbi.open();){
            Object object = this.withContainer(this.serializer.bytesToObject((byte[])((Query)handle.createQuery(String.format("select %s from %s where %s = ?", this.valueColumnName, this.tableName, this.keyColumnName)).bind(0, key)).map((ResultSetMapper)ByteArrayMapper.FIRST).first()));
            return (T)object;
        }
    }

    @Override
    public T put(String key, T value) {
        byte[] byteArrayValue = this.serializer.objectToBytes(this.withContainer(value));
        T previous = this.get(key);
        try (Handle handle = this.dbi.open();){
            if (previous == null) {
                handle.execute(String.format("insert into %s (%s, %s) values (?, ?)", this.tableName, this.keyColumnName, this.valueColumnName), new Object[]{key, byteArrayValue});
            } else {
                handle.execute(String.format("update %s set %s = ? where %s = ?", this.tableName, this.valueColumnName, this.keyColumnName), new Object[]{byteArrayValue, key});
            }
            this.updateAdditionalColumns(handle, key, value);
        }
        return this.withoutContainer(previous);
    }

    private void updateAdditionalColumns(Handle handle, String key, T value) {
        Map<String, Object> additional = this.additionalColumns(key, value);
        if (!additional.isEmpty()) {
            StringBuilder updateSql = new StringBuilder(String.format("update %s set ", this.tableName));
            ArrayList<Object> positionalParams = new ArrayList<Object>();
            boolean first = true;
            for (Map.Entry<String, Object> column : additional.entrySet()) {
                if (first) {
                    updateSql.append(String.format("%s = ?", column.getKey()));
                    first = false;
                } else {
                    updateSql.append(String.format(", %s = ?", column.getKey()));
                }
                positionalParams.add(column.getValue());
            }
            updateSql.append(String.format(" where %s = ?", this.keyColumnName));
            positionalParams.add(key);
            handle.execute(updateSql.toString(), positionalParams.toArray());
        }
    }

    public Iterator<T> query(String where, Object ... positionalParams) {
        Handle handle = this.dbi.open();
        Query query1 = handle.createQuery(String.format("select %s from %s where %s order by %s", this.valueColumnName, this.tableName, where, this.keyColumnName));
        int i = 0;
        for (Object param : positionalParams) {
            query1 = (Query)query1.bind(i++, param);
        }
        Query query2 = query1.map((ResultSetMapper)ByteArrayMapper.FIRST);
        return new QueryResultIterator<T, byte[]>(query2, handle){

            @Override
            public T next() {
                return SqlMap.this.withContainer(SqlMap.this.serializer.bytesToObject((byte[])this.resultIterator.next()));
            }
        };
    }

    public Iterator<T> query(String where, Map<String, Object> namedParams) {
        Handle handle = this.dbi.open();
        Query query1 = handle.createQuery(String.format("select %s from %s where %s order by %s", this.valueColumnName, this.tableName, where, this.keyColumnName));
        for (Map.Entry<String, Object> param : namedParams.entrySet()) {
            query1 = (Query)query1.bind(param.getKey(), param.getValue());
        }
        Query query2 = query1.map((ResultSetMapper)ByteArrayMapper.FIRST);
        return new QueryResultIterator<T, byte[]>(query2, handle){

            @Override
            public T next() {
                return SqlMap.this.withContainer(SqlMap.this.serializer.bytesToObject((byte[])this.resultIterator.next()));
            }
        };
    }

    protected Map<String, Object> additionalColumns(String key, T value) {
        return Collections.emptyMap();
    }

    private T withContainer(T value) {
        if (value instanceof Storable) {
            ((Storable)value).setContainer(this);
        }
        return value;
    }

    private T withoutContainer(T value) {
        if (value instanceof Storable) {
            ((Storable)value).setContainer(null);
        }
        return value;
    }

    private class QueryResultIterator<E, V>
    implements Iterator<E>,
    Closeable {
        protected final Handle handle;
        protected final ResultIterator<V> resultIterator;
        private final Throwable creatorTrace = new Throwable();
        private boolean closed = false;

        QueryResultIterator(Query<V> query, Handle handle) {
            this.handle = handle;
            this.resultIterator = query.iterator();
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.resultIterator.hasNext();
            if (!hasNext) {
                this.close();
            }
            return hasNext;
        }

        @Override
        public E next() {
            return (E)this.resultIterator.next();
        }

        @Override
        public void remove() {
            this.resultIterator.remove();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                LOGGER.warn("closing QueryResultIterator handle from finalizer", this.creatorTrace);
                this.close();
            }
        }

        @Override
        public void close() {
            this.handle.close();
            this.closed = true;
        }
    }

    private abstract class IteratingSet<V>
    extends AbstractSet<V>
    implements Closeable {
        private Iterator<V> iterator;

        private IteratingSet() {
        }

        @Override
        public final Iterator<V> iterator() {
            if (this.iterator != null) {
                throw new IllegalStateException("can't ask for iterator more than once");
            }
            this.iterator = this.createIterator();
            return this.iterator;
        }

        @Override
        public int size() {
            return SqlMap.this.size();
        }

        @Override
        public void clear() {
            SqlMap.this.clear();
        }

        @Override
        public boolean contains(Object v) {
            return SqlMap.this.containsValue(v);
        }

        protected abstract Iterator<V> createIterator();

        @Override
        public void close() {
            CloseableUtils.closeQuietly((Object[])new Object[]{this.iterator});
        }
    }
}

