/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilder;
import org.vertexium.EdgeBuilderBase;
import org.vertexium.EdgeBuilderByVertexId;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.GraphConfiguration;
import org.vertexium.GraphMetadataStore;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.SecurityVertexiumException;
import org.vertexium.Vertex;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.event.AddEdgeEvent;
import org.vertexium.event.AddPropertyEvent;
import org.vertexium.event.AddVertexEvent;
import org.vertexium.event.DeleteEdgeEvent;
import org.vertexium.event.DeletePropertyEvent;
import org.vertexium.event.DeleteVertexEvent;
import org.vertexium.event.GraphEvent;
import org.vertexium.event.MarkHiddenEdgeEvent;
import org.vertexium.event.MarkHiddenPropertyEvent;
import org.vertexium.event.MarkHiddenVertexEvent;
import org.vertexium.event.MarkVisibleEdgeEvent;
import org.vertexium.event.MarkVisiblePropertyEvent;
import org.vertexium.event.MarkVisibleVertexEvent;
import org.vertexium.event.SoftDeleteEdgeEvent;
import org.vertexium.event.SoftDeletePropertyEvent;
import org.vertexium.event.SoftDeleteVertexEvent;
import org.vertexium.id.IdGenerator;
import org.vertexium.inmemory.InMemoryAuthorizations;
import org.vertexium.inmemory.InMemoryEdge;
import org.vertexium.inmemory.InMemoryEdgeTable;
import org.vertexium.inmemory.InMemoryElement;
import org.vertexium.inmemory.InMemoryGraphConfiguration;
import org.vertexium.inmemory.InMemoryGraphMetadataStore;
import org.vertexium.inmemory.InMemoryStreamingPropertyValueRef;
import org.vertexium.inmemory.InMemoryTableEdge;
import org.vertexium.inmemory.InMemoryTableElement;
import org.vertexium.inmemory.InMemoryTableVertex;
import org.vertexium.inmemory.InMemoryVertex;
import org.vertexium.inmemory.InMemoryVertexTable;
import org.vertexium.inmemory.mutations.AlterEdgeLabelMutation;
import org.vertexium.inmemory.mutations.AlterVisibilityMutation;
import org.vertexium.inmemory.mutations.EdgeSetupMutation;
import org.vertexium.inmemory.mutations.ElementTimestampMutation;
import org.vertexium.mutation.AlterPropertyVisibility;
import org.vertexium.mutation.SetPropertyMetadata;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.property.StreamingPropertyValueRef;
import org.vertexium.search.IndexHint;
import org.vertexium.search.SearchIndex;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IncreasingTime;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.LookAheadIterable;
import org.vertexium.util.Preconditions;

public class InMemoryGraph
extends GraphBaseWithSearchIndex {
    protected static final InMemoryGraphConfiguration DEFAULT_CONFIGURATION = new InMemoryGraphConfiguration(new HashMap<String, Object>());
    private final InMemoryVertexTable vertices;
    private final InMemoryEdgeTable edges;
    private final Set<String> validAuthorizations = new HashSet<String>();
    private final GraphMetadataStore graphMetadataStore;

    protected InMemoryGraph(InMemoryGraphConfiguration configuration) {
        this(configuration, new InMemoryVertexTable(), new InMemoryEdgeTable());
    }

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex) {
        this(configuration, idGenerator, searchIndex, new InMemoryVertexTable(), new InMemoryEdgeTable());
    }

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, InMemoryVertexTable vertices, InMemoryEdgeTable edges) {
        super((GraphConfiguration)configuration);
        this.vertices = vertices;
        this.edges = edges;
        this.graphMetadataStore = this.newGraphMetadataStore(configuration);
    }

    protected InMemoryGraph(InMemoryGraphConfiguration configuration, IdGenerator idGenerator, SearchIndex searchIndex, InMemoryVertexTable vertices, InMemoryEdgeTable edges) {
        super((GraphConfiguration)configuration, idGenerator, searchIndex);
        this.vertices = vertices;
        this.edges = edges;
        this.graphMetadataStore = this.newGraphMetadataStore(configuration);
    }

    protected GraphMetadataStore newGraphMetadataStore(GraphConfiguration configuration) {
        return new InMemoryGraphMetadataStore();
    }

    public static InMemoryGraph create() {
        return InMemoryGraph.create(DEFAULT_CONFIGURATION);
    }

    public static InMemoryGraph create(InMemoryGraphConfiguration config) {
        InMemoryGraph graph = new InMemoryGraph(config);
        graph.setup();
        return graph;
    }

    public static InMemoryGraph create(Map<String, Object> config) {
        return InMemoryGraph.create(new InMemoryGraphConfiguration(config));
    }

    public static InMemoryGraph create(InMemoryGraphConfiguration config, IdGenerator idGenerator, SearchIndex searchIndex) {
        InMemoryGraph graph = new InMemoryGraph(config, idGenerator, searchIndex);
        graph.setup();
        return graph;
    }

    public VertexBuilder prepareVertex(String vertexId, Long timestamp, Visibility visibility) {
        if (vertexId == null) {
            vertexId = this.getIdGenerator().nextId();
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        final long timestampLong = timestamp;
        return new VertexBuilder(vertexId, visibility){

            public Vertex save(Authorizations authorizations) {
                InMemoryGraph.this.addValidAuthorizations(authorizations.getAuthorizations());
                boolean isNew = false;
                InMemoryTableElement vertexTableElement = InMemoryGraph.this.vertices.getTableElement(this.getVertexId());
                if (vertexTableElement == null) {
                    isNew = true;
                    InMemoryGraph.this.vertices.append(this.getVertexId(), new AlterVisibilityMutation(timestampLong, this.getVisibility()), new ElementTimestampMutation(timestampLong));
                } else {
                    InMemoryGraph.this.vertices.append(this.getVertexId(), new ElementTimestampMutation(timestampLong));
                }
                InMemoryVertex vertex = (InMemoryVertex)InMemoryGraph.this.vertices.get(InMemoryGraph.this, this.getVertexId(), authorizations);
                if (isNew && InMemoryGraph.this.hasEventListeners()) {
                    InMemoryGraph.this.fireGraphEvent((GraphEvent)new AddVertexEvent((Graph)InMemoryGraph.this, (Vertex)vertex));
                }
                vertex.updatePropertiesInternal(this);
                if (this.getIndexHint() != IndexHint.DO_NOT_INDEX) {
                    InMemoryGraph.this.getSearchIndex().addElement((Graph)InMemoryGraph.this, (Element)vertex, authorizations);
                }
                return vertex;
            }
        };
    }

    private void addValidAuthorizations(String[] authorizations) {
        Collections.addAll(this.validAuthorizations, authorizations);
    }

    public Iterable<Vertex> getVertices(EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) throws VertexiumException {
        this.validateAuthorizations(authorizations);
        return new ConvertingIterable<InMemoryVertex, Vertex>(this.vertices.getAll(this, fetchHints, endTime, authorizations)){

            protected Vertex convert(InMemoryVertex o) {
                return o;
            }
        };
    }

    protected void validateAuthorizations(Authorizations authorizations) {
        for (String auth : authorizations.getAuthorizations()) {
            if (this.validAuthorizations.contains(auth)) continue;
            throw new SecurityVertexiumException("Invalid authorizations", authorizations);
        }
    }

    public void deleteVertex(Vertex vertex, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List edgesToDelete = IterableUtils.toList((Iterable)vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToDelete : edgesToDelete) {
            this.deleteEdge(edgeToDelete, authorizations);
        }
        this.vertices.remove(vertex.getId());
        this.getSearchIndex().deleteElement((Graph)this, (Element)vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new DeleteVertexEvent((Graph)this, vertex));
        }
    }

    public void softDeleteVertex(Vertex vertex, Long timestamp, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        List edgesToSoftDelete = IterableUtils.toList((Iterable)vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToSoftDelete : edgesToSoftDelete) {
            this.softDeleteEdge(edgeToSoftDelete, timestamp, authorizations);
        }
        this.vertices.getTableElement(vertex.getId()).appendSoftDeleteMutation(timestamp);
        this.getSearchIndex().deleteElement((Graph)this, (Element)vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new SoftDeleteVertexEvent((Graph)this, vertex));
        }
    }

    public void markVertexHidden(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List edgesToMarkHidden = IterableUtils.toList((Iterable)vertex.getEdges(Direction.BOTH, authorizations));
        for (Edge edgeToMarkHidden : edgesToMarkHidden) {
            this.markEdgeHidden(edgeToMarkHidden, visibility, authorizations);
        }
        this.vertices.getTableElement(vertex.getId()).appendMarkHiddenMutation(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkHiddenVertexEvent((Graph)this, vertex));
        }
    }

    public void markVertexVisible(Vertex vertex, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryVertex)vertex).canRead(authorizations)) {
            return;
        }
        List edgesToMarkVisible = IterableUtils.toList((Iterable)vertex.getEdges(Direction.BOTH, FetchHint.ALL_INCLUDING_HIDDEN, authorizations));
        for (Edge edgeToMarkVisible : edgesToMarkVisible) {
            this.markEdgeVisible(edgeToMarkVisible, visibility, authorizations);
        }
        this.vertices.getTableElement(vertex.getId()).appendMarkVisibleMutation(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)vertex, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkVisibleVertexEvent((Graph)this, vertex));
        }
    }

    public void markPropertyHidden(InMemoryElement element, InMemoryTableElement inMemoryTableElement, String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        if (!element.canRead(authorizations)) {
            return;
        }
        Property property = inMemoryTableElement.appendMarkPropertyHiddenMutation(key, name, propertyVisibility, timestamp, visibility, authorizations);
        if (property != null && this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkHiddenPropertyEvent((Graph)this, (Element)element, property, visibility));
        }
    }

    public void markPropertyVisible(InMemoryElement element, InMemoryTableElement inMemoryTableElement, String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        if (!element.canRead(authorizations)) {
            return;
        }
        Property property = inMemoryTableElement.appendMarkPropertyVisibleMutation(key, name, propertyVisibility, timestamp, visibility, authorizations);
        if (property != null && this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkVisiblePropertyEvent((Graph)this, (Element)element, property, visibility));
        }
    }

    public EdgeBuilderByVertexId prepareEdge(String edgeId, String outVertexId, String inVertexId, String label, final Long timestamp, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilderByVertexId(edgeId, outVertexId, inVertexId, label, visibility){

            public Edge save(Authorizations authorizations) {
                InMemoryGraph.this.addValidAuthorizations(authorizations.getAuthorizations());
                return InMemoryGraph.this.savePreparedEdge((EdgeBuilderBase)this, this.getOutVertexId(), this.getInVertexId(), timestamp, authorizations);
            }
        };
    }

    public EdgeBuilder prepareEdge(String edgeId, Vertex outVertex, Vertex inVertex, String label, final Long timestamp, Visibility visibility) {
        if (edgeId == null) {
            edgeId = this.getIdGenerator().nextId();
        }
        return new EdgeBuilder(edgeId, outVertex, inVertex, label, visibility){

            public Edge save(Authorizations authorizations) {
                InMemoryGraph.this.addValidAuthorizations(authorizations.getAuthorizations());
                return InMemoryGraph.this.savePreparedEdge((EdgeBuilderBase)this, this.getOutVertex().getId(), this.getInVertex().getId(), timestamp, authorizations);
            }
        };
    }

    private Edge savePreparedEdge(EdgeBuilderBase edgeBuilder, String outVertexId, String inVertexId, Long timestamp, Authorizations authorizations) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        long incrementingTimestamp = timestamp;
        InMemoryTableElement edgeTableElement = this.edges.getTableElement(edgeBuilder.getEdgeId());
        boolean isNew = false;
        if (edgeTableElement == null) {
            isNew = true;
            this.edges.append(edgeBuilder.getEdgeId(), new AlterVisibilityMutation(incrementingTimestamp++, edgeBuilder.getVisibility()), new ElementTimestampMutation(incrementingTimestamp++), new AlterEdgeLabelMutation(incrementingTimestamp++, edgeBuilder.getLabel()), new EdgeSetupMutation(incrementingTimestamp++, outVertexId, inVertexId));
        } else {
            this.edges.append(edgeBuilder.getEdgeId(), new ElementTimestampMutation(incrementingTimestamp++));
        }
        if (edgeBuilder.getNewEdgeLabel() != null) {
            this.edges.append(edgeBuilder.getEdgeId(), new AlterEdgeLabelMutation(incrementingTimestamp, edgeBuilder.getNewEdgeLabel()));
        }
        InMemoryEdge edge = (InMemoryEdge)this.edges.get(this, edgeBuilder.getEdgeId(), authorizations);
        if (isNew && this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new AddEdgeEvent((Graph)this, (Edge)edge));
        }
        edge.updatePropertiesInternal(edgeBuilder);
        if (edgeBuilder.getIndexHint() != IndexHint.DO_NOT_INDEX) {
            this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        }
        return edge;
    }

    public Iterable<Edge> getEdges(EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        return new ConvertingIterable<InMemoryEdge, Edge>(this.edges.getAll(this, fetchHints, endTime, authorizations)){

            protected Edge convert(InMemoryEdge o) {
                return o;
            }
        };
    }

    protected GraphMetadataStore getGraphMetadataStore() {
        return this.graphMetadataStore;
    }

    public void deleteEdge(Edge edge, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge, (Object)"Edge cannot be null");
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        this.edges.remove(edge.getId());
        this.getSearchIndex().deleteElement((Graph)this, (Element)edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new DeleteEdgeEvent((Graph)this, edge));
        }
    }

    public void softDeleteEdge(Edge edge, Long timestamp, Authorizations authorizations) {
        Preconditions.checkNotNull((Object)edge, (Object)"Edge cannot be null");
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        this.edges.getTableElement(edge.getId()).appendSoftDeleteMutation(timestamp);
        this.getSearchIndex().deleteElement((Graph)this, (Element)edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new SoftDeleteEdgeEvent((Graph)this, edge));
        }
    }

    public void markEdgeHidden(Edge edge, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        Vertex inVertex = this.getVertex(edge.getVertexId(Direction.IN), authorizations);
        Preconditions.checkNotNull((Object)inVertex, (Object)("Could not find in vertex: " + edge.getVertexId(Direction.IN)));
        Vertex outVertex = this.getVertex(edge.getVertexId(Direction.OUT), authorizations);
        Preconditions.checkNotNull((Object)outVertex, (Object)("Could not find out vertex: " + edge.getVertexId(Direction.OUT)));
        this.edges.getTableElement(edge.getId()).appendMarkHiddenMutation(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkHiddenEdgeEvent((Graph)this, edge));
        }
    }

    public void markEdgeVisible(Edge edge, Visibility visibility, Authorizations authorizations) {
        if (!((InMemoryEdge)edge).canRead(authorizations)) {
            return;
        }
        Vertex inVertex = this.getVertex(edge.getVertexId(Direction.IN), FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        Preconditions.checkNotNull((Object)inVertex, (Object)("Could not find in vertex: " + edge.getVertexId(Direction.IN)));
        Vertex outVertex = this.getVertex(edge.getVertexId(Direction.OUT), FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
        Preconditions.checkNotNull((Object)outVertex, (Object)("Could not find out vertex: " + edge.getVertexId(Direction.OUT)));
        this.edges.getTableElement(edge.getId()).appendMarkVisibleMutation(visibility);
        this.getSearchIndex().addElement((Graph)this, (Element)edge, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new MarkVisibleEdgeEvent((Graph)this, edge));
        }
    }

    public Authorizations createAuthorizations(String ... auths) {
        this.addValidAuthorizations(auths);
        return new InMemoryAuthorizations(auths);
    }

    protected Iterable<Edge> getEdgesFromVertex(final String vertexId, final EnumSet<FetchHint> fetchHints, final Long endTime, final Authorizations authorizations) {
        final boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        return new LookAheadIterable<InMemoryTableEdge, Edge>(){

            protected boolean isIncluded(InMemoryTableEdge inMemoryTableElement, Edge edge) {
                if (edge == null) {
                    return false;
                }
                EdgeSetupMutation edgeSetupMutation = inMemoryTableElement.findLastMutation(EdgeSetupMutation.class);
                String inVertexId = edgeSetupMutation.getInVertexId();
                Preconditions.checkNotNull((Object)inVertexId, (Object)"inVertexId was null");
                String outVertexId = edgeSetupMutation.getOutVertexId();
                Preconditions.checkNotNull((Object)outVertexId, (Object)"outVertexId was null");
                return (inVertexId.equals(vertexId) || outVertexId.equals(vertexId)) && InMemoryGraph.this.isIncluded(inMemoryTableElement, fetchHints, authorizations);
            }

            protected Edge convert(InMemoryTableEdge inMemoryTableElement) {
                return (Edge)inMemoryTableElement.createElement(InMemoryGraph.this, includeHidden, endTime, authorizations);
            }

            protected Iterator<InMemoryTableEdge> createIterator() {
                return InMemoryGraph.this.edges.getAllTableElements().iterator();
            }
        };
    }

    protected boolean isIncluded(InMemoryTableElement element, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        if (!element.canRead(authorizations)) {
            return false;
        }
        return includeHidden || !element.isHidden(authorizations);
    }

    protected boolean isIncludedInTimeSpan(InMemoryTableElement element, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        boolean includeHidden = fetchHints.contains(FetchHint.INCLUDE_HIDDEN);
        if (!element.canRead(authorizations)) {
            return false;
        }
        if (!includeHidden && element.isHidden(authorizations)) {
            return false;
        }
        if (element.isDeleted(endTime, authorizations)) {
            return false;
        }
        return endTime == null || element.getFirstTimestamp() <= endTime;
    }

    protected void softDeleteProperty(InMemoryTableElement inMemoryTableElement, Property property, Long timestamp, Authorizations authorizations) {
        Vertex element;
        if (inMemoryTableElement instanceof InMemoryTableVertex) {
            inMemoryTableElement.appendSoftDeletePropertyMutation(property.getKey(), property.getName(), property.getVisibility(), timestamp);
            element = this.getVertex(inMemoryTableElement.getId(), authorizations);
        } else if (inMemoryTableElement instanceof InMemoryTableEdge) {
            inMemoryTableElement.appendSoftDeletePropertyMutation(property.getKey(), property.getName(), property.getVisibility(), timestamp);
            element = this.getEdge(inMemoryTableElement.getId(), authorizations);
        } else {
            throw new IllegalArgumentException("Unexpected element type: " + inMemoryTableElement.getClass().getName());
        }
        this.getSearchIndex().deleteProperty((Graph)this, (Element)element, property, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new SoftDeletePropertyEvent((Graph)this, (Element)element, property));
        }
    }

    public void addPropertyValue(InMemoryElement element, InMemoryTableElement inMemoryTableElement, String key, String name, Object value, Metadata metadata, Visibility visibility, Long timestamp, Authorizations authorizations) {
        if (timestamp == null) {
            timestamp = IncreasingTime.currentTimeMillis();
        }
        if (value instanceof StreamingPropertyValue) {
            value = this.saveStreamingPropertyValue(element.getId(), key, name, visibility, timestamp, (StreamingPropertyValue)value);
        }
        inMemoryTableElement.appendAddPropertyMutation(key, name, value, metadata, visibility, timestamp);
        Property property = inMemoryTableElement.getProperty(key, name, visibility, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new AddPropertyEvent((Graph)this, (Element)element, property));
        }
    }

    protected void alterElementVisibility(InMemoryTableElement inMemoryTableElement, Visibility newEdgeVisibility) {
        inMemoryTableElement.appendAlterVisibilityMutation(newEdgeVisibility);
    }

    protected void alterElementPropertyVisibilities(InMemoryTableElement inMemoryTableElement, List<AlterPropertyVisibility> alterPropertyVisibilities, Authorizations authorizations) {
        for (AlterPropertyVisibility apv : alterPropertyVisibilities) {
            Property property = inMemoryTableElement.getProperty(apv.getKey(), apv.getName(), apv.getExistingVisibility(), authorizations);
            if (property == null) {
                throw new VertexiumException("Could not find property " + apv.getKey() + ":" + apv.getName());
            }
            if (apv.getExistingVisibility() == null) {
                apv.setExistingVisibility(property.getVisibility());
            }
            Object value = property.getValue();
            Metadata metadata = property.getMetadata();
            inMemoryTableElement.appendSoftDeletePropertyMutation(apv.getKey(), apv.getName(), apv.getExistingVisibility(), IncreasingTime.currentTimeMillis());
            long newTimestamp = IncreasingTime.currentTimeMillis();
            if (value instanceof StreamingPropertyValue) {
                value = this.saveStreamingPropertyValue(inMemoryTableElement.getId(), apv.getKey(), apv.getName(), apv.getVisibility(), newTimestamp, (StreamingPropertyValue)value);
            }
            inMemoryTableElement.appendAddPropertyMutation(apv.getKey(), apv.getName(), value, metadata, apv.getVisibility(), newTimestamp);
        }
    }

    protected void alterElementPropertyMetadata(InMemoryTableElement element, List<SetPropertyMetadata> setPropertyMetadatas, Authorizations authorizations) {
        for (SetPropertyMetadata apm : setPropertyMetadatas) {
            Property property = element.getProperty(apm.getPropertyKey(), apm.getPropertyName(), apm.getPropertyVisibility(), authorizations);
            if (property == null) {
                throw new VertexiumException("Could not find property " + apm.getPropertyKey() + ":" + apm.getPropertyName());
            }
            property.getMetadata().add(apm.getMetadataName(), apm.getNewValue(), apm.getMetadataVisibility());
        }
    }

    protected StreamingPropertyValueRef saveStreamingPropertyValue(String elementId, String key, String name, Visibility visibility, long timestamp, StreamingPropertyValue value) {
        return new InMemoryStreamingPropertyValueRef(value);
    }

    public boolean isVisibilityValid(Visibility visibility, Authorizations authorizations) {
        return authorizations.canRead(visibility);
    }

    public void truncate() {
        this.vertices.clear();
        this.edges.clear();
        this.getSearchIndex().truncate();
    }

    public void drop() {
        this.vertices.clear();
        this.edges.clear();
        this.getSearchIndex().drop();
    }

    protected void alterEdgeLabel(InMemoryTableEdge inMemoryTableEdge, String newEdgeLabel) {
        inMemoryTableEdge.appendAlterEdgeLabelMutation(newEdgeLabel);
    }

    protected void deleteProperty(InMemoryElement element, InMemoryTableElement inMemoryTableElement, String key, String name, Visibility visibility, Authorizations authorizations) {
        Property property = inMemoryTableElement.getProperty(key, name, visibility, authorizations);
        inMemoryTableElement.deleteProperty(key, name, visibility, authorizations);
        this.getSearchIndex().deleteProperty((Graph)this, (Element)element, property, authorizations);
        if (this.hasEventListeners()) {
            this.fireGraphEvent((GraphEvent)new DeletePropertyEvent((Graph)this, (Element)element, property));
        }
    }
}

