/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.PropertyDefinition;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchQueryBase;
import org.vertexium.elasticsearch.ElasticsearchSingleDocumentSearchIndex;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.elasticsearch.score.ScoringStrategy;
import org.vertexium.query.Aggregation;
import org.vertexium.query.GeohashAggregation;
import org.vertexium.query.GraphQueryWithGeohashAggregation;
import org.vertexium.query.GraphQueryWithHistogramAggregation;
import org.vertexium.query.GraphQueryWithStatisticsAggregation;
import org.vertexium.query.GraphQueryWithTermsAggregation;
import org.vertexium.query.HistogramAggregation;
import org.vertexium.query.QueryBase;
import org.vertexium.query.QueryStringQueryParameters;
import org.vertexium.query.SortDirection;
import org.vertexium.query.StatisticsAggregation;
import org.vertexium.query.TermsAggregation;

public class ElasticSearchSingleDocumentSearchQueryBase
extends ElasticSearchQueryBase
implements GraphQueryWithHistogramAggregation,
GraphQueryWithTermsAggregation,
GraphQueryWithGeohashAggregation,
GraphQueryWithStatisticsAggregation {
    public ElasticSearchSingleDocumentSearchQueryBase(Client client, Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, int pageSize, Authorizations authorizations) {
        super(client, graph, queryString, propertyDefinitions, scoringStrategy, indexSelectionStrategy, false, true, false, pageSize, authorizations);
    }

    public ElasticSearchSingleDocumentSearchQueryBase(Client client, Graph graph, String[] similarToFields, String similarToText, Map<String, PropertyDefinition> propertyDefinitions, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, int pageSize, Authorizations authorizations) {
        super(client, graph, similarToFields, similarToText, propertyDefinitions, scoringStrategy, indexSelectionStrategy, false, true, false, pageSize, authorizations);
    }

    @Deprecated
    public GraphQueryWithHistogramAggregation addHistogramAggregation(String aggregationName, String fieldName, String interval, Long minDocumentCount) {
        this.addAggregation((Aggregation)new HistogramAggregation(aggregationName, fieldName, interval, minDocumentCount));
        return this;
    }

    @Deprecated
    public GraphQueryWithHistogramAggregation addHistogramAggregation(String aggregationName, String fieldName, String interval) {
        return this.addHistogramAggregation(aggregationName, fieldName, interval, null);
    }

    @Deprecated
    public GraphQueryWithTermsAggregation addTermsAggregation(String aggregationName, String fieldName) {
        this.addAggregation((Aggregation)new TermsAggregation(aggregationName, fieldName));
        return this;
    }

    @Deprecated
    public GraphQueryWithGeohashAggregation addGeohashAggregation(String aggregationName, String fieldName, int precision) {
        this.addAggregation((Aggregation)new GeohashAggregation(aggregationName, fieldName, precision));
        return this;
    }

    @Deprecated
    public GraphQueryWithStatisticsAggregation addStatisticsAggregation(String aggregationName, String field) {
        this.addAggregation((Aggregation)new StatisticsAggregation(aggregationName, field));
        return this;
    }

    public boolean isAggregationSupported(Aggregation agg) {
        if (agg instanceof HistogramAggregation) {
            return true;
        }
        if (agg instanceof TermsAggregation) {
            return true;
        }
        if (agg instanceof GeohashAggregation) {
            return true;
        }
        return agg instanceof StatisticsAggregation;
    }

    protected SearchRequestBuilder getSearchRequestBuilder(List<FilterBuilder> filters, QueryBuilder queryBuilder, ElasticSearchElementType elementType, int skip, int limit, boolean includeAggregations) {
        SearchRequestBuilder searchRequestBuilder = super.getSearchRequestBuilder(filters, queryBuilder, elementType, skip, limit, includeAggregations);
        if (includeAggregations) {
            List aggs = this.getElasticsearchAggregations(this.getAggregations());
            for (AbstractAggregationBuilder aggregationBuilder : aggs) {
                searchRequestBuilder.addAggregation(aggregationBuilder);
            }
        }
        return searchRequestBuilder;
    }

    protected QueryBuilder createQueryStringQuery(QueryStringQueryParameters queryParameters) {
        String queryString = queryParameters.getQueryString();
        if (queryString == null || queryString.equals("*")) {
            return QueryBuilders.matchAllQuery();
        }
        ElasticsearchSingleDocumentSearchIndex es = (ElasticsearchSingleDocumentSearchIndex)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
        Collection<String> fields = es.getQueryablePropertyNames(this.getGraph(), false, this.getParameters().getAuthorizations());
        QueryStringQueryBuilder qs = QueryBuilders.queryString((String)queryString);
        for (String field : fields) {
            qs = qs.field(field);
        }
        return qs;
    }

    protected List<FilterBuilder> getFilters(ElasticSearchElementType elementType) {
        String queryString;
        List results = super.getFilters(elementType);
        if (this.getParameters() instanceof QueryStringQueryParameters && ((queryString = ((QueryStringQueryParameters)this.getParameters()).getQueryString()) == null || queryString.equals("*"))) {
            ElasticsearchSingleDocumentSearchIndex es = (ElasticsearchSingleDocumentSearchIndex)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
            Collection<String> fields = es.getQueryableElementTypeVisibilityPropertyNames(this.getGraph(), this.getParameters().getAuthorizations());
            OrFilterBuilder atLeastOneFieldExistsFilter = new OrFilterBuilder(new FilterBuilder[0]);
            for (String field : fields) {
                atLeastOneFieldExistsFilter.add((FilterBuilder)new ExistsFilterBuilder(field));
            }
            results.add(atLeastOneFieldExistsFilter);
        }
        return results;
    }

    protected void applySort(SearchRequestBuilder q) {
        for (QueryBase.SortContainer sortContainer : this.getParameters().getSortContainers()) {
            SortOrder esOrder;
            SortOrder sortOrder = esOrder = sortContainer.direction == SortDirection.ASCENDING ? SortOrder.ASC : SortOrder.DESC;
            if ("__ID__".equals(sortContainer.propertyName)) {
                q.addSort("_uid", esOrder);
                continue;
            }
            PropertyDefinition propertyDefinition = this.getSearchIndex().getPropertyDefinition(this.getGraph(), sortContainer.propertyName);
            if (propertyDefinition == null) continue;
            if (!propertyDefinition.isSortable()) {
                throw new VertexiumException("Cannot sort on non-sortable fields");
            }
            q.addSort(propertyDefinition.getPropertyName(), esOrder);
        }
    }
}

