/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheRefreshThreadPool {
    public static final int THREAD_COUNT = Runtime.getRuntime().availableProcessors() * 2;
    private static ThreadPoolExecutor executorForAll;
    private static int leasedPoolInstances;
    private static MyStatus status;
    private ThreadPoolExecutor executor;

    public static synchronized CacheRefreshThreadPool getInstance() {
        if (executorForAll == null) {
            executorForAll = new ThreadPoolExecutor(0, THREAD_COUNT, 21L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new MyThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
        }
        ++leasedPoolInstances;
        CacheRefreshThreadPool p = new CacheRefreshThreadPool();
        p.executor = executorForAll;
        return p;
    }

    static synchronized void disposeOne() {
        if (--leasedPoolInstances == 0) {
            executorForAll.shutdown();
            executorForAll = null;
        }
    }

    private CacheRefreshThreadPool() {
    }

    public boolean submit(Runnable r) {
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            return false;
        }
        return true;
    }

    public void destroy() {
        CacheRefreshThreadPool.disposeOne();
        this.executor = null;
    }

    static {
        leasedPoolInstances = 0;
    }

    static class MyStatus {
        MyStatus() {
        }

        public String toString() {
            return "CacheRefreshThreadPool(size=" + executorForAll.getPoolSize() + ", " + "sizeLargest=" + executorForAll.getLargestPoolSize() + ", " + "sizeMax=" + executorForAll.getMaximumPoolSize() + ", " + "taskCount=" + executorForAll.getTaskCount() + ")";
        }
    }

    static class MyThreadFactory
    implements ThreadFactory {
        AtomicInteger count = new AtomicInteger();

        MyThreadFactory() {
        }

        @Override
        public synchronized Thread newThread(Runnable r) {
            Thread t = new Thread(r, "cache-refresh-" + this.count.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }
}

