/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import org.vertexium.Element;
import org.vertexium.GraphConfiguration;
import org.vertexium.PropertyDefinition;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchQueryBase;
import org.vertexium.elasticsearch.ElasticSearchSearchIndexBase;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class DefaultIndexSelectionStrategy
implements IndexSelectionStrategy {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(DefaultIndexSelectionStrategy.class);
    public static final String CONFIG_INDEX_NAME = "indexName";
    public static final String DEFAULT_INDEX_NAME = "vertexium";
    private String[] indicesToQuery;

    public DefaultIndexSelectionStrategy(GraphConfiguration config) {
        this.indicesToQuery = new String[]{DefaultIndexSelectionStrategy.getDefaultIndexName(config)};
    }

    private static String getDefaultIndexName(GraphConfiguration config) {
        String defaultIndexName = config.getString("search.indexName", DEFAULT_INDEX_NAME);
        LOGGER.info("Default index name: %s", new Object[]{defaultIndexName});
        return defaultIndexName;
    }

    @Override
    public String[] getIndicesToQuery(ElasticSearchSearchIndexBase es) {
        return this.indicesToQuery;
    }

    @Override
    public String getIndexName(ElasticSearchSearchIndexBase es, Element element) {
        return this.indicesToQuery[0];
    }

    @Override
    public String[] getIndexNames(ElasticSearchSearchIndexBase es, PropertyDefinition propertyDefinition) {
        return this.indicesToQuery;
    }

    @Override
    public boolean isIncluded(ElasticSearchSearchIndexBase es, String indexName) {
        return indexName.equals(this.indicesToQuery[0]);
    }

    @Override
    public String[] getManagedIndexNames(ElasticSearchSearchIndexBase es) {
        return this.indicesToQuery;
    }

    @Override
    public String[] getIndicesToQuery(ElasticSearchQueryBase query, ElasticSearchElementType elementType) {
        return this.indicesToQuery;
    }
}

