/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStats;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.vertexium.Element;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchQueryBase;
import org.vertexium.elasticsearch.GeohashUtils;
import org.vertexium.query.AggregationResult;
import org.vertexium.query.DefaultGraphQueryIterable;
import org.vertexium.query.GeohashAggregation;
import org.vertexium.query.GeohashBucket;
import org.vertexium.query.GeohashResult;
import org.vertexium.query.HistogramAggregation;
import org.vertexium.query.HistogramBucket;
import org.vertexium.query.HistogramResult;
import org.vertexium.query.IterableWithGeohashResults;
import org.vertexium.query.IterableWithHistogramResults;
import org.vertexium.query.IterableWithScores;
import org.vertexium.query.IterableWithSearchTime;
import org.vertexium.query.IterableWithStatisticsResults;
import org.vertexium.query.IterableWithTermsResults;
import org.vertexium.query.IterableWithTotalHits;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.StatisticsAggregation;
import org.vertexium.query.StatisticsResult;
import org.vertexium.query.TermsAggregation;
import org.vertexium.query.TermsBucket;
import org.vertexium.query.TermsResult;
import org.vertexium.type.GeoRect;

public class ElasticSearchGraphQueryIterable<T extends Element>
extends DefaultGraphQueryIterable<T>
implements IterableWithTotalHits<T>,
IterableWithSearchTime<T>,
IterableWithScores<T>,
IterableWithHistogramResults<T>,
IterableWithTermsResults<T>,
IterableWithGeohashResults<T>,
IterableWithStatisticsResults<T> {
    private final long totalHits;
    private final long searchTimeInNanoSeconds;
    private final Map<String, Double> scores = new HashMap<String, Double>();
    private final Map<String, AggregationResult> aggregationResults;

    public ElasticSearchGraphQueryIterable(ElasticSearchQueryBase query, SearchResponse searchResponse, QueryParameters parameters, Iterable<T> iterable, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, long totalHits, long searchTimeInNanoSeconds, SearchHits hits) {
        super(parameters, iterable, evaluateQueryString, evaluateHasContainers, evaluateSortContainers);
        ElasticSearchQueryBase query1 = query;
        SearchResponse searchResponse1 = searchResponse;
        this.totalHits = totalHits;
        this.searchTimeInNanoSeconds = searchTimeInNanoSeconds;
        if (hits != null) {
            for (SearchHit hit : hits.getHits()) {
                this.scores.put(hit.getId(), Double.valueOf(hit.getScore()));
            }
        }
        this.aggregationResults = ElasticSearchGraphQueryIterable.getAggregationResults(query1, searchResponse1);
    }

    public long getTotalHits() {
        return this.totalHits;
    }

    public Map<String, Double> getScores() {
        return this.scores;
    }

    public long getSearchTimeNanoSeconds() {
        return this.searchTimeInNanoSeconds;
    }

    public <TResult extends AggregationResult> TResult getAggregationResult(String name, Class<? extends TResult> resultType) {
        AggregationResult result = this.aggregationResults.get(name);
        if (result == null) {
            return (TResult)AggregationResult.createEmptyResult(resultType);
        }
        if (!resultType.isInstance(result)) {
            throw new VertexiumException("Could not cast aggregation result of type " + result.getClass().getName() + " to type " + resultType.getName());
        }
        return (TResult)((AggregationResult)resultType.cast(result));
    }

    private static Map<String, AggregationResult> getAggregationResults(ElasticSearchQueryBase query, SearchResponse searchResponse) {
        if (searchResponse == null) {
            return new HashMap<String, AggregationResult>();
        }
        Map<String, List<Aggregation>> aggsByName = ElasticSearchGraphQueryIterable.getAggregationResultsByName(query, (Iterable<Aggregation>)searchResponse.getAggregations());
        return ElasticSearchGraphQueryIterable.reduceAggregationResults(query, aggsByName);
    }

    private static Map<String, List<Aggregation>> getAggregationResultsByName(ElasticSearchQueryBase query, Iterable<Aggregation> aggs) {
        HashMap<String, List<Aggregation>> aggsByName = new HashMap<String, List<Aggregation>>();
        if (aggs == null) {
            return aggsByName;
        }
        for (Aggregation agg : aggs) {
            String aggName = query.getAggregationName(agg.getName());
            ArrayList<Aggregation> l = (ArrayList<Aggregation>)aggsByName.get(aggName);
            if (l == null) {
                l = new ArrayList<Aggregation>();
                aggsByName.put(aggName, l);
            }
            l.add(agg);
        }
        return aggsByName;
    }

    private static Map<String, AggregationResult> reduceAggregationResults(ElasticSearchQueryBase query, Map<String, List<Aggregation>> aggsByName) {
        HashMap<String, AggregationResult> results = new HashMap<String, AggregationResult>();
        for (Map.Entry<String, List<Aggregation>> entry : aggsByName.entrySet()) {
            results.put(entry.getKey(), ElasticSearchGraphQueryIterable.reduceAggregationResults(query, entry.getValue()));
        }
        return results;
    }

    private static AggregationResult reduceAggregationResults(ElasticSearchQueryBase query, List<Aggregation> aggs) {
        if (aggs.size() == 0) {
            throw new VertexiumException("Cannot reduce zero sized aggregation list");
        }
        Aggregation first = aggs.get(0);
        if (first instanceof HistogramAggregation || first instanceof InternalHistogram) {
            return ElasticSearchGraphQueryIterable.reduceHistogramResults(query, aggs);
        }
        if (first instanceof TermsAggregation || first instanceof InternalTerms) {
            return ElasticSearchGraphQueryIterable.reduceTermsResults(query, aggs);
        }
        if (first instanceof GeohashAggregation || first instanceof InternalGeoHashGrid) {
            return ElasticSearchGraphQueryIterable.reduceGeohashResults(query, aggs);
        }
        if (first instanceof StatisticsAggregation || first instanceof InternalExtendedStats) {
            return ElasticSearchGraphQueryIterable.reduceStatisticsResults(aggs);
        }
        throw new VertexiumException("Unhandled aggregation type: " + first.getClass().getName());
    }

    private static HistogramResult reduceHistogramResults(ElasticSearchQueryBase query, List<Aggregation> aggs) {
        HashMap<Object, List<MultiBucketsAggregation.Bucket>> bucketsByKey = new HashMap<Object, List<MultiBucketsAggregation.Bucket>>();
        for (Aggregation agg : aggs) {
            List<Object> l;
            DateHistogram h;
            if (agg instanceof DateHistogram) {
                h = (DateHistogram)agg;
                for (DateHistogram.Bucket b : h.getBuckets()) {
                    l = (ArrayList<DateHistogram.Bucket>)bucketsByKey.get(b.getKeyAsDate().toDate());
                    if (l == null) {
                        l = new ArrayList<DateHistogram.Bucket>();
                        bucketsByKey.put(b.getKey(), l);
                    }
                    l.add(b);
                }
                continue;
            }
            if (agg instanceof Histogram) {
                h = (Histogram)agg;
                for (DateHistogram.Bucket b : h.getBuckets()) {
                    l = (List)bucketsByKey.get(b.getKey());
                    if (l == null) {
                        l = new ArrayList();
                        bucketsByKey.put(b.getKey(), l);
                    }
                    l.add(b);
                }
                continue;
            }
            throw new VertexiumException("Aggregation is not a histogram: " + agg.getClass().getName());
        }
        return (HistogramResult)new MultiBucketsAggregationReducer<HistogramResult, HistogramBucket>(){

            @Override
            protected HistogramBucket createBucket(Object key, long count, Map<String, AggregationResult> nestedResults, List<MultiBucketsAggregation.Bucket> buckets) {
                return new HistogramBucket(key, count, nestedResults);
            }

            @Override
            protected HistogramResult bucketsToResults(List<HistogramBucket> buckets) {
                return new HistogramResult(buckets);
            }
        }.reduce(query, bucketsByKey);
    }

    private static TermsResult reduceTermsResults(ElasticSearchQueryBase query, List<Aggregation> aggs) {
        HashMap<Object, List<MultiBucketsAggregation.Bucket>> bucketsByKey = new HashMap<Object, List<MultiBucketsAggregation.Bucket>>();
        for (Aggregation agg : aggs) {
            if (agg instanceof Terms) {
                Terms h = (Terms)agg;
                for (Terms.Bucket b : h.getBuckets()) {
                    String mapKey = b.getKey();
                    ArrayList<Terms.Bucket> existingBucketByName = (ArrayList<Terms.Bucket>)bucketsByKey.get(mapKey);
                    if (existingBucketByName == null) {
                        existingBucketByName = new ArrayList<Terms.Bucket>();
                        bucketsByKey.put(mapKey, existingBucketByName);
                    }
                    existingBucketByName.add(b);
                }
                continue;
            }
            throw new VertexiumException("Aggregation is not a terms: " + agg.getClass().getName());
        }
        return (TermsResult)new MultiBucketsAggregationReducer<TermsResult, TermsBucket>(){

            @Override
            protected TermsBucket createBucket(Object key, long count, Map<String, AggregationResult> nestedResults, List<MultiBucketsAggregation.Bucket> buckets) {
                return new TermsBucket(key, count, nestedResults);
            }

            @Override
            protected TermsResult bucketsToResults(List<TermsBucket> buckets) {
                return new TermsResult(buckets);
            }
        }.reduce(query, bucketsByKey);
    }

    private static GeohashResult reduceGeohashResults(ElasticSearchQueryBase query, List<Aggregation> aggs) {
        HashMap<Object, List<MultiBucketsAggregation.Bucket>> bucketsByKey = new HashMap<Object, List<MultiBucketsAggregation.Bucket>>();
        for (Aggregation agg : aggs) {
            if (agg instanceof GeoHashGrid) {
                GeoHashGrid h = (GeoHashGrid)agg;
                for (GeoHashGrid.Bucket b : h.getBuckets()) {
                    ArrayList<GeoHashGrid.Bucket> existingBucket = (ArrayList<GeoHashGrid.Bucket>)bucketsByKey.get(b.getKey());
                    if (existingBucket == null) {
                        existingBucket = new ArrayList<GeoHashGrid.Bucket>();
                        bucketsByKey.put(b.getKey(), existingBucket);
                    }
                    existingBucket.add(b);
                }
                continue;
            }
            throw new VertexiumException("Aggregation is not a geohash: " + agg.getClass().getName());
        }
        return (GeohashResult)new MultiBucketsAggregationReducer<GeohashResult, GeohashBucket>(){

            @Override
            protected GeohashBucket createBucket(final Object key, long count, Map<String, AggregationResult> nestedResults, List<MultiBucketsAggregation.Bucket> buckets) {
                org.vertexium.type.GeoPoint geoPoint = ElasticSearchGraphQueryIterable.getAverageGeoPointFromBuckets(buckets);
                return new GeohashBucket(key.toString(), count, geoPoint, nestedResults){

                    public GeoRect getGeoCell() {
                        GeoPoint northWest = new GeoPoint();
                        GeoPoint southEast = new GeoPoint();
                        GeohashUtils.decodeCell(key.toString(), northWest, southEast);
                        return new GeoRect(new org.vertexium.type.GeoPoint(northWest.getLat(), northWest.getLon()), new org.vertexium.type.GeoPoint(southEast.getLat(), southEast.getLon()));
                    }
                };
            }

            @Override
            protected GeohashResult bucketsToResults(List<GeohashBucket> buckets) {
                return new GeohashResult(buckets);
            }
        }.reduce(query, bucketsByKey);
    }

    private static org.vertexium.type.GeoPoint getAverageGeoPointFromBuckets(List<MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<org.vertexium.type.GeoPoint> geoPoints = new ArrayList<org.vertexium.type.GeoPoint>();
        for (MultiBucketsAggregation.Bucket b : buckets) {
            GeoHashGrid.Bucket gb = (GeoHashGrid.Bucket)b;
            GeoPoint gp = gb.getKeyAsGeoPoint();
            geoPoints.add(new org.vertexium.type.GeoPoint(gp.getLat(), gp.getLon()));
        }
        return org.vertexium.type.GeoPoint.calculateCenter(geoPoints);
    }

    private static StatisticsResult reduceStatisticsResults(List<Aggregation> aggs) {
        ArrayList<StatisticsResult> results = new ArrayList<StatisticsResult>();
        for (Aggregation agg : aggs) {
            if (agg instanceof ExtendedStats) {
                ExtendedStats extendedStats = (ExtendedStats)agg;
                long count = extendedStats.getCount();
                double sum = extendedStats.getSum();
                double min = extendedStats.getMin();
                double max = extendedStats.getMax();
                double standardDeviation = extendedStats.getStdDeviation();
                results.add(new StatisticsResult(count, sum, min, max, standardDeviation));
                continue;
            }
            throw new VertexiumException("Aggregation is not a statistics: " + agg.getClass().getName());
        }
        return StatisticsResult.combine(results);
    }

    public GeohashResult getGeohashResults(String name) {
        return this.getAggregationResult(name, GeohashResult.class);
    }

    public HistogramResult getHistogramResults(String name) {
        return this.getAggregationResult(name, HistogramResult.class);
    }

    public StatisticsResult getStatisticsResults(String name) {
        return this.getAggregationResult(name, StatisticsResult.class);
    }

    public TermsResult getTermsResults(String name) {
        return this.getAggregationResult(name, TermsResult.class);
    }

    private static abstract class MultiBucketsAggregationReducer<TResult, TBucket> {
        private MultiBucketsAggregationReducer() {
        }

        public TResult reduce(ElasticSearchQueryBase query, Map<Object, List<MultiBucketsAggregation.Bucket>> bucketsByKey) {
            ArrayList<TBucket> buckets = new ArrayList<TBucket>();
            for (Map.Entry<Object, List<MultiBucketsAggregation.Bucket>> bucketsByKeyEntry : bucketsByKey.entrySet()) {
                Object key = bucketsByKeyEntry.getKey();
                long count = 0L;
                ArrayList<Aggregation> subAggs = new ArrayList<Aggregation>();
                for (MultiBucketsAggregation.Bucket b : bucketsByKeyEntry.getValue()) {
                    count += b.getDocCount();
                    for (Aggregation subAgg : b.getAggregations()) {
                        subAggs.add(subAgg);
                    }
                }
                Map nestedResults = ElasticSearchGraphQueryIterable.reduceAggregationResults(query, ElasticSearchGraphQueryIterable.getAggregationResultsByName(query, subAggs));
                buckets.add(this.createBucket(key, count, nestedResults, bucketsByKeyEntry.getValue()));
            }
            return this.bucketsToResults(buckets);
        }

        protected abstract TBucket createBucket(Object var1, long var2, Map<String, AggregationResult> var4, List<MultiBucketsAggregation.Bucket> var5);

        protected abstract TResult bucketsToResults(List<TBucket> var1);
    }
}

