/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.vertexium.Authorizations;
import org.vertexium.DateOnly;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.GraphConfiguration;
import org.vertexium.Property;
import org.vertexium.PropertyDefinition;
import org.vertexium.SearchIndexSecurityGranularity;
import org.vertexium.TextIndexHint;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.elasticsearch.ElasticSearchSearchIndexConfiguration;
import org.vertexium.elasticsearch.IndexInfo;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.id.NameSubstitutionStrategy;
import org.vertexium.property.StreamingPropertyValue;
import org.vertexium.query.DefaultMultiVertexQuery;
import org.vertexium.query.GraphQuery;
import org.vertexium.query.MultiVertexQuery;
import org.vertexium.query.SimilarToGraphQuery;
import org.vertexium.query.VertexQuery;
import org.vertexium.search.SearchIndex;
import org.vertexium.search.SearchIndexWithVertexPropertyCountByValue;
import org.vertexium.type.GeoCircle;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.IpV4Address;
import org.vertexium.util.Preconditions;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public abstract class ElasticSearchSearchIndexBase
implements SearchIndex,
SearchIndexWithVertexPropertyCountByValue {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ElasticSearchSearchIndexBase.class);
    protected static final VertexiumLogger MUTATION_LOGGER = VertexiumLoggerFactory.getMutationLogger(SearchIndex.class);
    public static final String ELEMENT_TYPE = "element";
    public static final String ELEMENT_TYPE_FIELD_NAME = "__elementType";
    public static final String VISIBILITY_FIELD_NAME = "__visibility";
    public static final String OUT_VERTEX_ID_FIELD_NAME = "__outVertexId";
    public static final String IN_VERTEX_ID_FIELD_NAME = "__inVertexId";
    public static final String EDGE_LABEL_FIELD_NAME = "__edgeLabel";
    public static final String EXACT_MATCH_PROPERTY_NAME_SUFFIX = "_e";
    public static final String GEO_PROPERTY_NAME_SUFFIX = "_g";
    public static final int MAX_BATCH_COUNT = 25000;
    public static final long MAX_BATCH_SIZE = 0xF00000L;
    public static final int EXACT_MATCH_IGNORE_ABOVE_LIMIT = 10000;
    private static final long IN_PROCESS_NODE_WAIT_TIME_MS = 600000L;
    private final Client client;
    private final ElasticSearchSearchIndexConfiguration config;
    private final Map<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
    private int indexInfosLastSize = 0;
    private String[] indexNamesAsArray;
    private NameSubstitutionStrategy nameSubstitutionStrategy;
    private IndexSelectionStrategy indexSelectionStrategy;
    private boolean allFieldEnabled;
    private Node inProcessNode;

    protected ElasticSearchSearchIndexBase(Graph graph, GraphConfiguration config) {
        this.config = new ElasticSearchSearchIndexConfiguration(graph, config);
        this.nameSubstitutionStrategy = this.config.getNameSubstitutionStrategy();
        this.indexSelectionStrategy = this.config.getIndexSelectionStrategy();
        this.allFieldEnabled = this.config.isAllFieldEnabled(this.getDefaultAllFieldEnabled());
        this.client = this.createClient(this.config);
        this.loadIndexInfos();
    }

    protected Client createClient(ElasticSearchSearchIndexConfiguration config) {
        if (config.isInProcessNode()) {
            return this.createInProcessNode(config);
        }
        return ElasticSearchSearchIndexBase.createTransportClient(config);
    }

    private Client createInProcessNode(ElasticSearchSearchIndexConfiguration config) {
        String dataPath = config.getInProcessNodeDataPath();
        Preconditions.checkNotNull((Object)dataPath, (Object)"inProcessNode.dataPath is required for in process Elasticsearch node");
        String logsPath = config.getInProcessNodeLogsPath();
        Preconditions.checkNotNull((Object)logsPath, (Object)"inProcessNode.logsPath is required for in process Elasticsearch node");
        String workPath = config.getInProcessNodeWorkPath();
        Preconditions.checkNotNull((Object)workPath, (Object)"inProcessNode.workPath is required for in process Elasticsearch node");
        int numberOfShards = config.getNumberOfShards();
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder();
        if (config.getClusterName() != null) {
            nodeBuilder = nodeBuilder.clusterName(config.getClusterName());
        }
        this.inProcessNode = nodeBuilder.local(false).settings((Settings.Builder)ImmutableSettings.settingsBuilder().put("script.disable_dynamic", "false").put("gateway.type", "local").put("index.number_of_shards", numberOfShards).put("index.number_of_replicas", "0").put("path.data", dataPath).put("path.logs", logsPath).put("path.work", workPath)).node();
        this.inProcessNode.start();
        Client client = this.inProcessNode.client();
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() > startTime + 600000L) {
                throw new VertexiumException("Status failed to exit red status after waiting 600000ms. Giving up.");
            }
            ClusterHealthResponse health = (ClusterHealthResponse)client.admin().cluster().prepareHealth(new String[0]).get();
            if (health.getStatus() != ClusterHealthStatus.RED) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new VertexiumException("Could not sleep", (Throwable)e);
            }
            LOGGER.info("Status is %s, waiting...", new Object[]{health.getStatus()});
        }
        return client;
    }

    private static TransportClient createTransportClient(ElasticSearchSearchIndexConfiguration config) {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder();
        if (config.getClusterName() != null) {
            settingsBuilder.put("cluster.name", config.getClusterName());
        }
        TransportClient transportClient = new TransportClient(settingsBuilder.build());
        for (String esLocation : config.getEsLocations()) {
            int port;
            String hostname;
            String[] locationSocket = esLocation.split(":");
            if (locationSocket.length == 2) {
                hostname = locationSocket[0];
                port = Integer.parseInt(locationSocket[1]);
            } else if (locationSocket.length == 1) {
                hostname = locationSocket[0];
                port = config.getPort();
            } else {
                throw new VertexiumException("Invalid elastic search location: " + esLocation);
            }
            transportClient.addTransportAddress((TransportAddress)new InetSocketTransportAddress(hostname, port));
        }
        return transportClient;
    }

    protected boolean getDefaultAllFieldEnabled() {
        return true;
    }

    protected boolean isStoreSourceData() {
        return this.getConfig().isStoreSourceData();
    }

    protected final boolean isAllFieldEnabled() {
        return this.allFieldEnabled;
    }

    protected void loadIndexInfos() {
        Map<String, IndexStats> indices = this.getExistingIndexNames();
        for (String indexName : indices.keySet()) {
            if (!this.indexSelectionStrategy.isIncluded(this, indexName)) {
                LOGGER.debug("skipping index %s, not in indicesToQuery", new Object[]{indexName});
                continue;
            }
            IndexInfo indexInfo = this.indexInfos.get(indexName);
            if (indexInfo != null) continue;
            LOGGER.debug("loading index info for %s", new Object[]{indexName});
            indexInfo = this.createIndexInfo(indexName);
            indexInfo.addPropertyDefinition(ELEMENT_TYPE_FIELD_NAME, new PropertyDefinition(ELEMENT_TYPE_FIELD_NAME, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH)));
            indexInfo.addPropertyDefinition(VISIBILITY_FIELD_NAME, new PropertyDefinition(VISIBILITY_FIELD_NAME, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH)));
            indexInfo.addPropertyDefinition(OUT_VERTEX_ID_FIELD_NAME, new PropertyDefinition(OUT_VERTEX_ID_FIELD_NAME, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH)));
            indexInfo.addPropertyDefinition(IN_VERTEX_ID_FIELD_NAME, new PropertyDefinition(IN_VERTEX_ID_FIELD_NAME, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH)));
            indexInfo.addPropertyDefinition(EDGE_LABEL_FIELD_NAME, new PropertyDefinition(EDGE_LABEL_FIELD_NAME, String.class, EnumSet.of(TextIndexHint.EXACT_MATCH)));
            this.indexInfos.put(indexName, indexInfo);
        }
    }

    private Map<String, IndexStats> getExistingIndexNames() {
        return ((IndicesStatsResponse)this.client.admin().indices().prepareStats(new String[0]).execute().actionGet()).getIndices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexInfo ensureIndexCreatedAndInitialized(String indexName, boolean storeSourceData) {
        IndexInfo indexInfo = this.indexInfos.get(indexName);
        if (indexInfo != null && indexInfo.isElementTypeDefined()) {
            return indexInfo;
        }
        Map<String, IndexInfo> map = this.indexInfos;
        synchronized (map) {
            if (indexInfo == null) {
                if (!((IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{indexName}).execute().actionGet()).isExists()) {
                    try {
                        this.createIndex(indexName, storeSourceData);
                    }
                    catch (IOException e) {
                        throw new VertexiumException("Could not create index: " + indexName, (Throwable)e);
                    }
                }
                indexInfo = this.createIndexInfo(indexName);
                this.indexInfos.put(indexName, indexInfo);
            }
            this.ensureMappingsCreated(indexInfo);
            return indexInfo;
        }
    }

    protected IndexInfo createIndexInfo(String indexName) {
        return new IndexInfo(indexName);
    }

    protected void ensureMappingsCreated(IndexInfo indexInfo) {
        if (!indexInfo.isElementTypeDefined()) {
            try {
                XContentBuilder mappingBuilder = XContentFactory.jsonBuilder().startObject().startObject("_source").field("enabled", this.isStoreSourceData()).endObject().startObject("_all").field("enabled", this.isAllFieldEnabled()).endObject().startObject("properties");
                this.createIndexAddFieldsToElementType(mappingBuilder);
                XContentBuilder mapping = mappingBuilder.endObject().endObject();
                this.client.admin().indices().preparePutMapping(new String[]{indexInfo.getIndexName()}).setType(ELEMENT_TYPE).setSource(mapping).execute().actionGet();
                indexInfo.setElementTypeDefined(true);
            }
            catch (Throwable e) {
                throw new VertexiumException("Could not add mappings to index: " + indexInfo.getIndexName(), e);
            }
        }
    }

    protected void createIndex(String indexName, boolean storeSourceData) throws IOException {
        int shards = this.getConfig().getNumberOfShards();
        CreateIndexResponse createResponse = (CreateIndexResponse)this.client.admin().indices().prepareCreate(indexName).setSettings((Settings.Builder)ImmutableSettings.settingsBuilder().put("number_of_shards", shards)).execute().actionGet();
        ClusterHealthResponse health = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[]{indexName}).setWaitForGreenStatus().execute().actionGet();
        LOGGER.debug("Index status: %s", new Object[]{health.toString()});
        if (health.isTimedOut()) {
            LOGGER.warn("timed out waiting for green index status, for index: %s", new Object[]{indexName});
        }
    }

    protected void createIndexAddFieldsToElementType(XContentBuilder builder) throws IOException {
        builder.startObject(ELEMENT_TYPE_FIELD_NAME).field("type", "string").field("store", "true").endObject().startObject(VISIBILITY_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject().startObject(IN_VERTEX_ID_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject().startObject(OUT_VERTEX_ID_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject().startObject(EDGE_LABEL_FIELD_NAME).field("type", "string").field("analyzer", "keyword").field("index", "not_analyzed").field("store", "true").endObject();
        this.getConfig().getScoringStrategy().addFieldsToElementType(builder);
    }

    public abstract void addElement(Graph var1, Element var2, Authorizations var3);

    public abstract void deleteElement(Graph var1, Element var2, Authorizations var3);

    public void deleteProperty(Graph graph, Element element, Property property, Authorizations authorizations) {
        this.deleteProperty(graph, element, property.getKey(), this.deflatePropertyName(graph, property), property.getVisibility(), authorizations);
    }

    public void deleteProperty(Graph graph, Element element, String propertyKey, String propertyName, Visibility propertyVisibility, Authorizations authorizations) {
        this.addElement(graph, element, authorizations);
    }

    public void addElements(Graph graph, Iterable<? extends Element> elements, Authorizations authorizations) {
        int totalCount = 0;
        HashMap<IndexInfo, BulkRequest> bulkRequests = new HashMap<IndexInfo, BulkRequest>();
        for (Element element : elements) {
            IndexInfo indexInfo = this.addPropertiesToIndex(graph, element, element.getProperties());
            BulkRequest bulkRequest = (BulkRequest)bulkRequests.get(indexInfo);
            if (bulkRequest == null) {
                bulkRequest = new BulkRequest();
                bulkRequests.put(indexInfo, bulkRequest);
            }
            if (bulkRequest.numberOfActions() >= 25000 || bulkRequest.estimatedSizeInBytes() > 0xF00000L) {
                LOGGER.debug("adding elements... %d (est size %d)", new Object[]{bulkRequest.numberOfActions(), bulkRequest.estimatedSizeInBytes()});
                totalCount += bulkRequest.numberOfActions();
                this.doBulkRequest(bulkRequest);
                bulkRequest = new BulkRequest();
                bulkRequests.put(indexInfo, bulkRequest);
            }
            this.addElementToBulkRequest(graph, bulkRequest, indexInfo, element, authorizations);
            this.getConfig().getScoringStrategy().addElement(this, graph, bulkRequest, indexInfo, element, authorizations);
        }
        for (BulkRequest bulkRequest : bulkRequests.values()) {
            if (bulkRequest.numberOfActions() <= 0) continue;
            LOGGER.debug("adding elements... %d (est size %d)", new Object[]{bulkRequest.numberOfActions(), bulkRequest.estimatedSizeInBytes()});
            totalCount += bulkRequest.numberOfActions();
            this.doBulkRequest(bulkRequest);
        }
        LOGGER.debug("added %d elements", new Object[]{totalCount});
        if (this.getConfig().isAutoFlush()) {
            this.flush();
        }
    }

    public abstract SearchIndexSecurityGranularity getSearchIndexSecurityGranularity();

    public abstract GraphQuery queryGraph(Graph var1, String var2, Authorizations var3);

    public MultiVertexQuery queryGraph(Graph graph, String[] vertexIds, String queryString, Authorizations authorizations) {
        return new DefaultMultiVertexQuery(graph, vertexIds, queryString, this.getAllPropertyDefinitions(), authorizations);
    }

    public abstract VertexQuery queryVertex(Graph var1, Vertex var2, String var3, Authorizations var4);

    public boolean isQuerySimilarToTextSupported() {
        return true;
    }

    public abstract SimilarToGraphQuery querySimilarTo(Graph var1, String[] var2, String var3, Authorizations var4);

    public Map<String, PropertyDefinition> getAllPropertyDefinitions() {
        HashMap<String, PropertyDefinition> allPropertyDefinitions = new HashMap<String, PropertyDefinition>();
        for (IndexInfo indexInfo : this.indexInfos.values()) {
            allPropertyDefinitions.putAll(indexInfo.getPropertyDefinitions());
        }
        return allPropertyDefinitions;
    }

    public void flush() {
        this.client.admin().indices().prepareRefresh(this.getIndexNamesAsArray()).execute().actionGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] getIndexNamesAsArray() {
        if (this.indexInfos.size() == this.indexInfosLastSize) {
            return this.indexNamesAsArray;
        }
        ElasticSearchSearchIndexBase elasticSearchSearchIndexBase = this;
        synchronized (elasticSearchSearchIndexBase) {
            Set<String> keys = this.indexInfos.keySet();
            this.indexNamesAsArray = keys.toArray(new String[keys.size()]);
            this.indexInfosLastSize = this.indexInfos.size();
            return this.indexNamesAsArray;
        }
    }

    public void shutdown() {
        this.client.close();
        if (this.inProcessNode != null) {
            this.inProcessNode.stop();
            this.inProcessNode = null;
        }
    }

    public void addPropertyDefinition(Graph graph, PropertyDefinition propertyDefinition) throws IOException {
        LOGGER.debug("adding property definition: %s", new Object[]{propertyDefinition.toString()});
        String propertyName = this.deflatePropertyName(propertyDefinition);
        for (String indexName : this.getIndexNames(propertyDefinition)) {
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.isStoreSourceData());
            if (!this.addPropertyDefinitionToIndex(graph, indexInfo, propertyName, propertyDefinition)) continue;
            indexInfo.addPropertyDefinition(propertyName, propertyDefinition);
        }
    }

    public boolean isPropertyDefined(String propertyName) {
        for (String indexName : this.getIndexNamesAsArray()) {
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.isStoreSourceData());
            if (!indexInfo.isPropertyDefined(propertyName)) continue;
            return true;
        }
        return false;
    }

    protected boolean addPropertyDefinitionToIndex(Graph graph, IndexInfo indexInfo, String propertyName, PropertyDefinition propertyDefinition) throws IOException {
        if (propertyDefinition.getDataType() == String.class) {
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH)) {
                this.addPropertyToIndex(graph, indexInfo, propertyName + EXACT_MATCH_PROPERTY_NAME_SUFFIX, String.class, false, propertyDefinition.getBoost(), propertyDefinition.isSortable());
            }
            if (propertyDefinition.getTextIndexHints().contains(TextIndexHint.FULL_TEXT)) {
                this.addPropertyToIndex(graph, indexInfo, propertyName, String.class, true, propertyDefinition.getBoost(), propertyDefinition.isSortable());
            }
            return true;
        }
        if (propertyDefinition.getDataType() == GeoPoint.class || propertyDefinition.getDataType() == GeoCircle.class) {
            this.addPropertyToIndex(graph, indexInfo, propertyName + GEO_PROPERTY_NAME_SUFFIX, propertyDefinition.getDataType(), true, propertyDefinition.getBoost(), propertyDefinition.isSortable());
            this.addPropertyToIndex(graph, indexInfo, propertyName, String.class, true, propertyDefinition.getBoost(), propertyDefinition.isSortable());
            return true;
        }
        this.addPropertyToIndex(graph, indexInfo, propertyDefinition);
        return true;
    }

    protected String[] getIndexNames(PropertyDefinition propertyDefinition) {
        return this.indexSelectionStrategy.getIndexNames(this, propertyDefinition);
    }

    protected String getIndexName(Element element) {
        return this.indexSelectionStrategy.getIndexName(this, element);
    }

    protected String[] getIndicesToQuery() {
        return this.indexSelectionStrategy.getIndicesToQuery(this);
    }

    public boolean isFieldBoostSupported() {
        return true;
    }

    public IndexInfo addPropertiesToIndex(Graph graph, Element element, Iterable<Property> properties) {
        try {
            String indexName = this.getIndexName(element);
            IndexInfo indexInfo = this.ensureIndexCreatedAndInitialized(indexName, this.isStoreSourceData());
            for (Property property : properties) {
                this.addPropertyToIndex(graph, indexInfo, property);
            }
            return indexInfo;
        }
        catch (IOException e) {
            throw new VertexiumException("Could not add properties to index", (Throwable)e);
        }
    }

    protected void addPropertyToIndex(Graph graph, IndexInfo indexInfo, String propertyName, Class dataType, boolean analyzed, boolean sortable) throws IOException {
        this.addPropertyToIndex(graph, indexInfo, propertyName, dataType, analyzed, null, sortable);
    }

    private void addPropertyToIndex(Graph graph, IndexInfo indexInfo, PropertyDefinition propertyDefinition) throws IOException {
        this.addPropertyToIndex(graph, indexInfo, this.deflatePropertyName(propertyDefinition), propertyDefinition.getDataType(), true, propertyDefinition.getBoost(), propertyDefinition.isSortable());
    }

    public void addPropertyToIndex(Graph graph, IndexInfo indexInfo, Property property) throws IOException {
        String deflatedPropertyName = this.deflatePropertyName(graph, property);
        if (indexInfo.isPropertyDefined(deflatedPropertyName)) {
            return;
        }
        Object propertyValue = property.getValue();
        if (propertyValue instanceof StreamingPropertyValue) {
            StreamingPropertyValue streamingPropertyValue = (StreamingPropertyValue)propertyValue;
            if (!streamingPropertyValue.isSearchIndex()) {
                return;
            }
            Class dataType = streamingPropertyValue.getValueType();
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, dataType, true, false);
        } else if (propertyValue instanceof String) {
            Class<String> dataType = String.class;
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName + EXACT_MATCH_PROPERTY_NAME_SUFFIX, dataType, false, false);
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, dataType, true, false);
        } else if (propertyValue instanceof GeoPoint) {
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName + GEO_PROPERTY_NAME_SUFFIX, GeoPoint.class, true, false);
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, String.class, true, false);
        } else if (propertyValue instanceof GeoCircle) {
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName + GEO_PROPERTY_NAME_SUFFIX, GeoCircle.class, true, false);
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, String.class, true, false);
        } else {
            Preconditions.checkNotNull((Object)propertyValue, (Object)("property value cannot be null for property: " + deflatedPropertyName));
            Class<?> dataType = propertyValue.getClass();
            this.addPropertyToIndex(graph, indexInfo, deflatedPropertyName, dataType, true, true);
        }
    }

    protected String inflatePropertyName(String string) {
        return this.nameSubstitutionStrategy.inflate(string);
    }

    protected String deflatePropertyName(Graph graph, Property property) {
        return this.deflatePropertyName(property.getName());
    }

    protected String deflatePropertyName(PropertyDefinition propertyDefinition) {
        return this.deflatePropertyName(propertyDefinition.getPropertyName());
    }

    protected String deflatePropertyName(String propertyName) {
        return this.nameSubstitutionStrategy.deflate(propertyName);
    }

    public String[] getAllMatchingPropertyNames(Graph graph, String propertyName, Authorizations authorizations) {
        return new String[]{this.nameSubstitutionStrategy.deflate(propertyName)};
    }

    protected abstract void addPropertyToIndex(Graph var1, IndexInfo var2, String var3, Class var4, boolean var5, Double var6, boolean var7) throws IOException;

    protected boolean shouldIgnoreType(Class dataType) {
        return dataType == byte[].class;
    }

    public Client getClient() {
        return this.client;
    }

    public ElasticSearchSearchIndexConfiguration getConfig() {
        return this.config;
    }

    protected void addTypeToMapping(XContentBuilder mapping, String propertyName, Class dataType, boolean analyzed, Double boost) throws IOException {
        if (dataType == String.class) {
            LOGGER.debug("Registering string type for %s", new Object[]{propertyName});
            mapping.field("type", "string");
            if (!analyzed) {
                mapping.field("index", "not_analyzed");
                mapping.field("ignore_above", 10000);
            }
        } else if (dataType == IpV4Address.class) {
            LOGGER.debug("Registering IP type for %s", new Object[]{propertyName});
            mapping.field("type", "ip");
        } else if (dataType == Float.class) {
            LOGGER.debug("Registering float type for %s", new Object[]{propertyName});
            mapping.field("type", "float");
        } else if (dataType == Double.class) {
            LOGGER.debug("Registering double type for %s", new Object[]{propertyName});
            mapping.field("type", "double");
        } else if (dataType == Byte.class) {
            LOGGER.debug("Registering byte type for %s", new Object[]{propertyName});
            mapping.field("type", "byte");
        } else if (dataType == Short.class) {
            LOGGER.debug("Registering short type for %s", new Object[]{propertyName});
            mapping.field("type", "short");
        } else if (dataType == Integer.class) {
            LOGGER.debug("Registering integer type for %s", new Object[]{propertyName});
            mapping.field("type", "integer");
        } else if (dataType == Date.class || dataType == DateOnly.class) {
            LOGGER.debug("Registering date type for %s", new Object[]{propertyName});
            mapping.field("type", "date");
        } else if (dataType == Long.class) {
            LOGGER.debug("Registering long type for %s", new Object[]{propertyName});
            mapping.field("type", "long");
        } else if (dataType == Boolean.class) {
            LOGGER.debug("Registering boolean type for %s", new Object[]{propertyName});
            mapping.field("type", "boolean");
        } else if (dataType == GeoPoint.class) {
            LOGGER.debug("Registering geo_point type for %s", new Object[]{propertyName});
            mapping.field("type", "geo_point");
        } else if (dataType == GeoCircle.class) {
            LOGGER.debug("Registering geo_shape type for %s", new Object[]{propertyName});
            mapping.field("type", "geo_shape");
            mapping.field("tree", "quadtree");
            mapping.field("precision", "100m");
        } else if (Number.class.isAssignableFrom(dataType)) {
            LOGGER.debug("Registering double type for %s", new Object[]{propertyName});
            mapping.field("type", "double");
        } else {
            throw new VertexiumException("Unexpected value type for property \"" + propertyName + "\": " + dataType.getName());
        }
        if (boost != null) {
            mapping.field("boost", boost.doubleValue());
        }
    }

    protected void doBulkRequest(BulkRequest bulkRequest) {
        BulkResponse response = (BulkResponse)this.getClient().bulk(bulkRequest).actionGet();
        if (response.hasFailures()) {
            for (BulkItemResponse bulkResponse : response) {
                if (!bulkResponse.isFailed()) continue;
                LOGGER.error("Failed to index %s (message: %s)", new Object[]{bulkResponse.getId(), bulkResponse.getFailureMessage()});
            }
            throw new VertexiumException("Could not add element.");
        }
    }

    public synchronized void truncate() {
        LOGGER.warn("Truncate of Elasticsearch is not possible, dropping the indices and recreating instead.", new Object[0]);
        this.drop();
    }

    public void drop() {
        Set<String> indexInfosSet = this.indexInfos.keySet();
        for (String indexName : indexInfosSet) {
            try {
                DeleteIndexRequest deleteRequest = new DeleteIndexRequest(indexName);
                this.getClient().admin().indices().delete(deleteRequest).actionGet();
                this.indexInfos.remove(indexName);
            }
            catch (Exception ex) {
                throw new VertexiumException("Could not delete index " + indexName, (Throwable)ex);
            }
            this.ensureIndexCreatedAndInitialized(indexName, this.isStoreSourceData());
        }
    }

    public abstract void addElementToBulkRequest(Graph var1, BulkRequest var2, IndexInfo var3, Element var4, Authorizations var5);

    protected void addPropertyValueToPropertiesMap(Map<String, Object> propertiesMap, String propertyName, Object propertyValue) {
        Object existingValue = propertiesMap.get(propertyName);
        if (existingValue == null) {
            propertiesMap.put(propertyName, propertyValue);
            return;
        }
        if (existingValue instanceof List) {
            ((List)existingValue).add(propertyValue);
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(existingValue);
        list.add(propertyValue);
        propertiesMap.put(propertyName, list);
    }

    protected void convertGeoPoint(Graph graph, XContentBuilder jsonBuilder, Property property, GeoPoint geoPoint) throws IOException {
        HashMap<String, Double> propertyValueMap = new HashMap<String, Double>();
        propertyValueMap.put("lat", geoPoint.getLatitude());
        propertyValueMap.put("lon", geoPoint.getLongitude());
        jsonBuilder.field(this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoPoint.getDescription() != null) {
            jsonBuilder.field(this.deflatePropertyName(graph, property), geoPoint.getDescription());
        }
    }

    protected void convertGeoPoint(Graph graph, Map<String, Object> propertiesMap, Property property, GeoPoint geoPoint) throws IOException {
        HashMap<String, Double> propertyValueMap = new HashMap<String, Double>();
        propertyValueMap.put("lat", geoPoint.getLatitude());
        propertyValueMap.put("lon", geoPoint.getLongitude());
        this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoPoint.getDescription() != null) {
            this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property), geoPoint.getDescription());
        }
    }

    protected void convertGeoCircle(Graph graph, XContentBuilder jsonBuilder, Property property, GeoCircle geoCircle) throws IOException {
        HashMap<String, Object> propertyValueMap = new HashMap<String, Object>();
        propertyValueMap.put("type", "circle");
        ArrayList<Double> coordinates = new ArrayList<Double>();
        coordinates.add(geoCircle.getLongitude());
        coordinates.add(geoCircle.getLatitude());
        propertyValueMap.put("coordinates", coordinates);
        propertyValueMap.put("radius", geoCircle.getRadius() + "km");
        jsonBuilder.field(this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoCircle.getDescription() != null) {
            jsonBuilder.field(this.deflatePropertyName(graph, property), geoCircle.getDescription());
        }
    }

    protected void convertGeoCircle(Graph graph, Map<String, Object> propertiesMap, Property property, GeoCircle geoCircle) throws IOException {
        HashMap<String, Object> propertyValueMap = new HashMap<String, Object>();
        propertyValueMap.put("type", "circle");
        ArrayList<Double> coordinates = new ArrayList<Double>();
        coordinates.add(geoCircle.getLongitude());
        coordinates.add(geoCircle.getLatitude());
        propertyValueMap.put("coordinates", coordinates);
        propertyValueMap.put("radius", geoCircle.getRadius() + "km");
        this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property) + GEO_PROPERTY_NAME_SUFFIX, propertyValueMap);
        if (geoCircle.getDescription() != null) {
            this.addPropertyValueToPropertiesMap(propertiesMap, this.deflatePropertyName(graph, property), geoCircle.getDescription());
        }
    }

    public IndexSelectionStrategy getIndexSelectionStrategy() {
        return this.indexSelectionStrategy;
    }

    public String getPropertyVisibilityHashFromDeflatedPropertyName(String propertyName) {
        return "";
    }

    public String getAggregationName(String name) {
        return name;
    }

    public boolean isAuthorizationFilterEnabled() {
        return this.getConfig().isAuthorizationFilterEnabled();
    }

    public PropertyDefinition getPropertyDefinition(Graph graph, String propertyName) {
        return this.getAllPropertyDefinitions().get(propertyName);
    }

    protected boolean isReservedFieldName(String fieldName) {
        return fieldName.equals(ELEMENT_TYPE_FIELD_NAME) || fieldName.equals(VISIBILITY_FIELD_NAME);
    }
}

