/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.analysis.BinaryFunction;
import org.apache.commons.math.analysis.BivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;

public abstract class ComposableFunction
implements UnivariateRealFunction {
    public static final ComposableFunction ZERO = new ComposableFunction(){

        public double value(double d) {
            return 0.0;
        }
    };
    public static final ComposableFunction ONE = new ComposableFunction(){

        public double value(double d) {
            return 1.0;
        }
    };
    public static final ComposableFunction IDENTITY = new ComposableFunction(){

        public double value(double d) {
            return d;
        }
    };
    public static final ComposableFunction ABS = new ComposableFunction(){

        public double value(double d) {
            return Math.abs(d);
        }
    };
    public static final ComposableFunction NEGATE = new ComposableFunction(){

        public double value(double d) {
            return -d;
        }
    };
    public static final ComposableFunction INVERT = new ComposableFunction(){

        public double value(double d) {
            return 1.0 / d;
        }
    };
    public static final ComposableFunction SIN = new ComposableFunction(){

        public double value(double d) {
            return Math.sin(d);
        }
    };
    public static final ComposableFunction SQRT = new ComposableFunction(){

        public double value(double d) {
            return Math.sqrt(d);
        }
    };
    public static final ComposableFunction SINH = new ComposableFunction(){

        public double value(double d) {
            return Math.sinh(d);
        }
    };
    public static final ComposableFunction EXP = new ComposableFunction(){

        public double value(double d) {
            return Math.exp(d);
        }
    };
    public static final ComposableFunction EXPM1 = new ComposableFunction(){

        public double value(double d) {
            return Math.expm1(d);
        }
    };
    public static final ComposableFunction ASIN = new ComposableFunction(){

        public double value(double d) {
            return Math.asin(d);
        }
    };
    public static final ComposableFunction ATAN = new ComposableFunction(){

        public double value(double d) {
            return Math.atan(d);
        }
    };
    public static final ComposableFunction TAN = new ComposableFunction(){

        public double value(double d) {
            return Math.tan(d);
        }
    };
    public static final ComposableFunction TANH = new ComposableFunction(){

        public double value(double d) {
            return Math.tanh(d);
        }
    };
    public static final ComposableFunction CBRT = new ComposableFunction(){

        public double value(double d) {
            return Math.cbrt(d);
        }
    };
    public static final ComposableFunction CEIL = new ComposableFunction(){

        public double value(double d) {
            return Math.ceil(d);
        }
    };
    public static final ComposableFunction FLOOR = new ComposableFunction(){

        public double value(double d) {
            return Math.floor(d);
        }
    };
    public static final ComposableFunction LOG = new ComposableFunction(){

        public double value(double d) {
            return Math.log(d);
        }
    };
    public static final ComposableFunction LOG10 = new ComposableFunction(){

        public double value(double d) {
            return Math.log10(d);
        }
    };
    public static final ComposableFunction LOG1P = new ComposableFunction(){

        public double value(double d) {
            return Math.log1p(d);
        }
    };
    public static final ComposableFunction COS = new ComposableFunction(){

        public double value(double d) {
            return Math.cos(d);
        }
    };
    public static final ComposableFunction ACOS = new ComposableFunction(){

        public double value(double d) {
            return Math.acos(d);
        }
    };
    public static final ComposableFunction COSH = new ComposableFunction(){

        public double value(double d) {
            return Math.cosh(d);
        }
    };
    public static final ComposableFunction RINT = new ComposableFunction(){

        public double value(double d) {
            return Math.rint(d);
        }
    };
    public static final ComposableFunction SIGNUM = new ComposableFunction(){

        public double value(double d) {
            return Math.signum(d);
        }
    };
    public static final ComposableFunction ULP = new ComposableFunction(){

        public double value(double d) {
            return Math.ulp(d);
        }
    };

    public ComposableFunction of(final UnivariateRealFunction f) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return ComposableFunction.this.value(f.value(x));
            }
        };
    }

    public ComposableFunction postCompose(final UnivariateRealFunction f) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return f.value(ComposableFunction.this.value(x));
            }
        };
    }

    public ComposableFunction combine(final UnivariateRealFunction f, final BivariateRealFunction combiner) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return combiner.value(ComposableFunction.this.value(x), f.value(x));
            }
        };
    }

    public ComposableFunction add(final UnivariateRealFunction f) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x) + f.value(x);
            }
        };
    }

    public ComposableFunction add(final double a) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x) + a;
            }
        };
    }

    public ComposableFunction subtract(final UnivariateRealFunction f) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x) - f.value(x);
            }
        };
    }

    public ComposableFunction multiply(final UnivariateRealFunction f) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x) * f.value(x);
            }
        };
    }

    public ComposableFunction multiply(final double scaleFactor) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x) * scaleFactor;
            }
        };
    }

    public ComposableFunction divide(final UnivariateRealFunction f) {
        return new ComposableFunction(){

            public double value(double x) throws FunctionEvaluationException {
                return ComposableFunction.this.value(x) / f.value(x);
            }
        };
    }

    public MultivariateRealFunction asCollector(final BivariateRealFunction combiner, final double initialValue) {
        return new MultivariateRealFunction(){

            public double value(double[] point) throws FunctionEvaluationException, IllegalArgumentException {
                double result = initialValue;
                for (double entry : point) {
                    result = combiner.value(result, ComposableFunction.this.value(entry));
                }
                return result;
            }
        };
    }

    public MultivariateRealFunction asCollector(BivariateRealFunction combiner) {
        return this.asCollector(combiner, 0.0);
    }

    public MultivariateRealFunction asCollector(double initialValue) {
        return this.asCollector(BinaryFunction.ADD, initialValue);
    }

    public MultivariateRealFunction asCollector() {
        return this.asCollector(BinaryFunction.ADD, 0.0);
    }

    public abstract double value(double var1) throws FunctionEvaluationException;
}

