/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.hbase;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayEntry;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.formats.util.TitanHadoopGraph;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetup;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;

public class TitanHBaseHadoopGraph
extends TitanHadoopGraph {
    public TitanHBaseHadoopGraph(TitanHadoopSetup setup) {
        super(setup);
    }

    public FaunusVertex readHadoopVertex(Configuration configuration, byte[] key, NavigableMap<byte[], NavigableMap<Long, byte[]>> rowMap) {
        return super.readHadoopVertex(configuration, (StaticBuffer)new StaticArrayBuffer(key), new HBaseMapIterable(rowMap));
    }

    private static class HBaseMapIterator
    implements Iterator<Entry> {
        private final Iterator<Map.Entry<byte[], NavigableMap<Long, byte[]>>> iterator;

        public HBaseMapIterator(Iterator<Map.Entry<byte[], NavigableMap<Long, byte[]>>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Entry next() {
            Map.Entry<byte[], NavigableMap<Long, byte[]>> entry = this.iterator.next();
            byte[] col = entry.getKey();
            byte[] val = entry.getValue().lastEntry().getValue();
            return StaticArrayEntry.of((StaticBuffer)new StaticArrayBuffer(col), (StaticBuffer)new StaticArrayBuffer(val));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class HBaseMapIterable
    implements Iterable<Entry> {
        private final NavigableMap<byte[], NavigableMap<Long, byte[]>> columnValues;

        public HBaseMapIterable(NavigableMap<byte[], NavigableMap<Long, byte[]>> columnValues) {
            Preconditions.checkNotNull(columnValues);
            this.columnValues = columnValues;
        }

        @Override
        public Iterator<Entry> iterator() {
            return new HBaseMapIterator(this.columnValues.entrySet().iterator());
        }
    }
}

