/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mrunit.internal.counters.CounterWrapper;
import org.apache.hadoop.mrunit.internal.io.Serialization;
import org.apache.hadoop.mrunit.internal.output.MockMultipleOutputs;
import org.apache.hadoop.mrunit.internal.util.ArgumentChecker;
import org.apache.hadoop.mrunit.internal.util.DistCacheUtils;
import org.apache.hadoop.mrunit.internal.util.Errors;
import org.apache.hadoop.mrunit.internal.util.PairEquality;
import org.apache.hadoop.mrunit.internal.util.StringUtils;
import org.apache.hadoop.mrunit.types.Pair;

public abstract class TestDriver<K, V, T extends TestDriver<K, V, T>> {
    public static final Log LOG = LogFactory.getLog(TestDriver.class);
    protected List<Pair<K, V>> expectedOutputs = new ArrayList<Pair<K, V>>();
    private boolean strictCountersChecking = false;
    protected List<Pair<Enum<?>, Long>> expectedEnumCounters = new ArrayList();
    protected List<Pair<Pair<String, String>, Long>> expectedStringCounters = new ArrayList<Pair<Pair<String, String>, Long>>();
    private Configuration configuration;
    private Serialization serialization;
    private Configuration outputSerializationConfiguration;
    private Comparator<K> keyComparator;
    private Comparator<V> valueComparator;
    private File tmpDistCacheDir;
    protected CounterWrapper counterWrapper;
    protected MockMultipleOutputs mos;
    protected Map<String, List<Pair<?, ?>>> expectedMultipleOutputs = new HashMap();
    protected Map<String, List<Pair<?, ?>>> expectedPathOutputs = new HashMap();
    private boolean hasRun = false;

    protected boolean driverReused() {
        return this.hasRun;
    }

    protected void setUsedOnceStatus() {
        this.hasRun = true;
    }

    public void addAllOutput(List<Pair<K, V>> outputRecords) {
        for (Pair<K, V> output : outputRecords) {
            this.addOutput(output);
        }
    }

    public T withAllOutput(List<Pair<K, V>> outputRecords) {
        this.addAllOutput(outputRecords);
        return this.thisAsTestDriver();
    }

    public void addOutput(Pair<K, V> outputRecord) {
        this.addOutput(outputRecord.getFirst(), outputRecord.getSecond());
    }

    public void addOutput(K key, V val) {
        this.expectedOutputs.add(this.copyPair(key, val));
    }

    public T withOutput(Pair<K, V> outputRecord) {
        this.addOutput(outputRecord);
        return this.thisAsTestDriver();
    }

    public T withOutput(K key, V val) {
        this.addOutput(key, val);
        return this.thisAsTestDriver();
    }

    @Deprecated
    public void addOutputFromString(String output) {
        this.addOutput(TestDriver.parseTabbedPair(output));
    }

    @Deprecated
    public T withOutputFromString(String output) {
        this.addOutputFromString(output);
        return this.thisAsTestDriver();
    }

    public List<Pair<K, V>> getExpectedOutputs() {
        return this.expectedOutputs;
    }

    public void resetOutput() {
        this.expectedOutputs.clear();
    }

    public List<Pair<Enum<?>, Long>> getExpectedEnumCounters() {
        return this.expectedEnumCounters;
    }

    public List<Pair<Pair<String, String>, Long>> getExpectedStringCounters() {
        return this.expectedStringCounters;
    }

    public void resetExpectedCounters() {
        this.expectedEnumCounters.clear();
        this.expectedStringCounters.clear();
    }

    protected T thisAsTestDriver() {
        return (T)this;
    }

    public T withCounter(Enum<?> e, long expectedValue) {
        this.expectedEnumCounters.add(new Pair(e, expectedValue));
        return this.thisAsTestDriver();
    }

    public T withCounter(String group, String name, long expectedValue) {
        this.expectedStringCounters.add(new Pair<Pair<String, String>, Long>(new Pair<String, String>(group, name), expectedValue));
        return this.thisAsTestDriver();
    }

    public T withStrictCounterChecking() {
        this.strictCountersChecking = true;
        return this.thisAsTestDriver();
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        return this.configuration;
    }

    public Comparator<K> getKeyComparator() {
        return this.keyComparator;
    }

    public Comparator<V> getValueComparator() {
        return this.valueComparator;
    }

    @Deprecated
    public void setConfiguration(Configuration configuration) {
        this.configuration = ArgumentChecker.returnNonNull(configuration);
    }

    @Deprecated
    public T withConfiguration(Configuration configuration) {
        this.setConfiguration(configuration);
        return this.thisAsTestDriver();
    }

    public Configuration getOutputSerializationConfiguration() {
        return this.outputSerializationConfiguration;
    }

    public void setOutputSerializationConfiguration(Configuration configuration) {
        this.outputSerializationConfiguration = ArgumentChecker.returnNonNull(configuration);
    }

    public T withOutputSerializationConfiguration(Configuration configuration) {
        this.setOutputSerializationConfiguration(configuration);
        return this.thisAsTestDriver();
    }

    public void addCacheFile(String path) {
        this.addCacheFile(DistCacheUtils.findResource(path));
    }

    public void addCacheFile(URI uri) {
        DistributedCache.addCacheFile((URI)uri, (Configuration)this.getConfiguration());
    }

    public void setCacheFiles(URI[] files) {
        DistributedCache.setCacheFiles((URI[])files, (Configuration)this.getConfiguration());
    }

    public void setKeyComparator(Comparator<K> keyComparator) {
        this.keyComparator = keyComparator;
    }

    public void setValueComparator(Comparator<V> valueComparator) {
        this.valueComparator = valueComparator;
    }

    public void addCacheArchive(String path) {
        this.addCacheArchive(DistCacheUtils.findResource(path));
    }

    public void addCacheArchive(URI uri) {
        DistributedCache.addCacheArchive((URI)uri, (Configuration)this.getConfiguration());
    }

    public void setCacheArchives(URI[] archives) {
        DistributedCache.setCacheArchives((URI[])archives, (Configuration)this.getConfiguration());
    }

    public T withCacheFile(String file) {
        this.addCacheFile(file);
        return this.thisAsTestDriver();
    }

    public T withCacheFile(URI file) {
        this.addCacheFile(file);
        return this.thisAsTestDriver();
    }

    public T withCacheArchive(String archive) {
        this.addCacheArchive(archive);
        return this.thisAsTestDriver();
    }

    public T withCacheArchive(URI archive) {
        this.addCacheArchive(archive);
        return this.thisAsTestDriver();
    }

    public List<Pair<K, V>> run(boolean validateCounters) throws IOException {
        List<Pair<K, V>> outputs = this.run();
        if (validateCounters) {
            this.validate(this.counterWrapper);
        }
        return outputs;
    }

    private Serialization getSerialization() {
        if (this.serialization == null) {
            this.serialization = new Serialization(this.getConfiguration());
        }
        return this.serialization;
    }

    protected void initDistributedCache() throws IOException {
        Configuration conf = this.getConfiguration();
        if (this.isDistributedCacheInitialised(conf)) {
            return;
        }
        ArrayList<Path> localArchives = new ArrayList<Path>();
        ArrayList<Path> localFiles = new ArrayList<Path>();
        if (DistributedCache.getCacheFiles((Configuration)conf) != null) {
            for (URI uri : DistributedCache.getCacheFiles((Configuration)conf)) {
                Path filePath = new Path(uri.getPath());
                localFiles.add(filePath);
            }
            if (!localFiles.isEmpty()) {
                DistCacheUtils.addLocalFiles(conf, DistCacheUtils.stringifyPathList(localFiles));
            }
        }
        if (DistributedCache.getCacheArchives((Configuration)conf) != null) {
            for (URI uri : DistributedCache.getCacheArchives((Configuration)conf)) {
                Path archivePath = new Path(uri.getPath());
                if (this.tmpDistCacheDir == null) {
                    this.tmpDistCacheDir = DistCacheUtils.createTempDirectory();
                }
                localArchives.add(DistCacheUtils.extractArchiveToTemp(archivePath, this.tmpDistCacheDir));
            }
            if (!localArchives.isEmpty()) {
                DistCacheUtils.addLocalArchives(conf, DistCacheUtils.stringifyPathList(localArchives));
            }
        }
    }

    private boolean isDistributedCacheInitialised(Configuration conf) throws IOException {
        return DistributedCache.getLocalCacheArchives((Configuration)conf) != null || DistributedCache.getLocalCacheFiles((Configuration)conf) != null;
    }

    protected void cleanupDistributedCache() throws IOException {
        if (this.tmpDistCacheDir != null) {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConfiguration());
            LOG.debug((Object)("Deleting " + this.tmpDistCacheDir.toURI()));
            fs.delete(new Path(this.tmpDistCacheDir.toURI()), true);
        }
        this.tmpDistCacheDir = null;
    }

    public abstract List<Pair<K, V>> run() throws IOException;

    public void runTest() throws IOException {
        this.runTest(true);
    }

    public void runTest(boolean orderMatters) throws IOException {
        if (LOG.isDebugEnabled()) {
            this.printPreTestDebugLog();
        }
        List<Pair<K, V>> outputs = this.run();
        this.validate(outputs, orderMatters);
        this.validate(this.counterWrapper);
        this.validate(this.mos);
    }

    protected void printPreTestDebugLog() {
    }

    public static Pair<Text, Text> parseTabbedPair(String tabSeparatedPair) {
        return StringUtils.parseTabbedPair(tabSeparatedPair);
    }

    protected static List<Text> parseCommaDelimitedList(String commaDelimList) {
        return StringUtils.parseCommaDelimitedList(commaDelimList);
    }

    protected <E> E copy(E object) {
        return this.getSerialization().copyWithConf(object, this.getConfiguration());
    }

    protected <S, E> Pair<S, E> copyPair(S first, E second) {
        return new Pair<S, E>(this.copy(first), this.copy(second));
    }

    protected void validate(List<Pair<K, V>> outputs, boolean orderMatters) {
        if (outputs.isEmpty() && this.expectedOutputs.isEmpty()) {
            return;
        }
        Errors errors = new Errors(LOG);
        if (!outputs.isEmpty() && this.expectedOutputs.isEmpty()) {
            errors.record("Expected no output; got %d output(s).", outputs.size());
            errors.assertNone();
        }
        if (outputs.isEmpty() && !this.expectedOutputs.isEmpty()) {
            errors.record("Expected %d output(s); got no output.", this.expectedOutputs.size());
            errors.assertNone();
        }
        this.checkOverrides(outputs, this.expectedOutputs);
        PairEquality<K, V> equality = new PairEquality<K, V>(this.keyComparator, this.valueComparator);
        if (orderMatters) {
            this.validateWithOrder(outputs, errors, equality);
        } else {
            this.validateWithoutOrder(outputs, errors, equality);
        }
        if (!errors.isEmpty()) {
            Class<?> outputKeyClass = null;
            Class<?> outputValueClass = null;
            Class<?> expectedKeyClass = null;
            Class<?> expectedValueClass = null;
            for (Pair<K, V> output : outputs) {
                if (output.getFirst() != null) {
                    outputKeyClass = output.getFirst().getClass();
                }
                if (output.getSecond() != null) {
                    outputValueClass = output.getSecond().getClass();
                }
                if (outputKeyClass == null || outputValueClass == null) continue;
                break;
            }
            for (Pair<K, V> expected : this.expectedOutputs) {
                if (expected.getFirst() != null) {
                    expectedKeyClass = expected.getFirst().getClass();
                }
                if (expected.getSecond() != null) {
                    expectedValueClass = expected.getSecond().getClass();
                }
                if (expectedKeyClass == null || expectedValueClass == null) continue;
                break;
            }
            if (outputKeyClass != null && expectedKeyClass != null && !outputKeyClass.equals(expectedKeyClass)) {
                errors.record("Mismatch in key class: expected: %s actual: %s", expectedKeyClass, outputKeyClass);
            }
            if (outputValueClass != null && expectedValueClass != null && !outputValueClass.equals(expectedValueClass)) {
                errors.record("Mismatch in value class: expected: %s actual: %s", expectedValueClass, outputValueClass);
            }
        }
        errors.assertNone();
    }

    private void validateWithoutOrder(List<Pair<K, V>> outputs, Errors errors, PairEquality<K, V> equality) {
        int i;
        HashSet<Integer> verifiedExpecteds = new HashSet<Integer>();
        HashSet<Integer> unverifiedOutputs = new HashSet<Integer>();
        for (i = 0; i < outputs.size(); ++i) {
            Pair<K, V> output = outputs.get(i);
            boolean found = false;
            for (int j = 0; j < this.expectedOutputs.size(); ++j) {
                Pair<K, V> expected;
                if (verifiedExpecteds.contains(j) || !equality.isTrueFor(output, expected = this.expectedOutputs.get(j))) continue;
                found = true;
                verifiedExpecteds.add(j);
                LOG.debug((Object)String.format("Matched expected output %s no %d at position %d", output, j, i));
                break;
            }
            if (found) continue;
            unverifiedOutputs.add(i);
        }
        for (int j = 0; j < this.expectedOutputs.size(); ++j) {
            if (verifiedExpecteds.contains(j)) continue;
            errors.record("Missing expected output %s", this.expectedOutputs.get(j));
        }
        for (i = 0; i < outputs.size(); ++i) {
            if (!unverifiedOutputs.contains(i)) continue;
            errors.record("Received unexpected output %s", outputs.get(i));
        }
    }

    private void validateWithOrder(List<Pair<K, V>> outputs, Errors errors, PairEquality<K, V> equality) {
        int j;
        int i = 0;
        for (i = 0; i < Math.min(outputs.size(), this.expectedOutputs.size()); ++i) {
            Pair<K, V> expected;
            Pair<K, V> output = outputs.get(i);
            if (equality.isTrueFor(output, expected = this.expectedOutputs.get(i))) {
                LOG.debug((Object)String.format("Matched expected output %s at position %d", expected, i));
                continue;
            }
            errors.record("Missing expected output %s at position %d, got %s.", expected, i, output);
        }
        for (j = i; j < outputs.size(); ++j) {
            errors.record("Received unexpected output %s at position %d.", outputs.get(j), j);
        }
        for (j = i; j < this.expectedOutputs.size(); ++j) {
            errors.record("Missing expected output %s at position %d.", this.expectedOutputs.get(j), j);
        }
    }

    private void checkOverrides(List<Pair<K, V>> outputPairs, List<Pair<K, V>> expectedOutputPairs) {
        Class<?> keyClass = null;
        Class<?> valueClass = null;
        for (Pair<K, V> pair : outputPairs) {
            if (keyClass == null && pair.getFirst() != null) {
                keyClass = pair.getFirst().getClass();
            }
            if (valueClass != null || pair.getSecond() == null) continue;
            valueClass = pair.getSecond().getClass();
        }
        for (Pair<K, V> pair : expectedOutputPairs) {
            if (keyClass == null && pair.getFirst() != null) {
                keyClass = pair.getFirst().getClass();
            }
            if (valueClass != null || pair.getSecond() == null) continue;
            valueClass = pair.getSecond().getClass();
        }
        this.checkOverride(keyClass);
        this.checkOverride(valueClass);
    }

    private void checkOverride(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        try {
            if (clazz.getMethod("equals", Object.class).getDeclaringClass() != clazz) {
                LOG.warn((Object)(clazz.getCanonicalName() + ".equals(Object) " + "is not being overridden - tests may fail!"));
            }
            if (clazz.getMethod("hashCode", new Class[0]).getDeclaringClass() != clazz) {
                LOG.warn((Object)(clazz.getCanonicalName() + ".hashCode() " + "is not being overridden - tests may fail!"));
            }
            if (clazz.getMethod("toString", new Class[0]).getDeclaringClass() != clazz) {
                LOG.warn((Object)(clazz.getCanonicalName() + ".toString() " + "is not being overridden - test failures may be difficult to diagnose."));
                LOG.warn((Object)"Consider executing test using run() to access outputs");
            }
        }
        catch (SecurityException e) {
            LOG.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)e);
        }
    }

    private Map<Pair<K, V>, List<Integer>> buildPositionMap(List<Pair<K, V>> values, Comparator<Pair<K, V>> comparator) {
        TreeMap valuePositions = new TreeMap(comparator);
        for (int i = 0; i < values.size(); ++i) {
            List<Integer> positions;
            Pair<K, V> output = values.get(i);
            if (valuePositions.containsKey(output)) {
                positions = (List)valuePositions.get(output);
            } else {
                positions = new ArrayList();
                valuePositions.put(output, positions);
            }
            positions.add(i);
        }
        return valuePositions;
    }

    protected void validate(CounterWrapper counterWrapper) {
        this.validateExpectedAgainstActual(counterWrapper);
        this.validateActualAgainstExpected(counterWrapper);
    }

    protected void validateOutputList(String name, Errors errors, Map<String, List<Pair<?, ?>>> actuals, Map<String, List<Pair<?, ?>>> expects) {
        ArrayList<String> removeList = new ArrayList<String>();
        for (String key : expects.keySet()) {
            removeList.add(key);
            List<Pair<?, ?>> expectedValues = expects.get(key);
            List<Pair<?, ?>> actualValues = actuals.get(key);
            if (actualValues == null) {
                errors.record("Missing expected outputs for %s '%s'", name, key);
                actualValues = new ArrayList();
            }
            int expectedSize = expectedValues.size();
            int actualSize = actualValues.size();
            for (int i = 0; expectedSize > i || actualSize > i; ++i) {
                Pair<?, ?> expected;
                if (expectedSize > i && actualSize > i) {
                    Pair<?, ?> actual;
                    expected = expectedValues.get(i);
                    if (expected.equals(actual = actualValues.get(i))) continue;
                    errors.record("Expected output %s for %s '%s' at position %d, but found %s", expected.toString(), name, key, i, actual.toString());
                    continue;
                }
                if (expectedSize > i) {
                    expected = expectedValues.get(i);
                    errors.record("Missing expected output %s for %s '%s' at position %d.", expected.toString(), name, key, i);
                    continue;
                }
                Pair<?, ?> actual = actualValues.get(i);
                errors.record("Received unexpected output %s for %s '%s' at position %d.", actual.toString(), name, key, i);
            }
        }
        for (String processedOutput : removeList) {
            actuals.remove(processedOutput);
        }
        for (String key : actuals.keySet()) {
            List<Pair<?, ?>> actualValues = actuals.get(key);
            for (Pair<?, ?> pair : actualValues) {
                errors.record("Received unexpected output %s for unexpected %s '%s'", pair.toString(), name, key);
            }
        }
    }

    protected void validate(MockMultipleOutputs mos) {
        Errors errors = new Errors(LOG);
        if (mos != null && !mos.isNamedOutputsEmpty() && this.expectedMultipleOutputs.isEmpty()) {
            errors.record("Expected no multiple outputs; got %d named MultipleOutputs.", mos.getMultipleOutputsCount());
        }
        Map<String, List<Pair<?, ?>>> actuals = this.buildActualMultipleOutputs(mos);
        Map<String, List<Pair<?, ?>>> expects = this.buildExpectedMultipleOutputs();
        this.validateOutputList("namedOutput", errors, actuals, expects);
        actuals.clear();
        expects.clear();
        if (mos != null && !mos.isPathOutputsEmpty() && this.expectedPathOutputs.isEmpty()) {
            errors.record("Expected no pathOutputs; got %d pathOutputs.", mos.getPathOutputsCount());
        }
        actuals = this.buildActualPathOutputs(mos);
        expects = this.buildExpectedPathOutputs();
        this.validateOutputList("PathOutput", errors, actuals, expects);
        errors.assertNone();
    }

    private Map<String, List<Pair<?, ?>>> buildActualMultipleOutputs(MockMultipleOutputs mos) {
        HashMap actuals = new HashMap();
        if (mos != null) {
            List<String> multipleOutputsNames = mos.getMultipleOutputsNames();
            for (String name : multipleOutputsNames) {
                actuals.put(name, mos.getMultipleOutputs(name));
            }
        }
        return actuals;
    }

    private Map<String, List<Pair<?, ?>>> buildExpectedMultipleOutputs() {
        HashMap result = new HashMap();
        for (String name : this.expectedMultipleOutputs.keySet()) {
            result.put(name, this.expectedMultipleOutputs.get(name));
        }
        return result;
    }

    private Map<String, List<Pair<?, ?>>> buildActualPathOutputs(MockMultipleOutputs mos) {
        HashMap actuals = new HashMap();
        if (mos != null) {
            List<String> outputPaths = mos.getOutputPaths();
            for (String path : outputPaths) {
                actuals.put(path, mos.getPathOutputs(path));
            }
        }
        return actuals;
    }

    private Map<String, List<Pair<?, ?>>> buildExpectedPathOutputs() {
        HashMap result = new HashMap();
        for (String name : this.expectedPathOutputs.keySet()) {
            result.put(name, this.expectedPathOutputs.get(name));
        }
        return result;
    }

    private Collection<Pair<String, String>> findExpectedCounterValues() {
        ArrayList<Pair<String, String>> results = new ArrayList<Pair<String, String>>();
        for (Pair<Pair<String, String>, Long> pair : this.expectedStringCounters) {
            results.add(pair.getFirst());
        }
        for (Pair<Object, Long> pair : this.expectedEnumCounters) {
            Enum first = (Enum)pair.getFirst();
            String groupName = first.getDeclaringClass().getName();
            String counterName = first.name();
            results.add(new Pair<String, String>(groupName, counterName));
        }
        return results;
    }

    private void validateExpectedAgainstActual(CounterWrapper counterWrapper) {
        Errors errors = new Errors(LOG);
        for (Pair<Enum<?>, Long> pair : this.expectedEnumCounters) {
            long actualValue = counterWrapper.findCounterValue(pair.getFirst());
            if (actualValue == pair.getSecond()) continue;
            errors.record("Counter %s.%s has value %d instead of expected %d", pair.getFirst().getDeclaringClass().getCanonicalName(), pair.getFirst().toString(), actualValue, pair.getSecond());
        }
        for (Pair<Object, Long> pair : this.expectedStringCounters) {
            Pair counter = (Pair)pair.getFirst();
            long actualValue = counterWrapper.findCounterValue((String)counter.getFirst(), (String)counter.getSecond());
            if (actualValue == pair.getSecond()) continue;
            errors.record("Counter with category %s and name %s has value %d instead of expected %d", counter.getFirst(), counter.getSecond(), actualValue, pair.getSecond());
        }
        errors.assertNone();
    }

    private void validateActualAgainstExpected(CounterWrapper counterWrapper) {
        if (this.strictCountersChecking) {
            Errors errors = new Errors(LOG);
            Collection<Pair<String, String>> unmatchedCounters = counterWrapper.findCounterValues();
            Collection<Pair<String, String>> findExpectedCounterValues = this.findExpectedCounterValues();
            unmatchedCounters.removeAll(findExpectedCounterValues);
            if (!unmatchedCounters.isEmpty()) {
                for (Pair<String, String> unmatcherCounter : unmatchedCounters) {
                    errors.record("Actual counter (\"%s\",\"%s\") was not found in expected counters", unmatcherCounter.getFirst(), unmatcherCounter.getSecond());
                }
            }
            errors.assertNone();
        }
    }

    public static void formatValueList(List<?> values, StringBuilder sb) {
        StringUtils.formatValueList(values, sb);
    }

    protected static <KEYIN, VALUEIN> void formatPairList(List<Pair<KEYIN, VALUEIN>> pairs, StringBuilder sb) {
        StringUtils.formatPairList(pairs, sb);
    }

    public <K, V> void addMultiOutput(String namedOutput, Pair<K, V> outputRecord) {
        this.addMultiOutput(namedOutput, outputRecord.getFirst(), outputRecord.getSecond());
    }

    public <K, V> void addMultiOutput(String namedOutput, K key, V val) {
        List<Pair<?, ?>> outputs = this.expectedMultipleOutputs.get(namedOutput);
        if (outputs == null) {
            outputs = new ArrayList();
            this.expectedMultipleOutputs.put(namedOutput, outputs);
        }
        outputs.add(new Pair<K, V>(key, val));
    }

    public <K extends Comparable, V extends Comparable> T withMultiOutput(String namedOutput, K key, V value) {
        this.addMultiOutput(namedOutput, key, value);
        return this.thisAsTestDriver();
    }

    public <K, V> T withMultiOutput(String namedOutput, Pair<K, V> outputRecord) {
        this.addMultiOutput(namedOutput, outputRecord);
        return this.thisAsTestDriver();
    }

    public <K, V> T withPathOutput(K key, V value, String path) {
        return this.withPathOutput(new Pair<K, V>(key, value), path);
    }

    public <K, V> T withPathOutput(Pair<K, V> outputRecord, String path) {
        List<Pair<?, ?>> list = this.expectedPathOutputs.get(path);
        if (list == null) {
            list = new ArrayList();
            this.expectedPathOutputs.put(path, list);
        }
        list.add(outputRecord);
        return this.thisAsTestDriver();
    }
}

