/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.EnumSet;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.PropertyDefinition;
import org.vertexium.Vertex;
import org.vertexium.query.DefaultGraphQueryIterable;
import org.vertexium.query.MultiVertexQuery;
import org.vertexium.query.QueryBase;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.VerticesToEdgeIdsIterable;

public class DefaultMultiVertexQuery
extends QueryBase
implements MultiVertexQuery {
    private final String[] vertexIds;

    public DefaultMultiVertexQuery(Graph graph, String[] vertexIds, String queryString, Map<String, PropertyDefinition> propertyDefinitions, Authorizations authorizations) {
        super(graph, queryString, propertyDefinitions, authorizations);
        this.vertexIds = vertexIds;
    }

    @Override
    public QueryResultsIterable<Vertex> vertices(EnumSet<FetchHint> fetchHints) {
        Iterable<Vertex> vertices = this.getGraph().getVertices(IterableUtils.toIterable(this.getVertexIds()), fetchHints, this.getParameters().getAuthorizations());
        return new DefaultGraphQueryIterable<Vertex>(this.getParameters(), vertices, true, true, true);
    }

    @Override
    public QueryResultsIterable<Edge> edges(EnumSet<FetchHint> fetchHints) {
        Iterable<Vertex> vertices = this.getGraph().getVertices(IterableUtils.toIterable(this.getVertexIds()), fetchHints, this.getParameters().getAuthorizations());
        VerticesToEdgeIdsIterable edgeIds = new VerticesToEdgeIdsIterable(vertices, this.getParameters().getAuthorizations());
        Iterable<Edge> edges = this.getGraph().getEdges(edgeIds, fetchHints, this.getParameters().getAuthorizations());
        return new DefaultGraphQueryIterable<Edge>(this.getParameters(), edges, true, true, true);
    }

    public String[] getVertexIds() {
        return this.vertexIds;
    }
}

