/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.PropertyDefinition;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.query.Aggregation;
import org.vertexium.query.Compare;
import org.vertexium.query.Contains;
import org.vertexium.query.Predicate;
import org.vertexium.query.Query;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.QueryResultsJoinIterable;
import org.vertexium.query.QueryStringQueryParameters;
import org.vertexium.query.SimilarToGraphQuery;
import org.vertexium.query.SimilarToQueryParameters;
import org.vertexium.query.SimilarToTextQueryParameters;
import org.vertexium.query.SortDirection;
import org.vertexium.util.IterableUtils;

public abstract class QueryBase
implements Query,
SimilarToGraphQuery {
    private final Graph graph;
    private final Map<String, PropertyDefinition> propertyDefinitions;
    private final QueryParameters parameters;
    private List<Aggregation> aggregations = new ArrayList<Aggregation>();

    protected QueryBase(Graph graph, String queryString, Map<String, PropertyDefinition> propertyDefinitions, Authorizations authorizations) {
        this.graph = graph;
        this.propertyDefinitions = propertyDefinitions;
        this.parameters = new QueryStringQueryParameters(queryString, authorizations);
    }

    protected QueryBase(Graph graph, String[] similarToFields, String similarToText, Map<String, PropertyDefinition> propertyDefinitions, Authorizations authorizations) {
        this.graph = graph;
        this.propertyDefinitions = propertyDefinitions;
        this.parameters = new SimilarToTextQueryParameters(similarToFields, similarToText, authorizations);
    }

    @Override
    public QueryResultsIterable<Vertex> vertices() {
        return this.vertices(FetchHint.ALL);
    }

    @Override
    public abstract QueryResultsIterable<Vertex> vertices(EnumSet<FetchHint> var1);

    @Override
    public QueryResultsIterable<Edge> edges() {
        return this.edges(FetchHint.ALL);
    }

    @Override
    public abstract QueryResultsIterable<Edge> edges(EnumSet<FetchHint> var1);

    @Override
    public <T> Query hasEdgeLabel(String ... edgeLabels) {
        for (String edgeLabel : edgeLabels) {
            this.getParameters().addEdgeLabel(edgeLabel);
        }
        return this;
    }

    @Override
    public <T> Query hasEdgeLabel(Collection<String> edgeLabels) {
        for (String edgeLabel : edgeLabels) {
            this.getParameters().addEdgeLabel(edgeLabel);
        }
        return this;
    }

    @Override
    @Deprecated
    public QueryResultsIterable<Edge> edges(String label, EnumSet<FetchHint> fetchHints) {
        this.hasEdgeLabel(label);
        return this.edges(fetchHints);
    }

    @Override
    @Deprecated
    public QueryResultsIterable<Edge> edges(String label) {
        this.hasEdgeLabel(label);
        return this.edges();
    }

    @Override
    public QueryResultsIterable<Element> elements() {
        return this.elements(FetchHint.ALL);
    }

    @Override
    public QueryResultsIterable<Element> elements(EnumSet<FetchHint> fetchHints) {
        Iterable<Element> vertices = IterableUtils.toElementIterable(this.vertices(fetchHints));
        Iterable<Element> edges = IterableUtils.toElementIterable(this.edges(fetchHints));
        return new QueryResultsJoinIterable<Element>(vertices, edges);
    }

    @Override
    public <T> Query range(String propertyName, T startValue, T endValue) {
        return this.range(propertyName, startValue, true, endValue, true);
    }

    @Override
    public <T> Query range(String propertyName, T startValue, boolean inclusiveStartValue, T endValue, boolean inclusiveEndValue) {
        if (startValue != null) {
            this.parameters.addHasContainer(new HasValueContainer(propertyName, inclusiveStartValue ? Compare.GREATER_THAN_EQUAL : Compare.GREATER_THAN, startValue, this.propertyDefinitions));
        }
        if (endValue != null) {
            this.parameters.addHasContainer(new HasValueContainer(propertyName, inclusiveEndValue ? Compare.LESS_THAN_EQUAL : Compare.LESS_THAN, endValue, this.propertyDefinitions));
        }
        return this;
    }

    @Override
    public Query sort(String propertyName, SortDirection direction) {
        this.parameters.addSortContainer(new SortContainer(propertyName, direction));
        return this;
    }

    @Override
    public <T> Query has(String propertyName, T value) {
        this.parameters.addHasContainer(new HasValueContainer(propertyName, Compare.EQUAL, value, this.propertyDefinitions));
        return this;
    }

    @Override
    public <T> Query hasNot(String propertyName, T value) {
        this.parameters.addHasContainer(new HasValueContainer(propertyName, Contains.NOT_IN, new Object[]{value}, this.propertyDefinitions));
        return this;
    }

    @Override
    public <T> Query has(String propertyName, Predicate predicate, T value) {
        this.parameters.addHasContainer(new HasValueContainer(propertyName, predicate, value, this.propertyDefinitions));
        return this;
    }

    @Override
    public Query has(String propertyName) {
        this.parameters.addHasContainer(new HasPropertyContainer(propertyName));
        return this;
    }

    @Override
    public Query hasNot(String propertyName) {
        this.parameters.addHasContainer(new HasNotPropertyContainer(propertyName));
        return this;
    }

    @Override
    public Query skip(int count) {
        this.parameters.setSkip(count);
        return this;
    }

    @Override
    public Query limit(Integer count) {
        this.parameters.setLimit(count);
        return this;
    }

    @Override
    public Query limit(Long count) {
        this.parameters.setLimit(count);
        return this;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public QueryParameters getParameters() {
        return this.parameters;
    }

    protected Map<String, PropertyDefinition> getPropertyDefinitions() {
        return this.propertyDefinitions;
    }

    @Override
    public SimilarToGraphQuery minTermFrequency(int minTermFrequency) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new VertexiumException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMinTermFrequency(minTermFrequency);
        return this;
    }

    @Override
    public SimilarToGraphQuery maxQueryTerms(int maxQueryTerms) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new VertexiumException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMaxQueryTerms(maxQueryTerms);
        return this;
    }

    @Override
    public SimilarToGraphQuery minDocFrequency(int minDocFrequency) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new VertexiumException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMinDocFrequency(minDocFrequency);
        return this;
    }

    @Override
    public SimilarToGraphQuery maxDocFrequency(int maxDocFrequency) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new VertexiumException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setMaxDocFrequency(maxDocFrequency);
        return this;
    }

    @Override
    public SimilarToGraphQuery percentTermsToMatch(float percentTermsToMatch) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new VertexiumException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setPercentTermsToMatch(Float.valueOf(percentTermsToMatch));
        return this;
    }

    @Override
    public SimilarToGraphQuery boost(float boost) {
        if (!(this.parameters instanceof SimilarToQueryParameters)) {
            throw new VertexiumException("Invalid query parameters, expected " + SimilarToQueryParameters.class.getName() + " found " + this.parameters.getClass().getName());
        }
        ((SimilarToQueryParameters)this.parameters).setBoost(Float.valueOf(boost));
        return this;
    }

    @Override
    public boolean isAggregationSupported(Aggregation aggregation) {
        return false;
    }

    @Override
    public Query addAggregation(Aggregation aggregation) {
        if (!this.isAggregationSupported(aggregation)) {
            throw new VertexiumException("Aggregation " + aggregation.getClass().getName() + " is not supported");
        }
        this.aggregations.add(aggregation);
        return this;
    }

    public Collection<Aggregation> getAggregations() {
        return this.aggregations;
    }

    public static class HasNotPropertyContainer
    extends HasContainer {
        private final String key;

        public HasNotPropertyContainer(String key) {
            this.key = key;
        }

        @Override
        public boolean isMatch(Element elem) {
            for (Property prop : elem.getProperties()) {
                if (!prop.getName().equals(this.key)) continue;
                return false;
            }
            return true;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class HasPropertyContainer
    extends HasContainer {
        private final String key;

        public HasPropertyContainer(String key) {
            this.key = key;
        }

        @Override
        public boolean isMatch(Element elem) {
            for (Property prop : elem.getProperties()) {
                if (!prop.getName().equals(this.key)) continue;
                return true;
            }
            return false;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class HasValueContainer
    extends HasContainer {
        public String key;
        public Object value;
        public Predicate predicate;
        private final Map<String, PropertyDefinition> propertyDefinitions;

        public HasValueContainer(String key, Predicate predicate, Object value, Map<String, PropertyDefinition> propertyDefinitions) {
            this.key = key;
            this.value = value;
            this.predicate = predicate;
            this.propertyDefinitions = propertyDefinitions;
        }

        @Override
        public boolean isMatch(Element elem) {
            return this.predicate.evaluate(elem.getProperties(this.key), this.value, this.propertyDefinitions);
        }
    }

    public static class SortContainer {
        public final String propertyName;
        public final SortDirection direction;

        public SortContainer(String propertyName, SortDirection direction) {
            this.propertyName = propertyName;
            this.direction = direction;
        }
    }

    public static abstract class HasContainer {
        public abstract boolean isMatch(Element var1);
    }
}

