/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeInfo;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloElement;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.GetVertexIdsIterable;
import org.vertexium.accumulo.iterator.VertexIterator;
import org.vertexium.accumulo.iterator.model.Edges;
import org.vertexium.accumulo.iterator.model.EdgesWithCount;
import org.vertexium.accumulo.iterator.model.EdgesWithEdgeInfo;
import org.vertexium.accumulo.util.DataInputStreamUtils;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.mutation.ExistingElementMutationImpl;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.query.VertexQuery;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.JoinIterable;
import org.vertexium.util.LookAheadIterable;

public class AccumuloVertex
extends AccumuloElement
implements Vertex {
    public static final Text CF_SIGNAL = VertexIterator.CF_SIGNAL;
    public static final Text CF_OUT_EDGE = VertexIterator.CF_OUT_EDGE;
    public static final Text CF_IN_EDGE = VertexIterator.CF_IN_EDGE;
    public static final Text CF_OUT_EDGE_SOFT_DELETE = VertexIterator.CF_OUT_EDGE_SOFT_DELETE;
    public static final Text CF_IN_EDGE_SOFT_DELETE = VertexIterator.CF_IN_EDGE_SOFT_DELETE;
    public static final Text CF_OUT_EDGE_HIDDEN = VertexIterator.CF_OUT_EDGE_HIDDEN;
    public static final Text CF_IN_EDGE_HIDDEN = VertexIterator.CF_IN_EDGE_HIDDEN;
    private final Edges inEdges;
    private final Edges outEdges;

    public AccumuloVertex(AccumuloGraph graph, String vertexId, Visibility vertexVisibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, long timestamp, Authorizations authorizations) {
        this(graph, vertexId, vertexVisibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, (Edges)new EdgesWithEdgeInfo(), (Edges)new EdgesWithEdgeInfo(), timestamp, authorizations);
    }

    public AccumuloVertex(AccumuloGraph graph, String vertexId, Visibility vertexVisibility, Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations, Iterable<Visibility> hiddenVisibilities, Edges inEdges, Edges outEdges, long timestamp, Authorizations authorizations) {
        super((Graph)graph, vertexId, vertexVisibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, timestamp, authorizations);
        this.inEdges = inEdges;
        this.outEdges = outEdges;
    }

    public static Vertex createFromIteratorValue(AccumuloGraph graph, Key key, Value value, Authorizations authorizations) {
        try {
            ArrayList<PropertyDeleteMutation> propertyDeleteMutations = new ArrayList<PropertyDeleteMutation>();
            ArrayList<PropertySoftDeleteMutation> propertySoftDeleteMutations = new ArrayList<PropertySoftDeleteMutation>();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(value.get());
            DataInputStream in = new DataInputStream(byteArrayInputStream);
            DataInputStreamUtils.decodeHeader(in, (byte)1);
            String vertexId = DataInputStreamUtils.decodeText(in).toString();
            long timestamp = in.readLong();
            Visibility vertexVisibility = new Visibility(DataInputStreamUtils.decodeText(in).toString());
            Iterable hiddenVisibilities = Iterables.transform(DataInputStreamUtils.decodeTextList(in), (Function)new Function<Text, Visibility>(){

                @Nullable
                public Visibility apply(Text input) {
                    return new Visibility(input.toString());
                }
            });
            Iterable<Property> properties = DataInputStreamUtils.decodeProperties(graph, in);
            Edges outEdges = DataInputStreamUtils.decodeEdges(in, graph.getNameSubstitutionStrategy());
            Edges inEdges = DataInputStreamUtils.decodeEdges(in, graph.getNameSubstitutionStrategy());
            return new AccumuloVertex(graph, vertexId, vertexVisibility, properties, propertyDeleteMutations, propertySoftDeleteMutations, hiddenVisibilities, inEdges, outEdges, timestamp, authorizations);
        }
        catch (IOException ex) {
            throw new VertexiumException("Could not read vertex", (Throwable)ex);
        }
    }

    public Iterable<Edge> getEdges(Direction direction, Authorizations authorizations) {
        return this.getEdges(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdges(direction, fetchHints, null, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIds(direction, authorizations), fetchHints, endTime, authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(null, direction, null, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIds(direction, AccumuloVertex.labelToArrayOrNull(label), authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(null, direction, AccumuloVertex.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(null, direction, labels, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(null, direction, labels, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, null, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, null, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, AccumuloVertex.labelToArrayOrNull(label), authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, AccumuloVertex.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getEdges(this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, labels, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdgeIdsWithOtherVertexId(otherVertex.getId(), direction, labels, authorizations);
    }

    public int getEdgeCount(Direction direction, Authorizations authorizations) {
        return IterableUtils.count(this.getEdgeIds(direction, authorizations));
    }

    public Iterable<String> getEdgeLabels(Direction direction, Authorizations authorizations) {
        HashSet<String> edgeLabels = new HashSet<String>();
        if (direction == Direction.IN || direction == Direction.BOTH) {
            if (this.inEdges instanceof EdgesWithCount) {
                edgeLabels.addAll(((EdgesWithCount)this.inEdges).getLabels());
            } else {
                edgeLabels.addAll(IterableUtils.toList((Iterable)new ConvertingIterable<Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo>, String>(this.getEdgeInfos(Direction.IN)){

                    protected String convert(Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo> o) {
                        return o.getValue().getLabel();
                    }
                }));
            }
        }
        if (direction == Direction.OUT || direction == Direction.BOTH) {
            if (this.outEdges instanceof EdgesWithCount) {
                edgeLabels.addAll(((EdgesWithCount)this.outEdges).getLabels());
            } else {
                edgeLabels.addAll(IterableUtils.toList((Iterable)new ConvertingIterable<Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo>, String>(this.getEdgeInfos(Direction.OUT)){

                    protected String convert(Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo> o) {
                        return o.getValue().getLabel();
                    }
                }));
            }
        }
        return edgeLabels;
    }

    public Iterable<Vertex> getVertices(Direction direction, Authorizations authorizations) {
        return this.getVertices(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<String> getEdgeIdsWithOtherVertexId(final String otherVertexId, final Direction direction, final String[] labels, Authorizations authorizations) {
        return new LookAheadIterable<Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo>, String>(){

            protected boolean isIncluded(Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo> edgeInfo, String edgeId) {
                if (otherVertexId != null && !otherVertexId.equals(edgeInfo.getValue().getVertexId())) {
                    return false;
                }
                if (labels == null || labels.length == 0) {
                    return true;
                }
                for (String label : labels) {
                    if (!label.equals(edgeInfo.getValue().getLabel())) continue;
                    return true;
                }
                return false;
            }

            protected String convert(Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo> edgeInfo) {
                return edgeInfo.getKey().toString();
            }

            protected Iterator<Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo>> createIterator() {
                return AccumuloVertex.this.getEdgeInfos(direction).iterator();
            }
        };
    }

    private Iterable<Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo>> getEdgeInfos(Direction direction) {
        switch (direction) {
            case IN: {
                if (this.inEdges instanceof EdgesWithEdgeInfo) {
                    return ((EdgesWithEdgeInfo)this.inEdges).getEntries();
                }
                throw new VertexiumException("Cannot get edge info");
            }
            case OUT: {
                if (this.outEdges instanceof EdgesWithEdgeInfo) {
                    return ((EdgesWithEdgeInfo)this.outEdges).getEntries();
                }
                throw new VertexiumException("Cannot get edge info");
            }
            case BOTH: {
                return new JoinIterable(new Iterable[]{this.getEdgeInfos(Direction.IN), this.getEdgeInfos(Direction.OUT)});
            }
        }
        throw new VertexiumException("Unexpected direction: " + direction);
    }

    public Iterable<EdgeInfo> getEdgeInfos(Direction direction, Authorizations authorizations) {
        return new ConvertingIterable<Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo>, EdgeInfo>(this.getEdgeInfos(direction)){

            protected EdgeInfo convert(Map.Entry<Text, org.vertexium.accumulo.iterator.model.EdgeInfo> o) {
                final String edgeId = o.getKey().toString();
                final org.vertexium.accumulo.iterator.model.EdgeInfo edgeInfo = o.getValue();
                return new EdgeInfo(){

                    public String getEdgeId() {
                        return edgeId;
                    }

                    public String getLabel() {
                        return edgeInfo.getLabel();
                    }

                    public String getVertexId() {
                        return edgeInfo.getVertexId();
                    }
                };
            }
        };
    }

    public Iterable<Vertex> getVertices(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertices(this.getVertexIds(direction, authorizations), fetchHints, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, Authorizations authorizations) {
        return this.getVertices(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVertices(direction, AccumuloVertex.labelToArrayOrNull(label), fetchHints, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getVertices(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getGraph().getVertices(this.getVertexIds(direction, labels, authorizations), fetchHints, authorizations);
    }

    public Iterable<String> getVertexIds(Direction direction, String label, Authorizations authorizations) {
        return this.getVertexIds(direction, AccumuloVertex.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<String> getVertexIds(Direction direction, Authorizations authorizations) {
        return this.getVertexIds(direction, (String[])null, authorizations);
    }

    public Iterable<String> getVertexIds(Direction direction, String[] labels, Authorizations authorizations) {
        switch (direction) {
            case BOTH: {
                Iterable<String> inVertexIds = this.getVertexIds(Direction.IN, labels, authorizations);
                Iterable<String> outVertexIds = this.getVertexIds(Direction.OUT, labels, authorizations);
                return new JoinIterable(new Iterable[]{inVertexIds, outVertexIds});
            }
            case IN: {
                if (this.inEdges instanceof EdgesWithEdgeInfo) {
                    return new GetVertexIdsIterable(((EdgesWithEdgeInfo)this.inEdges).getEdgeInfos(), labels);
                }
                throw new VertexiumException("Cannot get vertex ids");
            }
            case OUT: {
                if (this.outEdges instanceof EdgesWithEdgeInfo) {
                    return new GetVertexIdsIterable(((EdgesWithEdgeInfo)this.outEdges).getEdgeInfos(), labels);
                }
                throw new VertexiumException("Cannot get vertex ids");
            }
        }
        throw new VertexiumException("Unexpected direction: " + direction);
    }

    public VertexQuery query(Authorizations authorizations) {
        return this.query(null, authorizations);
    }

    public VertexQuery query(String queryString, Authorizations authorizations) {
        return this.getGraph().getSearchIndex().queryVertex((Graph)this.getGraph(), (Vertex)this, queryString, authorizations);
    }

    void addOutEdge(Edge edge) {
        if (!(this.outEdges instanceof EdgesWithEdgeInfo)) {
            throw new VertexiumException("Cannot add edge");
        }
        ((EdgesWithEdgeInfo)this.outEdges).add(edge.getId(), new org.vertexium.accumulo.iterator.model.EdgeInfo(edge.getLabel(), edge.getVertexId(Direction.IN)));
    }

    void removeOutEdge(Edge edge) {
        if (!(this.outEdges instanceof EdgesWithEdgeInfo)) {
            throw new VertexiumException("Cannot remove out edge");
        }
        ((EdgesWithEdgeInfo)this.outEdges).remove(edge.getId());
    }

    void addInEdge(Edge edge) {
        if (!(this.inEdges instanceof EdgesWithEdgeInfo)) {
            throw new VertexiumException("Cannot add edge");
        }
        ((EdgesWithEdgeInfo)this.inEdges).add(edge.getId(), new org.vertexium.accumulo.iterator.model.EdgeInfo(edge.getLabel(), edge.getVertexId(Direction.OUT)));
    }

    void removeInEdge(Edge edge) {
        if (!(this.inEdges instanceof EdgesWithEdgeInfo)) {
            throw new VertexiumException("Cannot remove in edge");
        }
        ((EdgesWithEdgeInfo)this.inEdges).remove(edge.getId());
    }

    public ExistingElementMutation<Vertex> prepareMutation() {
        return new ExistingElementMutationImpl<Vertex>((Vertex)this){

            public Vertex save(Authorizations authorizations) {
                AccumuloVertex.this.saveExistingElementMutation(this, authorizations);
                return (Vertex)this.getElement();
            }
        };
    }

    private static String[] labelToArrayOrNull(String label) {
        String[] stringArray;
        if (label == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = label;
        }
        return stringArray;
    }
}

