/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSVisitor;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MasterSnapshotVerifier {
    private static final Log LOG = LogFactory.getLog(MasterSnapshotVerifier.class);
    private HBaseProtos.SnapshotDescription snapshot;
    private FileSystem fs;
    private Path rootDir;
    private String tableName;
    private MasterServices services;

    public MasterSnapshotVerifier(MasterServices services, HBaseProtos.SnapshotDescription snapshot, Path rootDir) {
        this.fs = services.getMasterFileSystem().getFileSystem();
        this.services = services;
        this.snapshot = snapshot;
        this.rootDir = rootDir;
        this.tableName = snapshot.getTable();
    }

    public void verifySnapshot(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        this.verifySnapshotDescription(snapshotDir);
        this.verifyTableInfo(snapshotDir);
        this.verifyRegions(snapshotDir);
    }

    private void verifySnapshotDescription(Path snapshotDir) throws CorruptedSnapshotException {
        HBaseProtos.SnapshotDescription found = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        if (!this.snapshot.equals(found)) {
            throw new CorruptedSnapshotException("Snapshot read (" + found + ") doesn't equal snapshot we ran (" + this.snapshot + ").", this.snapshot);
        }
    }

    private void verifyTableInfo(Path snapshotDir) throws IOException {
        FSTableDescriptors.getTableDescriptor(this.fs, snapshotDir);
    }

    private void verifyRegions(Path snapshotDir) throws IOException {
        List<HRegionInfo> regions = MetaReader.getTableRegions(this.services.getCatalogTracker(), Bytes.toBytes(this.tableName));
        Set<String> snapshotRegions = SnapshotReferenceUtil.getSnapshotRegionNames(this.fs, snapshotDir);
        if (snapshotRegions == null) {
            String msg = "Snapshot " + SnapshotDescriptionUtils.toString(this.snapshot) + " looks empty";
            LOG.error((Object)msg);
            throw new CorruptedSnapshotException(msg);
        }
        if (snapshotRegions.size() != regions.size()) {
            String msg = "Regions moved during the snapshot '" + SnapshotDescriptionUtils.toString(this.snapshot) + "'. expected=" + regions.size() + " snapshotted=" + snapshotRegions.size();
            LOG.error((Object)msg);
            throw new CorruptedSnapshotException(msg);
        }
        for (HRegionInfo region : regions) {
            if (!snapshotRegions.contains(region.getEncodedName())) {
                String msg = "No region directory found for region:" + (Object)((Object)region);
                LOG.error((Object)msg);
                throw new CorruptedSnapshotException(msg, this.snapshot);
            }
            this.verifyRegion(this.fs, snapshotDir, region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRegion(FileSystem fs, final Path snapshotDir, final HRegionInfo region) throws IOException {
        Path regionDir = new Path(snapshotDir, region.getEncodedName());
        Path regionInfo = new Path(regionDir, ".regioninfo");
        if (!fs.exists(regionInfo)) {
            throw new CorruptedSnapshotException("No region info found for region:" + (Object)((Object)region), this.snapshot);
        }
        FSDataInputStream in = fs.open(regionInfo);
        HRegionInfo found = new HRegionInfo();
        try {
            found.readFields((DataInput)in);
            if (!region.equals((Object)found)) {
                throw new CorruptedSnapshotException("Found region info (" + (Object)((Object)found) + ") doesn't match expected region:" + (Object)((Object)region), this.snapshot);
            }
        }
        finally {
            in.close();
        }
        TakeSnapshotUtils.verifyRecoveredEdits(fs, snapshotDir, found, this.snapshot);
        SnapshotReferenceUtil.visitRegionStoreFiles(fs, regionDir, new FSVisitor.StoreFileVisitor(){

            @Override
            public void storeFile(String regionNameSuffix, String family, String hfileName) throws IOException {
                MasterSnapshotVerifier.this.verifyStoreFile(snapshotDir, region, family, hfileName);
            }
        });
    }

    private void verifyStoreFile(Path snapshotDir, HRegionInfo regionInfo, String family, String fileName) throws IOException {
        Path snapshotHFilePath;
        Path refPath = null;
        if (StoreFile.isReference(fileName) && !this.fs.exists(refPath = StoreFile.getReferredToFile(snapshotHFilePath = new Path(new Path(new Path(snapshotDir, regionInfo.getEncodedName()), family), fileName)))) {
            throw new CorruptedSnapshotException("Missing parent hfile for: " + fileName, this.snapshot);
        }
        Path linkPath = refPath != null && HFileLink.isHFileLink(refPath) ? new Path(family, refPath.getName()) : (HFileLink.isHFileLink(fileName) ? new Path(family, fileName) : new Path(family, HFileLink.createHFileLinkName(this.tableName, regionInfo.getEncodedName(), fileName)));
        HFileLink link = new HFileLink(this.services.getConfiguration(), linkPath);
        if (!link.exists(this.fs)) {
            throw new CorruptedSnapshotException("Can't find hfile: " + fileName + " in the real (" + link.getOriginPath() + ") or archive (" + link.getArchivePath() + ") directory for the primary table.", this.snapshot);
        }
    }

    private void verifyLogs(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        Path snapshotLogDir = new Path(snapshotDir, ".logs");
        Path logsDir = new Path(this.rootDir, ".logs");
        TakeSnapshotUtils.verifyAllLogsGotReferenced(this.fs, logsDir, snapshotServers, this.snapshot, snapshotLogDir);
    }
}

