/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseFileSystem;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.client.coprocessor.ExecResult;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.CompoundConfiguration;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.metrics.OperationMetrics;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HashedBytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;
import org.cliffc.high_scale_lib.Counter;

public class HRegion
implements HeapSize {
    public static final Log LOG = LogFactory.getLog(HRegion.class);
    private static final String MERGEDIR = ".merges";
    public static final String LOAD_CFS_ON_DEMAND_CONFIG_KEY = "hbase.hregion.scan.loadColumnFamiliesOnDemand";
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean closing = new AtomicBoolean(false);
    private final ConcurrentHashMap<HashedBytes, CountDownLatch> lockedRows = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, HashedBytes> lockIds = new ConcurrentHashMap();
    private final AtomicInteger lockIdGenerator = new AtomicInteger(1);
    private static Random rand = new Random();
    protected final Map<byte[], Store> stores = new ConcurrentSkipListMap<byte[], Store>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private ClassToInstanceMap<CoprocessorProtocol> protocolHandlers = MutableClassToInstanceMap.create();
    private Map<String, Class<? extends CoprocessorProtocol>> protocolHandlerNames = Maps.newHashMap();
    public static final String REGION_TEMP_SUBDIR = ".tmp";
    final AtomicLong memstoreSize = new AtomicLong(0L);
    final AtomicLong numPutsWithoutWAL = new AtomicLong(0L);
    final AtomicLong dataInMemoryWithoutWAL = new AtomicLong(0L);
    final Counter readRequestsCount = new Counter();
    final Counter writeRequestsCount = new Counter();
    final Counter updatesBlockedMs = new Counter();
    private final Path tableDir;
    private final HLog log;
    private final FileSystem fs;
    private final Configuration conf;
    final Configuration baseConf;
    private final int rowLockWaitDuration;
    static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    final long busyWaitDuration;
    static final long DEFAULT_BUSY_WAIT_DURATION = HConstants.DEFAULT_HBASE_RPC_TIMEOUT;
    final int maxBusyWaitMultiplier;
    final long maxBusyWaitDuration;
    private final HRegionInfo regionInfo;
    private final Path regiondir;
    KeyValue.KVComparator comparator;
    private ConcurrentHashMap<RegionScanner, Long> scannerReadPoints;
    private boolean isLoadingCfsOnDemandDefault = false;
    final WriteState writestate = new WriteState();
    long memstoreFlushSize;
    final long timestampSlop;
    private volatile long lastFlushTime;
    final RegionServerServices rsServices;
    private RegionServerAccounting rsAccounting;
    private List<Pair<Long, Long>> recentFlushes = new ArrayList<Pair<Long, Long>>();
    private long flushCheckInterval;
    private long blockingMemStoreSize;
    final long threadWakeFrequency;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock updatesLock = new ReentrantReadWriteLock();
    private boolean splitRequest;
    private byte[] explicitSplitPoint = null;
    private final MultiVersionConsistencyControl mvcc = new MultiVersionConsistencyControl();
    private RegionCoprocessorHost coprocessorHost;
    public static final String REGIONINFO_FILE = ".regioninfo";
    private HTableDescriptor htableDescriptor = null;
    private RegionSplitPolicy splitPolicy;
    private final OperationMetrics opMetrics;
    private final boolean deferredLogSyncDisabled;
    private final Object closeLock = new Object();
    public static final String MEMSTORE_PERIODIC_FLUSH_INTERVAL = "hbase.regionserver.optionalcacheflushinterval";
    public static final int DEFAULT_CACHE_FLUSH_INTERVAL = 3600000;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + ClassSize.ARRAY + 36 * ClassSize.REFERENCE + 8 + 64 + 1);
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + (long)(3 * ClassSize.ATOMIC_LONG) + (long)ClassSize.ATOMIC_INTEGER + (long)(3 * ClassSize.CONCURRENT_HASHMAP) + WriteState.HEAP_SIZE + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)(2 * ClassSize.REENTRANT_LOCK) + (long)ClassSize.ARRAYLIST + MultiVersionConsistencyControl.FIXED_SIZE;
    private static final List<KeyValue> MOCKED_LIST = new AbstractList<KeyValue>(){

        @Override
        public void add(int index, KeyValue element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends KeyValue> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSmallestReadPoint() {
        long minimumReadPoint;
        ConcurrentHashMap<RegionScanner, Long> concurrentHashMap = this.scannerReadPoints;
        synchronized (concurrentHashMap) {
            minimumReadPoint = this.mvcc.memstoreReadPoint();
            for (Long readPoint : this.scannerReadPoints.values()) {
                if (readPoint >= minimumReadPoint) continue;
                minimumReadPoint = readPoint;
            }
        }
        return minimumReadPoint;
    }

    public HRegion() {
        this.tableDir = null;
        this.blockingMemStoreSize = 0L;
        this.conf = null;
        this.rowLockWaitDuration = 30000;
        this.rsServices = null;
        this.baseConf = null;
        this.fs = null;
        this.timestampSlop = Long.MAX_VALUE;
        this.memstoreFlushSize = 0L;
        this.log = null;
        this.regiondir = null;
        this.regionInfo = null;
        this.htableDescriptor = null;
        this.threadWakeFrequency = 0L;
        this.coprocessorHost = null;
        this.scannerReadPoints = new ConcurrentHashMap();
        this.opMetrics = new OperationMetrics();
        this.maxBusyWaitDuration = 2 * HConstants.DEFAULT_HBASE_RPC_TIMEOUT;
        this.busyWaitDuration = DEFAULT_BUSY_WAIT_DURATION;
        this.maxBusyWaitMultiplier = 2;
        this.deferredLogSyncDisabled = false;
    }

    public HRegion(HRegion other) {
        this(other.getTableDir(), other.getLog(), other.getFilesystem(), other.baseConf, other.getRegionInfo(), other.getTableDesc(), null);
    }

    public HRegion(Path tableDir, HLog log, FileSystem fs, Configuration confParam, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        this.tableDir = tableDir;
        this.comparator = regionInfo.getComparator();
        this.log = log;
        this.fs = fs;
        if (confParam instanceof CompoundConfiguration) {
            throw new IllegalArgumentException("Need original base configuration");
        }
        this.baseConf = confParam;
        this.conf = htd != null ? new CompoundConfiguration().add(confParam).add(htd.getValues()) : new CompoundConfiguration().add(confParam);
        this.flushCheckInterval = this.conf.getInt(MEMSTORE_PERIODIC_FLUSH_INTERVAL, 3600000);
        this.rowLockWaitDuration = this.conf.getInt("hbase.rowlock.wait.duration", 30000);
        this.isLoadingCfsOnDemandDefault = this.conf.getBoolean(LOAD_CFS_ON_DEMAND_CONFIG_KEY, false);
        this.regionInfo = regionInfo;
        this.htableDescriptor = htd;
        this.rsServices = rsServices;
        this.threadWakeFrequency = this.conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        String encodedNameStr = this.regionInfo.getEncodedName();
        this.setHTableSpecificConf();
        this.regiondir = HRegion.getRegionDir(this.tableDir, encodedNameStr);
        this.scannerReadPoints = new ConcurrentHashMap();
        this.opMetrics = new OperationMetrics(this.conf, this.regionInfo);
        this.busyWaitDuration = this.conf.getLong("hbase.busy.wait.duration", DEFAULT_BUSY_WAIT_DURATION);
        this.maxBusyWaitMultiplier = this.conf.getInt("hbase.busy.wait.multiplier.max", 2);
        if (this.busyWaitDuration * (long)this.maxBusyWaitMultiplier <= 0L) {
            throw new IllegalArgumentException("Invalid hbase.busy.wait.duration (" + this.busyWaitDuration + ") or hbase.busy.wait.multiplier.max (" + this.maxBusyWaitMultiplier + "). Their product should be positive");
        }
        this.maxBusyWaitDuration = this.conf.getLong("ipc.client.call.purge.timeout", (long)(2 * HConstants.DEFAULT_HBASE_RPC_TIMEOUT));
        this.timestampSlop = this.conf.getLong("hbase.hregion.keyvalue.timestamp.slop.millisecs", Long.MAX_VALUE);
        boolean bl = this.deferredLogSyncDisabled = this.conf.getLong("hbase.regionserver.optionallogflushinterval", 1000L) <= 0L;
        if (rsServices != null) {
            this.rsAccounting = this.rsServices.getRegionServerAccounting();
            this.coprocessorHost = new RegionCoprocessorHost(this, rsServices, this.conf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiated " + this));
        }
    }

    void setHTableSpecificConf() {
        if (this.htableDescriptor == null) {
            return;
        }
        LOG.info((Object)"Setting up tabledescriptor config now ...");
        long flushSize = this.htableDescriptor.getMemStoreFlushSize();
        if (flushSize <= 0L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
        this.memstoreFlushSize = flushSize;
        this.blockingMemStoreSize = this.memstoreFlushSize * this.conf.getLong("hbase.hregion.memstore.block.multiplier", 2L);
    }

    public long initialize() throws IOException {
        return this.initialize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long initialize(CancelableProgressable reporter) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        long nextSeqId = -1L;
        try {
            long l = nextSeqId = this.initializeRegionInternals(reporter, status);
            return l;
        }
        finally {
            if (nextSeqId == -1L) {
                status.abort("Exception during region " + this.getRegionNameAsString() + " initialization.");
            }
        }
    }

    private long initializeRegionInternals(CancelableProgressable reporter, MonitoredTask status) throws IOException, UnsupportedEncodingException {
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-open hook");
            this.coprocessorHost.preOpen();
        }
        status.setStatus("Writing region info on filesystem");
        this.checkRegioninfoOnFilesystem();
        status.setStatus("Cleaning up temporary data from old regions");
        this.cleanupTmpDir();
        TreeMap<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        long maxSeqId = -1L;
        long maxMemstoreTS = -1L;
        if (this.htableDescriptor != null && !this.htableDescriptor.getFamilies().isEmpty()) {
            ThreadPoolExecutor storeOpenerThreadPool = this.getStoreOpenAndCloseThreadPool("StoreOpenerThread-" + this.regionInfo.getRegionNameAsString());
            ExecutorCompletionService<Store> completionService = new ExecutorCompletionService<Store>(storeOpenerThreadPool);
            for (final HColumnDescriptor family : this.htableDescriptor.getFamilies()) {
                status.setStatus("Instantiating store for column family " + family);
                completionService.submit(new Callable<Store>(){

                    @Override
                    public Store call() throws IOException {
                        return HRegion.this.instantiateHStore(HRegion.this.tableDir, family);
                    }
                });
            }
            try {
                for (int i = 0; i < this.htableDescriptor.getFamilies().size(); ++i) {
                    long maxStoreMemstoreTS;
                    Future future = completionService.take();
                    Store store = (Store)future.get();
                    this.stores.put(store.getColumnFamilyName().getBytes(), store);
                    long storeSeqId = store.getMaxSequenceId();
                    maxSeqIdInStores.put(store.getColumnFamilyName().getBytes(), storeSeqId);
                    if (maxSeqId == -1L || storeSeqId > maxSeqId) {
                        maxSeqId = storeSeqId;
                    }
                    if ((maxStoreMemstoreTS = store.getMaxMemstoreTS()) <= maxMemstoreTS) continue;
                    maxMemstoreTS = maxStoreMemstoreTS;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
            finally {
                storeOpenerThreadPool.shutdownNow();
            }
        }
        this.mvcc.initialize(maxMemstoreTS + 1L);
        maxSeqId = Math.max(maxSeqId, this.replayRecoveredEditsIfAny(this.regiondir, maxSeqIdInStores, reporter, status));
        status.setStatus("Cleaning up detritus from prior splits");
        SplitTransaction.cleanupAnySplitDetritus(this);
        FSUtils.deleteDirectory(this.fs, new Path(this.regiondir, MERGEDIR));
        this.writestate.setReadOnly(this.htableDescriptor.isReadOnly());
        this.writestate.flushRequested = false;
        this.writestate.compacting = 0;
        this.splitPolicy = RegionSplitPolicy.create(this, this.conf);
        this.lastFlushTime = EnvironmentEdgeManager.currentTimeMillis();
        long nextSeqid = maxSeqId + 1L;
        LOG.info((Object)("Onlined " + this.toString() + "; next sequenceid=" + nextSeqid));
        this.closing.set(false);
        this.closed.set(false);
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor post-open hooks");
            this.coprocessorHost.postOpen();
        }
        status.markComplete("Region opened successfully");
        return nextSeqid;
    }

    static void moveInitialFilesIntoPlace(FileSystem fs, Path initialFiles, Path regiondir) throws IOException {
        if (initialFiles != null && fs.exists(initialFiles) && !HBaseFileSystem.renameDirForFileSystem(fs, initialFiles, regiondir)) {
            LOG.warn((Object)("Unable to rename " + initialFiles + " to " + regiondir));
        }
    }

    public boolean hasReferences() {
        for (Store store : this.stores.values()) {
            for (StoreFile sf : store.getStorefiles()) {
                if (!sf.isReference()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDFSBlocksDistribution getHDFSBlocksDistribution() {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        Map<byte[], Store> map = this.stores;
        synchronized (map) {
            for (Store store : this.stores.values()) {
                for (StoreFile sf : store.getStorefiles()) {
                    HDFSBlocksDistribution storeFileBlocksDistribution = sf.getHDFSBlockDistribution();
                    hdfsBlocksDistribution.add(storeFileBlocksDistribution);
                }
            }
        }
        return hdfsBlocksDistribution;
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, HTableDescriptor tableDescriptor, String regionEncodedName) throws IOException {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        Path tablePath = FSUtils.getTablePath(FSUtils.getRootDir(conf), tableDescriptor.getName());
        FileSystem fs = tablePath.getFileSystem(conf);
        for (HColumnDescriptor family : tableDescriptor.getFamilies()) {
            Path storeHomeDir = Store.getStoreHomedir(tablePath, regionEncodedName, family.getName());
            if (!fs.exists(storeHomeDir)) continue;
            FileStatus[] hfilesStatus = null;
            for (FileStatus hfileStatus : hfilesStatus = fs.listStatus(storeHomeDir)) {
                HDFSBlocksDistribution storeFileBlocksDistribution = FSUtils.computeHDFSBlocksDistribution(fs, hfileStatus, 0L, hfileStatus.getLen());
                hdfsBlocksDistribution.add(storeFileBlocksDistribution);
            }
        }
        return hdfsBlocksDistribution;
    }

    public AtomicLong getMemstoreSize() {
        return this.memstoreSize;
    }

    public long addAndGetGlobalMemstoreSize(long memStoreSize) {
        if (this.rsAccounting != null) {
            this.rsAccounting.addAndGetGlobalMemstoreSize(memStoreSize);
        }
        return this.memstoreSize.getAndAdd(memStoreSize);
    }

    private void checkRegioninfoOnFilesystem() throws IOException {
        this.checkRegioninfoOnFilesystem(this.regiondir);
    }

    private void checkRegioninfoOnFilesystem(Path regiondir) throws IOException {
        HRegion.writeRegioninfoOnFilesystem(this.regionInfo, regiondir, this.getFilesystem(), this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRegioninfoOnFilesystem(HRegionInfo regionInfo, Path regiondir, FileSystem fs, Configuration conf) throws IOException {
        Path regioninfoPath = new Path(regiondir, REGIONINFO_FILE);
        if (fs.exists(regioninfoPath)) {
            if (fs.getFileStatus(regioninfoPath).getLen() > 0L) {
                return;
            }
            LOG.info((Object)("Rewriting .regioninfo file at: " + regioninfoPath));
            if (!fs.delete(regioninfoPath, false)) {
                throw new IOException("Unable to remove existing " + regioninfoPath);
            }
        }
        FsPermission perms = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        Path tmpPath = new Path(HRegion.getTmpDir(regiondir), REGIONINFO_FILE);
        if (FSUtils.isExists(fs, tmpPath)) {
            FSUtils.delete(fs, tmpPath, true);
        }
        FSDataOutputStream out = FSUtils.create(fs, tmpPath, perms);
        try {
            regionInfo.write((DataOutput)out);
            out.write(10);
            out.write(10);
            out.write(Bytes.toBytes(regionInfo.toString()));
        }
        finally {
            out.close();
        }
        if (!HBaseFileSystem.renameDirForFileSystem(fs, tmpPath, regioninfoPath)) {
            throw new IOException("Unable to rename " + tmpPath + " to " + regioninfoPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRegionInfo loadDotRegionInfoFileContent(FileSystem fs, Path dir) throws IOException {
        Path regioninfo = new Path(dir, REGIONINFO_FILE);
        if (!fs.exists(regioninfo)) {
            throw new FileNotFoundException(regioninfo.toString());
        }
        FSDataInputStream in = fs.open(regioninfo);
        try {
            HRegionInfo hri = new HRegionInfo();
            hri.readFields((DataInput)in);
            HRegionInfo hRegionInfo = hri;
            return hRegionInfo;
        }
        finally {
            in.close();
        }
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    RegionServerServices getRegionServerServices() {
        return this.rsServices;
    }

    public long getRequestsCount() {
        return this.readRequestsCount.get() + this.writeRequestsCount.get();
    }

    public long getReadRequestsCount() {
        return this.readRequestsCount.get();
    }

    public long getWriteRequestsCount() {
        return this.writeRequestsCount.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public boolean isAvailable() {
        return !this.isClosed() && !this.isClosing();
    }

    public boolean isSplittable() {
        return this.isAvailable() && !this.hasReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areWritesEnabled() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            return this.writestate.writesEnabled;
        }
    }

    public MultiVersionConsistencyControl getMVCC() {
        return this.mvcc;
    }

    public boolean isLoadingCfsOnDemandDefault() {
        return this.isLoadingCfsOnDemandDefault;
    }

    public List<StoreFile> close() throws IOException {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StoreFile> close(boolean abort) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Closing region " + this + (abort ? " due to abort" : ""));
        status.setStatus("Waiting for close lock");
        try {
            Object object = this.closeLock;
            synchronized (object) {
                List<StoreFile> list = this.doClose(abort, status);
                return list;
            }
        }
        finally {
            status.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<StoreFile> doClose(boolean abort, MonitoredTask status) throws IOException {
        if (this.isClosed()) {
            LOG.warn((Object)("Region " + this + " already closed"));
            return null;
        }
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-close hooks");
            this.coprocessorHost.preClose(abort);
        }
        status.setStatus("Disabling compacts and flushes for region");
        boolean wasFlushing = false;
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            this.writestate.writesEnabled = false;
            wasFlushing = this.writestate.flushing;
            LOG.debug((Object)("Closing " + this + ": disabling compactions & flushes"));
            this.waitForFlushesAndCompactions();
        }
        if (!abort && !wasFlushing && this.worthPreFlushing()) {
            status.setStatus("Pre-flushing region before close");
            LOG.info((Object)("Running close preflush of " + this.getRegionNameAsString()));
            this.internalFlushcache(status);
        }
        this.closing.set(true);
        status.setStatus("Disabling writes for close");
        this.lock.writeLock().lock();
        try {
            if (this.isClosed()) {
                status.abort("Already got closed by another process");
                writeState = null;
                return writeState;
            }
            LOG.debug((Object)("Updates disabled for region " + this));
            if (!abort) {
                this.internalFlushcache(status);
            }
            ArrayList<StoreFile> result = new ArrayList<StoreFile>();
            if (!this.stores.isEmpty()) {
                ThreadPoolExecutor storeCloserThreadPool = this.getStoreOpenAndCloseThreadPool("StoreCloserThread-" + this.regionInfo.getRegionNameAsString());
                ExecutorCompletionService<ImmutableList<StoreFile>> completionService = new ExecutorCompletionService<ImmutableList<StoreFile>>(storeCloserThreadPool);
                for (final Store store : this.stores.values()) {
                    completionService.submit(new Callable<ImmutableList<StoreFile>>(){

                        @Override
                        public ImmutableList<StoreFile> call() throws IOException {
                            return store.close();
                        }
                    });
                }
                try {
                    for (int i = 0; i < this.stores.size(); ++i) {
                        Future future = completionService.take();
                        ImmutableList storeFileList = (ImmutableList)future.get();
                        result.addAll((Collection<StoreFile>)storeFileList);
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                catch (ExecutionException e) {
                    throw new IOException(e.getCause());
                }
                finally {
                    storeCloserThreadPool.shutdownNow();
                }
            }
            this.closed.set(true);
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor post-close hooks");
                this.coprocessorHost.postClose(abort);
            }
            this.opMetrics.closeMetrics(this.getRegionInfo().getEncodedName());
            status.markComplete("Closed");
            LOG.info((Object)("Closed " + this));
            ArrayList<StoreFile> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFlushesAndCompactions() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            while (this.writestate.compacting > 0 || this.writestate.flushing) {
                LOG.debug((Object)("waiting for " + this.writestate.compacting + " compactions" + (this.writestate.flushing ? " & cache flush" : "") + " to complete for region " + this));
                try {
                    this.writestate.wait();
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected ThreadPoolExecutor getStoreOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getFamilies().size());
        int maxThreads = Math.min(numStores, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1));
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    protected ThreadPoolExecutor getStoreFileOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getFamilies().size());
        int maxThreads = Math.max(1, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1) / numStores);
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    static ThreadPoolExecutor getOpenAndCloseThreadPool(int maxThreads, final String threadNamePrefix) {
        return Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadNamePrefix + "-" + this.count++);
            }
        });
    }

    private boolean worthPreFlushing() {
        return this.memstoreSize.get() > this.conf.getLong("hbase.hregion.preclose.flush.size", 0x500000L);
    }

    public byte[] getStartKey() {
        return this.regionInfo.getStartKey();
    }

    public byte[] getEndKey() {
        return this.regionInfo.getEndKey();
    }

    public long getRegionId() {
        return this.regionInfo.getRegionId();
    }

    public byte[] getRegionName() {
        return this.regionInfo.getRegionName();
    }

    public String getRegionNameAsString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public HTableDescriptor getTableDesc() {
        return this.htableDescriptor;
    }

    public HLog getLog() {
        return this.log;
    }

    public Configuration getConf() {
        return this.conf;
    }

    Configuration getBaseConf() {
        return this.baseConf;
    }

    public Path getRegionDir() {
        return this.regiondir;
    }

    public static Path getRegionDir(Path tabledir, String name) {
        return new Path(tabledir, name);
    }

    public FileSystem getFilesystem() {
        return this.fs;
    }

    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    public List<Pair<Long, Long>> getRecentFlushInfo() {
        this.lock.readLock().lock();
        List<Pair<Long, Long>> ret = this.recentFlushes;
        this.recentFlushes = new ArrayList<Pair<Long, Long>>();
        this.lock.readLock().unlock();
        return ret;
    }

    public long getLargestHStoreSize() {
        long size = 0L;
        for (Store h : this.stores.values()) {
            long storeSize = h.getSize();
            if (storeSize <= size) continue;
            size = storeSize;
        }
        return size;
    }

    void doRegionCompactionPrep() throws IOException {
    }

    private void cleanupTmpDir() throws IOException {
        FSUtils.deleteDirectory(this.fs, this.getTmpDir());
    }

    Path getTmpDir() {
        return HRegion.getTmpDir(this.getRegionDir());
    }

    static Path getTmpDir(Path regionDir) {
        return new Path(regionDir, REGION_TEMP_SUBDIR);
    }

    void triggerMajorCompaction() {
        for (Store h : this.stores.values()) {
            h.triggerMajorCompaction();
        }
    }

    public void compactStores(boolean majorCompaction) throws IOException {
        if (majorCompaction) {
            this.triggerMajorCompaction();
        }
        this.compactStores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactStores() throws IOException {
        for (Store s : this.getStores().values()) {
            CompactionRequest cr = s.requestCompaction();
            if (cr == null) continue;
            try {
                this.compact(cr);
            }
            finally {
                s.finishRequest(cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compact(CompactionRequest cr) throws IOException {
        if (cr == null) {
            return false;
        }
        if (this.closing.get() || this.closed.get()) {
            LOG.debug((Object)("Skipping compaction on " + this + " because closing/closed"));
            return false;
        }
        Preconditions.checkArgument((boolean)cr.getHRegion().equals(this));
        this.lock.readLock().lock();
        MonitoredTask status = TaskMonitor.get().createStatus("Compacting " + cr.getStore() + " in " + this);
        try {
            if (this.closed.get()) {
                LOG.debug((Object)("Skipping compaction on " + this + " because closed"));
                boolean bl = false;
                return bl;
            }
            boolean decr = true;
            try {
                WriteState writeState = this.writestate;
                synchronized (writeState) {
                    if (!this.writestate.writesEnabled) {
                        String msg = "NOT compacting region " + this + ". Writes disabled.";
                        LOG.info((Object)msg);
                        status.abort(msg);
                        decr = false;
                        boolean bl = false;
                        return bl;
                    }
                    ++this.writestate.compacting;
                }
                LOG.info((Object)("Starting compaction on " + cr.getStore() + " in region " + this + (cr.getCompactSelection().isOffPeakCompaction() ? " as an off-peak compaction" : "")));
                this.doRegionCompactionPrep();
                try {
                    status.setStatus("Compacting store " + cr.getStore());
                    cr.getStore().compact(cr);
                }
                catch (InterruptedIOException iioe) {
                    String msg = "compaction interrupted by user";
                    LOG.info((Object)msg, (Throwable)iioe);
                    status.abort(msg);
                    boolean bl = false;
                    if (decr) {
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            --this.writestate.compacting;
                            if (this.writestate.compacting <= 0) {
                                this.writestate.notifyAll();
                            }
                        }
                    }
                    status.cleanup();
                    this.lock.readLock().unlock();
                    return bl;
                }
            }
            finally {
                if (decr) {
                    WriteState writeState = this.writestate;
                    synchronized (writeState) {
                        --this.writestate.compacting;
                        if (this.writestate.compacting <= 0) {
                            this.writestate.notifyAll();
                        }
                    }
                }
            }
            status.markComplete("Compaction complete");
            boolean bl = true;
            return bl;
        }
        finally {
            status.cleanup();
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean flushcache() throws IOException {
        if (this.closing.get()) {
            HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closing"));
            return false;
        }
        status = TaskMonitor.get().createStatus("Flushing " + this);
        status.setStatus("Acquiring readlock on region");
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                HRegion.LOG.debug((Object)("Skipping flush on " + this + " because closed"));
                status.abort("Skipped: closed");
                var2_2 = false;
                return var2_2;
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor pre-flush hooks");
                this.coprocessorHost.preFlush();
            }
            if (this.numPutsWithoutWAL.get() > 0L) {
                this.numPutsWithoutWAL.set(0L);
                this.dataInMemoryWithoutWAL.set(0L);
            }
            var2_3 = this.writestate;
            synchronized (var2_3) {
                if (this.writestate.flushing || !this.writestate.writesEnabled) {
                    if (HRegion.LOG.isDebugEnabled()) {
                        HRegion.LOG.debug((Object)("NOT flushing memstore for region " + this + ", flushing=" + this.writestate.flushing + ", writesEnabled=" + this.writestate.writesEnabled));
                    }
                    status.abort("Not flushing since " + (this.writestate.flushing != false ? "already flushing" : "writes not enabled"));
                    var3_5 = false;
                    return var3_5;
                }
                this.writestate.flushing = true;
                ** try [egrp 4[TRYBLOCK] [1 : 391->396)] { 
                {
                }
            }
lbl33:
            // 1 sources

            try {
                result = this.internalFlushcache(status);
                if (this.coprocessorHost != null) {
                    status.setStatus("Running post-flush coprocessor hooks");
                    this.coprocessorHost.postFlush();
                }
                status.markComplete("Flush successful");
                var3_6 = result;
                var4_8 = this.writestate;
            }
            catch (Throwable var6_10) {
                var7_11 = this.writestate;
                synchronized (var7_11) {
                    this.writestate.flushing = false;
                    this.writestate.flushRequested = false;
                    this.writestate.notifyAll();
                }
                throw var6_10;
            }
            synchronized (var4_8) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var3_6;
        }
        finally {
            this.lock.readLock().unlock();
            status.cleanup();
        }
    }

    boolean shouldFlush() {
        if (this.flushCheckInterval <= 0L) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        if (now - this.getLastFlushTime() < this.flushCheckInterval) {
            return false;
        }
        for (Store s : this.getStores().values()) {
            if (s.timeOfOldestEdit() >= now - this.flushCheckInterval) continue;
            return true;
        }
        return false;
    }

    protected boolean internalFlushcache(MonitoredTask status) throws IOException {
        return this.internalFlushcache(this.log, -1L, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalFlushcache(HLog wal, long myseqid, MonitoredTask status) throws IOException {
        long startTime;
        if (this.rsServices != null && this.rsServices.isAborted()) {
            throw new IOException("Aborting flush because server is abortted...");
        }
        this.lastFlushTime = startTime = EnvironmentEdgeManager.currentTimeMillis();
        if (this.memstoreSize.get() <= 0L) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Started memstore flush for " + this + ", current region memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + (wal != null ? "" : "; wal is null, using passed sequenceid=" + myseqid)));
        }
        long sequenceId = -1L;
        long completeSequenceId = -1L;
        MultiVersionConsistencyControl.WriteEntry w = null;
        status.setStatus("Obtaining lock to block concurrent updates");
        this.updatesLock.writeLock().lock();
        long flushsize = this.memstoreSize.get();
        status.setStatus("Preparing to flush by snapshotting stores");
        ArrayList<StoreFlusher> storeFlushers = new ArrayList<StoreFlusher>(this.stores.size());
        try {
            w = this.mvcc.beginMemstoreInsert();
            this.mvcc.advanceMemstore(w);
            sequenceId = wal == null ? myseqid : wal.startCacheFlush(this.regionInfo.getEncodedNameAsBytes());
            completeSequenceId = this.getCompleteCacheFlushSequenceId(sequenceId);
            for (Store s : this.stores.values()) {
                storeFlushers.add(s.getStoreFlusher(completeSequenceId));
            }
            for (StoreFlusher flusher : storeFlushers) {
                flusher.prepare();
            }
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        String s = "Finished snapshotting " + this + ", commencing wait for mvcc, flushsize=" + flushsize;
        status.setStatus(s);
        LOG.debug((Object)s);
        if (wal != null && this.isDeferredLogSyncEnabled()) {
            wal.sync();
        }
        this.mvcc.waitForRead(w);
        status.setStatus("Flushing stores");
        LOG.debug((Object)"Finished snapshotting, commencing flushing stores");
        boolean compactionRequested = false;
        try {
            for (StoreFlusher flusher : storeFlushers) {
                flusher.flushCache(status);
            }
            for (StoreFlusher flusher : storeFlushers) {
                boolean needsCompaction = flusher.commit(status);
                if (!needsCompaction) continue;
                compactionRequested = true;
            }
            storeFlushers.clear();
            this.addAndGetGlobalMemstoreSize(-flushsize);
        }
        catch (Throwable t) {
            if (wal != null) {
                wal.abortCacheFlush(this.regionInfo.getEncodedNameAsBytes());
            }
            DroppedSnapshotException dse = new DroppedSnapshotException("region: " + Bytes.toStringBinary(this.getRegionName()));
            dse.initCause(t);
            status.abort("Flush failed: " + StringUtils.stringifyException((Throwable)t));
            throw dse;
        }
        if (wal != null) {
            wal.completeCacheFlush(this.regionInfo.getEncodedNameAsBytes(), this.regionInfo.getTableName(), completeSequenceId, this.getRegionInfo().isMetaRegion());
        }
        HRegion t = this;
        synchronized (t) {
            this.notifyAll();
        }
        long time = EnvironmentEdgeManager.currentTimeMillis() - startTime;
        long memstoresize = this.memstoreSize.get();
        String msg = "Finished memstore flush of ~" + StringUtils.humanReadableInt((long)flushsize) + "/" + flushsize + ", currentsize=" + StringUtils.humanReadableInt((long)memstoresize) + "/" + memstoresize + " for region " + this + " in " + time + "ms, sequenceid=" + sequenceId + ", compaction requested=" + compactionRequested + (wal == null ? "; wal=null" : "");
        LOG.info((Object)msg);
        status.setStatus(msg);
        this.recentFlushes.add(new Pair<Long, Long>(time / 1000L, flushsize));
        return compactionRequested;
    }

    protected long getCompleteCacheFlushSequenceId(long currentSequenceId) {
        return currentSequenceId;
    }

    Result getClosestRowBefore(byte[] row) throws IOException {
        return this.getClosestRowBefore(row, HConstants.CATALOG_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getClosestRowBefore(byte[] row, byte[] family) throws IOException {
        Result result;
        if (this.coprocessorHost != null && this.coprocessorHost.preGetClosestRowBefore(row, family, result = new Result())) {
            return result;
        }
        this.checkRow(row, "getClosestRowBefore");
        this.startRegionOperation();
        this.readRequestsCount.increment();
        this.opMetrics.setReadRequestCountMetrics(this.readRequestsCount.get());
        try {
            Store store = this.getStore(family);
            KeyValue key = store.getRowKeyAtOrBefore(row);
            Result result2 = null;
            if (key != null) {
                Get get2 = new Get(key.getRow());
                get2.addFamily(family);
                result2 = this.get(get2, null);
            }
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postGetClosestRowBefore(row, family, result2);
            }
            Result result3 = result2;
            return result3;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public RegionScanner getScanner(Scan scan) throws IOException {
        return this.getScanner(scan, null);
    }

    void prepareScanner(Scan scan) throws IOException {
        if (!scan.hasFamilies()) {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                scan.addFamily(family);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegionScanner getScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        this.startRegionOperation();
        try {
            this.prepareScanner(scan);
            if (scan.hasFamilies()) {
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    this.checkFamily(family);
                }
            }
            RegionScanner regionScanner = this.instantiateRegionScanner(scan, additionalScanners);
            return regionScanner;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    protected RegionScanner instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        return new RegionScannerImpl(scan, additionalScanners, this);
    }

    private void prepareDelete(Delete delete) throws IOException {
        if (delete.getFamilyMap().isEmpty()) {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                delete.deleteFamily(family, delete.getTimeStamp());
            }
        } else {
            for (byte[] family : delete.getFamilyMap().keySet()) {
                if (family == null) {
                    throw new NoSuchColumnFamilyException("Empty family is invalid");
                }
                this.checkFamily(family);
            }
        }
    }

    public void delete(Delete delete, boolean writeToWAL) throws IOException {
        this.delete(delete, null, writeToWAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Delete delete, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        Integer lid = null;
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
        try {
            byte[] row = delete.getRow();
            lid = this.getLock(lockid, row, true);
            try {
                this.prepareDelete(delete);
                this.internalDelete(delete, delete.getClusterId(), writeToWAL);
            }
            finally {
                if (lockid == null) {
                    this.releaseRowLock(lid);
                }
            }
        }
        finally {
            this.closeRegionOperation();
        }
    }

    void delete(Map<byte[], List<KeyValue>> familyMap, UUID clusterId, boolean writeToWAL) throws IOException {
        Delete delete = new Delete();
        delete.setFamilyMap(familyMap);
        delete.setClusterId(clusterId);
        delete.setWriteToWAL(writeToWAL);
        this.internalDelete(delete, clusterId, writeToWAL);
    }

    private void prepareDeleteTimestamps(Map<byte[], List<KeyValue>> familyMap, byte[] byteNow) throws IOException {
        for (Map.Entry<byte[], List<KeyValue>> e : familyMap.entrySet()) {
            byte[] family = e.getKey();
            List<KeyValue> kvs = e.getValue();
            TreeMap<byte[], Integer> kvCount = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            for (KeyValue kv : kvs) {
                if (kv.isLatestTimestamp() && kv.isDeleteType()) {
                    Integer count;
                    byte[] qual = kv.getQualifier();
                    if (qual == null) {
                        qual = HConstants.EMPTY_BYTE_ARRAY;
                    }
                    if ((count = (Integer)kvCount.get(qual)) == null) {
                        kvCount.put(qual, 1);
                    } else {
                        kvCount.put(qual, count + 1);
                    }
                    count = (Integer)kvCount.get(qual);
                    Get get2 = new Get(kv.getRow());
                    get2.setMaxVersions(count);
                    get2.addColumn(family, qual);
                    List<KeyValue> result = this.get(get2, false);
                    if (result.size() < count) {
                        kv.updateLatestStamp(byteNow);
                        continue;
                    }
                    if (result.size() > count) {
                        throw new RuntimeException("Unexpected size: " + result.size());
                    }
                    KeyValue getkv = result.get(count - 1);
                    Bytes.putBytes(kv.getBuffer(), kv.getTimestampOffset(), getkv.getBuffer(), getkv.getTimestampOffset(), 8);
                    continue;
                }
                kv.updateLatestStamp(byteNow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalDelete(Delete delete, UUID clusterId, boolean writeToWAL) throws IOException {
        Map<byte[], List<KeyValue>> familyMap = delete.getFamilyMap();
        WALEdit walEdit = new WALEdit();
        if (this.coprocessorHost != null && this.coprocessorHost.preDelete(delete, walEdit, writeToWAL)) {
            return;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes(now);
        boolean flush = false;
        this.lock(this.updatesLock.readLock());
        try {
            this.prepareDeleteTimestamps(delete.getFamilyMap(), byteNow);
            if (writeToWAL) {
                this.addFamilyMapToWALEdit(familyMap, walEdit);
                walEdit.addClusterIds(delete.getClusterIds());
                this.log.append(this.regionInfo, this.htableDescriptor.getName(), walEdit, clusterId, now, this.htableDescriptor);
            }
            long addedSize = this.applyFamilyMapToMemstore(familyMap, null);
            flush = this.isFlushSize(this.addAndGetGlobalMemstoreSize(addedSize));
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postDelete(delete, walEdit, writeToWAL);
        }
        long after = EnvironmentEdgeManager.currentTimeMillis();
        this.opMetrics.updateDeleteMetrics(familyMap.keySet(), after - now);
        if (flush) {
            this.requestFlush();
        }
    }

    public void put(Put put2) throws IOException {
        this.put(put2, null, put2.getWriteToWAL());
    }

    public void put(Put put2, boolean writeToWAL) throws IOException {
        this.put(put2, null, writeToWAL);
    }

    public void put(Put put2, Integer lockid) throws IOException {
        this.put(put2, lockid, put2.getWriteToWAL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Put put2, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
        try {
            byte[] row = put2.getRow();
            Integer lid = this.getLock(lockid, row, true);
            try {
                this.internalPut(put2, put2.getClusterId(), writeToWAL);
            }
            finally {
                if (lockid == null) {
                    this.releaseRowLock(lid);
                }
            }
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public OperationStatus[] put(Put[] puts) throws IOException {
        Pair[] putsAndLocks = new Pair[puts.length];
        for (int i = 0; i < puts.length; ++i) {
            putsAndLocks[i] = new Pair<Put, Object>(puts[i], null);
        }
        return this.batchMutate(putsAndLocks);
    }

    @Deprecated
    public OperationStatus[] put(Pair<Put, Integer>[] putsAndLocks) throws IOException {
        Pair[] mutationsAndLocks = new Pair[putsAndLocks.length];
        System.arraycopy(putsAndLocks, 0, mutationsAndLocks, 0, putsAndLocks.length);
        return this.batchMutate(mutationsAndLocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus[] batchMutate(Pair<Mutation, Integer>[] mutationsAndLocks) throws IOException {
        BatchOperationInProgress<Pair<Mutation, Integer>> batchOp = new BatchOperationInProgress<Pair<Mutation, Integer>>(mutationsAndLocks);
        boolean initialized = false;
        while (!batchOp.isDone()) {
            long newSize;
            this.checkReadOnly();
            this.checkResources();
            this.startRegionOperation();
            try {
                if (!initialized) {
                    this.writeRequestsCount.increment();
                    this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
                    this.doPreMutationHook(batchOp);
                    initialized = true;
                }
                long addedSize = this.doMiniBatchMutation(batchOp);
                newSize = this.addAndGetGlobalMemstoreSize(addedSize);
            }
            finally {
                this.closeRegionOperation();
            }
            if (!this.isFlushSize(newSize)) continue;
            this.requestFlush();
        }
        return batchOp.retCodeDetails;
    }

    private void doPreMutationHook(BatchOperationInProgress<Pair<Mutation, Integer>> batchOp) throws IOException {
        WALEdit walEdit = new WALEdit();
        if (this.coprocessorHost != null) {
            for (int i = 0; i < ((Pair[])batchOp.operations).length; ++i) {
                Pair nextPair = ((Pair[])batchOp.operations)[i];
                Mutation m = (Mutation)nextPair.getFirst();
                if (m instanceof Put) {
                    if (this.coprocessorHost.prePut((Put)m, walEdit, m.getWriteToWAL())) {
                        batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    }
                } else if (m instanceof Delete) {
                    if (this.coprocessorHost.preDelete((Delete)m, walEdit, m.getWriteToWAL())) {
                        batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    }
                } else {
                    batchOp.retCodeDetails[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, "Put/Delete mutations only supported in batchMutate() now");
                }
                if (walEdit.isEmpty()) continue;
                batchOp.walEditsFromCoprocessors[i] = walEdit;
                walEdit = new WALEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doMiniBatchMutation(BatchOperationInProgress<Pair<Mutation, Integer>> batchOp) throws IOException {
        long l;
        int noOfDeletes;
        int noOfPuts;
        boolean success;
        int lastIndexExclusive;
        long startTimeMs;
        boolean deletesCfSetConsistent;
        Set<byte[]> deletesCfSet;
        boolean putsCfSetConsistent;
        Set<byte[]> putsCfSet;
        block77: {
            long now;
            int firstIndex;
            Map[] familyMaps;
            HashSet rowsAlreadyLocked;
            ArrayList acquiredLocks;
            boolean locked;
            boolean walSyncSuccessful;
            long txid;
            MultiVersionConsistencyControl.WriteEntry w;
            WALEdit walEdit;
            block75: {
                long l2;
                block76: {
                    MiniBatchOperationInProgress<Pair<Mutation, Integer>> miniBatchOp;
                    byte[] byteNow;
                    int numReadyToWrite;
                    block73: {
                        long mutation2;
                        block74: {
                            putsCfSet = null;
                            putsCfSetConsistent = true;
                            deletesCfSet = null;
                            deletesCfSetConsistent = true;
                            startTimeMs = EnvironmentEdgeManager.currentTimeMillis();
                            walEdit = new WALEdit();
                            w = null;
                            txid = 0L;
                            walSyncSuccessful = false;
                            locked = false;
                            acquiredLocks = Lists.newArrayListWithCapacity((int)((Pair[])batchOp.operations).length);
                            rowsAlreadyLocked = Sets.newHashSet();
                            familyMaps = new Map[((Pair[])batchOp.operations).length];
                            lastIndexExclusive = firstIndex = batchOp.nextIndexToProcess;
                            success = false;
                            noOfPuts = 0;
                            noOfDeletes = 0;
                            numReadyToWrite = 0;
                            now = EnvironmentEdgeManager.currentTimeMillis();
                            while (lastIndexExclusive < ((Pair[])batchOp.operations).length) {
                                Map<byte[], List<KeyValue>> familyMap;
                                Pair nextPair = ((Pair[])batchOp.operations)[lastIndexExclusive];
                                Mutation mutation2 = (Mutation)nextPair.getFirst();
                                Integer providedLockId = (Integer)nextPair.getSecond();
                                familyMaps[lastIndexExclusive] = familyMap = mutation2.getFamilyMap();
                                if (batchOp.retCodeDetails[lastIndexExclusive].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) {
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                try {
                                    if (mutation2 instanceof Put) {
                                        this.checkFamilies(familyMap.keySet());
                                        this.checkTimestamps(mutation2.getFamilyMap(), now);
                                    } else {
                                        this.prepareDelete((Delete)mutation2);
                                    }
                                }
                                catch (NoSuchColumnFamilyException nscf) {
                                    LOG.warn((Object)"No such column family in batch mutation", (Throwable)nscf);
                                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.BAD_FAMILY, nscf.getMessage());
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                catch (DoNotRetryIOException fsce) {
                                    LOG.warn((Object)"Batch Mutation did not pass sanity check", (Throwable)fsce);
                                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, fsce.getMessage());
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                boolean shouldBlock = numReadyToWrite == 0;
                                boolean failedToAcquire = false;
                                Integer acquiredLockId = null;
                                HashedBytes currentRow = new HashedBytes(mutation2.getRow());
                                try {
                                    if (providedLockId != null || !rowsAlreadyLocked.contains(currentRow)) {
                                        acquiredLockId = this.getLock(providedLockId, currentRow, shouldBlock);
                                        if (acquiredLockId == null) {
                                            failedToAcquire = true;
                                        } else if (providedLockId == null) {
                                            rowsAlreadyLocked.add(currentRow);
                                        }
                                    }
                                }
                                catch (IOException ioe) {
                                    LOG.warn((Object)("Failed getting lock in batch put, row=" + currentRow), (Throwable)ioe);
                                    failedToAcquire = true;
                                }
                                if (failedToAcquire) {
                                    assert (!shouldBlock) : "Should never fail to get lock when blocking";
                                    break;
                                }
                                if (providedLockId == null) {
                                    acquiredLocks.add(acquiredLockId);
                                }
                                ++lastIndexExclusive;
                                ++numReadyToWrite;
                                if (mutation2 instanceof Put) {
                                    if (putsCfSet == null) {
                                        putsCfSet = mutation2.getFamilyMap().keySet();
                                        continue;
                                    }
                                    putsCfSetConsistent = putsCfSetConsistent && ((Object)mutation2.getFamilyMap().keySet()).equals(putsCfSet);
                                    continue;
                                }
                                if (deletesCfSet == null) {
                                    deletesCfSet = mutation2.getFamilyMap().keySet();
                                    continue;
                                }
                                deletesCfSetConsistent = deletesCfSetConsistent && ((Object)mutation2.getFamilyMap().keySet()).equals(deletesCfSet);
                            }
                            now = EnvironmentEdgeManager.currentTimeMillis();
                            byteNow = Bytes.toBytes(now);
                            if (numReadyToWrite > 0) break block73;
                            mutation2 = 0L;
                            if (!walSyncSuccessful) {
                                this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                            }
                            if (w != null) {
                                this.mvcc.completeMemstoreInsert(w);
                            }
                            if (locked) {
                                this.updatesLock.readLock().unlock();
                            }
                            if (acquiredLocks == null) break block74;
                            for (Integer toRelease : acquiredLocks) {
                                this.releaseRowLock(toRelease);
                            }
                        }
                        long netTimeMs = EnvironmentEdgeManager.currentTimeMillis() - startTimeMs;
                        long timeTakenForPuts = 0L;
                        if (noOfPuts > 0) {
                            double noOfMutations = noOfPuts + noOfDeletes;
                            timeTakenForPuts = (long)((double)netTimeMs * ((double)noOfPuts / noOfMutations));
                            Set<byte[]> keptCfs = putsCfSetConsistent ? putsCfSet : null;
                            this.opMetrics.updateMultiPutMetrics(keptCfs, timeTakenForPuts);
                        }
                        if (noOfDeletes > 0) {
                            Set<byte[]> keptCfs = deletesCfSetConsistent ? deletesCfSet : null;
                            this.opMetrics.updateMultiDeleteMetrics(keptCfs, netTimeMs - timeTakenForPuts);
                        }
                        if (!success) {
                            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                                batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                            }
                        }
                        batchOp.nextIndexToProcess = lastIndexExclusive;
                        return mutation2;
                    }
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        Mutation mutation = (Mutation)((Pair[])batchOp.operations)[i].getFirst();
                        if (mutation instanceof Put) {
                            this.updateKVTimestamps(familyMaps[i].values(), byteNow);
                            ++noOfPuts;
                            continue;
                        }
                        this.prepareDeleteTimestamps(familyMaps[i], byteNow);
                        ++noOfDeletes;
                    }
                    this.lock(this.updatesLock.readLock(), numReadyToWrite);
                    locked = true;
                    w = this.mvcc.beginMemstoreInsert();
                    if (this.coprocessorHost == null || !this.coprocessorHost.preBatchMutate(miniBatchOp = new MiniBatchOperationInProgress<Pair<Mutation, Integer>>(batchOp.operations, batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive))) break block75;
                    l2 = 0L;
                    if (!walSyncSuccessful) {
                        this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                    }
                    if (w != null) {
                        this.mvcc.completeMemstoreInsert(w);
                    }
                    if (locked) {
                        this.updatesLock.readLock().unlock();
                    }
                    if (acquiredLocks == null) break block76;
                    for (Integer toRelease : acquiredLocks) {
                        this.releaseRowLock(toRelease);
                    }
                }
                long netTimeMs = EnvironmentEdgeManager.currentTimeMillis() - startTimeMs;
                long timeTakenForPuts = 0L;
                if (noOfPuts > 0) {
                    double noOfMutations = noOfPuts + noOfDeletes;
                    timeTakenForPuts = (long)((double)netTimeMs * ((double)noOfPuts / noOfMutations));
                    Set<byte[]> keptCfs = putsCfSetConsistent ? putsCfSet : null;
                    this.opMetrics.updateMultiPutMetrics(keptCfs, timeTakenForPuts);
                }
                if (noOfDeletes > 0) {
                    Set<byte[]> keptCfs = deletesCfSetConsistent ? deletesCfSet : null;
                    this.opMetrics.updateMultiDeleteMetrics(keptCfs, netTimeMs - timeTakenForPuts);
                }
                if (!success) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                    }
                }
                batchOp.nextIndexToProcess = lastIndexExclusive;
                return l2;
            }
            try {
                long addedSize = 0L;
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    addedSize += this.applyFamilyMapToMemstore(familyMaps[i], w);
                }
                Durability durability = Durability.USE_DEFAULT;
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    Mutation m = (Mutation)((Pair[])batchOp.operations)[i].getFirst();
                    Durability tmpDur = m.getDurability();
                    if (tmpDur.ordinal() > durability.ordinal()) {
                        durability = tmpDur;
                    }
                    if (tmpDur == Durability.SKIP_WAL) {
                        if (!(m instanceof Put)) continue;
                        this.recordPutWithoutWal(m.getFamilyMap());
                        continue;
                    }
                    WALEdit fromCP = batchOp.walEditsFromCoprocessors[i];
                    if (fromCP != null) {
                        for (KeyValue kv : fromCP.getKeyValues()) {
                            walEdit.add(kv);
                        }
                    }
                    this.addFamilyMapToWALEdit(familyMaps[i], walEdit);
                }
                Mutation first = (Mutation)((Pair[])batchOp.operations)[firstIndex].getFirst();
                walEdit.addClusterIds(first.getClusterIds());
                txid = this.log.appendNoSync(this.regionInfo, this.htableDescriptor.getName(), walEdit, first.getClusterId(), now, this.htableDescriptor);
                if (locked) {
                    this.updatesLock.readLock().unlock();
                    locked = false;
                }
                if (acquiredLocks != null) {
                    for (Integer toRelease : acquiredLocks) {
                        this.releaseRowLock(toRelease);
                    }
                    acquiredLocks = null;
                    rowsAlreadyLocked = null;
                }
                if (walEdit.size() > 0) {
                    this.syncOrDefer(txid, durability);
                }
                walSyncSuccessful = true;
                if (this.coprocessorHost != null) {
                    MiniBatchOperationInProgress<Pair<Mutation, Integer>> miniBatchOp = new MiniBatchOperationInProgress<Pair<Mutation, Integer>>(batchOp.operations, batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                    this.coprocessorHost.postBatchMutate(miniBatchOp);
                }
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                    w = null;
                }
                if (this.coprocessorHost != null) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) continue;
                        Mutation m = (Mutation)((Pair[])batchOp.operations)[i].getFirst();
                        if (m instanceof Put) {
                            this.coprocessorHost.postPut((Put)m, walEdit, m.getWriteToWAL());
                            continue;
                        }
                        this.coprocessorHost.postDelete((Delete)m, walEdit, m.getWriteToWAL());
                    }
                }
                success = true;
                l = addedSize;
                if (!walSyncSuccessful) {
                    this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                }
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                if (acquiredLocks == null) break block77;
            }
            catch (Throwable throwable) {
                if (!walSyncSuccessful) {
                    this.rollbackMemstore(batchOp, familyMaps, firstIndex, lastIndexExclusive);
                }
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                if (acquiredLocks != null) {
                    for (Integer toRelease : acquiredLocks) {
                        this.releaseRowLock(toRelease);
                    }
                }
                long netTimeMs = EnvironmentEdgeManager.currentTimeMillis() - startTimeMs;
                long timeTakenForPuts = 0L;
                if (noOfPuts > 0) {
                    double noOfMutations = noOfPuts + noOfDeletes;
                    timeTakenForPuts = (long)((double)netTimeMs * ((double)noOfPuts / noOfMutations));
                    Set<byte[]> keptCfs = putsCfSetConsistent ? putsCfSet : null;
                    this.opMetrics.updateMultiPutMetrics(keptCfs, timeTakenForPuts);
                }
                if (noOfDeletes > 0) {
                    Set<byte[]> keptCfs = deletesCfSetConsistent ? deletesCfSet : null;
                    this.opMetrics.updateMultiDeleteMetrics(keptCfs, netTimeMs - timeTakenForPuts);
                }
                if (!success) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                    }
                }
                batchOp.nextIndexToProcess = lastIndexExclusive;
                throw throwable;
            }
            for (Integer toRelease : acquiredLocks) {
                this.releaseRowLock(toRelease);
            }
        }
        long netTimeMs = EnvironmentEdgeManager.currentTimeMillis() - startTimeMs;
        long timeTakenForPuts = 0L;
        if (noOfPuts > 0) {
            double noOfMutations = noOfPuts + noOfDeletes;
            timeTakenForPuts = (long)((double)netTimeMs * ((double)noOfPuts / noOfMutations));
            Set<byte[]> keptCfs = putsCfSetConsistent ? putsCfSet : null;
            this.opMetrics.updateMultiPutMetrics(keptCfs, timeTakenForPuts);
        }
        if (noOfDeletes > 0) {
            Set<byte[]> keptCfs = deletesCfSetConsistent ? deletesCfSet : null;
            this.opMetrics.updateMultiDeleteMetrics(keptCfs, netTimeMs - timeTakenForPuts);
        }
        if (!success) {
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
            }
        }
        batchOp.nextIndexToProcess = lastIndexExclusive;
        return l;
    }

    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Writable w, boolean writeToWAL) throws IOException {
        return this.checkAndMutate(row, family, qualifier, compareOp, comparator, w, null, writeToWAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Writable w, Integer lockId, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        boolean isPut = w instanceof Put;
        if (!isPut && !(w instanceof Delete)) {
            throw new DoNotRetryIOException("Action must be Put or Delete");
        }
        Row r = (Row)w;
        if (!Bytes.equals(row, r.getRow())) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
        try {
            Integer lid;
            block28: {
                RowLock lock = isPut ? ((Put)w).getRowLock() : ((Delete)w).getRowLock();
                Get get2 = new Get(row, lock);
                this.checkFamily(family);
                get2.addColumn(family, qualifier);
                lid = this.getLock(lockId, get2.getRow(), true);
                this.mvcc.completeMemstoreInsert(this.mvcc.beginMemstoreInsert());
                List<Object> result = new ArrayList();
                try {
                    result = this.get(get2, false);
                    boolean valueIsNull = comparator.getValue() == null || comparator.getValue().length == 0;
                    boolean matches = false;
                    if (result.size() == 0 && valueIsNull) {
                        matches = true;
                    } else if (result.size() > 0 && ((KeyValue)result.get(0)).getValue().length == 0 && valueIsNull) {
                        matches = true;
                    } else if (result.size() == 1 && !valueIsNull) {
                        KeyValue kv = (KeyValue)result.get(0);
                        int compareResult = comparator.compareTo(kv.getBuffer(), kv.getValueOffset(), kv.getValueLength());
                        switch (compareOp) {
                            case LESS: {
                                matches = compareResult <= 0;
                                break;
                            }
                            case LESS_OR_EQUAL: {
                                matches = compareResult < 0;
                                break;
                            }
                            case EQUAL: {
                                matches = compareResult == 0;
                                break;
                            }
                            case NOT_EQUAL: {
                                matches = compareResult != 0;
                                break;
                            }
                            case GREATER_OR_EQUAL: {
                                matches = compareResult > 0;
                                break;
                            }
                            case GREATER: {
                                matches = compareResult >= 0;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown Compare op " + compareOp.name());
                            }
                        }
                    }
                    if (!matches) break block28;
                    if (isPut) {
                        this.internalPut((Put)w, HConstants.DEFAULT_CLUSTER_ID, writeToWAL);
                    } else {
                        Delete d = (Delete)w;
                        this.prepareDelete(d);
                        this.internalDelete(d, HConstants.DEFAULT_CLUSTER_ID, writeToWAL);
                    }
                    boolean bl = true;
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    throw throwable;
                }
            }
            boolean bl = false;
            if (lockId == null) {
                this.releaseRowLock(lid);
            }
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    public void addRegionToSnapshot(HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare exnSnare) throws IOException {
        Path rootDir = FSUtils.getRootDir(this.rsServices.getConfiguration());
        Path snapshotRegionDir = TakeSnapshotUtils.getRegionSnapshotDirectory(desc, rootDir, this.regionInfo.getEncodedName());
        LOG.debug((Object)"Storing region-info for snapshot.");
        this.checkRegioninfoOnFilesystem(snapshotRegionDir);
        LOG.debug((Object)"Creating references for hfiles");
        for (Store store : this.stores.values()) {
            Path dstStoreDir = TakeSnapshotUtils.getStoreSnapshotDirectory(snapshotRegionDir, Bytes.toString(store.getFamily().getName()));
            List<StoreFile> storeFiles = store.getStorefiles();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding snapshot references for " + storeFiles + " hfiles"));
            }
            int sz = storeFiles.size();
            for (int i = 0; i < sz; ++i) {
                if (exnSnare != null) {
                    exnSnare.rethrowException();
                }
                StoreFile storeFile = storeFiles.get(i);
                Path file = storeFile.getPath();
                LOG.debug((Object)("Creating reference for file (" + (i + 1) + "/" + sz + ") : " + file));
                Path referenceFile = new Path(dstStoreDir, file.getName());
                boolean success = true;
                if (storeFile.isReference()) {
                    storeFile.getReference().write(this.fs, referenceFile);
                } else {
                    success = HBaseFileSystem.createNewFileOnFileSystem(this.fs, referenceFile);
                }
                if (success) continue;
                throw new IOException("Failed to create reference file:" + referenceFile);
            }
        }
    }

    private void updateKVTimestamps(Iterable<List<KeyValue>> keyLists, byte[] now) {
        for (List<KeyValue> keys : keyLists) {
            if (keys == null) continue;
            for (KeyValue key : keys) {
                key.updateLatestStamp(now);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResources() throws RegionTooBusyException, InterruptedIOException {
        if (this.getRegionInfo().isMetaRegion()) {
            return;
        }
        boolean blocked = false;
        long startTime = 0L;
        while (this.memstoreSize.get() > this.blockingMemStoreSize) {
            long now;
            long timeToWait;
            this.requestFlush();
            if (!blocked) {
                startTime = EnvironmentEdgeManager.currentTimeMillis();
                LOG.info((Object)("Blocking updates for '" + Thread.currentThread().getName() + "' on region " + Bytes.toStringBinary(this.getRegionName()) + ": memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + " is >= than blocking " + StringUtils.humanReadableInt((long)this.blockingMemStoreSize) + " size"));
            }
            if ((timeToWait = startTime + this.busyWaitDuration - (now = EnvironmentEdgeManager.currentTimeMillis())) <= 0L) {
                long totalTime = now - startTime;
                this.updatesBlockedMs.add(totalTime);
                LOG.info((Object)("Failed to unblock updates for region " + this + " '" + Thread.currentThread().getName() + "' in " + totalTime + "ms. The region is still busy."));
                throw new RegionTooBusyException("region is flushing");
            }
            blocked = true;
            HRegion hRegion = this;
            synchronized (hRegion) {
                try {
                    this.wait(Math.min(timeToWait, this.threadWakeFrequency));
                }
                catch (InterruptedException ie) {
                    long totalTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
                    if (totalTime > 0L) {
                        this.updatesBlockedMs.add(totalTime);
                    }
                    LOG.info((Object)("Interrupted while waiting to unblock updates for region " + this + " '" + Thread.currentThread().getName() + "'"));
                    InterruptedIOException iie = new InterruptedIOException();
                    iie.initCause(ie);
                    throw iie;
                }
            }
        }
        if (blocked) {
            long totalTime = EnvironmentEdgeManager.currentTimeMillis() - startTime;
            if (totalTime > 0L) {
                this.updatesBlockedMs.add(totalTime);
            }
            LOG.info((Object)("Unblocking updates for region " + this + " '" + Thread.currentThread().getName() + "'"));
        }
    }

    protected void checkReadOnly() throws IOException {
        if (this.writestate.isReadOnly()) {
            throw new IOException("region is read only");
        }
    }

    private void put(byte[] family, List<KeyValue> edits) throws IOException {
        HashMap<byte[], List<KeyValue>> familyMap = new HashMap<byte[], List<KeyValue>>();
        familyMap.put(family, edits);
        Put p = new Put();
        p.setFamilyMap(familyMap);
        p.setClusterId(HConstants.DEFAULT_CLUSTER_ID);
        p.setWriteToWAL(true);
        this.internalPut(p, HConstants.DEFAULT_CLUSTER_ID, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPut(Put put2, UUID clusterId, boolean writeToWAL) throws IOException {
        Map<byte[], List<KeyValue>> familyMap = put2.getFamilyMap();
        WALEdit walEdit = new WALEdit();
        if (this.coprocessorHost != null && this.coprocessorHost.prePut(put2, walEdit, writeToWAL)) {
            return;
        }
        long now = EnvironmentEdgeManager.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes(now);
        boolean flush = false;
        this.lock(this.updatesLock.readLock());
        try {
            this.checkFamilies(familyMap.keySet());
            this.checkTimestamps(familyMap, now);
            this.updateKVTimestamps(familyMap.values(), byteNow);
            if (writeToWAL) {
                this.addFamilyMapToWALEdit(familyMap, walEdit);
                walEdit.addClusterIds(put2.getClusterIds());
                this.log.append(this.regionInfo, this.htableDescriptor.getName(), walEdit, clusterId, now, this.htableDescriptor);
            } else {
                this.recordPutWithoutWal(familyMap);
            }
            long addedSize = this.applyFamilyMapToMemstore(familyMap, null);
            flush = this.isFlushSize(this.addAndGetGlobalMemstoreSize(addedSize));
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postPut(put2, walEdit, writeToWAL);
        }
        long after = EnvironmentEdgeManager.currentTimeMillis();
        this.opMetrics.updatePutMetrics(familyMap.keySet(), after - now);
        if (flush) {
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long applyFamilyMapToMemstore(Map<byte[], List<KeyValue>> familyMap, MultiVersionConsistencyControl.WriteEntry localizedWriteEntry) {
        long size = 0L;
        boolean freemvcc = false;
        try {
            if (localizedWriteEntry == null) {
                localizedWriteEntry = this.mvcc.beginMemstoreInsert();
                freemvcc = true;
            }
            for (Map.Entry<byte[], List<KeyValue>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<KeyValue> edits = e.getValue();
                Store store = this.getStore(family);
                for (KeyValue kv : edits) {
                    kv.setMemstoreTS(localizedWriteEntry.getWriteNumber());
                    size += store.add(kv);
                }
            }
        }
        finally {
            if (freemvcc) {
                this.mvcc.completeMemstoreInsert(localizedWriteEntry);
            }
        }
        return size;
    }

    private void rollbackMemstore(BatchOperationInProgress<Pair<Mutation, Integer>> batchOp, Map<byte[], List<KeyValue>>[] familyMaps, int start, int end) {
        int kvsRolledback = 0;
        for (int i = start; i < end; ++i) {
            if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) continue;
            Map<byte[], List<KeyValue>> familyMap = familyMaps[i];
            for (Map.Entry<byte[], List<KeyValue>> e : familyMap.entrySet()) {
                byte[] family = e.getKey();
                List<KeyValue> edits = e.getValue();
                Store store = this.getStore(family);
                for (KeyValue kv : edits) {
                    store.rollback(kv);
                    ++kvsRolledback;
                }
            }
        }
        LOG.debug((Object)("rollbackMemstore rolled back " + kvsRolledback + " keyvalues from start:" + start + " to end:" + end));
    }

    private void checkFamilies(Collection<byte[]> families) throws NoSuchColumnFamilyException {
        for (byte[] family : families) {
            this.checkFamily(family);
        }
    }

    private void checkTimestamps(Map<byte[], List<KeyValue>> familyMap, long now) throws DoNotRetryIOException {
        if (this.timestampSlop == Long.MAX_VALUE) {
            return;
        }
        long maxTs = now + this.timestampSlop;
        for (List<KeyValue> kvs : familyMap.values()) {
            for (KeyValue kv : kvs) {
                if (kv.isLatestTimestamp() || kv.getTimestamp() <= maxTs) continue;
                throw new DoNotRetryIOException("Timestamp for KV out of range " + kv + " (too.new=" + this.timestampSlop + ")");
            }
        }
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<KeyValue>> familyMap, WALEdit walEdit) {
        for (List<KeyValue> edits : familyMap.values()) {
            for (KeyValue kv : edits) {
                walEdit.add(kv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFlush() {
        if (this.rsServices == null) {
            return;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.isFlushRequested()) {
                return;
            }
            this.writestate.flushRequested = true;
        }
        this.rsServices.getFlushRequester().requestFlush(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Flush requested on " + this));
        }
    }

    private boolean isFlushSize(long size) {
        return size > this.memstoreFlushSize;
    }

    protected long replayRecoveredEditsIfAny(Path regiondir, Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter, MonitoredTask status) throws UnsupportedEncodingException, IOException {
        long minSeqIdForTheRegion = -1L;
        for (Long maxSeqIdInStore : maxSeqIdInStores.values()) {
            if (maxSeqIdInStore >= minSeqIdForTheRegion && minSeqIdForTheRegion != -1L) continue;
            minSeqIdForTheRegion = maxSeqIdInStore;
        }
        long seqid = minSeqIdForTheRegion;
        NavigableSet<Path> files = HLog.getSplitEditFilesSorted(this.fs, regiondir);
        if (files == null || files.isEmpty()) {
            return seqid;
        }
        for (Path edits : files) {
            if (edits == null || !this.fs.exists(edits)) {
                LOG.warn((Object)("Null or non-existent edits file: " + edits));
                continue;
            }
            if (HRegion.isZeroLengthThenDelete(this.fs, edits)) continue;
            long maxSeqId = Long.MAX_VALUE;
            String fileName = edits.getName();
            maxSeqId = Math.abs(Long.parseLong(fileName));
            if (maxSeqId <= minSeqIdForTheRegion) {
                String msg = "Maximum sequenceid for this log is " + maxSeqId + " and minimum sequenceid for the region is " + minSeqIdForTheRegion + ", skipped the whole file, path=" + edits;
                LOG.debug((Object)msg);
                continue;
            }
            try {
                seqid = this.replayRecoveredEdits(edits, maxSeqIdInStores, reporter);
            }
            catch (IOException e) {
                boolean skipErrors = this.conf.getBoolean("hbase.skip.errors", false);
                if (skipErrors) {
                    Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                    LOG.error((Object)("hbase.skip.errors=true so continuing. Renamed " + edits + " as " + p), (Throwable)e);
                }
                throw e;
            }
            if (this.rsAccounting == null) continue;
            this.rsAccounting.clearRegionReplayEditsSize(this.regionInfo.getRegionName());
        }
        if (seqid > minSeqIdForTheRegion) {
            this.internalFlushcache(null, seqid, status);
        }
        for (Path file : files) {
            if (!HBaseFileSystem.deleteFileFromFileSystem(this.fs, file)) {
                LOG.error((Object)("Failed delete of " + file));
                continue;
            }
            LOG.debug((Object)("Deleted recovered.edits file=" + file));
        }
        return seqid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replayRecoveredEdits(Path edits, Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter) throws IOException {
        String msg = "Replaying edits from " + edits;
        LOG.info((Object)msg);
        MonitoredTask status = TaskMonitor.get().createStatus(msg);
        status.setStatus("Opening logs");
        HLog.Reader reader = null;
        try {
            reader = HLog.getReader(this.fs, edits, this.conf);
            long currentEditSeqId = -1L;
            long firstSeqIdInLog = -1L;
            long skippedEdits = 0L;
            long editsCount = 0L;
            long intervalEdits = 0L;
            Store store = null;
            boolean reported_once = false;
            try {
                HLog.Entry entry;
                int interval = this.conf.getInt("hbase.hstore.report.interval.edits", 2000);
                int period = this.conf.getInt("hbase.hstore.report.period", this.conf.getInt("hbase.master.assignment.timeoutmonitor.timeout", 180000) / 2);
                long lastReport = EnvironmentEdgeManager.currentTimeMillis();
                while ((entry = reader.next()) != null) {
                    HLogKey key = entry.getKey();
                    WALEdit val = entry.getEdit();
                    if (reporter != null && (intervalEdits += (long)val.size()) >= (long)interval) {
                        intervalEdits = 0L;
                        long cur = EnvironmentEdgeManager.currentTimeMillis();
                        if (lastReport + (long)period <= cur) {
                            status.setStatus("Replaying edits... skipped=" + skippedEdits + " edits=" + editsCount);
                            if (!reporter.progress()) {
                                msg = "Progressable reporter failed, stopping replay";
                                LOG.warn((Object)msg);
                                status.abort(msg);
                                throw new IOException(msg);
                            }
                            reported_once = true;
                            lastReport = cur;
                        }
                    }
                    if (this.coprocessorHost != null) {
                        status.setStatus("Running pre-WAL-restore hook in coprocessors");
                        if (this.coprocessorHost.preWALRestore(this.getRegionInfo(), key, val)) continue;
                    }
                    if (firstSeqIdInLog == -1L) {
                        firstSeqIdInLog = key.getLogSeqNum();
                    }
                    boolean flush = false;
                    for (KeyValue kv : val.getKeyValues()) {
                        if (kv.matchingFamily(HLog.METAFAMILY) || !Bytes.equals(key.getEncodedRegionName(), this.regionInfo.getEncodedNameAsBytes())) {
                            ++skippedEdits;
                            continue;
                        }
                        if (store == null || !kv.matchingFamily(store.getFamily().getName())) {
                            store = this.stores.get(kv.getFamily());
                        }
                        if (store == null) {
                            LOG.warn((Object)("No family for " + kv));
                            ++skippedEdits;
                            continue;
                        }
                        if (key.getLogSeqNum() <= maxSeqIdInStores.get(store.getFamily().getName())) {
                            ++skippedEdits;
                            continue;
                        }
                        currentEditSeqId = key.getLogSeqNum();
                        flush = this.restoreEdit(store, kv);
                        ++editsCount;
                    }
                    if (flush) {
                        this.internalFlushcache(null, currentEditSeqId, status);
                    }
                    if (this.coprocessorHost == null) continue;
                    this.coprocessorHost.postWALRestore(this.getRegionInfo(), key, val);
                }
            }
            catch (EOFException eof) {
                Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                msg = "Encountered EOF. Most likely due to Master failure during log spliting, so we have this data in another edit.  Continuing, but renaming " + edits + " as " + p;
                LOG.warn((Object)msg, (Throwable)eof);
                status.abort(msg);
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof ParseException) {
                    Path p = HLog.moveAsideBadEditsFile(this.fs, edits);
                    msg = "File corruption encountered!  Continuing, but renaming " + edits + " as " + p;
                    LOG.warn((Object)msg, (Throwable)ioe);
                    status.setStatus(msg);
                }
                status.abort(StringUtils.stringifyException((Throwable)ioe));
                throw ioe;
            }
            if (reporter != null && !reported_once) {
                reporter.progress();
            }
            msg = "Applied " + editsCount + ", skipped " + skippedEdits + ", firstSequenceidInLog=" + firstSeqIdInLog + ", maxSequenceidInLog=" + currentEditSeqId + ", path=" + edits;
            status.markComplete(msg);
            LOG.debug((Object)msg);
            long l = currentEditSeqId;
            return l;
        }
        finally {
            status.cleanup();
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected boolean restoreEdit(Store s, KeyValue kv) {
        long kvSize = s.add(kv);
        if (this.rsAccounting != null) {
            this.rsAccounting.addAndGetRegionReplayEditsSize(this.regionInfo.getRegionName(), kvSize);
        }
        return this.isFlushSize(this.addAndGetGlobalMemstoreSize(kvSize));
    }

    private static boolean isZeroLengthThenDelete(FileSystem fs, Path p) throws IOException {
        FileStatus stat = fs.getFileStatus(p);
        if (stat.getLen() > 0L) {
            return false;
        }
        LOG.warn((Object)("File " + p + " is zero-length, deleting."));
        HBaseFileSystem.deleteFileFromFileSystem(fs, p);
        return true;
    }

    protected Store instantiateHStore(Path tableDir, HColumnDescriptor c) throws IOException {
        return new Store(tableDir, this, c, this.fs, this.conf);
    }

    public Store getStore(byte[] column) {
        return this.stores.get(column);
    }

    public Map<byte[], Store> getStores() {
        return this.stores;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStoreFileList(byte[][] columns) throws IllegalArgumentException {
        ArrayList<String> storeFileNames = new ArrayList<String>();
        Object object = this.closeLock;
        synchronized (object) {
            for (byte[] column : columns) {
                Store store = this.stores.get(column);
                if (store == null) {
                    throw new IllegalArgumentException("No column family : " + new String(column) + " available");
                }
                List<StoreFile> storeFiles = store.getStorefiles();
                for (StoreFile storeFile : storeFiles) {
                    storeFileNames.add(storeFile.getPath().toString());
                }
            }
        }
        return storeFileNames;
    }

    void checkRow(byte[] row, String op) throws IOException {
        if (!HRegion.rowIsInRange(this.regionInfo, row)) {
            throw new WrongRegionException("Requested row out of range for " + op + " on HRegion " + this + ", startKey='" + Bytes.toStringBinary(this.regionInfo.getStartKey()) + "', getEndKey()='" + Bytes.toStringBinary(this.regionInfo.getEndKey()) + "', row='" + Bytes.toStringBinary(row) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer obtainRowLock(byte[] row) throws IOException {
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
        try {
            Integer n = this.internalObtainRowLock(new HashedBytes(row), true);
            return n;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private Integer internalObtainRowLock(HashedBytes rowKey, boolean waitForLock) throws IOException {
        this.checkRow(rowKey.getBytes(), "row lock");
        this.startRegionOperation();
        try {
            CountDownLatch existingLatch;
            CountDownLatch rowLatch = new CountDownLatch(1);
            while ((existingLatch = this.lockedRows.putIfAbsent(rowKey, rowLatch)) != null) {
                if (!waitForLock) {
                    Integer n = null;
                    return n;
                }
                try {
                    if (existingLatch.await(this.rowLockWaitDuration, TimeUnit.MILLISECONDS)) continue;
                    throw new IOException("Timed out on getting lock for row=" + rowKey);
                }
                catch (InterruptedException ie) {
                }
            }
            while (true) {
                Integer lockId;
                HashedBytes existingRowKey;
                if ((existingRowKey = this.lockIds.putIfAbsent(lockId = Integer.valueOf(this.lockIdGenerator.incrementAndGet()), rowKey)) == null) {
                    Integer n = lockId;
                    return n;
                }
                this.lockIdGenerator.set(rand.nextInt());
            }
        }
        finally {
            this.closeRegionOperation();
        }
    }

    byte[] getRowFromLock(Integer lockid) {
        HashedBytes rowKey = this.lockIds.get(lockid);
        return rowKey == null ? null : rowKey.getBytes();
    }

    public void releaseRowLock(Integer lockId) {
        if (lockId == null) {
            return;
        }
        HashedBytes rowKey = this.lockIds.remove(lockId);
        if (rowKey == null) {
            LOG.warn((Object)("Release unknown lockId: " + lockId));
            return;
        }
        CountDownLatch rowLatch = this.lockedRows.remove(rowKey);
        if (rowLatch == null) {
            LOG.error((Object)("Releases row not locked, lockId: " + lockId + " row: " + rowKey));
            return;
        }
        rowLatch.countDown();
    }

    boolean isRowLocked(Integer lockId) {
        return this.lockIds.containsKey(lockId);
    }

    public Integer getLock(Integer lockid, byte[] row, boolean waitForLock) throws IOException {
        return this.getLock(lockid, new HashedBytes(row), waitForLock);
    }

    protected Integer getLock(Integer lockid, HashedBytes row, boolean waitForLock) throws IOException {
        Integer lid;
        if (lockid == null) {
            lid = this.internalObtainRowLock(row, waitForLock);
        } else {
            HashedBytes rowFromLock = this.lockIds.get(lockid);
            if (!row.equals(rowFromLock)) {
                throw new IOException("Invalid row lock: LockId: " + lockid + " holds the lock for row: " + rowFromLock + " but wanted lock for row: " + row);
            }
            lid = lockid;
        }
        return lid;
    }

    private static boolean hasMultipleColumnFamilies(List<Pair<byte[], String>> familyPaths) {
        boolean multipleFamilies = false;
        byte[] family = null;
        for (Pair<byte[], String> pair : familyPaths) {
            byte[] fam = pair.getFirst();
            if (family == null) {
                family = fam;
                continue;
            }
            if (Bytes.equals(family, fam)) continue;
            multipleFamilies = true;
            break;
        }
        return multipleFamilies;
    }

    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths) throws IOException {
        return this.bulkLoadHFiles(familyPaths, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, BulkLoadListener bulkLoadListener) throws IOException {
        Preconditions.checkNotNull(familyPaths);
        this.startBulkRegionOperation(HRegion.hasMultipleColumnFamilies(familyPaths));
        try {
            Store store;
            String path;
            this.writeRequestsCount.increment();
            this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
            ArrayList<IOException> ioes = new ArrayList<IOException>();
            ArrayList<Pair<byte[], String>> failures = new ArrayList<Pair<byte[], String>>();
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = p.getFirst();
                path = p.getSecond();
                store = this.getStore(byArray);
                if (store == null) {
                    DoNotRetryIOException ioe = new DoNotRetryIOException("No such column family " + Bytes.toStringBinary(byArray));
                    ioes.add(ioe);
                    continue;
                }
                try {
                    store.assertBulkLoadHFileOk(new Path(path));
                }
                catch (WrongRegionException wre) {
                    failures.add(p);
                }
                catch (IOException ioe) {
                    ioes.add(ioe);
                }
            }
            if (ioes.size() != 0) {
                IOException e = MultipleIOException.createIOException(ioes);
                LOG.error((Object)"There were one or more IO errors when checking if the bulk load is ok.", (Throwable)e);
                throw e;
            }
            if (failures.size() != 0) {
                StringBuilder list = new StringBuilder();
                for (Pair pair : failures) {
                    list.append("\n").append(Bytes.toString((byte[])pair.getFirst())).append(" : ").append((String)pair.getSecond());
                }
                LOG.warn((Object)("There was a recoverable bulk load failure likely due to a split.  These (family, HFile) pairs were not loaded: " + list));
                boolean i$ = false;
                return i$;
            }
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = p.getFirst();
                path = p.getSecond();
                store = this.getStore(byArray);
                try {
                    String finalPath = path;
                    if (bulkLoadListener != null) {
                        finalPath = bulkLoadListener.prepareBulkLoad(byArray, path);
                    }
                    store.bulkLoadHFile(finalPath);
                    if (bulkLoadListener == null) continue;
                    bulkLoadListener.doneBulkLoad(byArray, path);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("There was a partial failure due to IO when attempting to load " + Bytes.toString(p.getFirst()) + " : " + p.getSecond()));
                    if (bulkLoadListener != null) {
                        try {
                            bulkLoadListener.failedBulkLoad(byArray, path);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Error while calling failedBulkLoad for family " + Bytes.toString(byArray) + " with path " + path), (Throwable)ex);
                        }
                    }
                    throw ioe;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.closeBulkRegionOperation();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof HRegion)) {
            return false;
        }
        return Bytes.equals(this.getRegionName(), ((HRegion)o).getRegionName());
    }

    public int hashCode() {
        return Bytes.hashCode(this.getRegionName());
    }

    public String toString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public Path getTableDir() {
        return this.tableDir;
    }

    public static HRegion newHRegion(Path tableDir, HLog log, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        try {
            Class regionClass = conf.getClass("hbase.hregion.impl", HRegion.class);
            Constructor c = regionClass.getConstructor(Path.class, HLog.class, FileSystem.class, Configuration.class, HRegionInfo.class, HTableDescriptor.class, RegionServerServices.class);
            return (HRegion)c.newInstance(new Object[]{tableDir, log, fs, conf, regionInfo, htd, rsServices});
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not instantiate a region instance.", e);
        }
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, null);
    }

    public static void closeHRegion(HRegion r) throws IOException {
        if (r == null) {
            return;
        }
        r.close();
        if (r.getLog() == null) {
            return;
        }
        r.getLog().closeAndDelete();
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog, boolean initialize) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, hlog, initialize, false);
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog, boolean initialize, boolean ignoreHLog) throws IOException {
        LOG.info((Object)("creating HRegion " + info.getTableNameAsString() + " HTD == " + hTableDescriptor + " RootDir = " + rootDir + " Table name == " + info.getTableNameAsString()));
        Path tableDir = HTableDescriptor.getTableDir(rootDir, info.getTableName());
        Path regionDir = HRegion.getRegionDir(tableDir, info.getEncodedName());
        FileSystem fs = FileSystem.get((Configuration)conf);
        HBaseFileSystem.makeDirOnFileSystem(fs, regionDir);
        HRegion.writeRegioninfoOnFilesystem(info, regionDir, fs, conf);
        HLog effectiveHLog = hlog;
        if (hlog == null && !ignoreHLog) {
            effectiveHLog = new HLog(fs, new Path(regionDir, ".logs"), new Path(regionDir, ".oldlogs"), conf);
        }
        HRegion region = HRegion.newHRegion(tableDir, effectiveHLog, fs, conf, info, hTableDescriptor, null);
        if (initialize) {
            region.initialize();
        }
        return region;
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, HLog hlog) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, hlog, true);
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + (Object)((Object)info)));
        }
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        Path dir = HTableDescriptor.getTableDir(FSUtils.getRootDir(conf), info.getTableName());
        FileSystem fs = null;
        if (rsServices != null) {
            fs = rsServices.getFileSystem();
        }
        if (fs == null) {
            fs = FileSystem.get((Configuration)conf);
        }
        HRegion r = HRegion.newHRegion(dir, wal, fs, conf, info, htd, rsServices);
        return r.openHRegion(reporter);
    }

    public static HRegion openHRegion(Path tableDir, HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(tableDir, info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(Path tableDir, HRegionInfo info, HTableDescriptor htd, HLog wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        LOG.info((Object)("HRegion.openHRegion Region name ==" + info.getRegionNameAsString()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + (Object)((Object)info)));
        }
        Path dir = HTableDescriptor.getTableDir(tableDir, info.getTableName());
        HRegion r = HRegion.newHRegion(dir, wal, FileSystem.get((Configuration)conf), conf, info, htd, rsServices);
        return r.openHRegion(reporter);
    }

    protected HRegion openHRegion(CancelableProgressable reporter) throws IOException {
        this.checkCompressionCodecs();
        long seqid = this.initialize(reporter);
        if (this.log != null) {
            this.log.setSequenceNumber(seqid);
        }
        return this;
    }

    private void checkCompressionCodecs() throws IOException {
        for (HColumnDescriptor fam : this.htableDescriptor.getColumnFamilies()) {
            CompressionTest.testCompression(fam.getCompression());
            CompressionTest.testCompression(fam.getCompactionCompression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegionToMETA(HRegion meta, HRegion r) throws IOException {
        meta.checkResources();
        byte[] row = r.getRegionName();
        Integer lid = meta.obtainRowLock(row);
        try {
            long now = EnvironmentEdgeManager.currentTimeMillis();
            ArrayList<KeyValue> edits = new ArrayList<KeyValue>(2);
            edits.add(new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, now, Writables.getBytes((Writable)r.getRegionInfo())));
            edits.add(new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER, now, Bytes.toBytes((short)0)));
            meta.put(HConstants.CATALOG_FAMILY, edits);
        }
        finally {
            meta.releaseRowLock(lid);
        }
    }

    public static void deleteRegion(FileSystem fs, Path rootdir, HRegionInfo info) throws IOException {
        HRegion.deleteRegion(fs, HRegion.getRegionDir(rootdir, info));
    }

    private static void deleteRegion(FileSystem fs, Path regiondir) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETING region " + regiondir.toString()));
        }
        if (!HBaseFileSystem.deleteDirFromFileSystem(fs, regiondir)) {
            LOG.warn((Object)("Failed delete of " + regiondir));
        }
    }

    public static Path getRegionDir(Path rootdir, HRegionInfo info) {
        return new Path(HTableDescriptor.getTableDir(rootdir, info.getTableName()), info.getEncodedName());
    }

    public static boolean rowIsInRange(HRegionInfo info, byte[] row) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo(info.getStartKey(), row) > 0 || info.getEndKey().length != 0 && Bytes.compareTo(info.getEndKey(), row) <= 0);
    }

    public static void makeColumnFamilyDirs(FileSystem fs, Path tabledir, HRegionInfo hri, byte[] colFamily) throws IOException {
        Path dir = Store.getStoreHomedir(tabledir, hri.getEncodedName(), colFamily);
        if (!HBaseFileSystem.makeDirOnFileSystem(fs, dir)) {
            LOG.warn((Object)("Failed to create " + dir));
        }
    }

    public static HRegion mergeAdjacent(HRegion srcA, HRegion srcB) throws IOException {
        HRegion a = srcA;
        HRegion b = srcB;
        if (srcA.getStartKey() == null) {
            if (srcB.getStartKey() == null) {
                throw new IOException("Cannot merge two regions with null start key");
            }
        } else if (srcB.getStartKey() == null || Bytes.compareTo(srcA.getStartKey(), srcB.getStartKey()) > 0) {
            a = srcB;
            b = srcA;
        }
        if (Bytes.compareTo(a.getEndKey(), b.getStartKey()) != 0) {
            throw new IOException("Cannot merge non-adjacent regions");
        }
        return HRegion.merge(a, b);
    }

    public static HRegion merge(HRegion a, HRegion b) throws IOException {
        byte[] startKey;
        if (!a.getRegionInfo().getTableNameAsString().equals(b.getRegionInfo().getTableNameAsString())) {
            throw new IOException("Regions do not belong to the same table");
        }
        FileSystem fs = a.getFilesystem();
        a.flushcache();
        b.flushcache();
        a.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + a));
            HRegion.listPaths(fs, a.getRegionDir());
        }
        b.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + b));
            HRegion.listPaths(fs, b.getRegionDir());
        }
        Configuration conf = a.getBaseConf();
        HTableDescriptor tabledesc = a.getTableDesc();
        HLog log = a.getLog();
        Path tableDir = a.getTableDir();
        byte[] byArray = a.comparator.matchingRows(a.getStartKey(), 0, a.getStartKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) || b.comparator.matchingRows(b.getStartKey(), 0, b.getStartKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) ? HConstants.EMPTY_BYTE_ARRAY : (startKey = a.comparator.compareRows(a.getStartKey(), 0, a.getStartKey().length, b.getStartKey(), 0, b.getStartKey().length) <= 0 ? a.getStartKey() : b.getStartKey());
        byte[] endKey = a.comparator.matchingRows(a.getEndKey(), 0, a.getEndKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) || a.comparator.matchingRows(b.getEndKey(), 0, b.getEndKey().length, HConstants.EMPTY_BYTE_ARRAY, 0, HConstants.EMPTY_BYTE_ARRAY.length) ? HConstants.EMPTY_BYTE_ARRAY : (a.comparator.compareRows(a.getEndKey(), 0, a.getEndKey().length, b.getEndKey(), 0, b.getEndKey().length) <= 0 ? b.getEndKey() : a.getEndKey());
        HRegionInfo newRegionInfo = new HRegionInfo(tabledesc.getName(), startKey, endKey);
        LOG.info((Object)("Creating new region " + newRegionInfo.toString()));
        String encodedName = newRegionInfo.getEncodedName();
        Path newRegionDir = HRegion.getRegionDir(a.getTableDir(), encodedName);
        if (fs.exists(newRegionDir)) {
            throw new IOException("Cannot merge; target file collision at " + newRegionDir);
        }
        HBaseFileSystem.makeDirOnFileSystem(fs, newRegionDir);
        LOG.info((Object)("starting merge of regions: " + a + " and " + b + " into new region " + newRegionInfo.toString() + " with start key <" + Bytes.toStringBinary(startKey) + "> and end key <" + Bytes.toStringBinary(endKey) + ">"));
        Map<byte[], List<StoreFile>> byFamily = new TreeMap<byte[], List<StoreFile>>(Bytes.BYTES_COMPARATOR);
        byFamily = HRegion.filesByFamily(byFamily, a.close());
        byFamily = HRegion.filesByFamily(byFamily, b.close());
        for (Map.Entry<byte[], List<StoreFile>> es : byFamily.entrySet()) {
            long seqB;
            long seqA;
            byte[] colFamily = es.getKey();
            HRegion.makeColumnFamilyDirs(fs, tableDir, newRegionInfo, colFamily);
            List<StoreFile> srcFiles = es.getValue();
            if (srcFiles.size() == 2 && (seqA = srcFiles.get(0).getMaxSequenceId()) == (seqB = srcFiles.get(1).getMaxSequenceId())) {
                throw new IOException("Files have same sequenceid: " + seqA);
            }
            for (StoreFile hsf : srcFiles) {
                StoreFile.rename(fs, hsf.getPath(), StoreFile.getUniqueFile(fs, Store.getStoreHomedir(tableDir, newRegionInfo.getEncodedName(), colFamily)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, newRegionDir);
        }
        HRegion dstRegion = HRegion.newHRegion(tableDir, log, fs, conf, newRegionInfo, a.getTableDesc(), null);
        long totalReadRequestCount = a.readRequestsCount.get() + b.readRequestsCount.get();
        dstRegion.readRequestsCount.set(totalReadRequestCount);
        dstRegion.opMetrics.setReadRequestCountMetrics(totalReadRequestCount);
        long totalWriteRequestCount = a.writeRequestsCount.get() + b.writeRequestsCount.get();
        dstRegion.writeRequestsCount.set(totalWriteRequestCount);
        dstRegion.opMetrics.setWriteRequestCountMetrics(totalWriteRequestCount);
        dstRegion.initialize();
        dstRegion.compactStores();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, dstRegion.getRegionDir());
        }
        HFileArchiver.archiveRegion(fs, FSUtils.getRootDir(a.getConf()), a.getTableDir(), a.getRegionDir());
        HFileArchiver.archiveRegion(fs, FSUtils.getRootDir(b.getConf()), b.getTableDir(), b.getRegionDir());
        LOG.info((Object)("merge completed. New region is " + dstRegion));
        return dstRegion;
    }

    private static Map<byte[], List<StoreFile>> filesByFamily(Map<byte[], List<StoreFile>> byFamily, List<StoreFile> storeFiles) {
        for (StoreFile src : storeFiles) {
            byte[] family = src.getFamily();
            List<StoreFile> v = byFamily.get(family);
            if (v == null) {
                v = new ArrayList<StoreFile>();
                byFamily.put(family, v);
            }
            v.add(src);
        }
        return byFamily;
    }

    boolean isMajorCompaction() throws IOException {
        for (Store store : this.stores.values()) {
            if (!store.isMajorCompaction()) continue;
            return true;
        }
        return false;
    }

    private static void listPaths(FileSystem fs, Path dir) throws IOException {
        if (LOG.isDebugEnabled()) {
            FileStatus[] stats = FSUtils.listStatus(fs, dir, null);
            if (stats == null || stats.length == 0) {
                return;
            }
            for (int i = 0; i < stats.length; ++i) {
                String path = stats[i].getPath().toString();
                if (stats[i].isDir()) {
                    LOG.debug((Object)("d " + path));
                    HRegion.listPaths(fs, stats[i].getPath());
                    continue;
                }
                LOG.debug((Object)("f " + path + " size=" + stats[i].getLen()));
            }
        }
    }

    public Result get(Get get2) throws IOException {
        return this.get(get2, null);
    }

    public Result get(Get get2, Integer lockid) throws IOException {
        this.checkRow(get2.getRow(), "Get");
        if (get2.hasFamilies()) {
            for (byte[] family : get2.familySet()) {
                this.checkFamily(family);
            }
        } else {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                get2.addFamily(family);
            }
        }
        List<KeyValue> results = this.get(get2, true);
        return new Result(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyValue> get(Get get2, boolean withCoprocessor) throws IOException {
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        if (withCoprocessor && this.coprocessorHost != null && this.coprocessorHost.preGet(get2, results)) {
            return results;
        }
        Scan scan = new Scan(get2);
        RegionScanner scanner = null;
        try {
            scanner = this.getScanner(scan);
            scanner.next(results, "getsize");
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
        if (withCoprocessor && this.coprocessorHost != null) {
            this.coprocessorHost.postGet(get2, results);
        }
        long after = EnvironmentEdgeManager.currentTimeMillis();
        this.opMetrics.updateGetMetrics(get2.familySet(), after - now);
        return results;
    }

    public void mutateRow(RowMutations rm) throws IOException {
        this.mutateRowsWithLocks(rm.getMutations(), Collections.singleton(rm.getRow()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateRowsWithLocks(Collection<Mutation> mutations, Collection<byte[]> rowsToLock) throws IOException {
        boolean flush = false;
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation();
        ArrayList<Integer> acquiredLocks = null;
        try {
            WALEdit walEdit = new WALEdit();
            if (this.coprocessorHost != null) {
                for (Mutation m : mutations) {
                    if (m instanceof Put) {
                        if (!this.coprocessorHost.prePut((Put)m, walEdit, m.getWriteToWAL())) continue;
                        return;
                    }
                    if (!(m instanceof Delete)) continue;
                    Delete d = (Delete)m;
                    this.prepareDelete(d);
                    if (!this.coprocessorHost.preDelete(d, walEdit, d.getWriteToWAL())) continue;
                    return;
                }
            }
            long txid = 0L;
            boolean walSyncSuccessful = false;
            boolean locked = false;
            acquiredLocks = new ArrayList<Integer>(rowsToLock.size());
            for (byte[] row : rowsToLock) {
                Integer lid = this.getLock(null, row, true);
                if (lid == null) {
                    throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary(row));
                }
                acquiredLocks.add(lid);
            }
            this.lock(this.updatesLock.readLock(), acquiredLocks.size());
            locked = true;
            MultiVersionConsistencyControl.WriteEntry w = this.mvcc.beginMemstoreInsert();
            long now = EnvironmentEdgeManager.currentTimeMillis();
            byte[] byteNow = Bytes.toBytes(now);
            Durability durability = Durability.USE_DEFAULT;
            try {
                for (Mutation m : mutations) {
                    if (m instanceof Put) {
                        Map<byte[], List<KeyValue>> familyMap = m.getFamilyMap();
                        this.checkFamilies(familyMap.keySet());
                        this.checkTimestamps(familyMap, now);
                        this.updateKVTimestamps(familyMap.values(), byteNow);
                    } else if (m instanceof Delete) {
                        Delete d = (Delete)m;
                        this.prepareDelete(d);
                        this.prepareDeleteTimestamps(d.getFamilyMap(), byteNow);
                    } else {
                        throw new DoNotRetryIOException("Action must be Put or Delete. But was: " + m.getClass().getName());
                    }
                    Durability tmpDur = m.getDurability();
                    if (tmpDur.ordinal() > durability.ordinal()) {
                        durability = tmpDur;
                    }
                    if (tmpDur == Durability.SKIP_WAL) continue;
                    this.addFamilyMapToWALEdit(m.getFamilyMap(), walEdit);
                }
                if (walEdit.size() > 0) {
                    txid = this.log.appendNoSync(this.regionInfo, this.htableDescriptor.getName(), walEdit, HConstants.DEFAULT_CLUSTER_ID, now, this.htableDescriptor);
                }
                long addedSize = 0L;
                for (Mutation m : mutations) {
                    addedSize += this.applyFamilyMapToMemstore(m.getFamilyMap(), w);
                }
                flush = this.isFlushSize(this.addAndGetGlobalMemstoreSize(addedSize));
                this.updatesLock.readLock().unlock();
                locked = false;
                if (acquiredLocks != null) {
                    for (Integer lid : acquiredLocks) {
                        this.releaseRowLock(lid);
                    }
                    acquiredLocks = null;
                }
                if (walEdit.size() > 0) {
                    this.syncOrDefer(txid, durability);
                }
                walSyncSuccessful = true;
                this.mvcc.completeMemstoreInsert(w);
                w = null;
                if (this.coprocessorHost != null) {
                    for (Mutation m : mutations) {
                        if (m instanceof Put) {
                            this.coprocessorHost.postPut((Put)m, walEdit, m.getWriteToWAL());
                            continue;
                        }
                        if (!(m instanceof Delete)) continue;
                        this.coprocessorHost.postDelete((Delete)m, walEdit, m.getWriteToWAL());
                    }
                }
            }
            finally {
                if (!walSyncSuccessful) {
                    int kvsRolledback = 0;
                    for (Mutation m : mutations) {
                        for (Map.Entry<byte[], List<KeyValue>> e : m.getFamilyMap().entrySet()) {
                            List<KeyValue> kvs = e.getValue();
                            byte[] family = e.getKey();
                            Store store = this.getStore(family);
                            for (KeyValue kv : kvs) {
                                store.rollback(kv);
                                ++kvsRolledback;
                            }
                        }
                    }
                    LOG.info((Object)("mutateRowWithLocks: rolled back " + kvsRolledback + " KeyValues"));
                }
                if (w != null) {
                    this.mvcc.completeMemstoreInsert(w);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                if (acquiredLocks != null) {
                    for (Integer lid : acquiredLocks) {
                        this.releaseRowLock(lid);
                    }
                }
            }
        }
        finally {
            if (flush) {
                this.requestFlush();
            }
            this.closeRegionOperation();
        }
    }

    public Result append(Append append, boolean writeToWAL) throws IOException {
        return this.append(append, null, writeToWAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result append(Append append, Integer lockid, boolean writeToWAL) throws IOException {
        byte[] row = append.getRow();
        this.checkRow(row, "append");
        boolean flush = false;
        WALEdit walEdits = null;
        ArrayList<KeyValue> allKVs = new ArrayList<KeyValue>(append.size());
        HashMap tempMemstore = new HashMap();
        long before = EnvironmentEdgeManager.currentTimeMillis();
        long size = 0L;
        long txid = 0L;
        this.checkReadOnly();
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
        try {
            Integer lid = this.getLock(lockid, row, true);
            this.lock(this.updatesLock.readLock());
            try {
                Store store;
                long now = EnvironmentEdgeManager.currentTimeMillis();
                for (Map.Entry<byte[], List<KeyValue>> entry : append.getFamilyMap().entrySet()) {
                    store = this.stores.get(entry.getKey());
                    Collections.sort(entry.getValue(), store.getComparator());
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(entry.getValue().size());
                    Get get2 = new Get(row);
                    for (KeyValue kv : entry.getValue()) {
                        get2.addColumn(entry.getKey(), kv.getQualifier());
                    }
                    List<KeyValue> results = this.get(get2, false);
                    int idx = 0;
                    for (KeyValue kv : entry.getValue()) {
                        KeyValue newKV;
                        if (idx < results.size() && results.get(idx).matchingQualifier(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength())) {
                            KeyValue oldKv = results.get(idx);
                            newKV = new KeyValue(row.length, kv.getFamilyLength(), kv.getQualifierLength(), now, KeyValue.Type.Put, oldKv.getValueLength() + kv.getValueLength());
                            System.arraycopy(oldKv.getBuffer(), oldKv.getValueOffset(), newKV.getBuffer(), newKV.getValueOffset(), oldKv.getValueLength());
                            System.arraycopy(kv.getBuffer(), kv.getValueOffset(), newKV.getBuffer(), newKV.getValueOffset() + oldKv.getValueLength(), kv.getValueLength());
                            ++idx;
                        } else {
                            newKV = new KeyValue(row.length, kv.getFamilyLength(), kv.getQualifierLength(), now, KeyValue.Type.Put, kv.getValueLength());
                            System.arraycopy(kv.getBuffer(), kv.getValueOffset(), newKV.getBuffer(), newKV.getValueOffset(), kv.getValueLength());
                        }
                        System.arraycopy(kv.getBuffer(), kv.getRowOffset(), newKV.getBuffer(), newKV.getRowOffset(), kv.getRowLength());
                        System.arraycopy(kv.getBuffer(), kv.getFamilyOffset(), newKV.getBuffer(), newKV.getFamilyOffset(), kv.getFamilyLength());
                        System.arraycopy(kv.getBuffer(), kv.getQualifierOffset(), newKV.getBuffer(), newKV.getQualifierOffset(), kv.getQualifierLength());
                        kvs.add(newKV);
                        if (!writeToWAL) continue;
                        if (walEdits == null) {
                            walEdits = new WALEdit();
                        }
                        walEdits.add(newKV);
                    }
                    tempMemstore.put(store, kvs);
                }
                if (writeToWAL) {
                    txid = this.log.appendNoSync(this.regionInfo, this.htableDescriptor.getName(), walEdits, HConstants.DEFAULT_CLUSTER_ID, EnvironmentEdgeManager.currentTimeMillis(), this.htableDescriptor);
                }
                for (Map.Entry<Object, List<KeyValue>> entry : tempMemstore.entrySet()) {
                    store = (Store)entry.getKey();
                    size += store.upsert(entry.getValue());
                    allKVs.addAll((Collection)entry.getValue());
                }
                size = this.addAndGetGlobalMemstoreSize(size);
                flush = this.isFlushSize(size);
            }
            finally {
                this.updatesLock.readLock().unlock();
                this.releaseRowLock(lid);
            }
            if (writeToWAL) {
                this.syncOrDefer(txid, append.getDurability());
            }
        }
        finally {
            this.closeRegionOperation();
        }
        long after = EnvironmentEdgeManager.currentTimeMillis();
        this.opMetrics.updateAppendMetrics(append.getFamilyMap().keySet(), after - before);
        if (flush) {
            this.requestFlush();
        }
        return append.isReturnResults() ? new Result(allKVs) : null;
    }

    public Result increment(Increment increment2, boolean writeToWAL) throws IOException {
        return this.increment(increment2, null, writeToWAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result increment(Increment increment2, Integer lockid, boolean writeToWAL) throws IOException {
        byte[] row = increment2.getRow();
        this.checkRow(row, "increment");
        TimeRange tr = increment2.getTimeRange();
        boolean flush = false;
        WALEdit walEdits = null;
        ArrayList<KeyValue> allKVs = new ArrayList<KeyValue>(increment2.numColumns());
        HashMap tempMemstore = new HashMap();
        long before = EnvironmentEdgeManager.currentTimeMillis();
        long size = 0L;
        long txid = 0L;
        this.checkReadOnly();
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
        try {
            Integer lid = this.getLock(lockid, row, true);
            this.lock(this.updatesLock.readLock());
            try {
                Store store;
                long now = EnvironmentEdgeManager.currentTimeMillis();
                for (Map.Entry<byte[], NavigableMap<byte[], Long>> entry : increment2.getFamilyMap().entrySet()) {
                    store = this.stores.get(entry.getKey());
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(entry.getValue().size());
                    Get get2 = new Get(row);
                    for (Map.Entry column : entry.getValue().entrySet()) {
                        get2.addColumn(entry.getKey(), (byte[])column.getKey());
                    }
                    get2.setTimeRange(tr.getMin(), tr.getMax());
                    List<KeyValue> results = this.get(get2, false);
                    int idx = 0;
                    for (Map.Entry column : entry.getValue().entrySet()) {
                        long amount = (Long)column.getValue();
                        if (idx < results.size() && results.get(idx).matchingQualifier((byte[])column.getKey())) {
                            KeyValue kv = results.get(idx);
                            if (kv.getValueLength() == 8) {
                                amount += Bytes.toLong(kv.getBuffer(), kv.getValueOffset(), 8);
                            } else {
                                throw new DoNotRetryIOException("Attempted to increment field that isn't 64 bits wide");
                            }
                            ++idx;
                        }
                        KeyValue newKV = new KeyValue(row, entry.getKey(), (byte[])column.getKey(), now, Bytes.toBytes(amount));
                        kvs.add(newKV);
                        if (!writeToWAL) continue;
                        if (walEdits == null) {
                            walEdits = new WALEdit();
                        }
                        walEdits.add(newKV);
                    }
                    tempMemstore.put(store, kvs);
                }
                if (writeToWAL) {
                    txid = this.log.appendNoSync(this.regionInfo, this.htableDescriptor.getName(), walEdits, HConstants.DEFAULT_CLUSTER_ID, EnvironmentEdgeManager.currentTimeMillis(), this.htableDescriptor);
                }
                for (Map.Entry<Object, NavigableMap<Object, Long>> entry : tempMemstore.entrySet()) {
                    store = (Store)entry.getKey();
                    size += store.upsert((List)((Object)entry.getValue()));
                    allKVs.addAll((Collection)((Object)entry.getValue()));
                }
                size = this.addAndGetGlobalMemstoreSize(size);
                flush = this.isFlushSize(size);
            }
            finally {
                this.updatesLock.readLock().unlock();
                this.releaseRowLock(lid);
            }
            if (writeToWAL) {
                this.syncOrDefer(txid, Durability.USE_DEFAULT);
            }
        }
        finally {
            this.closeRegionOperation();
            long after = EnvironmentEdgeManager.currentTimeMillis();
            this.opMetrics.updateIncrementMetrics(increment2.getFamilyMap().keySet(), after - before);
        }
        if (flush) {
            this.requestFlush();
        }
        return new Result(allKVs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        long before = EnvironmentEdgeManager.currentTimeMillis();
        this.checkRow(row, "increment");
        boolean flush = false;
        boolean wrongLength = false;
        long txid = 0L;
        long result = amount;
        this.startRegionOperation();
        this.writeRequestsCount.increment();
        this.opMetrics.setWriteRequestCountMetrics(this.writeRequestsCount.get());
        try {
            Integer lid = this.obtainRowLock(row);
            this.lock(this.updatesLock.readLock());
            try {
                Store store = this.stores.get(family);
                Get get2 = new Get(row);
                get2.addColumn(family, qualifier);
                List<KeyValue> results = this.get(get2, false);
                if (!results.isEmpty()) {
                    KeyValue kv = results.get(0);
                    if (kv.getValueLength() == 8) {
                        byte[] buffer = kv.getBuffer();
                        int valueOffset = kv.getValueOffset();
                        result += Bytes.toLong(buffer, valueOffset, 8);
                    } else {
                        wrongLength = true;
                    }
                }
                if (!wrongLength) {
                    KeyValue newKv = new KeyValue(row, family, qualifier, EnvironmentEdgeManager.currentTimeMillis(), Bytes.toBytes(result));
                    if (writeToWAL) {
                        long now = EnvironmentEdgeManager.currentTimeMillis();
                        WALEdit walEdit = new WALEdit();
                        walEdit.add(newKv);
                        txid = this.log.appendNoSync(this.regionInfo, this.htableDescriptor.getName(), walEdit, HConstants.DEFAULT_CLUSTER_ID, now, this.htableDescriptor);
                    }
                    long size = store.updateColumnValue(row, family, qualifier, result);
                    size = this.addAndGetGlobalMemstoreSize(size);
                    flush = this.isFlushSize(size);
                }
            }
            finally {
                this.updatesLock.readLock().unlock();
                this.releaseRowLock(lid);
            }
            if (writeToWAL) {
                this.syncOrDefer(txid, Durability.USE_DEFAULT);
            }
        }
        finally {
            this.closeRegionOperation();
        }
        long after = EnvironmentEdgeManager.currentTimeMillis();
        this.opMetrics.updateIncrementColumnValueMetrics(family, after - before);
        if (flush) {
            this.requestFlush();
        }
        if (wrongLength) {
            throw new DoNotRetryIOException("Attempted to increment field that isn't 64 bits wide");
        }
        return result;
    }

    private void checkFamily(byte[] family) throws NoSuchColumnFamilyException {
        if (!this.htableDescriptor.hasFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toString(family) + " does not exist in region " + this + " in table " + this.htableDescriptor);
        }
    }

    @Override
    public long heapSize() {
        long heapSize = DEEP_OVERHEAD;
        for (Store store : this.stores.values()) {
            heapSize += store.heapSize();
        }
        return heapSize;
    }

    private static void printUsageAndExit(String message) {
        if (message != null && message.length() > 0) {
            System.out.println(message);
        }
        System.out.println("Usage: HRegion CATLALOG_TABLE_DIR [major_compact]");
        System.out.println("Options:");
        System.out.println(" major_compact  Pass this option to major compact passed region.");
        System.out.println("Default outputs scan of passed region.");
        System.exit(1);
    }

    public <T extends CoprocessorProtocol> boolean registerProtocol(Class<T> protocol, T handler) {
        if (this.protocolHandlers.containsKey(protocol)) {
            LOG.error((Object)("Protocol " + protocol.getName() + " already registered, rejecting request from " + handler));
            return false;
        }
        this.protocolHandlers.putInstance(protocol, handler);
        this.protocolHandlerNames.put(protocol.getName(), protocol);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered protocol handler: region=" + Bytes.toStringBinary(this.getRegionName()) + " protocol=" + protocol.getName()));
        }
        return true;
    }

    public ExecResult exec(Exec call) throws IOException {
        Object value;
        Class<? extends CoprocessorProtocol> protocol = call.getProtocol();
        if (protocol == null) {
            String protocolName = call.getProtocolName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Received dynamic protocol exec call with protocolName " + protocolName));
            }
            if ((protocol = this.protocolHandlerNames.get(protocolName)) == null) {
                throw new HBaseRPC.UnknownProtocolException(protocol, "No matching handler for protocol " + protocolName + " in region " + Bytes.toStringBinary(this.getRegionName()));
            }
        }
        if (!this.protocolHandlers.containsKey(protocol)) {
            throw new HBaseRPC.UnknownProtocolException(protocol, "No matching handler for protocol " + protocol.getName() + " in region " + Bytes.toStringBinary(this.getRegionName()));
        }
        CoprocessorProtocol handler = (CoprocessorProtocol)this.protocolHandlers.getInstance(protocol);
        try {
            Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
            method.setAccessible(true);
            value = method.invoke((Object)handler, call.getParameters());
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof IOException) {
                throw (IOException)target;
            }
            IOException ioe = new IOException(target.toString());
            ioe.setStackTrace(target.getStackTrace());
            throw ioe;
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                LOG.error((Object)"Unexpected throwable object ", e);
            }
            IOException ioe = new IOException(e.toString());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        return new ExecResult(this.getRegionName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTable(FileSystem fs, Path p, HLog log, Configuration c, boolean majorCompact2) throws IOException {
        block12: {
            HRegion region = null;
            String rootStr = Bytes.toString(HConstants.ROOT_TABLE_NAME);
            String metaStr = Bytes.toString(HConstants.META_TABLE_NAME);
            if (p.getName().startsWith(rootStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.ROOT_REGIONINFO, HTableDescriptor.ROOT_TABLEDESC, null);
            } else if (p.getName().startsWith(metaStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.FIRST_META_REGIONINFO, HTableDescriptor.META_TABLEDESC, null);
            } else {
                throw new IOException("Not a known catalog table: " + p.toString());
            }
            try {
                region.initialize();
                if (majorCompact2) {
                    region.compactStores(true);
                    break block12;
                }
                Scan scan = new Scan();
                RegionScanner scanner = region.getScanner(scan);
                try {
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                    boolean done = false;
                    do {
                        kvs.clear();
                        done = scanner.next(kvs);
                        if (kvs.size() <= 0) continue;
                        LOG.info(kvs);
                    } while (done);
                }
                finally {
                    scanner.close();
                }
            }
            finally {
                region.close();
            }
        }
    }

    boolean shouldForceSplit() {
        return this.splitRequest;
    }

    byte[] getExplicitSplitPoint() {
        return this.explicitSplitPoint;
    }

    void forceSplit(byte[] sp) {
        this.splitRequest = true;
        if (sp != null) {
            this.explicitSplitPoint = sp;
        }
    }

    void clearSplit_TESTS_ONLY() {
        this.splitRequest = false;
    }

    protected void prepareToSplit() {
    }

    public byte[] checkSplit() {
        if (this.regionInfo.isMetaTable()) {
            if (this.shouldForceSplit()) {
                LOG.warn((Object)"Cannot split root/meta regions in HBase 0.20 and above");
            }
            return null;
        }
        if (!this.splitPolicy.shouldSplit()) {
            return null;
        }
        byte[] ret = this.splitPolicy.getSplitPoint();
        if (ret != null) {
            try {
                this.checkRow(ret, "calculated split");
            }
            catch (IOException e) {
                LOG.error((Object)"Ignoring invalid split", (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public int getCompactPriority() {
        int count = Integer.MAX_VALUE;
        for (Store store : this.stores.values()) {
            count = Math.min(count, store.getCompactPriority());
        }
        return count;
    }

    public boolean needsCompaction() {
        for (Store store : this.stores.values()) {
            if (!store.needsCompaction()) continue;
            return true;
        }
        return false;
    }

    public RegionCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    public void setOpMetricsReadRequestCount(long value) {
        this.opMetrics.setReadRequestCountMetrics(value);
    }

    public void setOpMetricsWriteRequestCount(long value) {
        this.opMetrics.setWriteRequestCountMetrics(value);
    }

    public void setCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    public void startRegionOperation() throws NotServingRegionException, RegionTooBusyException, InterruptedIOException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closing");
        }
        this.lock(this.lock.readLock());
        if (this.closed.get()) {
            this.lock.readLock().unlock();
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closed");
        }
    }

    public void closeRegionOperation() {
        this.lock.readLock().unlock();
    }

    private void startBulkRegionOperation(boolean writeLockNeeded) throws NotServingRegionException, RegionTooBusyException, InterruptedIOException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closing");
        }
        if (writeLockNeeded) {
            this.lock(this.lock.writeLock());
        } else {
            this.lock(this.lock.readLock());
        }
        if (this.closed.get()) {
            if (writeLockNeeded) {
                this.lock.writeLock().unlock();
            } else {
                this.lock.readLock().unlock();
            }
            throw new NotServingRegionException(this.regionInfo.getRegionNameAsString() + " is closed");
        }
    }

    private void closeBulkRegionOperation() {
        if (this.lock.writeLock().isHeldByCurrentThread()) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
    }

    private void recordPutWithoutWal(Map<byte[], List<KeyValue>> familyMap) {
        if (this.numPutsWithoutWAL.getAndIncrement() == 0L) {
            LOG.info((Object)("writing data to region " + this + " with WAL disabled. Data may be lost in the event of a crash."));
        }
        long putSize = 0L;
        for (List<KeyValue> edits : familyMap.values()) {
            for (KeyValue kv : edits) {
                putSize += (long)(kv.getKeyLength() + kv.getValueLength());
            }
        }
        this.dataInMemoryWithoutWAL.addAndGet(putSize);
    }

    private void lock(Lock lock) throws RegionTooBusyException, InterruptedIOException {
        this.lock(lock, 1);
    }

    private void lock(Lock lock, int multiplier) throws RegionTooBusyException, InterruptedIOException {
        try {
            long waitTime = Math.min(this.maxBusyWaitDuration, this.busyWaitDuration * (long)Math.min(multiplier, this.maxBusyWaitMultiplier));
            if (!lock.tryLock(waitTime, TimeUnit.MILLISECONDS)) {
                throw new RegionTooBusyException("failed to get a lock in " + waitTime + "ms");
            }
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted while waiting for a lock");
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            throw iie;
        }
    }

    private void syncOrDefer(long txid, Durability durability) throws IOException {
        if (this.getRegionInfo().isMetaRegion()) {
            this.log.sync(txid);
        } else {
            switch (durability) {
                case USE_DEFAULT: {
                    if (this.isDeferredLogSyncEnabled()) break;
                    this.log.sync(txid);
                    break;
                }
                case SKIP_WAL: {
                    break;
                }
                case ASYNC_WAL: {
                    if (!this.deferredLogSyncDisabled) break;
                    this.log.sync(txid);
                    break;
                }
                case SYNC_WAL: 
                case FSYNC_WAL: {
                    this.log.sync(txid);
                }
            }
        }
    }

    private boolean isDeferredLogSyncEnabled() {
        return this.htableDescriptor.isDeferredLogFlush() && !this.deferredLogSyncDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            HRegion.printUsageAndExit(null);
        }
        boolean majorCompact2 = false;
        if (args.length > 1) {
            if (!args[1].toLowerCase().startsWith("major")) {
                HRegion.printUsageAndExit("ERROR: Unrecognized option <" + args[1] + ">");
            }
            majorCompact2 = true;
        }
        Path tableDir = new Path(args[0]);
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        Path logdir = new Path(c.get("hbase.tmp.dir"), "hlog" + tableDir.getName() + EnvironmentEdgeManager.currentTimeMillis());
        Path oldLogDir = new Path(c.get("hbase.tmp.dir"), ".oldlogs");
        HLog log = new HLog(fs, logdir, oldLogDir, c);
        try {
            HRegion.processTable(fs, tableDir, log, c, majorCompact2);
        }
        finally {
            log.close();
            BlockCache bc = new CacheConfig(c).getBlockCache();
            if (bc != null) {
                bc.shutdown();
            }
        }
    }

    public static interface BulkLoadListener {
        public String prepareBulkLoad(byte[] var1, String var2) throws IOException;

        public void doneBulkLoad(byte[] var1, String var2) throws IOException;

        public void failedBulkLoad(byte[] var1, String var2) throws IOException;
    }

    class RegionScannerImpl
    implements RegionScanner {
        KeyValueHeap storeHeap = null;
        KeyValueHeap joinedHeap = null;
        private KeyValue joinedContinuationRow = null;
        private final KeyValue KV_LIMIT = new KeyValue();
        private final byte[] stopRow;
        private Filter filter;
        private int batch;
        private int isScan;
        private boolean filterClosed = false;
        private long readPt;
        private HRegion region;

        @Override
        public HRegionInfo getRegionInfo() {
            return HRegion.this.regionInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            this.region = region;
            this.filter = scan.getFilter();
            this.batch = scan.getBatch();
            this.stopRow = (byte[])(Bytes.equals(scan.getStopRow(), HConstants.EMPTY_END_ROW) ? null : scan.getStopRow());
            this.isScan = scan.isGetScan() ? -1 : 0;
            IsolationLevel isolationLevel = scan.getIsolationLevel();
            ConcurrentHashMap concurrentHashMap = HRegion.this.scannerReadPoints;
            synchronized (concurrentHashMap) {
                if (isolationLevel == IsolationLevel.READ_UNCOMMITTED) {
                    this.readPt = Long.MAX_VALUE;
                    MultiVersionConsistencyControl.setThreadReadPoint(this.readPt);
                } else {
                    this.readPt = MultiVersionConsistencyControl.resetThreadReadPoint(HRegion.this.mvcc);
                }
                HRegion.this.scannerReadPoints.put(this, this.readPt);
            }
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
            ArrayList<KeyValueScanner> joinedScanners = new ArrayList<KeyValueScanner>();
            if (additionalScanners != null) {
                scanners.addAll(additionalScanners);
            }
            for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
                Store store = HRegion.this.stores.get(entry.getKey());
                KeyValueScanner scanner = store.getScanner(scan, entry.getValue());
                if (this.filter == null || !scan.doLoadColumnFamiliesOnDemand() || FilterBase.isFamilyEssential(this.filter, entry.getKey())) {
                    scanners.add(scanner);
                    continue;
                }
                joinedScanners.add(scanner);
            }
            this.storeHeap = new KeyValueHeap(scanners, HRegion.this.comparator);
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new KeyValueHeap(joinedScanners, HRegion.this.comparator);
            }
        }

        RegionScannerImpl(Scan scan, HRegion region) throws IOException {
            this(scan, null, region);
        }

        @Override
        public long getMvccReadPoint() {
            return this.readPt;
        }

        protected void resetFilters() {
            if (this.filter != null) {
                this.filter.reset();
            }
        }

        @Override
        public boolean next(List<KeyValue> outResults, int limit) throws IOException {
            return this.next(outResults, limit, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean next(List<KeyValue> outResults, int limit, String metric) throws IOException {
            if (this.filterClosed) {
                throw new UnknownScannerException("Scanner was closed (timed out?) after we renewed it. Could be caused by a very slow scanner or a lengthy garbage collection");
            }
            HRegion.this.startRegionOperation();
            HRegion.this.readRequestsCount.increment();
            HRegion.this.opMetrics.setReadRequestCountMetrics(HRegion.this.readRequestsCount.get());
            try {
                MultiVersionConsistencyControl.setThreadReadPoint(this.readPt);
                boolean bl = this.nextRaw(outResults, limit, metric);
                return bl;
            }
            finally {
                HRegion.this.closeRegionOperation();
            }
        }

        @Override
        public boolean nextRaw(List<KeyValue> outResults, String metric) throws IOException {
            return this.nextRaw(outResults, this.batch, metric);
        }

        @Override
        public boolean nextRaw(List<KeyValue> outResults, int limit, String metric) throws IOException {
            boolean returnResult;
            if (outResults.isEmpty()) {
                returnResult = this.nextInternal(outResults, limit, metric);
            } else {
                ArrayList<KeyValue> tmpList = new ArrayList<KeyValue>();
                returnResult = this.nextInternal(tmpList, limit, metric);
                outResults.addAll(tmpList);
            }
            this.resetFilters();
            if (this.isFilterDone()) {
                return false;
            }
            return returnResult;
        }

        @Override
        public boolean next(List<KeyValue> outResults) throws IOException {
            return this.next(outResults, this.batch, null);
        }

        @Override
        public boolean next(List<KeyValue> outResults, String metric) throws IOException {
            return this.next(outResults, this.batch, metric);
        }

        private void populateFromJoinedHeap(List<KeyValue> results, int limit, String metric) throws IOException {
            assert (this.joinedContinuationRow != null);
            KeyValue kv = this.populateResult(results, this.joinedHeap, limit, this.joinedContinuationRow.getBuffer(), this.joinedContinuationRow.getRowOffset(), this.joinedContinuationRow.getRowLength(), metric);
            if (kv != this.KV_LIMIT) {
                this.joinedContinuationRow = null;
            }
            Collections.sort(results, HRegion.this.comparator);
        }

        private KeyValue populateResult(List<KeyValue> results, KeyValueHeap heap, int limit, byte[] currentRow, int offset, short length, String metric) throws IOException {
            KeyValue nextKv;
            do {
                heap.next(results, limit - results.size(), metric);
                if (limit <= 0 || results.size() != limit) continue;
                return this.KV_LIMIT;
            } while ((nextKv = heap.peek()) != null && nextKv.matchingRow(currentRow, offset, length));
            return nextKv;
        }

        @Override
        public synchronized boolean isFilterDone() {
            return this.filter != null && this.filter.filterAllRemaining();
        }

        private boolean nextInternal(List<KeyValue> results, int limit, String metric) throws IOException {
            boolean stopRow;
            if (!results.isEmpty()) {
                throw new IllegalArgumentException("First parameter should be an empty list");
            }
            RpcCallContext rpcCall = HBaseServer.getCurrentCall();
            while (true) {
                if (rpcCall != null) {
                    rpcCall.throwExceptionIfCallerDisconnected();
                }
                KeyValue current = this.storeHeap.peek();
                byte[] currentRow = null;
                int offset = 0;
                short length = 0;
                if (current != null) {
                    currentRow = current.getBuffer();
                    offset = current.getRowOffset();
                    length = current.getRowLength();
                }
                stopRow = this.isStopRow(currentRow, offset, length);
                if (this.joinedContinuationRow == null) {
                    if (stopRow) {
                        if (this.filter != null && this.filter.hasFilterRow()) {
                            this.filter.filterRow(results);
                        }
                        if (this.filter != null && this.filter.filterRow()) {
                            results.clear();
                        }
                        return false;
                    }
                    if (this.filterRowKey(currentRow, offset, length)) {
                        results.clear();
                        boolean moreRows = this.nextRow(currentRow, offset, length);
                        if (moreRows) continue;
                        return false;
                    }
                    KeyValue nextKv = this.populateResult(results, this.storeHeap, limit, currentRow, offset, length, metric);
                    if (nextKv == this.KV_LIMIT) {
                        if (this.filter != null && this.filter.hasFilterRow()) {
                            throw new IncompatibleFilterException("Filter whose hasFilterRow() returns true is incompatible with scan with limit!");
                        }
                        return true;
                    }
                    stopRow = nextKv == null || this.isStopRow(nextKv.getBuffer(), nextKv.getRowOffset(), nextKv.getRowLength());
                    boolean isEmptyRow = results.isEmpty();
                    if (this.filter != null && this.filter.hasFilterRow()) {
                        this.filter.filterRow(results);
                    }
                    if (isEmptyRow || this.filterRow()) {
                        results.clear();
                        boolean moreRows = this.nextRow(currentRow, offset, length);
                        if (!moreRows) {
                            return false;
                        }
                        if (!stopRow) continue;
                        return false;
                    }
                    if (this.joinedHeap != null) {
                        boolean mayHaveData;
                        KeyValue nextJoinedKv = this.joinedHeap.peek();
                        boolean bl = mayHaveData = nextJoinedKv != null && nextJoinedKv.matchingRow(currentRow, offset, length) || this.joinedHeap.requestSeek(KeyValue.createFirstOnRow(currentRow, offset, length), true, true) && this.joinedHeap.peek() != null && this.joinedHeap.peek().matchingRow(currentRow, offset, length);
                        if (mayHaveData) {
                            this.joinedContinuationRow = current;
                            this.populateFromJoinedHeap(results, limit, metric);
                        }
                    }
                } else {
                    this.populateFromJoinedHeap(results, limit, metric);
                }
                if (this.joinedContinuationRow != null) {
                    return true;
                }
                if (!results.isEmpty()) break;
                boolean moreRows = this.nextRow(currentRow, offset, length);
                if (!moreRows) {
                    return false;
                }
                if (stopRow) break;
            }
            return !stopRow;
        }

        private boolean filterRow() {
            return this.filter != null && this.filter.filterRow();
        }

        private boolean filterRowKey(byte[] row, int offset, short length) {
            return this.filter != null && this.filter.filterRowKey(row, offset, length);
        }

        protected boolean nextRow(byte[] currentRow, int offset, short length) throws IOException {
            KeyValue next;
            while ((next = this.storeHeap.peek()) != null && next.matchingRow(currentRow, offset, length)) {
                this.storeHeap.next(MOCKED_LIST);
            }
            this.resetFilters();
            if (this.region.getCoprocessorHost() != null) {
                return this.region.getCoprocessorHost().postScannerFilterRow(this, currentRow);
            }
            return true;
        }

        private boolean isStopRow(byte[] currentRow, int offset, short length) {
            return currentRow == null || this.stopRow != null && HRegion.this.comparator.compareRows(this.stopRow, 0, this.stopRow.length, currentRow, offset, length) <= this.isScan;
        }

        @Override
        public synchronized void close() {
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
            }
            if (this.joinedHeap != null) {
                this.joinedHeap.close();
                this.joinedHeap = null;
            }
            HRegion.this.scannerReadPoints.remove(this);
            this.filterClosed = true;
        }

        KeyValueHeap getStoreHeapForTesting() {
            return this.storeHeap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean reseek(byte[] row) throws IOException {
            if (row == null) {
                throw new IllegalArgumentException("Row cannot be null.");
            }
            boolean result = false;
            HRegion.this.startRegionOperation();
            try {
                MultiVersionConsistencyControl.setThreadReadPoint(this.readPt);
                KeyValue kv = KeyValue.createFirstOnRow(row);
                result = this.storeHeap.requestSeek(kv, true, true);
                if (this.joinedHeap != null) {
                    result = this.joinedHeap.requestSeek(kv, true, true) || result;
                }
            }
            finally {
                HRegion.this.closeRegionOperation();
            }
            return result;
        }
    }

    private static class BatchOperationInProgress<T> {
        T[] operations;
        int nextIndexToProcess = 0;
        OperationStatus[] retCodeDetails;
        WALEdit[] walEditsFromCoprocessors;

        public BatchOperationInProgress(T[] operations) {
            this.operations = operations;
            this.retCodeDetails = new OperationStatus[operations.length];
            this.walEditsFromCoprocessors = new WALEdit[operations.length];
            Arrays.fill(this.retCodeDetails, OperationStatus.NOT_RUN);
        }

        public boolean isDone() {
            return this.nextIndexToProcess == this.operations.length;
        }
    }

    static class WriteState {
        volatile boolean flushing = false;
        volatile boolean flushRequested = false;
        volatile int compacting = 0;
        volatile boolean writesEnabled = true;
        volatile boolean readOnly = false;
        static final long HEAP_SIZE = ClassSize.align(ClassSize.OBJECT + 5);

        WriteState() {
        }

        synchronized void setReadOnly(boolean onOff) {
            this.writesEnabled = !onOff;
            this.readOnly = onOff;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        boolean isFlushRequested() {
            return this.flushRequested;
        }
    }
}

