/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.data.AuthenticationInfo;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.CookieSetting;
import org.restlet.data.Dimension;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Response
extends Message {
    private static final ThreadLocal<Response> CURRENT = new ThreadLocal();
    private volatile int age = 0;
    private volatile Set<Method> allowedMethods = null;
    private volatile AuthenticationInfo authenticationInfo;
    private volatile boolean autoCommitting = true;
    private volatile List<ChallengeRequest> challengeRequests = null;
    private volatile boolean committed = false;
    private volatile Series<CookieSetting> cookieSettings = null;
    private volatile Set<Dimension> dimensions = null;
    private volatile Reference locationRef = null;
    private volatile List<ChallengeRequest> proxyChallengeRequests = null;
    private volatile Request request;
    private volatile Date retryAfter;
    private volatile ServerInfo serverInfo;
    private volatile Status status;

    public static Response getCurrent() {
        return CURRENT.get();
    }

    public static void setCurrent(Response response) {
        CURRENT.set(response);
    }

    public Response(Request request) {
        this.request = request;
        this.retryAfter = null;
        this.serverInfo = null;
        this.status = Status.SUCCESS_OK;
    }

    public void abort() {
        this.getRequest().abort();
    }

    public void commit() {
        this.getRequest().commit(this);
    }

    public int getAge() {
        return this.age;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Method> getAllowedMethods() {
        Set<Method> a = this.allowedMethods;
        if (a == null) {
            Response response = this;
            synchronized (response) {
                a = this.allowedMethods;
                if (a == null) {
                    this.allowedMethods = a = new CopyOnWriteArraySet<Method>();
                }
            }
        }
        return a;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChallengeRequest> getChallengeRequests() {
        List<ChallengeRequest> cr = this.challengeRequests;
        if (cr == null) {
            Response response = this;
            synchronized (response) {
                cr = this.challengeRequests;
                if (cr == null) {
                    this.challengeRequests = cr = new CopyOnWriteArrayList<ChallengeRequest>();
                }
            }
        }
        return cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Series<CookieSetting> getCookieSettings() {
        Series<CookieSetting> c = this.cookieSettings;
        if (c == null) {
            Response response = this;
            synchronized (response) {
                c = this.cookieSettings;
                if (c == null) {
                    this.cookieSettings = c = new Series<CookieSetting>(CookieSetting.class);
                }
            }
        }
        return c;
    }

    public Set<Dimension> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new CopyOnWriteArraySet<Dimension>();
        }
        return this.dimensions;
    }

    public Reference getLocationRef() {
        return this.locationRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChallengeRequest> getProxyChallengeRequests() {
        List<ChallengeRequest> cr = this.proxyChallengeRequests;
        if (cr == null) {
            Response response = this;
            synchronized (response) {
                cr = this.proxyChallengeRequests;
                if (cr == null) {
                    this.proxyChallengeRequests = cr = new CopyOnWriteArrayList<ChallengeRequest>();
                }
            }
        }
        return cr;
    }

    public Request getRequest() {
        return this.request;
    }

    public Date getRetryAfter() {
        return this.retryAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerInfo getServerInfo() {
        ServerInfo s = this.serverInfo;
        if (s == null) {
            Response response = this;
            synchronized (response) {
                s = this.serverInfo;
                if (s == null) {
                    this.serverInfo = s = new ServerInfo();
                }
            }
        }
        return s;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean isAutoCommitting() {
        return this.autoCommitting;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public boolean isConfidential() {
        return this.getRequest().isConfidential();
    }

    public boolean isFinal() {
        return !this.getStatus().isInformational();
    }

    public boolean isProvisional() {
        return this.getStatus().isInformational();
    }

    public void redirectPermanent(Reference targetRef) {
        this.setLocationRef(targetRef);
        this.setStatus(Status.REDIRECTION_PERMANENT);
    }

    public void redirectPermanent(String targetUri) {
        this.setLocationRef(targetUri);
        this.setStatus(Status.REDIRECTION_PERMANENT);
    }

    public void redirectSeeOther(Reference targetRef) {
        this.setLocationRef(targetRef);
        this.setStatus(Status.REDIRECTION_SEE_OTHER);
    }

    public void redirectSeeOther(String targetUri) {
        this.setLocationRef(targetUri);
        this.setStatus(Status.REDIRECTION_SEE_OTHER);
    }

    public void redirectTemporary(Reference targetRef) {
        this.setLocationRef(targetRef);
        this.setStatus(Status.REDIRECTION_TEMPORARY);
    }

    public void redirectTemporary(String targetUri) {
        this.setLocationRef(targetUri);
        this.setStatus(Status.REDIRECTION_TEMPORARY);
    }

    public void setAge(int age) {
        this.age = age;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedMethods(Set<Method> allowedMethods) {
        Set<Method> set = this.getAllowedMethods();
        synchronized (set) {
            if (allowedMethods != this.allowedMethods) {
                this.allowedMethods.clear();
                if (allowedMethods != null) {
                    this.allowedMethods.addAll(allowedMethods);
                }
            }
        }
    }

    public void setAuthenticationInfo(AuthenticationInfo authenticationInfo) {
        this.authenticationInfo = authenticationInfo;
    }

    public void setAutoCommitting(boolean autoCommitting) {
        this.autoCommitting = autoCommitting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChallengeRequests(List<ChallengeRequest> challengeRequests) {
        List<ChallengeRequest> list = this.getChallengeRequests();
        synchronized (list) {
            if (challengeRequests != this.getChallengeRequests()) {
                this.getChallengeRequests().clear();
                if (challengeRequests != null) {
                    this.getChallengeRequests().addAll(challengeRequests);
                }
            }
        }
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCookieSettings(Series<CookieSetting> cookieSettings) {
        Series<CookieSetting> series = this.getCookieSettings();
        synchronized (series) {
            if (cookieSettings != this.getCookieSettings()) {
                this.getCookieSettings().clear();
                if (cookieSettings != null) {
                    this.getCookieSettings().addAll(cookieSettings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimensions(Set<Dimension> dimensions) {
        Set<Dimension> set = this.getDimensions();
        synchronized (set) {
            if (dimensions != this.getDimensions()) {
                this.getDimensions().clear();
                if (dimensions != null) {
                    this.getDimensions().addAll(dimensions);
                }
            }
        }
    }

    public void setLocationRef(Reference locationRef) {
        this.locationRef = locationRef;
    }

    public void setLocationRef(String locationUri) {
        Reference baseRef = null;
        if (this.getRequest().getResourceRef() != null) {
            baseRef = this.getRequest().getResourceRef().getBaseRef() != null ? this.getRequest().getResourceRef().getBaseRef() : this.getRequest().getResourceRef();
        }
        this.setLocationRef(new Reference(baseRef, locationUri).getTargetRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProxyChallengeRequests(List<ChallengeRequest> proxyChallengeRequests) {
        List<ChallengeRequest> list = this.getProxyChallengeRequests();
        synchronized (list) {
            if (proxyChallengeRequests != this.getProxyChallengeRequests()) {
                this.getProxyChallengeRequests().clear();
                if (proxyChallengeRequests != null) {
                    this.getProxyChallengeRequests().addAll(proxyChallengeRequests);
                }
            }
        }
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setRetryAfter(Date retryAfter) {
        this.retryAfter = retryAfter;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setStatus(Status status, String description) {
        this.setStatus(new Status(status, description));
    }

    public void setStatus(Status status, Throwable throwable) {
        this.setStatus(new Status(status, throwable));
    }

    public void setStatus(Status status, Throwable throwable, String message) {
        this.setStatus(new Status(status, throwable, message));
    }

    public String toString() {
        return (this.getRequest() == null ? "?" : this.getRequest().getProtocol()) + " - " + this.getStatus();
    }
}

