/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.cache2k.storage.ByteBufferInputStream;
import org.cache2k.storage.Marshaller;
import org.cache2k.storage.MarshallerFactory;

public class StandardMarshaller
implements Marshaller {
    @Override
    public byte[] marshall(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        return bos.toByteArray();
    }

    @Override
    public Object unmarshall(byte[] ba) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(ba);
        return this.returnObject(bis);
    }

    @Override
    public Object unmarshall(ByteBuffer b) throws IOException, ClassNotFoundException {
        ByteBufferInputStream bis = new ByteBufferInputStream(b);
        return this.returnObject(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object returnObject(InputStream bis) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(bis);
        try {
            Object object = ois.readObject();
            return object;
        }
        finally {
            ois.close();
        }
    }

    @Override
    public boolean supports(Object o) {
        return true;
    }

    @Override
    public ObjectOutput startOutput(OutputStream out) throws IOException {
        return new ObjectOutputStream(out);
    }

    @Override
    public ObjectInput startInput(InputStream in) throws IOException {
        return new ObjectInputStream(in);
    }

    @Override
    public MarshallerFactory.Parameters getFactoryParameters() {
        return new MarshallerFactory.Parameters(this.getClass());
    }
}

