/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb.database.serialize.attribute;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.ScanBuffer;
import com.thinkaurelius.titan.diskstorage.WriteBuffer;
import com.thinkaurelius.titan.graphdb.database.serialize.AttributeUtil;
import com.thinkaurelius.titan.graphdb.database.serialize.OrderPreservingSerializer;
import com.thinkaurelius.titan.graphdb.database.serialize.attribute.LongSerializer;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDecimal
extends Number
implements Comparable<AbstractDecimal> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDecimal.class);
    public static final int MAX_DECIMALS = 9;
    private long format;
    private byte decimals;
    public static final double EPSILON = 1.0E-8;

    protected AbstractDecimal() {
    }

    public AbstractDecimal(double value, int decimals) {
        this(AbstractDecimal.convert(value, decimals), decimals);
    }

    protected AbstractDecimal(long format, int decimals) {
        Preconditions.checkArgument((decimals > 0 && decimals <= 9 ? 1 : 0) != 0, (String)"Number of decimals out of range [1-9]: %s", (Object[])new Object[]{decimals});
        this.decimals = (byte)decimals;
        this.format = format;
    }

    private static long multiplier(int decimals) {
        long multiplier = 1L;
        for (int i = 0; i < decimals; ++i) {
            multiplier *= 10L;
        }
        return multiplier;
    }

    public static double minDoubleValue(int decimals) {
        return -9.223372036854776E18 / (double)(AbstractDecimal.multiplier(decimals) + 1L);
    }

    public static double maxDoubleValue(int decimals) {
        return 9.223372036854776E18 / (double)(AbstractDecimal.multiplier(decimals) + 1L);
    }

    public static final boolean withinRange(double value, int decimals) {
        return value >= AbstractDecimal.minDoubleValue(decimals) && value <= AbstractDecimal.maxDoubleValue(decimals);
    }

    public static final long convert(double value, int decimals) {
        Preconditions.checkArgument((decimals > 0 && decimals <= 9 ? 1 : 0) != 0, (String)"Number of decimals out of range [1-9]: %s", (Object[])new Object[]{decimals});
        Preconditions.checkArgument((!Double.isNaN(value) ? 1 : 0) != 0, (Object)"Value may not be NaN");
        Preconditions.checkArgument((boolean)AbstractDecimal.withinRange(value, decimals), (String)"Value out of range for this decimal: %s. Use full precision floating point representation.", (Object[])new Object[]{value});
        long format = Math.round(value * (double)AbstractDecimal.multiplier(decimals));
        if (Math.abs(AbstractDecimal.convert(format, decimals) - value) > 1.0E-8) {
            log.warn("Truncated decimals of float value: {}. Use FullFloat for full precision.", (Object)value);
        }
        return format;
    }

    public static final double convert(long format, int decimals) {
        return (double)format / (double)AbstractDecimal.multiplier(decimals);
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        return this.format / AbstractDecimal.multiplier(this.decimals);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return AbstractDecimal.convert(this.format, (int)this.decimals);
    }

    public double getDecimalsOnly() {
        long multiplier = AbstractDecimal.multiplier(this.decimals);
        return (double)(this.format % multiplier) / (double)multiplier;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.format).append(this.decimals).toHashCode();
    }

    public String toString() {
        double decimal = this.getDecimalsOnly();
        assert (decimal < 1.0 && decimal >= 0.0);
        return Long.toString(this.longValue()) + Double.toString(decimal).substring(1);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Number) {
            return this.doubleValue() == ((Number)other).doubleValue();
        }
        if (other instanceof AbstractDecimal) {
            AbstractDecimal o = (AbstractDecimal)other;
            return this.decimals == o.decimals && this.format == o.format;
        }
        return false;
    }

    @Override
    public int compareTo(AbstractDecimal o) {
        return Double.compare(this.doubleValue(), o.doubleValue());
    }

    public static abstract class AbstractDecimalSerializer<V extends AbstractDecimal>
    implements OrderPreservingSerializer<V> {
        private final int decimals;
        private final Class<V> type;
        private final LongSerializer ls = new LongSerializer();

        public AbstractDecimalSerializer(int decimals, Class<V> type) {
            Preconditions.checkNotNull(type);
            this.type = type;
            Preconditions.checkArgument((decimals > 0 && decimals <= 9 ? 1 : 0) != 0, (String)"Number of decimals out of range [1-9]: %s", (Object[])new Object[]{decimals});
            this.decimals = decimals;
        }

        protected abstract V construct(long var1, int var3);

        @Override
        public V read(ScanBuffer buffer) {
            long format = this.ls.read(buffer);
            return this.construct(format, this.decimals);
        }

        @Override
        public void write(WriteBuffer buffer, V attribute) {
            V d = attribute;
            Preconditions.checkArgument((((AbstractDecimal)d).decimals == this.decimals ? 1 : 0) != 0, (String)"Invalid argument provided: %s", (Object[])new Object[]{attribute});
            this.ls.write(buffer, ((AbstractDecimal)d).format);
        }

        @Override
        public V readByteOrder(ScanBuffer buffer) {
            return (V)this.read(buffer);
        }

        @Override
        public void writeByteOrder(WriteBuffer buffer, V attribute) {
            this.write(buffer, attribute);
        }

        @Override
        public void verifyAttribute(V value) {
        }

        @Override
        public V convert(Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().equals(this.type)) {
                return (V)((AbstractDecimal)value);
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                if (AttributeUtil.isWholeNumber(n)) {
                    long l = n.longValue();
                    long multiplier = AbstractDecimal.multiplier(this.decimals);
                    Preconditions.checkArgument((Long.MIN_VALUE / multiplier < l && Long.MAX_VALUE / multiplier > l ? 1 : 0) != 0, (String)"Number out of range: %s", (Object[])new Object[]{l});
                    return this.construct(l * multiplier, this.decimals);
                }
                return this.construct(AbstractDecimal.convert(n.doubleValue(), this.decimals), this.decimals);
            }
            if (value instanceof String) {
                return this.construct(AbstractDecimal.convert(Double.parseDouble(value.toString()), this.decimals), this.decimals);
            }
            return null;
        }
    }
}

