/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;

public class TimestampFieldMapper
extends DateFieldMapper
implements InternalMapper,
RootMapper {
    public static final String NAME = "_timestamp";
    public static final String CONTENT_TYPE = "_timestamp";
    public static final String DEFAULT_DATE_TIME_FORMAT = "dateOptionalTime";
    private EnabledAttributeMapper enabledState;
    private final String path;
    private final String defaultTimestamp;

    public TimestampFieldMapper(Settings indexSettings) {
        this(new FieldType(Defaults.FIELD_TYPE), null, Defaults.ENABLED, Defaults.PATH, Defaults.DATE_TIME_FORMATTER, "now", true, Defaults.IGNORE_MALFORMED, Defaults.COERCE, null, null, null, null, indexSettings);
    }

    protected TimestampFieldMapper(FieldType fieldType, Boolean docValues, EnabledAttributeMapper enabledState, String path, FormatDateTimeFormatter dateTimeFormatter, String defaultTimestamp, boolean roundCeil, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names("_timestamp", "_timestamp", "_timestamp", "_timestamp"), dateTimeFormatter, 16, 1.0f, fieldType, docValues, Defaults.NULL_VALUE, TimeUnit.MILLISECONDS, roundCeil, ignoreMalformed, coerce, postingsProvider, docValuesProvider, null, normsLoading, fieldDataSettings, indexSettings, AbstractFieldMapper.MultiFields.empty(), null);
        this.enabledState = enabledState;
        this.path = path;
        this.defaultTimestamp = defaultTimestamp;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public String path() {
        return this.path;
    }

    public String defaultTimestamp() {
        return this.defaultTimestamp;
    }

    @Override
    public FormatDateTimeFormatter dateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    @Override
    public Object valueForSearch(Object value) {
        return this.value(value);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (this.enabledState.enabled) {
            long timestamp = context.sourceToParse().timestamp();
            if (!(this.fieldType.indexed() || this.fieldType.stored() || this.hasDocValues())) {
                context.ignoredValue(this.names.indexName(), String.valueOf(timestamp));
            }
            if (this.fieldType.indexed() || this.fieldType.stored()) {
                fields.add(new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, timestamp, this.fieldType));
            }
            if (this.hasDocValues()) {
                fields.add((Field)new NumericDocValuesField(this.names.indexName(), timestamp));
            }
        }
    }

    @Override
    protected String contentType() {
        return "_timestamp";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType.indexed() == Defaults.FIELD_TYPE.indexed() && this.customFieldDataSettings == null && this.fieldType.stored() == Defaults.FIELD_TYPE.stored() && this.enabledState == Defaults.ENABLED && this.path == Defaults.PATH && this.dateTimeFormatter.format().equals(Defaults.DATE_TIME_FORMATTER.format()) && "now".equals(this.defaultTimestamp) && !this.hasDocValues()) {
            return builder;
        }
        builder.startObject("_timestamp");
        if (includeDefaults || this.enabledState != Defaults.ENABLED) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (includeDefaults || this.fieldType.indexed() != Defaults.FIELD_TYPE.indexed() || this.fieldType.tokenized() != Defaults.FIELD_TYPE.tokenized()) {
            builder.field("index", TimestampFieldMapper.indexTokenizeOptionToString(this.fieldType.indexed(), this.fieldType.tokenized()));
        }
        if (includeDefaults || this.fieldType.stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType.stored());
        }
        if (includeDefaults || this.hasDocValues()) {
            builder.field("doc_values", this.docValues);
        }
        if (includeDefaults || this.path != Defaults.PATH) {
            builder.field("path", this.path);
        }
        if (includeDefaults || !this.dateTimeFormatter.format().equals(Defaults.DATE_TIME_FORMATTER.format())) {
            builder.field("format", this.dateTimeFormatter.format());
        }
        if (includeDefaults || !"now".equals(this.defaultTimestamp)) {
            builder.field("default", this.defaultTimestamp);
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        if (this.docValuesFormat != null) {
            if (includeDefaults || !this.docValuesFormat.name().equals(this.defaultDocValuesFormat())) {
                builder.field("doc_values_format", this.docValuesFormat.name());
            }
        } else if (includeDefaults) {
            String format = this.defaultDocValuesFormat();
            if (format == null) {
                format = "default";
            }
            builder.field("doc_values_format", format);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        TimestampFieldMapper timestampFieldMapperMergeWith = (TimestampFieldMapper)mergeWith;
        super.merge(mergeWith, mergeContext);
        if (!mergeContext.mergeFlags().simulate()) {
            if (timestampFieldMapperMergeWith.enabledState != this.enabledState && !timestampFieldMapperMergeWith.enabledState.unset()) {
                this.enabledState = timestampFieldMapperMergeWith.enabledState;
            }
        } else {
            if (timestampFieldMapperMergeWith.defaultTimestamp() == null && this.defaultTimestamp == null) {
                return;
            }
            if (this.defaultTimestamp == null) {
                mergeContext.addConflict("Cannot update default in _timestamp value. Value is null now encountering " + timestampFieldMapperMergeWith.defaultTimestamp());
            } else if (timestampFieldMapperMergeWith.defaultTimestamp() == null) {
                mergeContext.addConflict("Cannot update default in _timestamp value. Value is \" + defaultTimestamp.toString() + \" now encountering null");
            } else if (!timestampFieldMapperMergeWith.defaultTimestamp().equals(this.defaultTimestamp)) {
                mergeContext.addConflict("Cannot update default in _timestamp value. Value is " + this.defaultTimestamp.toString() + " now encountering " + timestampFieldMapperMergeWith.defaultTimestamp());
            }
            if (this.path != null) {
                if (!this.path.equals(timestampFieldMapperMergeWith.path())) {
                    mergeContext.addConflict("Cannot update path in _timestamp value. Value is " + this.path + " path in merged mapping is " + (timestampFieldMapperMergeWith.path() == null ? "missing" : timestampFieldMapperMergeWith.path()));
                }
            } else if (timestampFieldMapperMergeWith.path() != null) {
                mergeContext.addConflict("Cannot update path in _timestamp value. Value is " + this.path + " path in merged mapping is missing");
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.timestamp();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    EnabledAttributeMapper enabledState = XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                    builder.enabled(enabledState);
                    continue;
                }
                if (fieldName.equals("path")) {
                    builder.path(fieldNode.toString());
                    continue;
                }
                if (fieldName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(fieldNode.toString()));
                    continue;
                }
                if (!fieldName.equals("default")) continue;
                builder.defaultTimestamp(fieldNode == null ? null : fieldNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, TimestampFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;
        private String path = Defaults.PATH;
        private FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;
        private String defaultTimestamp = "now";

        public Builder() {
            super("_timestamp", new FieldType(Defaults.FIELD_TYPE), 16);
        }

        public Builder enabled(EnabledAttributeMapper enabledState) {
            this.enabledState = enabledState;
            return (Builder)this.builder;
        }

        public Builder path(String path) {
            this.path = path;
            return (Builder)this.builder;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return (Builder)this.builder;
        }

        public Builder defaultTimestamp(String defaultTimestamp) {
            this.defaultTimestamp = defaultTimestamp;
            return (Builder)this.builder;
        }

        @Override
        public TimestampFieldMapper build(Mapper.BuilderContext context) {
            boolean roundCeil = true;
            if (context.indexSettings() != null) {
                Settings settings = context.indexSettings();
                roundCeil = settings.getAsBoolean("index.mapping.date.round_ceil", settings.getAsBoolean("index.mapping.date.parse_upper_inclusive", (Boolean)true));
            }
            return new TimestampFieldMapper(this.fieldType, this.docValues, this.enabledState, this.path, this.dateTimeFormatter, this.defaultTimestamp, roundCeil, this.ignoreMalformed(context), this.coerce(context), this.postingsProvider, this.docValuesProvider, this.normsLoading, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends DateFieldMapper.Defaults {
        public static final String NAME = "_timestamp";
        public static final FieldType FIELD_TYPE = new FieldType(DateFieldMapper.Defaults.FIELD_TYPE);
        public static final EnabledAttributeMapper ENABLED;
        public static final String PATH;
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER;
        public static final String DEFAULT_TIMESTAMP = "now";

        static {
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.freeze();
            ENABLED = EnabledAttributeMapper.UNSET_DISABLED;
            PATH = null;
            DATE_TIME_FORMATTER = Joda.forPattern(TimestampFieldMapper.DEFAULT_DATE_TIME_FORMAT);
        }
    }
}

