/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.Version;
import org.elasticsearch.common.collect.ImmutableBiMap;
import org.elasticsearch.common.collect.ImmutableMap;

final class ActionNames {
    static final ImmutableBiMap<String, String> ACTION_NAMES = ActionNames.createActionNamesMap();

    private ActionNames() {
    }

    static String incomingAction(String action, Version version) {
        String post_1_4_action;
        if (version.before(Version.V_1_4_0_Beta1) && (post_1_4_action = ActionNames.post_1_4_action(action)) != null) {
            return post_1_4_action;
        }
        return action;
    }

    static String outgoingAction(String action, Version version) {
        String pre_1_4_Action;
        if (version.before(Version.V_1_4_0_Beta1) && (pre_1_4_Action = ActionNames.pre_1_4_Action(action)) != null) {
            return pre_1_4_Action;
        }
        return action;
    }

    static String post_1_4_action(String action) {
        return (String)((ImmutableMap)((Object)ACTION_NAMES.inverse())).get(action);
    }

    static String pre_1_4_Action(String action) {
        return (String)ACTION_NAMES.get(action);
    }

    private static ImmutableBiMap<String, String> createActionNamesMap() {
        ImmutableBiMap.Builder<String, String> builder = ImmutableBiMap.builder();
        ActionNames.addNodeAction("cluster:admin/nodes/restart", "cluster/nodes/restart", builder);
        builder.put((Object)"cluster:admin/nodes/shutdown", (Object)"cluster/nodes/shutdown");
        builder.put((Object)"cluster:admin/nodes/shutdown[n]", (Object)"/cluster/nodes/shutdown/node");
        builder.put((Object)"cluster:admin/repository/delete", (Object)"cluster/repository/delete");
        builder.put((Object)"cluster:admin/repository/get", (Object)"cluster/repository/get");
        builder.put((Object)"cluster:admin/repository/put", (Object)"cluster/repository/put");
        builder.put((Object)"cluster:admin/reroute", (Object)"cluster/reroute");
        builder.put((Object)"cluster:admin/settings/update", (Object)"cluster/settings/update");
        builder.put((Object)"cluster:admin/snapshot/create", (Object)"cluster/snapshot/create");
        builder.put((Object)"cluster:admin/snapshot/delete", (Object)"cluster/snapshot/delete");
        builder.put((Object)"cluster:admin/snapshot/get", (Object)"cluster/snapshot/get");
        builder.put((Object)"cluster:admin/snapshot/restore", (Object)"cluster/snapshot/restore");
        builder.put((Object)"cluster:monitor/health", (Object)"cluster/health");
        ActionNames.addNodeAction("cluster:monitor/nodes/hot_threads", "cluster/nodes/hot_threads", builder);
        ActionNames.addNodeAction("cluster:monitor/nodes/info", "cluster/nodes/info", builder);
        ActionNames.addNodeAction("cluster:monitor/nodes/stats", "cluster/nodes/stats", builder);
        builder.put((Object)"cluster:admin/snapshot/status", (Object)"cluster/snapshot/status");
        ActionNames.addNodeAction("cluster:admin/snapshot/status[nodes]", "cluster/snapshot/status/nodes", builder);
        builder.put((Object)"cluster:monitor/state", (Object)"cluster/state");
        ActionNames.addNodeAction("cluster:monitor/stats", "cluster/stats", builder);
        builder.put((Object)"cluster:monitor/task", (Object)"cluster/task");
        builder.put((Object)"indices:admin/aliases", (Object)"indices/aliases");
        builder.put((Object)"indices:admin/aliases/exists", (Object)"indices/exists/aliases");
        builder.put((Object)"indices:admin/aliases/get", (Object)"indices/get/aliases");
        ActionNames.addShardAction("indices:admin/analyze", "indices/analyze", builder);
        ActionNames.addShardAction("indices:admin/cache/clear", "indices/cache/clear", builder);
        builder.put((Object)"indices:admin/close", (Object)"indices/close");
        builder.put((Object)"indices:admin/create", (Object)"indices/create");
        builder.put((Object)"indices:admin/delete", (Object)"indices/delete");
        builder.put((Object)"indices:admin/exists", (Object)"indices/exists");
        ActionNames.addShardAction("indices:admin/flush", "indices/flush", builder);
        builder.put((Object)"indices:admin/mapping/delete", (Object)"indices/mapping/delete");
        builder.put((Object)"indices:admin/mapping/put", (Object)"indices/mapping/put");
        builder.put((Object)"indices:admin/mappings/fields/get", (Object)"mappings/fields/get");
        builder.put((Object)"indices:admin/mappings/fields/get[index][s]", (Object)"mappings/fields/get/index/s");
        builder.put((Object)"indices:admin/mappings/get", (Object)"mappings/get");
        builder.put((Object)"indices:admin/open", (Object)"indices/open");
        ActionNames.addShardAction("indices:admin/optimize", "indices/optimize", builder);
        ActionNames.addShardAction("indices:admin/refresh", "indices/refresh", builder);
        builder.put((Object)"indices:admin/settings/update", (Object)"indices/settings/update");
        builder.put((Object)"indices:admin/shards/search_shards", (Object)"cluster/shards/search_shards");
        builder.put((Object)"indices:admin/template/delete", (Object)"indices/template/delete");
        builder.put((Object)"indices:admin/template/get", (Object)"indices/template/get");
        builder.put((Object)"indices:admin/template/put", (Object)"indices/template/put");
        builder.put((Object)"indices:admin/types/exists", (Object)"indices/types/exists");
        ActionNames.addShardAction("indices:admin/validate/query", "indices/validate/query", builder);
        builder.put((Object)"indices:admin/warmers/delete", (Object)"indices/warmer/delete");
        builder.put((Object)"indices:admin/warmers/get", (Object)"warmers/get");
        builder.put((Object)"indices:admin/warmers/put", (Object)"indices/warmer/put");
        ActionNames.addShardAction("indices:data/read/count", "count", builder);
        ActionNames.addShardAction("indices:data/read/explain", "explain", builder);
        ActionNames.addShardAction("indices:data/read/get", "get", builder);
        builder.put((Object)"indices:data/read/mget", (Object)"mget");
        builder.put((Object)"indices:data/read/mget[shard][s]", (Object)"mget/shard/s");
        builder.put((Object)"indices:data/read/script/get", (Object)"getIndexedScript");
        builder.put((Object)"indices:data/write/script/put", (Object)"putIndexedScript");
        builder.put((Object)"indices:data/write/script/delete", (Object)"deleteIndexedScript");
        builder.put((Object)"indices:data/read/mlt", (Object)"mlt");
        builder.put((Object)"indices:data/read/mpercolate", (Object)"mpercolate");
        builder.put((Object)"indices:data/read/mpercolate[shard][s]", (Object)"mpercolate/shard/s");
        builder.put((Object)"indices:data/read/msearch", (Object)"msearch");
        builder.put((Object)"indices:data/read/mtv", (Object)"mtv");
        builder.put((Object)"indices:data/read/mtv[shard][s]", (Object)"mtv/shard/s");
        ActionNames.addShardAction("indices:data/read/percolate", "percolate", builder);
        builder.put((Object)"indices:data/read/scroll", (Object)"search/scroll");
        builder.put((Object)"indices:data/read/scroll/clear", (Object)"clear_sc");
        builder.put((Object)"indices:data/read/search", (Object)"search");
        builder.put((Object)"indices:data/read/search[free_context]", (Object)"search/freeContext");
        builder.put((Object)"indices:data/read/search[clear_scroll_contexts]", (Object)"search/clearScrollContexts");
        builder.put((Object)"indices:data/read/search[phase/dfs]", (Object)"search/phase/dfs");
        builder.put((Object)"indices:data/read/search[phase/query]", (Object)"search/phase/query");
        builder.put((Object)"indices:data/read/search[phase/query/id]", (Object)"search/phase/query/id");
        builder.put((Object)"indices:data/read/search[phase/query/scroll]", (Object)"search/phase/query/scroll");
        builder.put((Object)"indices:data/read/search[phase/query+fetch]", (Object)"search/phase/query+fetch");
        builder.put((Object)"indices:data/read/search[phase/query/query+fetch]", (Object)"search/phase/query/query+fetch");
        builder.put((Object)"indices:data/read/search[phase/query+fetch/scroll]", (Object)"search/phase/query+fetch/scroll");
        builder.put((Object)"indices:data/read/search[phase/fetch/id]", (Object)"search/phase/fetch/id");
        builder.put((Object)"indices:data/read/search[phase/scan]", (Object)"search/phase/scan");
        builder.put((Object)"indices:data/read/search[phase/scan/scroll]", (Object)"search/phase/scan/scroll");
        ActionNames.addShardAction("indices:data/read/suggest", "suggest", builder);
        ActionNames.addShardAction("indices:data/read/tv", "tv", builder);
        builder.put((Object)"indices:data/write/bulk", (Object)"bulk");
        builder.put((Object)"indices:data/write/bulk[s]", (Object)"bulk/shard");
        builder.put((Object)"indices:data/write/bulk[s][r]", (Object)"bulk/shard/replica");
        builder.put((Object)"indices:data/write/delete", (Object)"delete");
        builder.put((Object)"indices:data/write/delete[r]", (Object)"delete/replica");
        builder.put((Object)"indices:data/write/delete[s]", (Object)"indices/index/b_shard/delete");
        builder.put((Object)"indices:data/write/delete[s][r]", (Object)"indices/index/b_shard/delete/replica");
        builder.put((Object)"indices:data/write/delete/by_query", (Object)"deleteByQuery");
        builder.put((Object)"indices:data/write/delete/by_query[s]", (Object)"deleteByQuery/shard");
        builder.put((Object)"indices:data/write/delete/by_query[s][r]", (Object)"deleteByQuery/shard/replica");
        builder.put((Object)"indices:data/write/index", (Object)"index");
        builder.put((Object)"indices:data/write/index[r]", (Object)"index/replica");
        builder.put((Object)"indices:data/write/update", (Object)"update");
        ActionNames.addShardAction("indices:monitor/recovery", "indices/recovery", builder);
        ActionNames.addShardAction("indices:monitor/segments", "indices/segments", builder);
        ActionNames.addShardAction("indices:monitor/stats", "indices/stats", builder);
        ActionNames.addShardAction("indices:monitor/status", "indices/status", builder);
        builder.put((Object)"indices:monitor/settings/get", (Object)"indices/settings/get");
        builder.put((Object)"internal:cluster/mapping_updated", (Object)"cluster/mappingUpdated");
        builder.put((Object)"internal:cluster/node/index/deleted", (Object)"cluster/nodeIndexDeleted");
        builder.put((Object)"internal:cluster/node/index_store/deleted", (Object)"cluster/nodeIndexStoreDeleted");
        builder.put((Object)"internal:cluster/node/mapping/refresh", (Object)"cluster/nodeMappingRefresh");
        ActionNames.addNodeAction("internal:cluster/nodes/indices/shard/store", "/cluster/nodes/indices/shard/store", builder);
        builder.put((Object)"internal:cluster/shard/failure", (Object)"cluster/shardStarted");
        builder.put((Object)"internal:cluster/shard/started", (Object)"cluster/shardFailure");
        builder.put((Object)"internal:cluster/snapshot/update_restore", (Object)"cluster/snapshot/update_restore");
        builder.put((Object)"internal:cluster/snapshot/update_snapshot", (Object)"cluster/snapshot/update_snapshot");
        builder.put((Object)"internal:discovery/zen/fd/master_ping", (Object)"discovery/zen/fd/masterPing");
        builder.put((Object)"internal:discovery/zen/fd/ping", (Object)"discovery/zen/fd/ping");
        builder.put((Object)"internal:discovery/zen/join", (Object)"discovery/zen/join");
        builder.put((Object)"internal:discovery/zen/rejoin", (Object)"discovery/zen/rejoin");
        builder.put((Object)"internal:discovery/zen/join/validate", (Object)"discovery/zen/join/validate");
        builder.put((Object)"internal:discovery/zen/leave", (Object)"discovery/zen/leave");
        builder.put((Object)"internal:discovery/zen/multicast", (Object)"discovery/zen/multicast");
        builder.put((Object)"internal:discovery/zen/publish", (Object)"discovery/zen/publish");
        builder.put((Object)"internal:discovery/zen/unicast", (Object)"discovery/zen/unicast");
        builder.put((Object)"internal:gateway/local/allocate_dangled", (Object)"/gateway/local/allocate_dangled");
        ActionNames.addNodeAction("internal:gateway/local/meta_state", "/gateway/local/meta-state", builder);
        ActionNames.addNodeAction("internal:gateway/local/started_shards", "/gateway/local/started-shards", builder);
        builder.put((Object)"internal:index/shard/recovery/clean_files", (Object)"index/shard/recovery/cleanFiles");
        builder.put((Object)"internal:index/shard/recovery/file_chunk", (Object)"index/shard/recovery/fileChunk");
        builder.put((Object)"internal:index/shard/recovery/filesInfo", (Object)"index/shard/recovery/filesInfo");
        builder.put((Object)"internal:index/shard/recovery/finalize", (Object)"index/shard/recovery/finalize");
        builder.put((Object)"internal:index/shard/recovery/prepare_translog", (Object)"index/shard/recovery/prepareTranslog");
        builder.put((Object)"internal:index/shard/recovery/translog_ops", (Object)"index/shard/recovery/translogOps");
        builder.put((Object)"internal:index/shard/recovery/start_recovery", (Object)"index/shard/recovery/startRecovery");
        builder.put((Object)"internal:index/shard/exists", (Object)"index/shard/exists");
        builder.put((Object)"internal:river/state/publish", (Object)"river/state/publish");
        return builder.build();
    }

    private static void addNodeAction(String name, String pre_14_name, ImmutableBiMap.Builder<String, String> builder) {
        builder.put((Object)name, (Object)pre_14_name);
        builder.put((Object)(name + "[n]"), (Object)(pre_14_name + "/n"));
    }

    private static void addShardAction(String name, String pre_14_name, ImmutableBiMap.Builder<String, String> builder) {
        builder.put((Object)name, (Object)pre_14_name);
        builder.put((Object)(name + "[s]"), (Object)(pre_14_name + "/s"));
    }
}

