/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.util.ArgumentChecker;
import org.apache.accumulo.core.util.Pair;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;

public class IteratorSetting
implements Writable {
    private int priority;
    private String name;
    private String iteratorClass;
    private Map<String, String> properties;

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        ArgumentChecker.strictlyPositive(priority);
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        ArgumentChecker.notNull(name);
        this.name = name;
    }

    public String getIteratorClass() {
        return this.iteratorClass;
    }

    public void setIteratorClass(String iteratorClass) {
        ArgumentChecker.notNull(iteratorClass);
        this.iteratorClass = iteratorClass;
    }

    public IteratorSetting(int priority, String name, String iteratorClass) {
        this(priority, name, iteratorClass, new HashMap<String, String>());
    }

    public IteratorSetting(int priority, String name, String iteratorClass, Map<String, String> properties) {
        this.setPriority(priority);
        this.setName(name);
        this.setIteratorClass(iteratorClass);
        this.properties = new HashMap<String, String>();
        this.addOptions(properties);
    }

    public IteratorSetting(int priority, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) {
        this(priority, iteratorClass.getSimpleName(), iteratorClass.getName());
    }

    public IteratorSetting(int priority, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass, Map<String, String> properties) {
        this(priority, iteratorClass.getSimpleName(), iteratorClass.getName(), properties);
    }

    public IteratorSetting(int priority, String name, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass) {
        this(priority, name, iteratorClass.getName());
    }

    public IteratorSetting(int priority, String name, Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass, Map<String, String> properties) {
        this(priority, name, iteratorClass.getName(), properties);
    }

    public IteratorSetting(DataInput din) throws IOException {
        this.properties = new HashMap<String, String>();
        this.readFields(din);
    }

    public void addOption(String option, String value) {
        ArgumentChecker.notNull(option, value);
        this.properties.put(option, value);
    }

    public String removeOption(String option) {
        ArgumentChecker.notNull(option);
        return this.properties.remove(option);
    }

    public void addOptions(Set<Map.Entry<String, String>> propertyEntries) {
        ArgumentChecker.notNull(propertyEntries);
        for (Map.Entry<String, String> keyValue : propertyEntries) {
            this.addOption(keyValue.getKey(), keyValue.getValue());
        }
    }

    public void addOptions(Map<String, String> properties) {
        ArgumentChecker.notNull(properties);
        this.addOptions(properties.entrySet());
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void clearOptions() {
        this.properties.clear();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.iteratorClass == null ? 0 : this.iteratorClass.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.priority;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IteratorSetting)) {
            return false;
        }
        IteratorSetting other = (IteratorSetting)obj;
        if (this.iteratorClass == null ? other.iteratorClass != null : !this.iteratorClass.equals(other.iteratorClass)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name:");
        sb.append(this.name);
        sb.append(", priority:");
        sb.append(Integer.toString(this.priority));
        sb.append(", class:");
        sb.append(this.iteratorClass);
        sb.append(", properties:");
        sb.append(this.properties);
        return sb.toString();
    }

    public void readFields(DataInput din) throws IOException {
        this.priority = WritableUtils.readVInt((DataInput)din);
        this.name = WritableUtils.readString((DataInput)din);
        this.iteratorClass = WritableUtils.readString((DataInput)din);
        this.properties.clear();
        for (int size = WritableUtils.readVInt((DataInput)din); size > 0; --size) {
            this.properties.put(WritableUtils.readString((DataInput)din), WritableUtils.readString((DataInput)din));
        }
    }

    public void write(DataOutput dout) throws IOException {
        WritableUtils.writeVInt((DataOutput)dout, (int)this.priority);
        WritableUtils.writeString((DataOutput)dout, (String)this.name);
        WritableUtils.writeString((DataOutput)dout, (String)this.iteratorClass);
        WritableUtils.writeVInt((DataOutput)dout, (int)this.properties.size());
        for (Map.Entry<String, String> e : this.properties.entrySet()) {
            WritableUtils.writeString((DataOutput)dout, (String)e.getKey());
            WritableUtils.writeString((DataOutput)dout, (String)e.getValue());
        }
    }

    public static class Column
    extends Pair<Text, Text> {
        public Column(Text columnFamily, Text columnQualifier) {
            super(columnFamily, columnQualifier);
        }

        public Column(Text columnFamily) {
            super(columnFamily, null);
        }

        public Column(String columnFamily, String columnQualifier) {
            super(new Text(columnFamily), new Text(columnQualifier));
        }

        public Column(String columnFamily) {
            super(new Text(columnFamily), null);
        }

        public Text getColumnFamily() {
            return (Text)this.getFirst();
        }

        public Text getColumnQualifier() {
            return (Text)this.getSecond();
        }
    }
}

