/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.thrift.ThriftServerRunner;
import org.apache.hadoop.hbase.thrift.ThriftUtilities;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;

public class HRegionThriftServer
extends Thread {
    public static final Log LOG = LogFactory.getLog(HRegionThriftServer.class);
    private final HRegionServer rs;
    private final ThriftServerRunner serverRunner;

    HRegionThriftServer(HRegionServer regionServer, Configuration conf) throws IOException {
        super("Region Thrift Server");
        this.rs = regionServer;
        this.serverRunner = new ThriftServerRunner(conf, new HBaseHandlerRegion(conf));
    }

    void shutdown() {
        this.serverRunner.shutdown();
    }

    @Override
    public void run() {
        this.serverRunner.run();
    }

    private class HBaseHandlerRegion
    extends ThriftServerRunner.HBaseHandler {
        private boolean redirect;

        HBaseHandlerRegion(Configuration conf) throws IOException {
            super(conf);
            this.initialize(conf);
        }

        private void initialize(Configuration conf) {
            this.redirect = conf.getBoolean("hbase.regionserver.thrift.redirect", false);
        }

        @Override
        public List<TRowResult> getRowWithColumnsTs(ByteBuffer tableName, ByteBuffer rowb, List<ByteBuffer> columns, long timestamp, Map<ByteBuffer, ByteBuffer> attributes) throws IOError {
            try {
                byte[] row = HBaseHandlerRegion.toBytes(rowb);
                HTable table = this.getTable(HBaseHandlerRegion.toBytes(tableName));
                HRegionLocation location = table.getRegionLocation(row, false);
                byte[] regionName = location.getRegionInfo().getRegionName();
                if (columns == null) {
                    Get get2 = new Get(row);
                    get2.setTimeRange(Long.MIN_VALUE, timestamp);
                    Result result = HRegionThriftServer.this.rs.get(regionName, get2);
                    return ThriftUtilities.rowResultFromHBase(result);
                }
                Get get3 = new Get(row);
                for (ByteBuffer column : columns) {
                    byte[][] famAndQf = KeyValue.parseColumn(HBaseHandlerRegion.toBytes(column));
                    if (famAndQf.length == 1) {
                        get3.addFamily(famAndQf[0]);
                        continue;
                    }
                    get3.addColumn(famAndQf[0], famAndQf[1]);
                }
                get3.setTimeRange(Long.MIN_VALUE, timestamp);
                Result result = HRegionThriftServer.this.rs.get(regionName, get3);
                return ThriftUtilities.rowResultFromHBase(result);
            }
            catch (NotServingRegionException e) {
                if (!this.redirect) {
                    this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                    throw new IOError(e.getMessage());
                }
                this.LOG.debug((Object)"ThriftServer redirecting getRowWithColumnsTs");
                return super.getRowWithColumnsTs(tableName, rowb, columns, timestamp, attributes);
            }
            catch (IOException e) {
                this.LOG.warn((Object)e.getMessage(), (Throwable)e);
                throw new IOError(e.getMessage());
            }
        }
    }
}

